"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-aws/lib/provider");
const cdktf_1 = require("cdktf");
const _1 = require(".");
//import { Instance } from "@cdktf/provider-aws/lib/instance";
class MyStack extends cdktf_1.TerraformStack {
    constructor(scope, id) {
        super(scope, id);
        new provider_1.AwsProvider(this, 'aws', { region: 'eu-west-1' });
        const bucket = new _1.Bucket(this, 'ec2', {
            name: 'first-test',
            sseEnabled: true,
        });
        new cdktf_1.TerraformOutput(this, 'bucket-name', { value: bucket.id });
    }
}
const app = new cdktf_1.App();
const stack = new MyStack(app, '02-hcl-interoperability');
new cdktf_1.CloudBackend(stack, {
    hostname: 'app.terraform.io',
    organization: 'aws-rafams',
    workspaces: new cdktf_1.NamedCloudWorkspace('simple-ec2'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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