"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyMongo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) MongoDB Stateful Set class.
 *
 * @experimental
 */
class MyMongo extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e;
        super(scope, name);
        const volumerequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const defaultReplicas = (_b = opts.defaultReplicas) !== null && _b !== void 0 ? _b : 3;
        const replicas = defaultReplicas;
        const imageName = opts.image;
        const namespace = (_c = opts.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.namespace = namespace;
        const resources = {
            limits: convertQuantity((_d = opts.resources) === null || _d === void 0 ? void 0 : _d.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_e = opts.resources) === null || _e === void 0 ? void 0 : _e.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const labels = { db: name };
        const serviceOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                type: 'ClusterIP',
                clusterIP: 'None',
                ports: [{ port: 27017, targetPort: k8s.IntOrString.fromNumber(27017) }],
                selector: labels,
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const clusterroleOpts = {
            metadata: {
                namespace: namespace,
                name: 'get-pods-role',
            },
            rules: [
                {
                    verbs: ['list'],
                    apiGroups: ['*'],
                    resources: ['pods'],
                },
            ],
        };
        const clusterrole = new k8s.KubeClusterRole(this, 'clusterrole', clusterroleOpts);
        this.name = clusterrole.name;
        const serviceaccountOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
        };
        const sa = new k8s.KubeServiceAccount(this, 'serviceaccount', serviceaccountOpts);
        this.name = sa.name;
        const bindingOpts = {
            roleRef: {
                kind: 'ClusterRole',
                apiGroup: '',
                name: 'get-pods-role',
            },
            metadata: {
                namespace: namespace,
                name: name,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: name,
                    namespace: namespace,
                },
            ],
        };
        const clusterrolebinding = new k8s.KubeClusterRoleBinding(this, 'rolebinding', bindingOpts);
        this.name = clusterrolebinding.name;
        const pvcProps = {
            metadata: {
                name: name,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: opts.storageClass,
                resources: {
                    requests: volumerequest,
                },
            },
        };
        const stsOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                serviceName: name,
                selector: { matchLabels: labels },
                replicas: replicas,
                template: {
                    metadata: { labels: labels },
                    spec: {
                        containers: [
                            {
                                name: 'mongo-sidecar',
                                image: 'cvallance/mongo-k8s-sidecar',
                                env: [
                                    {
                                        name: 'MONGO_SIDECAR_POD_LABELS',
                                        value: `db=${name}`,
                                    },
                                    {
                                        name: 'KUBE_NAMESPACE',
                                        value: namespace,
                                    },
                                    {
                                        name: 'MONGODB_DATABASE',
                                        value: 'admin',
                                    },
                                    {
                                        name: 'MONGODB_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGODB_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                            },
                            {
                                name: name,
                                image: imageName,
                                env: [
                                    {
                                        name: 'MONGO_INITDB_ROOT_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGO_INITDB_ROOT_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                                resources: resources,
                                ports: [
                                    {
                                        containerPort: 27017,
                                    },
                                ],
                                args: [
                                    '--replSet',
                                    'rs0',
                                    '--bind_ip',
                                    '0.0.0.0',
                                    '--dbpath',
                                    '/data/db',
                                    '--oplogSize',
                                    '128',
                                ],
                                volumeMounts: [
                                    {
                                        name: name,
                                        mountPath: '/data/db',
                                    },
                                ],
                            },
                        ],
                        terminationGracePeriodSeconds: 10,
                        serviceAccountName: name,
                        nodeSelector: {
                            database: name,
                        },
                        securityContext: {
                            fsGroup: 999,
                            runAsGroup: 999,
                            runAsUser: 999,
                        },
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'sts', stsOpts);
        this.name = sts.name;
    }
}
exports.MyMongo = MyMongo;
_a = JSII_RTTI_SYMBOL_1;
MyMongo[_a] = { fqn: "cdk8s-mongo-sts.MyMongo", version: "0.0.3" };
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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