# Copyright (c) 2017-2021 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0

"""
Contains primitive declarations and functions for working with "native" Python types as they
correspond to types over the Ledger API.
"""

from .basic import (
    LEDGER_STRING_REGEX,
    NAME_STRING_REGEX,
    PACKAGE_ID_STRING_REGEX,
    PARTY_ID_STRING_REGEX,
    to_bool,
    to_str,
)
from .complex import to_record, to_variant
from .contracts import ContractData, ContractId
from .datetime import (
    TimeDeltaLike,
    date_to_int,
    date_to_str,
    datetime_to_epoch_microseconds,
    datetime_to_epoch_timedelta,
    datetime_to_str,
    datetime_to_timestamp,
    timedelta_to_duration,
    to_date,
    to_datetime,
    to_timedelta,
)
from .errors import DazlError, DazlWarning
from .json import JSONEncoder
from .map import FrozenDict
from .numbers import decimal_to_str, to_decimal, to_int
from .party import Party, to_party
