# Copyright 2021 eprbell
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=too-many-lines
RP2_TEST_OUTPUT = {
    "B1": """GainLossSet:
  configuration=./config/test_data.config
  asset=B1
  from_date=non-specified
  to_date=non-specified
  entries=
    GainLoss:
      id=3->None
      crypto_amount=2.00000000
      fiat_cost_basis=0.0000
      fiat_gain=24000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=24000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B1
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=None
    GainLoss:
      id=7->None
      crypto_amount=3.00000000
      fiat_cost_basis=0.0000
      fiat_gain=39000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=39000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B1
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=3->None""",
    "B2": """GainLossSet:
  configuration=./config/test_data.config
  asset=B2
  from_date=non-specified
  to_date=non-specified
  entries=
    GainLoss:
      id=16->4
      crypto_amount=0.20000000
      fiat_cost_basis=2220.0000
      fiat_gain=20.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2240.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=OutTransaction:
        id=16
        timestamp=2020-01-11 11:15:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=11200.0000
        crypto_out_no_fee=0.20000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=2240.0000
      acquired_lot_fiat_amount_with_fee_fraction=2220.0000
      acquired_lot_fraction_percentage=20.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=1 of 2
      parent=None
    GainLoss:
      id=3->None
      crypto_amount=2.00000000
      fiat_cost_basis=0.0000
      fiat_gain=24000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=24000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=16->4
    GainLoss:
      id=15->4
      crypto_amount=0.80000000
      fiat_cost_basis=8880.0000
      fiat_gain=880.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=9760.0000
      taxable_event_fraction_percentage=80.0000%
      taxable_event=OutTransaction:
        id=15
        timestamp=2020-02-11 19:58:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=12200.0000
        crypto_out_no_fee=1.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=12200.0000
      acquired_lot_fiat_amount_with_fee_fraction=8880.0000
      acquired_lot_fraction_percentage=80.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 2
      acquired_lot_fraction=2 of 2
      parent=3->None
    GainLoss:
      id=15->3
      crypto_amount=0.20000000
      fiat_cost_basis=2400.0000
      fiat_gain=40.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2440.0000
      taxable_event_fraction_percentage=20.0000%
      taxable_event=OutTransaction:
        id=15
        timestamp=2020-02-11 19:58:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=12200.0000
        crypto_out_no_fee=1.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=12200.0000
      acquired_lot_fiat_amount_with_fee_fraction=2400.0000
      acquired_lot_fraction_percentage=10.0000%
      acquired_lot=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      taxable_event_fraction=2 of 2
      acquired_lot_fraction=1 of 2
      parent=15->4
    GainLoss:
      id=7->None
      crypto_amount=3.00000000
      fiat_cost_basis=0.0000
      fiat_gain=39000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=39000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=15->3
    GainLoss:
      id=17->3
      crypto_amount=1.80000000
      fiat_cost_basis=21600.0000
      fiat_gain=3960.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=25560.0000
      taxable_event_fraction_percentage=36.0000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=21600.0000
      acquired_lot_fraction_percentage=90.0000%
      acquired_lot=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      taxable_event_fraction=1 of 3
      acquired_lot_fraction=2 of 2
      parent=7->None
    GainLoss:
      id=17->7
      crypto_amount=3.00000000
      fiat_cost_basis=39000.0000
      fiat_gain=3600.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=42600.0000
      taxable_event_fraction_percentage=60.0000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=39000.0000
      acquired_lot_fraction_percentage=100.0000%
      acquired_lot=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      taxable_event_fraction=2 of 3
      acquired_lot_fraction=1 of 1
      parent=17->3
    GainLoss:
      id=17->6
      crypto_amount=0.20000000
      fiat_cost_basis=2820.0000
      fiat_gain=20.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2840.0000
      taxable_event_fraction_percentage=4.0000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B2
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=2820.0000
      acquired_lot_fraction_percentage=5.0000%
      acquired_lot=InTransaction:
        id=6
        timestamp=2020-04-01 09:45:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=14000.0000
        crypto_in=4.00000000
        fiat_fee=400.0000
        fiat_in_no_fee=56000.0000
        fiat_in_with_fee=56400.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=3 of 3
      acquired_lot_fraction=1 of 3
      parent=17->7
    GainLoss:
      id=13->6
      crypto_amount=3.79000000
      fiat_cost_basis=53439.0000
      fiat_gain=758.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=54197.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=OutTransaction:
        id=13
        timestamp=2020-04-12 17:50:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.DONATE
        spot_price=14300.0000
        crypto_out_no_fee=3.79000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=54197.0000
      acquired_lot_fiat_amount_with_fee_fraction=53439.0000
      acquired_lot_fraction_percentage=94.7500%
      acquired_lot=InTransaction:
        id=6
        timestamp=2020-04-01 09:45:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=14000.0000
        crypto_in=4.00000000
        fiat_fee=400.0000
        fiat_in_no_fee=56000.0000
        fiat_in_with_fee=56400.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=2 of 3
      parent=17->6
    GainLoss:
      id=14->6
      crypto_amount=0.01000000
      fiat_cost_basis=141.0000
      fiat_gain=59.9950
      is_long_term_capital_gains=True
      taxable_event_fiat_amount_with_fee_fraction=200.9950
      taxable_event_fraction_percentage=0.4975%
      taxable_event=OutTransaction:
        id=14
        timestamp=2021-06-11 05:31:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=20200.0000
        crypto_out_no_fee=2.00000000
        crypto_fee=0.01000000
        is_taxable=True
        fiat_taxable_amount=40400.0000
      acquired_lot_fiat_amount_with_fee_fraction=141.0000
      acquired_lot_fraction_percentage=0.2500%
      acquired_lot=InTransaction:
        id=6
        timestamp=2020-04-01 09:45:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=14000.0000
        crypto_in=4.00000000
        fiat_fee=400.0000
        fiat_in_no_fee=56000.0000
        fiat_in_with_fee=56400.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 2
      acquired_lot_fraction=3 of 3
      parent=13->6
    GainLoss:
      id=14->5
      crypto_amount=2.00000000
      fiat_cost_basis=30200.0000
      fiat_gain=9999.0050
      is_long_term_capital_gains=True
      taxable_event_fiat_amount_with_fee_fraction=40199.0050
      taxable_event_fraction_percentage=99.5025%
      taxable_event=OutTransaction:
        id=14
        timestamp=2021-06-11 05:31:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=20200.0000
        crypto_out_no_fee=2.00000000
        crypto_fee=0.01000000
        is_taxable=True
        fiat_taxable_amount=40400.0000
      acquired_lot_fiat_amount_with_fee_fraction=30200.0000
      acquired_lot_fraction_percentage=40.0000%
      acquired_lot=InTransaction:
        id=5
        timestamp=2020-05-01 14:03:00.000000 +0000
        asset=B2
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=15000.0000
        crypto_in=5.00000000
        fiat_fee=500.0000
        fiat_in_no_fee=75000.0000
        fiat_in_with_fee=75500.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=2 of 2
      acquired_lot_fraction=1 of 1
      parent=14->6""",
    "B3": """GainLossSet:
  configuration=./config/test_data.config
  asset=B3
  from_date=non-specified
  to_date=non-specified
  entries=
    GainLoss:
      id=26->4
      crypto_amount=0.01000000
      fiat_cost_basis=111.0000
      fiat_gain=3.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=114.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=26
        timestamp=2020-01-21 18:33:14.342000 +0000
        asset=B3
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=BlockFi
        to_holder=Bob
        transaction_type=TransactionType.MOVE
        spot_price=11400.0000
        crypto_sent=0.10000000
        crypto_received=0.09000000
        crypto_fee=0.01000000
        fiat_fee=114.0000
        is_taxable=True
        fiat_taxable_amount=114.0000
      acquired_lot_fiat_amount_with_fee_fraction=111.0000
      acquired_lot_fraction_percentage=1.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B3
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=1 of 3
      parent=None
    GainLoss:
      id=3->None
      crypto_amount=2.00000000
      fiat_cost_basis=0.0000
      fiat_gain=24000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=24000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B3
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=26->4
    GainLoss:
      id=7->None
      crypto_amount=3.00000000
      fiat_cost_basis=0.0000
      fiat_gain=39000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=39000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B3
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=3->None
    GainLoss:
      id=25->4
      crypto_amount=0.02000000
      fiat_cost_basis=222.0000
      fiat_gain=66.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=288.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=25
        timestamp=2020-05-21 12:58:10.000000 +0000
        asset=B3
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=Kraken
        to_holder=Alice
        transaction_type=TransactionType.MOVE
        spot_price=14400.0000
        crypto_sent=0.20000000
        crypto_received=0.18000000
        crypto_fee=0.02000000
        fiat_fee=288.0000
        is_taxable=True
        fiat_taxable_amount=288.0000
      acquired_lot_fiat_amount_with_fee_fraction=222.0000
      acquired_lot_fraction_percentage=2.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B3
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=2 of 3
      parent=7->None
    GainLoss:
      id=23->4
      crypto_amount=0.04000000
      fiat_cost_basis=444.0000
      fiat_gain=412.0000
      is_long_term_capital_gains=True
      taxable_event_fiat_amount_with_fee_fraction=856.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=23
        timestamp=2021-07-21 10:02:02.000000 +0000
        asset=B3
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=Kraken
        to_holder=Alice
        transaction_type=TransactionType.MOVE
        spot_price=21400.0000
        crypto_sent=0.50000000
        crypto_received=0.46000000
        crypto_fee=0.04000000
        fiat_fee=856.0000
        is_taxable=True
        fiat_taxable_amount=856.0000
      acquired_lot_fiat_amount_with_fee_fraction=444.0000
      acquired_lot_fraction_percentage=4.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B3
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=3 of 3
      parent=25->4""",
    "B4": """GainLossSet:
  configuration=./config/test_data.config
  asset=B4
  from_date=non-specified
  to_date=non-specified
  entries=
    GainLoss:
      id=16->4
      crypto_amount=0.20000000
      fiat_cost_basis=2220.0000
      fiat_gain=20.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2240.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=OutTransaction:
        id=16
        timestamp=2020-01-11 11:15:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=11200.0000
        crypto_out_no_fee=0.20000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=2240.0000
      acquired_lot_fiat_amount_with_fee_fraction=2220.0000
      acquired_lot_fraction_percentage=20.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=1 of 3
      parent=None
    GainLoss:
      id=26->4
      crypto_amount=0.01000000
      fiat_cost_basis=111.0000
      fiat_gain=3.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=114.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=26
        timestamp=2020-01-21 18:33:14.342000 +0000
        asset=B4
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=BlockFi
        to_holder=Bob
        transaction_type=TransactionType.MOVE
        spot_price=11400.0000
        crypto_sent=0.10000000
        crypto_received=0.09000000
        crypto_fee=0.01000000
        fiat_fee=114.0000
        is_taxable=True
        fiat_taxable_amount=114.0000
      acquired_lot_fiat_amount_with_fee_fraction=111.0000
      acquired_lot_fraction_percentage=1.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=2 of 3
      parent=16->4
    GainLoss:
      id=3->None
      crypto_amount=2.00000000
      fiat_cost_basis=0.0000
      fiat_gain=24000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=24000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=26->4
    GainLoss:
      id=15->4
      crypto_amount=0.79000000
      fiat_cost_basis=8769.0000
      fiat_gain=869.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=9638.0000
      taxable_event_fraction_percentage=79.0000%
      taxable_event=OutTransaction:
        id=15
        timestamp=2020-02-11 19:58:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=12200.0000
        crypto_out_no_fee=1.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=12200.0000
      acquired_lot_fiat_amount_with_fee_fraction=8769.0000
      acquired_lot_fraction_percentage=79.0000%
      acquired_lot=InTransaction:
        id=4
        timestamp=2020-01-01 08:41:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=11000.0000
        crypto_in=1.00000000
        fiat_fee=100.0000
        fiat_in_no_fee=11000.0000
        fiat_in_with_fee=11100.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 2
      acquired_lot_fraction=3 of 3
      parent=3->None
    GainLoss:
      id=15->3
      crypto_amount=0.21000000
      fiat_cost_basis=2520.0000
      fiat_gain=42.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2562.0000
      taxable_event_fraction_percentage=21.0000%
      taxable_event=OutTransaction:
        id=15
        timestamp=2020-02-11 19:58:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=12200.0000
        crypto_out_no_fee=1.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=12200.0000
      acquired_lot_fiat_amount_with_fee_fraction=2520.0000
      acquired_lot_fraction_percentage=10.5000%
      acquired_lot=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      taxable_event_fraction=2 of 2
      acquired_lot_fraction=1 of 2
      parent=15->4
    GainLoss:
      id=7->None
      crypto_amount=3.00000000
      fiat_cost_basis=0.0000
      fiat_gain=39000.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=39000.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      acquired_lot_fiat_amount_with_fee_fraction=0.0000
      acquired_lot_fraction_percentage=0.0000%
      acquired_lot=None
      taxable_event_fraction=1 of 1
      parent=15->3
    GainLoss:
      id=17->3
      crypto_amount=1.79000000
      fiat_cost_basis=21480.0000
      fiat_gain=3938.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=25418.0000
      taxable_event_fraction_percentage=35.8000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=21480.0000
      acquired_lot_fraction_percentage=89.5000%
      acquired_lot=InTransaction:
        id=3
        timestamp=2020-02-01 11:18:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=12000.0000
        crypto_in=2.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=24000.0000
        fiat_in_with_fee=24000.0000
        is_taxable=True
        fiat_taxable_amount=24000.0000
      taxable_event_fraction=1 of 3
      acquired_lot_fraction=2 of 2
      parent=7->None
    GainLoss:
      id=17->7
      crypto_amount=3.00000000
      fiat_cost_basis=39000.0000
      fiat_gain=3600.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=42600.0000
      taxable_event_fraction_percentage=60.0000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=39000.0000
      acquired_lot_fraction_percentage=100.0000%
      acquired_lot=InTransaction:
        id=7
        timestamp=2020-03-01 09:45:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.INTEREST
        spot_price=13000.0000
        crypto_in=3.00000000
        fiat_fee=0.0000
        fiat_in_no_fee=39000.0000
        fiat_in_with_fee=39000.0000
        is_taxable=True
        fiat_taxable_amount=39000.0000
      taxable_event_fraction=2 of 3
      acquired_lot_fraction=1 of 1
      parent=17->3
    GainLoss:
      id=17->6
      crypto_amount=0.21000000
      fiat_cost_basis=2961.0000
      fiat_gain=21.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=2982.0000
      taxable_event_fraction_percentage=4.2000%
      taxable_event=OutTransaction:
        id=17
        timestamp=2020-04-11 07:10:00.000000 +0000
        asset=B4
        exchange=BlockFi
        holder=Bob
        transaction_type=TransactionType.GIFT
        spot_price=14200.0000
        crypto_out_no_fee=5.00000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=71000.0000
      acquired_lot_fiat_amount_with_fee_fraction=2961.0000
      acquired_lot_fraction_percentage=5.2500%
      acquired_lot=InTransaction:
        id=6
        timestamp=2020-04-01 09:45:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=14000.0000
        crypto_in=4.00000000
        fiat_fee=400.0000
        fiat_in_no_fee=56000.0000
        fiat_in_with_fee=56400.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=3 of 3
      acquired_lot_fraction=1 of 2
      parent=17->7
    GainLoss:
      id=13->6
      crypto_amount=3.79000000
      fiat_cost_basis=53439.0000
      fiat_gain=758.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=54197.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=OutTransaction:
        id=13
        timestamp=2020-04-12 17:50:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.DONATE
        spot_price=14300.0000
        crypto_out_no_fee=3.79000000
        crypto_fee=0.00000000
        is_taxable=True
        fiat_taxable_amount=54197.0000
      acquired_lot_fiat_amount_with_fee_fraction=53439.0000
      acquired_lot_fraction_percentage=94.7500%
      acquired_lot=InTransaction:
        id=6
        timestamp=2020-04-01 09:45:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=14000.0000
        crypto_in=4.00000000
        fiat_fee=400.0000
        fiat_in_no_fee=56000.0000
        fiat_in_with_fee=56400.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=2 of 2
      parent=17->6
    GainLoss:
      id=25->5
      crypto_amount=0.02000000
      fiat_cost_basis=302.0000
      fiat_gain=-14.0000
      is_long_term_capital_gains=False
      taxable_event_fiat_amount_with_fee_fraction=288.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=25
        timestamp=2020-05-21 12:58:10.000000 +0000
        asset=B4
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=Kraken
        to_holder=Alice
        transaction_type=TransactionType.MOVE
        spot_price=14400.0000
        crypto_sent=0.20000000
        crypto_received=0.18000000
        crypto_fee=0.02000000
        fiat_fee=288.0000
        is_taxable=True
        fiat_taxable_amount=288.0000
      acquired_lot_fiat_amount_with_fee_fraction=302.0000
      acquired_lot_fraction_percentage=0.4000%
      acquired_lot=InTransaction:
        id=5
        timestamp=2020-05-01 14:03:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=15000.0000
        crypto_in=5.00000000
        fiat_fee=500.0000
        fiat_in_no_fee=75000.0000
        fiat_in_with_fee=75500.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=1 of 3
      parent=13->6
    GainLoss:
      id=14->5
      crypto_amount=2.01000000
      fiat_cost_basis=30351.0000
      fiat_gain=10049.0000
      is_long_term_capital_gains=True
      taxable_event_fiat_amount_with_fee_fraction=40400.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=OutTransaction:
        id=14
        timestamp=2021-06-11 05:31:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.SELL
        spot_price=20200.0000
        crypto_out_no_fee=2.00000000
        crypto_fee=0.01000000
        is_taxable=True
        fiat_taxable_amount=40400.0000
      acquired_lot_fiat_amount_with_fee_fraction=30351.0000
      acquired_lot_fraction_percentage=40.2000%
      acquired_lot=InTransaction:
        id=5
        timestamp=2020-05-01 14:03:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=15000.0000
        crypto_in=5.00000000
        fiat_fee=500.0000
        fiat_in_no_fee=75000.0000
        fiat_in_with_fee=75500.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=2 of 3
      parent=25->5
    GainLoss:
      id=23->5
      crypto_amount=0.04000000
      fiat_cost_basis=604.0000
      fiat_gain=252.0000
      is_long_term_capital_gains=True
      taxable_event_fiat_amount_with_fee_fraction=856.0000
      taxable_event_fraction_percentage=100.0000%
      taxable_event=IntraTransaction:
        id=23
        timestamp=2021-07-21 10:02:02.000000 +0000
        asset=B4
        from_exchange=Coinbase
        from_holder=Bob
        to_exchange=Kraken
        to_holder=Alice
        transaction_type=TransactionType.MOVE
        spot_price=21400.0000
        crypto_sent=0.50000000
        crypto_received=0.46000000
        crypto_fee=0.04000000
        fiat_fee=856.0000
        is_taxable=True
        fiat_taxable_amount=856.0000
      acquired_lot_fiat_amount_with_fee_fraction=604.0000
      acquired_lot_fraction_percentage=0.8000%
      acquired_lot=InTransaction:
        id=5
        timestamp=2020-05-01 14:03:00.000000 +0000
        asset=B4
        exchange=Coinbase
        holder=Bob
        transaction_type=TransactionType.BUY
        spot_price=15000.0000
        crypto_in=5.00000000
        fiat_fee=500.0000
        fiat_in_no_fee=75000.0000
        fiat_in_with_fee=75500.0000
        is_taxable=False
        fiat_taxable_amount=0.0000
      taxable_event_fraction=1 of 1
      acquired_lot_fraction=3 of 3
      parent=14->5""",
}
