import * as ec2 from '@aws-cdk/aws-ec2';
import { IResource, RemovalPolicy, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Interface for a subnet group.
 *
 * @experimental
 */
export interface ISubnetGroup extends IResource {
    /**
     * (experimental) The name of the subnet group.
     *
     * @experimental
     * @attribute true
     */
    readonly subnetGroupName: string;
}
/**
 * (experimental) Properties for creating a SubnetGroup.
 *
 * @experimental
 */
export interface SubnetGroupProps {
    /**
     * (experimental) Description of the subnet group.
     *
     * @default - a name is generated
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The VPC to place the subnet group in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The name of the subnet group.
     *
     * @default - a name is generated
     * @experimental
     */
    readonly subnetGroupName?: string;
    /**
     * (experimental) Which subnets within the VPC to associate with this group.
     *
     * @default - private subnets
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) The removal policy to apply when the subnet group are removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.DESTROY
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Class for creating a RDS DB subnet group.
 *
 * @experimental
 * @resource AWS::Neptune::DBSubnetGroup
 */
export declare class SubnetGroup extends Resource implements ISubnetGroup {
    /**
     * (experimental) Imports an existing subnet group by name.
     *
     * @experimental
     */
    static fromSubnetGroupName(scope: Construct, id: string, subnetGroupName: string): ISubnetGroup;
    /**
     * (experimental) The name of the subnet group.
     *
     * @experimental
     */
    readonly subnetGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SubnetGroupProps);
}
