"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataGoogleworkspaceOrgUnit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/org_unit googleworkspace_org_unit}
*/
class DataGoogleworkspaceOrgUnit extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/org_unit googleworkspace_org_unit} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceOrgUnitConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'googleworkspace_org_unit',
            terraformGeneratorMetadata: {
                providerName: 'googleworkspace',
                providerVersion: '0.7.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._orgUnitId = config.orgUnitId;
        this._orgUnitPath = config.orgUnitPath;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // block_inheritance - computed: true, optional: false, required: false
    get blockInheritance() {
        return this.getBooleanAttribute('block_inheritance');
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    // etag - computed: true, optional: false, required: false
    get etag() {
        return this.getStringAttribute('etag');
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get orgUnitId() {
        return this.getStringAttribute('org_unit_id');
    }
    set orgUnitId(value) {
        this._orgUnitId = value;
    }
    resetOrgUnitId() {
        this._orgUnitId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orgUnitIdInput() {
        return this._orgUnitId;
    }
    get orgUnitPath() {
        return this.getStringAttribute('org_unit_path');
    }
    set orgUnitPath(value) {
        this._orgUnitPath = value;
    }
    resetOrgUnitPath() {
        this._orgUnitPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orgUnitPathInput() {
        return this._orgUnitPath;
    }
    // parent_org_unit_id - computed: true, optional: false, required: false
    get parentOrgUnitId() {
        return this.getStringAttribute('parent_org_unit_id');
    }
    // parent_org_unit_path - computed: true, optional: false, required: false
    get parentOrgUnitPath() {
        return this.getStringAttribute('parent_org_unit_path');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            org_unit_id: cdktf.stringToTerraform(this._orgUnitId),
            org_unit_path: cdktf.stringToTerraform(this._orgUnitPath),
        };
    }
}
exports.DataGoogleworkspaceOrgUnit = DataGoogleworkspaceOrgUnit;
_a = JSII_RTTI_SYMBOL_1;
DataGoogleworkspaceOrgUnit[_a] = { fqn: "@cdktf/provider-googleworkspace.dataGoogleworkspaceOrgUnit.DataGoogleworkspaceOrgUnit", version: "2.0.0" };
// =================
// STATIC PROPERTIES
// =================
DataGoogleworkspaceOrgUnit.tfResourceType = "googleworkspace_org_unit";
//# sourceMappingURL=data:application/json;base64,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