import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique ID of the user this role is assigned to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment#assigned_to RoleAssignment#assigned_to}
    */
    readonly assignedTo: string;
    /**
    * If the role is restricted to an organization unit, this contains the ID for the organization unit the exercise of this role is restricted to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment#org_unit_id RoleAssignment#org_unit_id}
    */
    readonly orgUnitId?: string;
    /**
    * The ID of the role that is assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment#role_id RoleAssignment#role_id}
    */
    readonly roleId: string;
    /**
    * Defaults to `CUSTOMER`. The scope in which this role is assigned. Valid values are :
      - `CUSTOMER`
      - `ORG_UNIT`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment#scope_type RoleAssignment#scope_type}
    */
    readonly scopeType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment googleworkspace_role_assignment}
*/
export declare class RoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_role_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/role_assignment googleworkspace_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: RoleAssignmentConfig);
    private _assignedTo?;
    get assignedTo(): string;
    set assignedTo(value: string);
    get assignedToInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _orgUnitId?;
    get orgUnitId(): string;
    set orgUnitId(value: string);
    resetOrgUnitId(): void;
    get orgUnitIdInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _scopeType?;
    get scopeType(): string;
    set scopeType(value: string);
    resetScopeType(): void;
    get scopeTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
