# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'AccessTokenInlineRole',
    'AccessTokenPolicyStatement',
    'CustomRolePolicy',
    'CustomRolePolicyStatement',
    'EnvironmentApprovalSetting',
    'FeatureFlagCustomProperty',
    'FeatureFlagDefaults',
    'FeatureFlagEnvironmentFallthrough',
    'FeatureFlagEnvironmentPrerequisite',
    'FeatureFlagEnvironmentRule',
    'FeatureFlagEnvironmentRuleClause',
    'FeatureFlagEnvironmentTarget',
    'FeatureFlagVariation',
    'ProjectEnvironment',
    'ProjectEnvironmentApprovalSetting',
    'SegmentRule',
    'SegmentRuleClause',
    'WebhookStatement',
    'GetEnvironmentApprovalSettingResult',
    'GetFeatureFlagClientSideAvailabilityResult',
    'GetFeatureFlagCustomPropertyResult',
    'GetFeatureFlagDefaultsResult',
    'GetFeatureFlagEnvironmentFallthroughResult',
    'GetFeatureFlagEnvironmentPrerequisiteResult',
    'GetFeatureFlagEnvironmentRuleResult',
    'GetFeatureFlagEnvironmentRuleClauseResult',
    'GetFeatureFlagEnvironmentTargetResult',
    'GetFeatureFlagVariationResult',
    'GetProjectClientSideAvailabilityResult',
    'GetSegmentRuleResult',
    'GetSegmentRuleClauseResult',
    'GetWebhookStatementResult',
]

@pulumi.output_type
class AccessTokenInlineRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notActions":
            suggest = "not_actions"
        elif key == "notResources":
            suggest = "not_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessTokenInlineRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessTokenInlineRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessTokenInlineRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] actions: The list of action specifiers defining the actions to which the statement applies.
        :param Sequence[str] not_actions: The list of action specifiers defining the actions to which the statement does not apply.
        :param Sequence[str] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply.
        :param Sequence[str] resources: - The list of resource specifiers defining the resources to which the statement applies.
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement applies.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply.
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply.
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class AccessTokenPolicyStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notActions":
            suggest = "not_actions"
        elif key == "notResources":
            suggest = "not_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessTokenPolicyStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessTokenPolicyStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessTokenPolicyStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] actions: The list of action specifiers defining the actions to which the statement applies.
        :param Sequence[str] not_actions: The list of action specifiers defining the actions to which the statement does not apply.
        :param Sequence[str] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply.
        :param Sequence[str] resources: - The list of resource specifiers defining the resources to which the statement applies.
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement applies.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply.
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply.
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class CustomRolePolicy(dict):
    def __init__(__self__, *,
                 actions: Sequence[str],
                 effect: str,
                 resources: Sequence[str]):
        """
        :param Sequence[str] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param str effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] resources: - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class CustomRolePolicyStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notActions":
            suggest = "not_actions"
        elif key == "notResources":
            suggest = "not_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomRolePolicyStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomRolePolicyStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomRolePolicyStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param Sequence[str] not_actions: The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param Sequence[str] not_resources: - The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param Sequence[str] resources: - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        - Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        - The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class EnvironmentApprovalSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canApplyDeclinedChanges":
            suggest = "can_apply_declined_changes"
        elif key == "canReviewOwnRequest":
            suggest = "can_review_own_request"
        elif key == "minNumApprovals":
            suggest = "min_num_approvals"
        elif key == "requiredApprovalTags":
            suggest = "required_approval_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentApprovalSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentApprovalSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentApprovalSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[bool] = None,
                 can_review_own_request: Optional[bool] = None,
                 min_num_approvals: Optional[int] = None,
                 required: Optional[bool] = None,
                 required_approval_tags: Optional[Sequence[str]] = None):
        """
        :param bool can_apply_declined_changes: Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        :param bool can_review_own_request: Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        :param int min_num_approvals: The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        :param bool required: Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        :param Sequence[str] required_approval_tags: An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[bool]:
        """
        Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        """
        return pulumi.get(self, "can_apply_declined_changes")

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[bool]:
        """
        Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        """
        return pulumi.get(self, "can_review_own_request")

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[int]:
        """
        The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        """
        return pulumi.get(self, "min_num_approvals")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[Sequence[str]]:
        """
        An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        return pulumi.get(self, "required_approval_tags")


@pulumi.output_type
class FeatureFlagCustomProperty(dict):
    def __init__(__self__, *,
                 key: str,
                 name: str,
                 values: Sequence[str]):
        """
        :param str key: The unique custom property key.
        :param str name: The name of the custom property.
        :param Sequence[str] values: The list of custom property value strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique custom property key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class FeatureFlagDefaults(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offVariation":
            suggest = "off_variation"
        elif key == "onVariation":
            suggest = "on_variation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureFlagDefaults. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureFlagDefaults.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureFlagDefaults.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 off_variation: int,
                 on_variation: int):
        """
        :param int off_variation: The index of the variation the flag will default to in all new environments when off.
        :param int on_variation: The index of the variation the flag will default to in all new environments when on.
        """
        pulumi.set(__self__, "off_variation", off_variation)
        pulumi.set(__self__, "on_variation", on_variation)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> int:
        """
        The index of the variation the flag will default to in all new environments when off.
        """
        return pulumi.get(self, "off_variation")

    @property
    @pulumi.getter(name="onVariation")
    def on_variation(self) -> int:
        """
        The index of the variation the flag will default to in all new environments when on.
        """
        return pulumi.get(self, "on_variation")


@pulumi.output_type
class FeatureFlagEnvironmentFallthrough(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketBy":
            suggest = "bucket_by"
        elif key == "rolloutWeights":
            suggest = "rollout_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureFlagEnvironmentFallthrough. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureFlagEnvironmentFallthrough.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureFlagEnvironmentFallthrough.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000. You must specify either `variation` or `rollout_weights`.
        :param int variation: The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "rollout_weights")

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class FeatureFlagEnvironmentPrerequisite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flagKey":
            suggest = "flag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureFlagEnvironmentPrerequisite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureFlagEnvironmentPrerequisite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureFlagEnvironmentPrerequisite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flag_key: str,
                 variation: int):
        """
        :param str flag_key: The prerequisite feature flag's `key`.
        :param int variation: The index of the prerequisite feature flag's variation to target.
        """
        pulumi.set(__self__, "flag_key", flag_key)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="flagKey")
    def flag_key(self) -> str:
        """
        The prerequisite feature flag's `key`.
        """
        return pulumi.get(self, "flag_key")

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The index of the prerequisite feature flag's variation to target.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class FeatureFlagEnvironmentRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketBy":
            suggest = "bucket_by"
        elif key == "rolloutWeights":
            suggest = "rollout_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureFlagEnvironmentRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureFlagEnvironmentRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureFlagEnvironmentRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['outputs.FeatureFlagEnvironmentRuleClause']] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        :param Sequence['FeatureFlagEnvironmentRuleClauseArgs'] clauses: List of nested blocks specifying the logical clauses to evaluate. To learn more, read Nested Clauses Blocks.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000. You must specify either `variation` or `rollout_weights`.
        :param int variation: The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute. This argument is only valid if `rollout_weights` is also specified.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['outputs.FeatureFlagEnvironmentRuleClause']]:
        """
        List of nested blocks specifying the logical clauses to evaluate. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights (in thousandths of a percent) to apply to each variation if the rule clauses evaluates to `true`. The sum of the `rollout_weights` must equal 100000. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "rollout_weights")

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index to serve if the rule clauses evaluate to `true`. You must specify either `variation` or `rollout_weights`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class FeatureFlagEnvironmentRuleClause(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureFlagEnvironmentRuleClause. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureFlagEnvironmentRuleClause.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureFlagEnvironmentRuleClause.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute to operate on.
        :param str op: The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether to negate the rule clause.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute to operate on.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the rule clause.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class FeatureFlagEnvironmentTarget(dict):
    def __init__(__self__, *,
                 values: Sequence[str],
                 variation: int):
        """
        :param Sequence[str] values: List of `user` strings to target.
        :param int variation: The index of the variation to serve is a user target value is matched.
        """
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of `user` strings to target.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The index of the variation to serve is a user target value is matched.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class FeatureFlagVariation(dict):
    def __init__(__self__, *,
                 value: str,
                 description: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: The variation value. The value's type must correspond to the `variation_type` argument. For example: `variation_type = "boolean"` accepts only `true` or `false`. The `"number"` variation type accepts both floats and ints, but please note that any trailing zeroes on floats will be trimmed (i.e. `1.1` and `1.100` will both be converted to `1.1`).
        :param str description: The variation's description.
        :param str name: The name of the variation.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The variation value. The value's type must correspond to the `variation_type` argument. For example: `variation_type = "boolean"` accepts only `true` or `false`. The `"number"` variation type accepts both floats and ints, but please note that any trailing zeroes on floats will be trimmed (i.e. `1.1` and `1.100` will both be converted to `1.1`).
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The variation's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the variation.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ProjectEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "approvalSettings":
            suggest = "approval_settings"
        elif key == "clientSideId":
            suggest = "client_side_id"
        elif key == "confirmChanges":
            suggest = "confirm_changes"
        elif key == "defaultTrackEvents":
            suggest = "default_track_events"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "mobileKey":
            suggest = "mobile_key"
        elif key == "requireComments":
            suggest = "require_comments"
        elif key == "secureMode":
            suggest = "secure_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color: str,
                 key: str,
                 name: str,
                 api_key: Optional[str] = None,
                 approval_settings: Optional[Sequence['outputs.ProjectEnvironmentApprovalSetting']] = None,
                 client_side_id: Optional[str] = None,
                 confirm_changes: Optional[bool] = None,
                 default_track_events: Optional[bool] = None,
                 default_ttl: Optional[int] = None,
                 mobile_key: Optional[str] = None,
                 require_comments: Optional[bool] = None,
                 secure_mode: Optional[bool] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param str color: The color swatch as an RGB hex value with no leading `#`. For example: `000000`.
        :param str key: The project-unique key for the environment.
        :param str name: The name of the environment.
        :param bool confirm_changes: Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
        :param bool default_track_events: Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/docs/data-export).
        :param int default_ttl: The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/docs/environments#section-ttl-settings).
        :param bool require_comments: Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
        :param bool secure_mode: Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
        :param Sequence[str] tags: Set of tags associated with the environment.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if approval_settings is not None:
            pulumi.set(__self__, "approval_settings", approval_settings)
        if client_side_id is not None:
            pulumi.set(__self__, "client_side_id", client_side_id)
        if confirm_changes is not None:
            pulumi.set(__self__, "confirm_changes", confirm_changes)
        if default_track_events is not None:
            pulumi.set(__self__, "default_track_events", default_track_events)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if mobile_key is not None:
            pulumi.set(__self__, "mobile_key", mobile_key)
        if require_comments is not None:
            pulumi.set(__self__, "require_comments", require_comments)
        if secure_mode is not None:
            pulumi.set(__self__, "secure_mode", secure_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        The color swatch as an RGB hex value with no leading `#`. For example: `000000`.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The project-unique key for the environment.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="approvalSettings")
    def approval_settings(self) -> Optional[Sequence['outputs.ProjectEnvironmentApprovalSetting']]:
        return pulumi.get(self, "approval_settings")

    @property
    @pulumi.getter(name="clientSideId")
    def client_side_id(self) -> Optional[str]:
        return pulumi.get(self, "client_side_id")

    @property
    @pulumi.getter(name="confirmChanges")
    def confirm_changes(self) -> Optional[bool]:
        """
        Set to `true` if this environment requires confirmation for flag and segment changes. This field will default to `false` when not set.
        """
        return pulumi.get(self, "confirm_changes")

    @property
    @pulumi.getter(name="defaultTrackEvents")
    def default_track_events(self) -> Optional[bool]:
        """
        Set to `true` to enable data export for every flag created in this environment after you configure this argument. This field will default to `false` when not set. To learn more, read [Data Export](https://docs.launchdarkly.com/docs/data-export).
        """
        return pulumi.get(self, "default_track_events")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        The TTL for the environment. This must be between 0 and 60 minutes. The TTL setting only applies to environments using the PHP SDK. This field will default to `0` when not set. To learn more, read [TTL settings](https://docs.launchdarkly.com/docs/environments#section-ttl-settings).
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="mobileKey")
    def mobile_key(self) -> Optional[str]:
        return pulumi.get(self, "mobile_key")

    @property
    @pulumi.getter(name="requireComments")
    def require_comments(self) -> Optional[bool]:
        """
        Set to `true` if this environment requires comments for flag and segment changes. This field will default to `false` when not set.
        """
        return pulumi.get(self, "require_comments")

    @property
    @pulumi.getter(name="secureMode")
    def secure_mode(self) -> Optional[bool]:
        """
        Set to `true` to ensure a user of the client-side SDK cannot impersonate another user. This field will default to `false` when not set.
        """
        return pulumi.get(self, "secure_mode")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Set of tags associated with the environment.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ProjectEnvironmentApprovalSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canApplyDeclinedChanges":
            suggest = "can_apply_declined_changes"
        elif key == "canReviewOwnRequest":
            suggest = "can_review_own_request"
        elif key == "minNumApprovals":
            suggest = "min_num_approvals"
        elif key == "requiredApprovalTags":
            suggest = "required_approval_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironmentApprovalSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironmentApprovalSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironmentApprovalSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[bool] = None,
                 can_review_own_request: Optional[bool] = None,
                 min_num_approvals: Optional[int] = None,
                 required: Optional[bool] = None,
                 required_approval_tags: Optional[Sequence[str]] = None):
        """
        :param bool can_apply_declined_changes: Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        :param bool can_review_own_request: Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        :param int min_num_approvals: The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        :param bool required: Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        :param Sequence[str] required_approval_tags: An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[bool]:
        """
        Set to `true` if changes can be applied as long as the `min_num_approvals` is met, regardless of whether any reviewers have declined a request. Defaults to `true`.
        """
        return pulumi.get(self, "can_apply_declined_changes")

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[bool]:
        """
        Set to `true` if requesters can approve or decline their own request. They may always comment. Defaults to `false`.
        """
        return pulumi.get(self, "can_review_own_request")

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[int]:
        """
        The number of approvals required before an approval request can be applied. This number must be between 1 and 5. Defaults to 1.
        """
        return pulumi.get(self, "min_num_approvals")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Set to `true` for changes to flags in this environment to require approval. You may only set `required` to true if `required_approval_tags` is not set and vice versa. Defaults to `false`.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[Sequence[str]]:
        """
        An array of tags used to specify which flags with those tags require approval. You may only set `required_approval_tags` if `required` is not set to `true` and vice versa.
        """
        return pulumi.get(self, "required_approval_tags")


@pulumi.output_type
class SegmentRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketBy":
            suggest = "bucket_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['outputs.SegmentRuleClause']] = None,
                 weight: Optional[int] = None):
        """
        :param str bucket_by: The attribute by which to group users together.
        :param Sequence['SegmentRuleClauseArgs'] clauses: List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        :param int weight: The integer weight of the rule (between 0 and 100000).
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        The attribute by which to group users together.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['outputs.SegmentRuleClause']]:
        """
        List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The integer weight of the rule (between 0 and 100000).
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class SegmentRuleClause(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentRuleClause. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentRuleClause.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentRuleClause.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute to operate on.
        :param str op: The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether to negate the rule clause.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute to operate on.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether to negate the rule clause.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class WebhookStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notActions":
            suggest = "not_actions"
        elif key == "notResources":
            suggest = "not_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] actions: The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param Sequence[str] not_actions: The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        :param Sequence[str] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param Sequence[str] resources: The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement applies. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        """
        The list of action specifiers defining the actions to which the statement does not apply. Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
        """
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. Either `resources` or `not_resources` must be specified. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class GetEnvironmentApprovalSettingResult(dict):
    def __init__(__self__, *,
                 can_apply_declined_changes: Optional[bool] = None,
                 can_review_own_request: Optional[bool] = None,
                 min_num_approvals: Optional[int] = None,
                 required: Optional[bool] = None,
                 required_approval_tags: Optional[Sequence[str]] = None):
        if can_apply_declined_changes is not None:
            pulumi.set(__self__, "can_apply_declined_changes", can_apply_declined_changes)
        if can_review_own_request is not None:
            pulumi.set(__self__, "can_review_own_request", can_review_own_request)
        if min_num_approvals is not None:
            pulumi.set(__self__, "min_num_approvals", min_num_approvals)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if required_approval_tags is not None:
            pulumi.set(__self__, "required_approval_tags", required_approval_tags)

    @property
    @pulumi.getter(name="canApplyDeclinedChanges")
    def can_apply_declined_changes(self) -> Optional[bool]:
        return pulumi.get(self, "can_apply_declined_changes")

    @property
    @pulumi.getter(name="canReviewOwnRequest")
    def can_review_own_request(self) -> Optional[bool]:
        return pulumi.get(self, "can_review_own_request")

    @property
    @pulumi.getter(name="minNumApprovals")
    def min_num_approvals(self) -> Optional[int]:
        return pulumi.get(self, "min_num_approvals")

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter(name="requiredApprovalTags")
    def required_approval_tags(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "required_approval_tags")


@pulumi.output_type
class GetFeatureFlagClientSideAvailabilityResult(dict):
    def __init__(__self__, *,
                 using_environment_id: Optional[bool] = None,
                 using_mobile_key: Optional[bool] = None):
        """
        :param bool using_environment_id: When set to true, this flag is available to SDKs using the client-side ID.
        :param bool using_mobile_key: When set to true, this flag is available to SDKs using a mobile key.
        """
        if using_environment_id is not None:
            pulumi.set(__self__, "using_environment_id", using_environment_id)
        if using_mobile_key is not None:
            pulumi.set(__self__, "using_mobile_key", using_mobile_key)

    @property
    @pulumi.getter(name="usingEnvironmentId")
    def using_environment_id(self) -> Optional[bool]:
        """
        When set to true, this flag is available to SDKs using the client-side ID.
        """
        return pulumi.get(self, "using_environment_id")

    @property
    @pulumi.getter(name="usingMobileKey")
    def using_mobile_key(self) -> Optional[bool]:
        """
        When set to true, this flag is available to SDKs using a mobile key.
        """
        return pulumi.get(self, "using_mobile_key")


@pulumi.output_type
class GetFeatureFlagCustomPropertyResult(dict):
    def __init__(__self__, *,
                 key: str,
                 name: str,
                 values: Sequence[str]):
        """
        :param str key: The unique feature flag key that references the flag in your application code.
        :param str name: The name of the custom property.
        :param Sequence[str] values: The list of custom property value strings.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The unique feature flag key that references the flag in your application code.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetFeatureFlagDefaultsResult(dict):
    def __init__(__self__, *,
                 off_variation: int,
                 on_variation: int):
        """
        :param int off_variation: (Required) The index of the variation the flag will default to in all new environments when off.
        :param int on_variation: (Required) The index of the variation the flag will default to in all new environments when on.
        """
        pulumi.set(__self__, "off_variation", off_variation)
        pulumi.set(__self__, "on_variation", on_variation)

    @property
    @pulumi.getter(name="offVariation")
    def off_variation(self) -> int:
        """
        (Required) The index of the variation the flag will default to in all new environments when off.
        """
        return pulumi.get(self, "off_variation")

    @property
    @pulumi.getter(name="onVariation")
    def on_variation(self) -> int:
        """
        (Required) The index of the variation the flag will default to in all new environments when on.
        """
        return pulumi.get(self, "on_variation")


@pulumi.output_type
class GetFeatureFlagEnvironmentFallthroughResult(dict):
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        """
        return pulumi.get(self, "rollout_weights")

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class GetFeatureFlagEnvironmentPrerequisiteResult(dict):
    def __init__(__self__, *,
                 flag_key: str,
                 variation: int):
        """
        :param str flag_key: The prerequisite feature flag's `key`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        pulumi.set(__self__, "flag_key", flag_key)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="flagKey")
    def flag_key(self) -> str:
        """
        The prerequisite feature flag's `key`.
        """
        return pulumi.get(self, "flag_key")

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class GetFeatureFlagEnvironmentRuleResult(dict):
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['outputs.GetFeatureFlagEnvironmentRuleClauseResult']] = None,
                 rollout_weights: Optional[Sequence[int]] = None,
                 variation: Optional[int] = None):
        """
        :param str bucket_by: Group percentage rollout by a custom attribute.
        :param Sequence['GetFeatureFlagEnvironmentRuleClauseArgs'] clauses: List of nested blocks specifying the logical clauses evaluated. To learn more, read Nested Clauses Blocks.
        :param Sequence[int] rollout_weights: List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if rollout_weights is not None:
            pulumi.set(__self__, "rollout_weights", rollout_weights)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        Group percentage rollout by a custom attribute.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['outputs.GetFeatureFlagEnvironmentRuleClauseResult']]:
        """
        List of nested blocks specifying the logical clauses evaluated. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @property
    @pulumi.getter(name="rolloutWeights")
    def rollout_weights(self) -> Optional[Sequence[int]]:
        """
        List of integer percentage rollout weights applied to each variation when the rule clauses evaluates to `true`.
        """
        return pulumi.get(self, "rollout_weights")

    @property
    @pulumi.getter
    def variation(self) -> Optional[int]:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class GetFeatureFlagEnvironmentRuleClauseResult(dict):
    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute operated on.
        :param str op: The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether the rule clause is negated.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute operated on.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether the rule clause is negated.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetFeatureFlagEnvironmentTargetResult(dict):
    def __init__(__self__, *,
                 values: Sequence[str],
                 variation: int):
        """
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param int variation: The integer variation index served when the rule clauses evaluate to `true`.
        """
        pulumi.set(__self__, "values", values)
        pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def variation(self) -> int:
        """
        The integer variation index served when the rule clauses evaluate to `true`.
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class GetFeatureFlagVariationResult(dict):
    def __init__(__self__, *,
                 value: str,
                 description: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: The list of custom property value strings.
        :param str description: The variation's description.
        :param str name: The name of the custom property.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The list of custom property value strings.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The variation's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the custom property.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetProjectClientSideAvailabilityResult(dict):
    def __init__(__self__, *,
                 using_environment_id: Optional[bool] = None,
                 using_mobile_key: Optional[bool] = None):
        """
        :param bool using_environment_id: When set to true, the flags in this project are available to SDKs using the client-side ID by default.
        :param bool using_mobile_key: When set to true, the flags in this project are available to SDKs using a mobile key by default.
        """
        if using_environment_id is not None:
            pulumi.set(__self__, "using_environment_id", using_environment_id)
        if using_mobile_key is not None:
            pulumi.set(__self__, "using_mobile_key", using_mobile_key)

    @property
    @pulumi.getter(name="usingEnvironmentId")
    def using_environment_id(self) -> Optional[bool]:
        """
        When set to true, the flags in this project are available to SDKs using the client-side ID by default.
        """
        return pulumi.get(self, "using_environment_id")

    @property
    @pulumi.getter(name="usingMobileKey")
    def using_mobile_key(self) -> Optional[bool]:
        """
        When set to true, the flags in this project are available to SDKs using a mobile key by default.
        """
        return pulumi.get(self, "using_mobile_key")


@pulumi.output_type
class GetSegmentRuleResult(dict):
    def __init__(__self__, *,
                 bucket_by: Optional[str] = None,
                 clauses: Optional[Sequence['outputs.GetSegmentRuleClauseResult']] = None,
                 weight: Optional[int] = None):
        """
        :param str bucket_by: The attribute by which to group users together.
        :param Sequence['GetSegmentRuleClauseArgs'] clauses: List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        :param int weight: The integer weight of the rule (between 0 and 100000).
        """
        if bucket_by is not None:
            pulumi.set(__self__, "bucket_by", bucket_by)
        if clauses is not None:
            pulumi.set(__self__, "clauses", clauses)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="bucketBy")
    def bucket_by(self) -> Optional[str]:
        """
        The attribute by which to group users together.
        """
        return pulumi.get(self, "bucket_by")

    @property
    @pulumi.getter
    def clauses(self) -> Optional[Sequence['outputs.GetSegmentRuleClauseResult']]:
        """
        List of nested custom rule clause blocks. To learn more, read Nested Clauses Blocks.
        """
        return pulumi.get(self, "clauses")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The integer weight of the rule (between 0 and 100000).
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetSegmentRuleClauseResult(dict):
    def __init__(__self__, *,
                 attribute: str,
                 op: str,
                 values: Sequence[str],
                 negate: Optional[bool] = None,
                 value_type: Optional[str] = None):
        """
        :param str attribute: The user attribute operated on.
        :param str op: The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        :param Sequence[str] values: The list of values associated with the rule clause.
        :param bool negate: Whether the rule clause is negated.
        :param str value_type: The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "values", values)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The user attribute operated on.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator associated with the rule clause. This will be one of `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The list of values associated with the rule clause.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Whether the rule clause is negated.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type for each of the clause's values. Available types are `boolean`, `string`, and `number`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetWebhookStatementResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 actions: Optional[Sequence[str]] = None,
                 not_actions: Optional[Sequence[str]] = None,
                 not_resources: Optional[Sequence[str]] = None,
                 resources: Optional[Sequence[str]] = None):
        """
        :param str effect: Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        :param Sequence[str] not_resources: The list of resource specifiers defining the resources to which the statement does not apply. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        :param Sequence[str] resources: The list of resource specifiers defining the resources to which the statement applies. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        pulumi.set(__self__, "effect", effect)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if not_actions is not None:
            pulumi.set(__self__, "not_actions", not_actions)
        if not_resources is not None:
            pulumi.set(__self__, "not_resources", not_resources)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="notActions")
    def not_actions(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "not_actions")

    @property
    @pulumi.getter(name="notResources")
    def not_resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement does not apply. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "not_resources")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The list of resource specifiers defining the resources to which the statement applies. For a list of available resources read [Understanding resource types and scopes](https://docs.launchdarkly.com/home/account-security/custom-roles/resources#understanding-resource-types-and-scopes).
        """
        return pulumi.get(self, "resources")


