# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 environments: pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]],
                 key: pulumi.Input[str],
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]] environments: List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        :param pulumi.Input[str] key: The project's unique key.
        :param pulumi.Input[bool] include_in_snippet: Whether feature flags created under the project should be available to client-side SDKs by default
        :param pulumi.Input[str] name: The project's name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The project's set of tags.
        """
        pulumi.set(__self__, "environments", environments)
        pulumi.set(__self__, "key", key)
        if include_in_snippet is not None:
            pulumi.set(__self__, "include_in_snippet", include_in_snippet)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]]:
        """
        List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The project's unique key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether feature flags created under the project should be available to client-side SDKs by default
        """
        return pulumi.get(self, "include_in_snippet")

    @include_in_snippet.setter
    def include_in_snippet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_in_snippet", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The project's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The project's set of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]] environments: List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        :param pulumi.Input[bool] include_in_snippet: Whether feature flags created under the project should be available to client-side SDKs by default
        :param pulumi.Input[str] key: The project's unique key.
        :param pulumi.Input[str] name: The project's name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The project's set of tags.
        """
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if include_in_snippet is not None:
            pulumi.set(__self__, "include_in_snippet", include_in_snippet)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]]]:
        """
        List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether feature flags created under the project should be available to client-side SDKs by default
        """
        return pulumi.get(self, "include_in_snippet")

    @include_in_snippet.setter
    def include_in_snippet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_in_snippet", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The project's unique key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The project's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The project's set of tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]]]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a LaunchDarkly project resource.

        This resource allows you to create and manage projects within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Project("example",
            environments=[
                launchdarkly.ProjectEnvironmentArgs(
                    approval_settings=[launchdarkly.ProjectEnvironmentApprovalSettingArgs(
                        can_apply_declined_changes=False,
                        can_review_own_request=False,
                        min_num_approvals=3,
                        required_approval_tags=["approvals_required"],
                    )],
                    color="EEEEEE",
                    key="production",
                    name="Production",
                    tags=["terraform"],
                ),
                launchdarkly.ProjectEnvironmentArgs(
                    color="000000",
                    key="staging",
                    name="Staging",
                    tags=["terraform"],
                ),
            ],
            key="example-project",
            tags=["terraform"])
        ```

        ## Import

        LaunchDarkly projects can be imported using the project's key, e.g.

        ```sh
         $ pulumi import launchdarkly:index/project:Project example example-project
        ```

         **IMPORTANT:** Please note that, regardless of how many `environments` blocks you include on your import, _all_ of the project's environments will be saved to the Terraform state and will update with subsequent applies. This means that any environments not included in your import configuration will be torn down with any subsequent apply. If you wish to manage project properties with Terraform but not nested environments consider using Terraform's [ignore changes](https://www.terraform.io/docs/language/meta-arguments/lifecycle.html#ignore_changes) lifecycle meta-argument; see below for example. resource "launchdarkly_project" "example" { 		lifecycle { 			ignore_changes = [environments] 		} 		name = "testProject" 		key = "%s" 		# environments not included on this configuration will not be affected by subsequent applies 	} Managing environment resources with Terraform should always be done on the project unless the project is not also managed with Terraform.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]]] environments: List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        :param pulumi.Input[bool] include_in_snippet: Whether feature flags created under the project should be available to client-side SDKs by default
        :param pulumi.Input[str] key: The project's unique key.
        :param pulumi.Input[str] name: The project's name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The project's set of tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a LaunchDarkly project resource.

        This resource allows you to create and manage projects within your LaunchDarkly organization.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_launchdarkly as launchdarkly

        example = launchdarkly.Project("example",
            environments=[
                launchdarkly.ProjectEnvironmentArgs(
                    approval_settings=[launchdarkly.ProjectEnvironmentApprovalSettingArgs(
                        can_apply_declined_changes=False,
                        can_review_own_request=False,
                        min_num_approvals=3,
                        required_approval_tags=["approvals_required"],
                    )],
                    color="EEEEEE",
                    key="production",
                    name="Production",
                    tags=["terraform"],
                ),
                launchdarkly.ProjectEnvironmentArgs(
                    color="000000",
                    key="staging",
                    name="Staging",
                    tags=["terraform"],
                ),
            ],
            key="example-project",
            tags=["terraform"])
        ```

        ## Import

        LaunchDarkly projects can be imported using the project's key, e.g.

        ```sh
         $ pulumi import launchdarkly:index/project:Project example example-project
        ```

         **IMPORTANT:** Please note that, regardless of how many `environments` blocks you include on your import, _all_ of the project's environments will be saved to the Terraform state and will update with subsequent applies. This means that any environments not included in your import configuration will be torn down with any subsequent apply. If you wish to manage project properties with Terraform but not nested environments consider using Terraform's [ignore changes](https://www.terraform.io/docs/language/meta-arguments/lifecycle.html#ignore_changes) lifecycle meta-argument; see below for example. resource "launchdarkly_project" "example" { 		lifecycle { 			ignore_changes = [environments] 		} 		name = "testProject" 		key = "%s" 		# environments not included on this configuration will not be affected by subsequent applies 	} Managing environment resources with Terraform should always be done on the project unless the project is not also managed with Terraform.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]]]] = None,
                 include_in_snippet: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            if environments is None and not opts.urn:
                raise TypeError("Missing required property 'environments'")
            __props__.__dict__["environments"] = environments
            __props__.__dict__["include_in_snippet"] = include_in_snippet
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
        super(Project, __self__).__init__(
            'launchdarkly:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]]]] = None,
            include_in_snippet: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectEnvironmentArgs']]]] environments: List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        :param pulumi.Input[bool] include_in_snippet: Whether feature flags created under the project should be available to client-side SDKs by default
        :param pulumi.Input[str] key: The project's unique key.
        :param pulumi.Input[str] name: The project's name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The project's set of tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["environments"] = environments
        __props__.__dict__["include_in_snippet"] = include_in_snippet
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Sequence['outputs.ProjectEnvironment']]:
        """
        List of nested `environments` blocks describing LaunchDarkly environments that belong to the project
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="includeInSnippet")
    def include_in_snippet(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether feature flags created under the project should be available to client-side SDKs by default
        """
        return pulumi.get(self, "include_in_snippet")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The project's unique key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The project's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The project's set of tags.
        """
        return pulumi.get(self, "tags")

