function [F,x1,x2,dx1,dx2]=quadr(a,b,c,rg,mx)
%
%QUAD create data for a 3-D plot for a quadratic function
%
%  [F,X1,X2] = QUADR(a,b,c,rg,mx)
%
%     1/2 xTax + bTx +c
%
%	  a  - Quadratic matrix (hessian).
%     b  - Linear vector.
%     c  - Scalar offset.
%     rg - Ranges for two elements of the x vector.
%     mx - Maximum F value to be plotted.
%	Returns:
%	  F  - function evaluated on a 3-D grid.
%	  x1 - points along x1 axis.
%	  x2 - points along x2 axis.

%  find ranges for the x1 and x2 axes

x1 = rg(1):(rg(2)-rg(1))/40:rg(2);
x2 = rg(3):(rg(4)-rg(3))/40:rg(4);
[X1,X2] = meshgrid(x1,x2);
[n,m] = size(X1);

%  evaluate the function

F = (a(1,1)*X1.^2 + (a(1,2)+a(2,1))*X1.*X2 + a(2,2)*X2.^2)/2 ...
         + b(1)*X1 + b(2)*X2 +c;

%  if the function is above a maximum value set it to the maximum

for i=1:41,
 for j=1:41,
    if(F(i,j)>mx),
      F(i,j)=mx;
    end
  end
end

xx = [reshape(X1,[1,n*m]);reshape(X2,[1,n*m])];
dxx = a*xx+b;
dx1 = reshape(dxx(1,:),[n,m]);
dx2 = reshape(dxx(2,:),[n,m]);