"use strict";
const core_1 = require("@aws-cdk/core");
const appscaling = require("../lib");
module.exports = {
    'test utc cron, hour only'(test) {
        test.equals(appscaling.Schedule.cron({ hour: '18', minute: '0' }).expressionString, 'cron(0 18 * * ? *)');
        test.done();
    },
    'test utc cron, hour and minute'(test) {
        test.equals(appscaling.Schedule.cron({ hour: '18', minute: '24' }).expressionString, 'cron(24 18 * * ? *)');
        test.done();
    },
    'rate must be whole number of minutes'(test) {
        test.throws(() => {
            appscaling.Schedule.rate(core_1.Duration.seconds(12345));
        }, /'12345 seconds' cannot be converted into a whole number of minutes/);
        test.done();
    },
    'rate cannot be 0'(test) {
        test.throws(() => {
            appscaling.Schedule.rate(core_1.Duration.days(0));
        }, /Duration cannot be 0/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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