"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const scalingcommon = require("@aws-cdk/aws-autoscaling-common");
const fc = require("fast-check");
const appscaling = require("../lib");
const lib_1 = require("../lib");
function createScalableTarget(scope) {
    return new appscaling.ScalableTarget(scope, 'Target', {
        serviceNamespace: lib_1.ServiceNamespace.DYNAMODB,
        scalableDimension: 'test:TestCount',
        resourceId: 'test:this/test',
        minCapacity: 1,
        maxCapacity: 20,
    });
}
exports.createScalableTarget = createScalableTarget;
class ArbitraryInputIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(ret.intervals);
    }
}
exports.ArbitraryInputIntervals = ArbitraryInputIntervals;
function arbitrary_input_intervals() {
    return new ArbitraryInputIntervals();
}
exports.arbitrary_input_intervals = arbitrary_input_intervals;
//# sourceMappingURL=data:application/json;base64,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