"""
    SatNOGS DB

    SatNOGS DB is a crowdsourced database of details about orbital                     satellites and data collected from them.  # noqa: E501

    The version of the OpenAPI document: 1.1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint as _Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.satellite import Satellite


class SatellitesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __satellites_create(
            self,
            **kwargs
        ):
            """satellites_create  # noqa: E501

            Creates a satellite suggestion.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.satellites_create(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                format (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Satellite
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.satellites_create = _Endpoint(
            settings={
                'response_type': (Satellite,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/satellites/',
                'operation_id': 'satellites_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'format',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'format': 'format',
                },
                'location_map': {
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__satellites_create
        )

        def __satellites_list(
            self,
            **kwargs
        ):
            """satellites_list  # noqa: E501

            Retrieve a full or filtered list of satellites in SatNOGS DB  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.satellites_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                format (str): [optional]
                in_orbit (bool): Filter by satellites currently in orbit (True) or those that have                             decayed (False). [optional]
                norad_cat_id (str): Select a satellite by its NORAD-assigned identifier. [optional]
                status (str): Filter by satellite status: alive dead future re-entered. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [Satellite]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.satellites_list = _Endpoint(
            settings={
                'response_type': ([Satellite],),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/satellites/',
                'operation_id': 'satellites_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'format',
                    'in_orbit',
                    'norad_cat_id',
                    'status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'format':
                        (str,),
                    'in_orbit':
                        (bool,),
                    'norad_cat_id':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'format': 'format',
                    'in_orbit': 'in_orbit',
                    'norad_cat_id': 'norad_cat_id',
                    'status': 'status',
                },
                'location_map': {
                    'format': 'query',
                    'in_orbit': 'query',
                    'norad_cat_id': 'query',
                    'status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__satellites_list
        )

        def __satellites_retrieve(
            self,
            satellite_identifier__sat_id,
            **kwargs
        ):
            """satellites_retrieve  # noqa: E501

            Retrieve details on a single satellite in SatNOGS DB  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.satellites_retrieve(satellite_identifier__sat_id, async_req=True)
            >>> result = thread.get()

            Args:
                satellite_identifier__sat_id (str): Select a satellite by its Satellite Identifier

            Keyword Args:
                format (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Satellite
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['satellite_identifier__sat_id'] = \
                satellite_identifier__sat_id
            return self.call_with_http_info(**kwargs)

        self.satellites_retrieve = _Endpoint(
            settings={
                'response_type': (Satellite,),
                'auth': [
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/satellites/{satellite_identifier__sat_id}/',
                'operation_id': 'satellites_retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'satellite_identifier__sat_id',
                    'format',
                ],
                'required': [
                    'satellite_identifier__sat_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'format',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('format',): {

                        "JSON": "json",
                        "JSON-LD": "json-ld"
                    },
                },
                'openapi_types': {
                    'satellite_identifier__sat_id':
                        (str,),
                    'format':
                        (str,),
                },
                'attribute_map': {
                    'satellite_identifier__sat_id': 'satellite_identifier__sat_id',
                    'format': 'format',
                },
                'location_map': {
                    'satellite_identifier__sat_id': 'path',
                    'format': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__satellites_retrieve
        )
