import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
     * The base instance name to use for instances in this group.
     *
     * The value must be a valid RFC1035 name. Supported characters are lowercase letters, numbers, and hyphens (-). Instances are named by appending a hyphen and a random four-character string to the base instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#base_instance_name ComputeInstanceGroupManager#base_instance_name}
     *
     * @stability stable
     */
    readonly baseInstanceName: string;
    /**
     * An optional textual description of the instance group manager.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#description ComputeInstanceGroupManager#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the instance group manager.
     *
     * Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#name ComputeInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#project ComputeInstanceGroupManager#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The full URL of all target pools to which new instances in the group are added.
     *
     * Updating the target pools attribute does not affect existing instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#target_pools ComputeInstanceGroupManager#target_pools}
     *
     * @stability stable
     */
    readonly targetPools?: string[];
    /**
     * The target number of running instances for this managed instance group.
     *
     * This value should always be explicitly set unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#target_size ComputeInstanceGroupManager#target_size}
     *
     * @stability stable
     */
    readonly targetSize?: number;
    /**
     * Whether to wait for all instances to be created/updated before returning.
     *
     * Note that if this is set to true and the operation does not succeed, Terraform will continue trying until it times out.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#wait_for_instances ComputeInstanceGroupManager#wait_for_instances}
     *
     * @stability stable
     */
    readonly waitForInstances?: boolean | cdktf.IResolvable;
    /**
     * When used with wait_for_instances specifies the status to wait for.
     *
     * When STABLE is specified this resource will wait until the instances are stable before returning. When UPDATED is set, it will wait for the version target to be reached and any per instance configs to be effective as well as all instances to be stable before returning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#wait_for_instances_status ComputeInstanceGroupManager#wait_for_instances_status}
     *
     * @stability stable
     */
    readonly waitForInstancesStatus?: string;
    /**
     * The zone that instances in this group should be created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#zone ComputeInstanceGroupManager#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * auto_healing_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#auto_healing_policies ComputeInstanceGroupManager#auto_healing_policies}
     *
     * @stability stable
     */
    readonly autoHealingPolicies?: ComputeInstanceGroupManagerAutoHealingPolicies;
    /**
     * named_port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#named_port ComputeInstanceGroupManager#named_port}
     *
     * @stability stable
     */
    readonly namedPort?: ComputeInstanceGroupManagerNamedPort[];
    /**
     * stateful_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#stateful_disk ComputeInstanceGroupManager#stateful_disk}
     *
     * @stability stable
     */
    readonly statefulDisk?: ComputeInstanceGroupManagerStatefulDisk[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#timeouts ComputeInstanceGroupManager#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceGroupManagerTimeouts;
    /**
     * update_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#update_policy ComputeInstanceGroupManager#update_policy}
     *
     * @stability stable
     */
    readonly updatePolicy?: ComputeInstanceGroupManagerUpdatePolicy;
    /**
     * version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#version ComputeInstanceGroupManager#version}
     *
     * @stability stable
     */
    readonly version: ComputeInstanceGroupManagerVersion[];
}
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allEffective(): any;
}
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerStatusStateful extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hasStatefulConfig(): any;
    /**
     * @stability stable
     */
    get perInstanceConfigs(): any;
}
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerStatusVersionTarget extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isReached(): any;
}
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get isStable(): any;
    /**
     * @stability stable
     */
    get stateful(): any;
    /**
     * @stability stable
     */
    get versionTarget(): any;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerAutoHealingPolicies {
    /**
     * The health check resource that signals autohealing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#health_check ComputeInstanceGroupManager#health_check}
     *
     * @stability stable
     */
    readonly healthCheck: string;
    /**
     * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances.
     *
     * Between 0 and 3600.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#initial_delay_sec ComputeInstanceGroupManager#initial_delay_sec}
     *
     * @stability stable
     */
    readonly initialDelaySec: number;
}
export declare function computeInstanceGroupManagerAutoHealingPoliciesToTerraform(struct?: ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference | ComputeInstanceGroupManagerAutoHealingPolicies): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceGroupManagerAutoHealingPolicies | undefined);
    private _healthCheck?;
    /**
     * @stability stable
     */
    get healthCheck(): string;
    /**
     * @stability stable
     */
    set healthCheck(value: string);
    /**
     * @stability stable
     */
    get healthCheckInput(): string | undefined;
    private _initialDelaySec?;
    /**
     * @stability stable
     */
    get initialDelaySec(): number;
    /**
     * @stability stable
     */
    set initialDelaySec(value: number);
    /**
     * @stability stable
     */
    get initialDelaySecInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerNamedPort {
    /**
     * The name of the port.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#name ComputeInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#port ComputeInstanceGroupManager#port}
     *
     * @stability stable
     */
    readonly port: number;
}
export declare function computeInstanceGroupManagerNamedPortToTerraform(struct?: ComputeInstanceGroupManagerNamedPort): any;
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerStatefulDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the disk when the VM is deleted, but do not delete the disk. ON_PERMANENT_INSTANCE_DELETION will delete the stateful disk when the VM is permanently deleted from the instance group. The default is NEVER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#delete_rule ComputeInstanceGroupManager#delete_rule}
     *
     * @stability stable
     */
    readonly deleteRule?: string;
    /**
     * The device name of the disk to be attached.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#device_name ComputeInstanceGroupManager#device_name}
     *
     * @stability stable
     */
    readonly deviceName: string;
}
export declare function computeInstanceGroupManagerStatefulDiskToTerraform(struct?: ComputeInstanceGroupManagerStatefulDisk): any;
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#create ComputeInstanceGroupManager#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#delete ComputeInstanceGroupManager#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#update ComputeInstanceGroupManager#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeInstanceGroupManagerTimeoutsToTerraform(struct?: ComputeInstanceGroupManagerTimeoutsOutputReference | ComputeInstanceGroupManagerTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceGroupManagerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceGroupManagerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerUpdatePolicy {
    /**
     * The maximum number of instances that can be created above the specified targetSize during the update process.
     *
     * Conflicts with max_surge_percent. If neither is set, defaults to 1
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#max_surge_fixed ComputeInstanceGroupManager#max_surge_fixed}
     *
     * @stability stable
     */
    readonly maxSurgeFixed?: number;
    /**
     * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process.
     *
     * Conflicts with max_surge_fixed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#max_surge_percent ComputeInstanceGroupManager#max_surge_percent}
     *
     * @stability stable
     */
    readonly maxSurgePercent?: number;
    /**
     * The maximum number of instances that can be unavailable during the update process.
     *
     * Conflicts with max_unavailable_percent. If neither is set, defaults to 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#max_unavailable_fixed ComputeInstanceGroupManager#max_unavailable_fixed}
     *
     * @stability stable
     */
    readonly maxUnavailableFixed?: number;
    /**
     * The maximum number of instances(calculated as percentage) that can be unavailable during the update process. Conflicts with max_unavailable_fixed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#max_unavailable_percent ComputeInstanceGroupManager#max_unavailable_percent}
     *
     * @stability stable
     */
    readonly maxUnavailablePercent?: number;
    /**
     * Minimum number of seconds to wait for after a newly created instance becomes available.
     *
     * This value must be from range [0, 3600].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#min_ready_sec ComputeInstanceGroupManager#min_ready_sec}
     *
     * @stability stable
     */
    readonly minReadySec?: number;
    /**
     * Minimal action to be taken on an instance.
     *
     * You can specify either RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a RESTART, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#minimal_action ComputeInstanceGroupManager#minimal_action}
     *
     * @stability stable
     */
    readonly minimalAction: string;
    /**
     * The instance replacement method for managed instance groups.
     *
     * Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#replacement_method ComputeInstanceGroupManager#replacement_method}
     *
     * @stability stable
     */
    readonly replacementMethod?: string;
    /**
     * The type of update process.
     *
     * You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#type ComputeInstanceGroupManager#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function computeInstanceGroupManagerUpdatePolicyToTerraform(struct?: ComputeInstanceGroupManagerUpdatePolicyOutputReference | ComputeInstanceGroupManagerUpdatePolicy): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceGroupManagerUpdatePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceGroupManagerUpdatePolicy | undefined);
    private _maxSurgeFixed?;
    /**
     * @stability stable
     */
    get maxSurgeFixed(): number;
    /**
     * @stability stable
     */
    set maxSurgeFixed(value: number);
    /**
     * @stability stable
     */
    resetMaxSurgeFixed(): void;
    /**
     * @stability stable
     */
    get maxSurgeFixedInput(): number | undefined;
    private _maxSurgePercent?;
    /**
     * @stability stable
     */
    get maxSurgePercent(): number;
    /**
     * @stability stable
     */
    set maxSurgePercent(value: number);
    /**
     * @stability stable
     */
    resetMaxSurgePercent(): void;
    /**
     * @stability stable
     */
    get maxSurgePercentInput(): number | undefined;
    private _maxUnavailableFixed?;
    /**
     * @stability stable
     */
    get maxUnavailableFixed(): number;
    /**
     * @stability stable
     */
    set maxUnavailableFixed(value: number);
    /**
     * @stability stable
     */
    resetMaxUnavailableFixed(): void;
    /**
     * @stability stable
     */
    get maxUnavailableFixedInput(): number | undefined;
    private _maxUnavailablePercent?;
    /**
     * @stability stable
     */
    get maxUnavailablePercent(): number;
    /**
     * @stability stable
     */
    set maxUnavailablePercent(value: number);
    /**
     * @stability stable
     */
    resetMaxUnavailablePercent(): void;
    /**
     * @stability stable
     */
    get maxUnavailablePercentInput(): number | undefined;
    private _minReadySec?;
    /**
     * @stability stable
     */
    get minReadySec(): number;
    /**
     * @stability stable
     */
    set minReadySec(value: number);
    /**
     * @stability stable
     */
    resetMinReadySec(): void;
    /**
     * @stability stable
     */
    get minReadySecInput(): number | undefined;
    private _minimalAction?;
    /**
     * @stability stable
     */
    get minimalAction(): string;
    /**
     * @stability stable
     */
    set minimalAction(value: string);
    /**
     * @stability stable
     */
    get minimalActionInput(): string | undefined;
    private _replacementMethod?;
    /**
     * @stability stable
     */
    get replacementMethod(): string;
    /**
     * @stability stable
     */
    set replacementMethod(value: string);
    /**
     * @stability stable
     */
    resetReplacementMethod(): void;
    /**
     * @stability stable
     */
    get replacementMethodInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerVersionTargetSize {
    /**
     * The number of instances which are managed for this version. Conflicts with percent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#fixed ComputeInstanceGroupManager#fixed}
     *
     * @stability stable
     */
    readonly fixed?: number;
    /**
     * The number of instances (calculated as percentage) which are managed for this version.
     *
     * Conflicts with fixed. Note that when using percent, rounding will be in favor of explicitly set target_size values; a managed instance group with 2 instances and 2 versions, one of which has a target_size.percent of 60 will create 2 instances of that version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#percent ComputeInstanceGroupManager#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
export declare function computeInstanceGroupManagerVersionTargetSizeToTerraform(struct?: ComputeInstanceGroupManagerVersionTargetSizeOutputReference | ComputeInstanceGroupManagerVersionTargetSize): any;
/**
 * @stability stable
 */
export declare class ComputeInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeInstanceGroupManagerVersionTargetSize | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeInstanceGroupManagerVersionTargetSize | undefined);
    private _fixed?;
    /**
     * @stability stable
     */
    get fixed(): number;
    /**
     * @stability stable
     */
    set fixed(value: number);
    /**
     * @stability stable
     */
    resetFixed(): void;
    /**
     * @stability stable
     */
    get fixedInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number;
    /**
     * @stability stable
     */
    set percent(value: number);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeInstanceGroupManagerVersion {
    /**
     * The full URL to an instance template from which all new instances of this version will be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#instance_template ComputeInstanceGroupManager#instance_template}
     *
     * @stability stable
     */
    readonly instanceTemplate: string;
    /**
     * Version name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#name ComputeInstanceGroupManager#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * target_size block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html#target_size ComputeInstanceGroupManager#target_size}
     *
     * @stability stable
     */
    readonly targetSize?: ComputeInstanceGroupManagerVersionTargetSize;
}
export declare function computeInstanceGroupManagerVersionToTerraform(struct?: ComputeInstanceGroupManagerVersion): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html google_compute_instance_group_manager}.
 *
 * @stability stable
 */
export declare class ComputeInstanceGroupManager extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_manager.html google_compute_instance_group_manager} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceGroupManagerConfig);
    private _baseInstanceName?;
    /**
     * @stability stable
     */
    get baseInstanceName(): string;
    /**
     * @stability stable
     */
    set baseInstanceName(value: string);
    /**
     * @stability stable
     */
    get baseInstanceNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceGroup(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get operation(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    status(index: string): ComputeInstanceGroupManagerStatus;
    private _targetPools?;
    /**
     * @stability stable
     */
    get targetPools(): string[];
    /**
     * @stability stable
     */
    set targetPools(value: string[]);
    /**
     * @stability stable
     */
    resetTargetPools(): void;
    /**
     * @stability stable
     */
    get targetPoolsInput(): string[] | undefined;
    private _targetSize?;
    /**
     * @stability stable
     */
    get targetSize(): number;
    /**
     * @stability stable
     */
    set targetSize(value: number);
    /**
     * @stability stable
     */
    resetTargetSize(): void;
    /**
     * @stability stable
     */
    get targetSizeInput(): number | undefined;
    private _waitForInstances?;
    /**
     * @stability stable
     */
    get waitForInstances(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set waitForInstances(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWaitForInstances(): void;
    /**
     * @stability stable
     */
    get waitForInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForInstancesStatus?;
    /**
     * @stability stable
     */
    get waitForInstancesStatus(): string;
    /**
     * @stability stable
     */
    set waitForInstancesStatus(value: string);
    /**
     * @stability stable
     */
    resetWaitForInstancesStatus(): void;
    /**
     * @stability stable
     */
    get waitForInstancesStatusInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _autoHealingPolicies;
    /**
     * @stability stable
     */
    get autoHealingPolicies(): ComputeInstanceGroupManagerAutoHealingPoliciesOutputReference;
    /**
     * @stability stable
     */
    putAutoHealingPolicies(value: ComputeInstanceGroupManagerAutoHealingPolicies): void;
    /**
     * @stability stable
     */
    resetAutoHealingPolicies(): void;
    /**
     * @stability stable
     */
    get autoHealingPoliciesInput(): ComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    private _namedPort?;
    /**
     * @stability stable
     */
    get namedPort(): ComputeInstanceGroupManagerNamedPort[];
    /**
     * @stability stable
     */
    set namedPort(value: ComputeInstanceGroupManagerNamedPort[]);
    /**
     * @stability stable
     */
    resetNamedPort(): void;
    /**
     * @stability stable
     */
    get namedPortInput(): ComputeInstanceGroupManagerNamedPort[] | undefined;
    private _statefulDisk?;
    /**
     * @stability stable
     */
    get statefulDisk(): ComputeInstanceGroupManagerStatefulDisk[];
    /**
     * @stability stable
     */
    set statefulDisk(value: ComputeInstanceGroupManagerStatefulDisk[]);
    /**
     * @stability stable
     */
    resetStatefulDisk(): void;
    /**
     * @stability stable
     */
    get statefulDiskInput(): ComputeInstanceGroupManagerStatefulDisk[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceGroupManagerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInstanceGroupManagerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceGroupManagerTimeouts | undefined;
    private _updatePolicy;
    /**
     * @stability stable
     */
    get updatePolicy(): ComputeInstanceGroupManagerUpdatePolicyOutputReference;
    /**
     * @stability stable
     */
    putUpdatePolicy(value: ComputeInstanceGroupManagerUpdatePolicy): void;
    /**
     * @stability stable
     */
    resetUpdatePolicy(): void;
    /**
     * @stability stable
     */
    get updatePolicyInput(): ComputeInstanceGroupManagerUpdatePolicy | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): ComputeInstanceGroupManagerVersion[];
    /**
     * @stability stable
     */
    set version(value: ComputeInstanceGroupManagerVersion[]);
    /**
     * @stability stable
     */
    get versionInput(): ComputeInstanceGroupManagerVersion[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
