import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretManagerSecretIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#member SecretManagerSecretIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#project SecretManagerSecretIamMember#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#role SecretManagerSecretIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#secret_id SecretManagerSecretIamMember#secret_id}.
     *
     * @stability stable
     */
    readonly secretId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#condition SecretManagerSecretIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: SecretManagerSecretIamMemberCondition;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#description SecretManagerSecretIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#expression SecretManagerSecretIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html#title SecretManagerSecretIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function secretManagerSecretIamMemberConditionToTerraform(struct?: SecretManagerSecretIamMemberConditionOutputReference | SecretManagerSecretIamMemberCondition): any;
/**
 * @stability stable
 */
export declare class SecretManagerSecretIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecretManagerSecretIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecretManagerSecretIamMemberCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html google_secret_manager_secret_iam_member}.
 *
 * @stability stable
 */
export declare class SecretManagerSecretIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_iam_member.html google_secret_manager_secret_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _secretId?;
    /**
     * @stability stable
     */
    get secretId(): string;
    /**
     * @stability stable
     */
    set secretId(value: string);
    /**
     * @stability stable
     */
    get secretIdInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): SecretManagerSecretIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: SecretManagerSecretIamMemberCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): SecretManagerSecretIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
