import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type REGISTRY::TEST::RESOURCE::MODULE.
 *
 * @schema CfnResource1ModuleProps
 */
export interface CfnResource1ModuleProps {
    /**
     * @schema CfnResource1ModuleProps#Parameters
     */
    readonly parameters?: CfnResource1ModulePropsParameters;
    /**
     * @schema CfnResource1ModuleProps#Resources
     */
    readonly resources?: CfnResource1ModulePropsResources;
}
/**
 * Converts an object of type 'CfnResource1ModuleProps' to JSON representation.
 */
export declare function toJson_CfnResource1ModuleProps(obj: CfnResource1ModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnResource1ModulePropsParameters
 */
export interface CfnResource1ModulePropsParameters {
    /**
     * Name for the bucket.
     *
     * @schema CfnResource1ModulePropsParameters#BucketName
     */
    readonly bucketName?: CfnResource1ModulePropsParametersBucketName;
}
/**
 * Converts an object of type 'CfnResource1ModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnResource1ModulePropsParameters(obj: CfnResource1ModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnResource1ModulePropsResources
 */
export interface CfnResource1ModulePropsResources {
    /**
     * @schema CfnResource1ModulePropsResources#S3Bucket
     */
    readonly s3Bucket?: CfnResource1ModulePropsResourcesS3Bucket;
}
/**
 * Converts an object of type 'CfnResource1ModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnResource1ModulePropsResources(obj: CfnResource1ModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Name for the bucket.
 *
 * @schema CfnResource1ModulePropsParametersBucketName
 */
export interface CfnResource1ModulePropsParametersBucketName {
    /**
     * @schema CfnResource1ModulePropsParametersBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnResource1ModulePropsParametersBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnResource1ModulePropsParametersBucketName' to JSON representation.
 */
export declare function toJson_CfnResource1ModulePropsParametersBucketName(obj: CfnResource1ModulePropsParametersBucketName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnResource1ModulePropsResourcesS3Bucket
 */
export interface CfnResource1ModulePropsResourcesS3Bucket {
    /**
     * @schema CfnResource1ModulePropsResourcesS3Bucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnResource1ModulePropsResourcesS3Bucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnResource1ModulePropsResourcesS3Bucket' to JSON representation.
 */
export declare function toJson_CfnResource1ModulePropsResourcesS3Bucket(obj: CfnResource1ModulePropsResourcesS3Bucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `REGISTRY::TEST::RESOURCE1::MODULE`.
 *
 * @external
 * @cloudformationResource REGISTRY::TEST::RESOURCE1::MODULE
 * @link http://unknown-url
 */
export declare class CfnResource1Module extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "REGISTRY::TEST::RESOURCE1::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnResource1ModuleProps;
    /**
     * Create a new `REGISTRY::TEST::RESOURCE1::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResource1ModuleProps);
}
