# vrt_lss_fieldservice
VeeRoute.LSS Field Service Engineers API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.6.163884
- Package version: 3.6.163884
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_fieldservice
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_fieldservice
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import vrt_lss_fieldservice
from vrt_lss_fieldservice.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.veeroute.tech/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_lss_fieldservice.Configuration(
    host = "https://api.veeroute.tech/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_lss_fieldservice.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_lss_fieldservice.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vrt_lss_fieldservice.AnalyticsApi(api_client)
    analytics_task = vrt_lss_fieldservice.AnalyticsTask() # AnalyticsTask | Request for analytics.

    try:
        # Planning result analytics.
        api_response = api_instance.analytics(analytics_task)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnalyticsApi->analytics: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyticsApi* | [**analytics**](docs/AnalyticsApi.md#analytics) | **POST** /fieldservice/analytics/xlsx | Planning result analytics.
*ConvertApi* | [**convert_to_json**](docs/ConvertApi.md#convert_to_json) | **POST** /fieldservice/convert/json | Conversion of planning task and result.
*ConvertApi* | [**convert_to_xlsx**](docs/ConvertApi.md#convert_to_xlsx) | **POST** /fieldservice/convert/xlsx | Conversion of planning task and result.
*PlanApi* | [**delete_result**](docs/PlanApi.md#delete_result) | **DELETE** /fieldservice/result/{id} | Planning result removal.
*PlanApi* | [**get_result**](docs/PlanApi.md#get_result) | **GET** /fieldservice/result/{id} | Getting the planning result.
*PlanApi* | [**plan**](docs/PlanApi.md#plan) | **POST** /fieldservice/plan | Planning, synchronous call.
*PlanApi* | [**run_plan**](docs/PlanApi.md#run_plan) | **POST** /fieldservice/run_plan | Launching the planning process.
*PredictApi* | [**predict**](docs/PredictApi.md#predict) | **POST** /fieldservice/predict | Time window prediction.
*SystemApi* | [**check**](docs/SystemApi.md#check) | **GET** /fieldservice/check | Checking the service availability.
*SystemApi* | [**version**](docs/SystemApi.md#version) | **GET** /fieldservice/version | Getting the service version.
*ValidateApi* | [**validate**](docs/ValidateApi.md#validate) | **POST** /fieldservice/validate | Data validation for planning.


## Documentation For Models

 - [AnalyticsTask](docs/AnalyticsTask.md)
 - [CalculationDetail](docs/CalculationDetail.md)
 - [Capacity](docs/Capacity.md)
 - [CapacityFactor](docs/CapacityFactor.md)
 - [CheckResult](docs/CheckResult.md)
 - [ConvertSettings](docs/ConvertSettings.md)
 - [ConvertTask](docs/ConvertTask.md)
 - [CostPenalty](docs/CostPenalty.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse406](docs/InlineResponse406.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [Location](docs/Location.md)
 - [Measurements](docs/Measurements.md)
 - [ObjectsMetrics](docs/ObjectsMetrics.md)
 - [Order](docs/Order.md)
 - [OrderCost](docs/OrderCost.md)
 - [Performer](docs/Performer.md)
 - [PlanAssumptions](docs/PlanAssumptions.md)
 - [PlanId](docs/PlanId.md)
 - [PlanInfo](docs/PlanInfo.md)
 - [PlanResult](docs/PlanResult.md)
 - [PlanSettings](docs/PlanSettings.md)
 - [PlanStatistics](docs/PlanStatistics.md)
 - [PlanStatus](docs/PlanStatus.md)
 - [PlanTask](docs/PlanTask.md)
 - [PredictResult](docs/PredictResult.md)
 - [PredictResultWindow](docs/PredictResultWindow.md)
 - [PredictTask](docs/PredictTask.md)
 - [QualityStatistics](docs/QualityStatistics.md)
 - [Routing](docs/Routing.md)
 - [RoutingMatrix](docs/RoutingMatrix.md)
 - [Shift](docs/Shift.md)
 - [Statistics](docs/Statistics.md)
 - [StopStatistics](docs/StopStatistics.md)
 - [Tariff](docs/Tariff.md)
 - [TariffPrimary](docs/TariffPrimary.md)
 - [TimeWindow](docs/TimeWindow.md)
 - [TimeWindowViolation](docs/TimeWindowViolation.md)
 - [TraceData](docs/TraceData.md)
 - [TrafficFactor](docs/TrafficFactor.md)
 - [TransportFactor](docs/TransportFactor.md)
 - [TransportLoad](docs/TransportLoad.md)
 - [TransportType](docs/TransportType.md)
 - [Trip](docs/Trip.md)
 - [TripAction](docs/TripAction.md)
 - [TripStatistics](docs/TripStatistics.md)
 - [UnplannedOrder](docs/UnplannedOrder.md)
 - [ValidateResult](docs/ValidateResult.md)
 - [Validation](docs/Validation.md)
 - [VersionResult](docs/VersionResult.md)
 - [Waypoint](docs/Waypoint.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


