import React from 'react';
import { VDomRenderer } from '@jupyterlab/apputils';
import { JupyterFrontEnd, ILabShell } from '@jupyterlab/application';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { INotebookTracker } from '@jupyterlab/notebook';
import { NotebookListener } from './utils/NotebookListener';
import { ActiveNotebookListener } from './utils/ActiveNotebookListener';
import { InstanceConfig } from './types';
export interface SidebarPanelOptions {
    app: JupyterFrontEnd;
    settingRegistry: ISettingRegistry;
    labShell: ILabShell;
    notebookTracker: INotebookTracker;
    widgetId: string;
    instanceConfig: InstanceConfig;
}
export declare class SidebarPanel extends VDomRenderer {
    app: JupyterFrontEnd;
    settingRegistry: ISettingRegistry;
    notebookListener: NotebookListener;
    activeNotebookListener: ActiveNotebookListener;
    instanceConfig: InstanceConfig;
    constructor(options: SidebarPanelOptions);
    render(): React.ReactElement;
}
