import React, { useState } from 'react';
import { createUseStyles } from 'react-jss';
import { FileDIDItemDetails } from './FileDIDItemDetails';
import { ContainerDIDItemDetails } from './ContainerDIDItemDetails';
import { toHumanReadableSize } from '../../utils/Helpers';
const useStyles = createUseStyles({
    listItemContainer: {
        borderBottom: '1px solid #E0E0E0'
    },
    listItem: {
        display: 'flex',
        flexDirection: 'row',
        fontSize: '9pt',
        alignItems: 'stretch',
        padding: '8px 16px 8px 16px',
        cursor: 'pointer'
    },
    listItemCollapsed: {
        extend: 'listItem',
        '&:hover': {
            backgroundColor: '#eeeeee'
        }
    },
    listItemExpanded: {
        extend: 'listItem',
        backgroundColor: '#F8F8F8'
    },
    textContainer: {
        flex: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden'
    },
    iconContainer: {
        lineHeight: 0,
        marginRight: '8px'
    },
    icon: {
        fontSize: '16px'
    },
    fileIcon: {
        extend: 'icon',
        color: '#66B100'
    },
    containerIcon: {
        extend: 'icon',
        color: '#5DC0FD'
    },
    datasetIcon: {
        extend: 'icon',
        color: '#FFB100'
    },
    sizeContainer: {
        color: '#808080'
    }
});
export const DIDListItem = ({ did, size, type, onClick, expand }) => {
    const classes = useStyles();
    const [open, setOpen] = useState(expand);
    const handleItemClick = () => {
        if (onClick) {
            if (!onClick()) {
                return;
            }
        }
        setOpen(!open);
    };
    return (React.createElement("div", { className: classes.listItemContainer },
        React.createElement("div", { className: open ? classes.listItemExpanded : classes.listItemCollapsed, onClick: handleItemClick },
            React.createElement("div", { className: classes.iconContainer },
                type === 'file' && React.createElement("i", { className: `${classes.fileIcon} material-icons` }, "attachment"),
                type === 'container' && React.createElement("i", { className: `${classes.containerIcon} material-icons` }, "folder")),
            React.createElement("div", { className: classes.textContainer }, did),
            !!size && React.createElement("div", { className: classes.sizeContainer }, toHumanReadableSize(size))),
        !!open && type === 'file' && React.createElement(FileDIDItemDetails, { did: did }),
        !!open && type === 'container' && React.createElement(ContainerDIDItemDetails, { did: did })));
};
