var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect, useMemo } from 'react';
import { createUseStyles } from 'react-jss';
import { useStoreState } from 'pullstate';
import { Spinning } from '../Spinning';
import { withRequestAPI } from '../../utils/Actions';
import { UIStore } from '../../stores/UIStore';
import { computeContainerState } from '../../utils/Helpers';
import { ExtensionStore } from '../../stores/ExtensionStore';
const useStyles = createUseStyles({
    listItemContainer: {
        display: 'flex',
        flexDirection: 'row',
        borderBottom: '1px solid #E0E0E0',
        padding: '8px 16px 8px 16px',
        fontSize: '9pt'
    },
    listItemIconContainer: {
        paddingRight: '8px'
    },
    listItemContent: {
        flex: 1
    },
    did: {
        textOverflow: 'ellipsis',
        overflow: 'hidden'
    },
    variableName: {
        color: '#808080'
    },
    statusIcon: {
        marginTop: '2px',
        fontSize: '9pt'
    },
    availableIcon: {
        extend: 'statusIcon',
        color: '#5a9216'
    },
    notAvailableIcon: {
        extend: 'statusIcon',
        color: '#dd2c00'
    },
    replicatingIcon: {
        extend: 'statusIcon',
        color: '#ffa000'
    },
    pendingInjectionIcon: {
        extend: 'statusIcon',
        color: '#a5d6a7'
    },
    notResolvedIcon: {
        extend: 'statusIcon',
        color: '#e0e0e0'
    },
    actionContainer: {},
    clearButton: {
        alignItems: 'center',
        padding: '4px',
        lineHeight: 0,
        cursor: 'pointer'
    },
    clearIcon: {
        color: '#dd2c0090',
        fontSize: '16px',
        lineHeight: '24px',
        '&:hover': {
            color: '#dd2c00'
        }
    }
});
const _NotebookAttachmentListItem = (_a) => {
    var { attachment, status } = _a, props = __rest(_a, ["attachment", "status"]);
    const classes = useStyles();
    const { actions } = props;
    const { did } = attachment;
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const fileDetails = useStoreState(UIStore, s => s.fileDetails[did]);
    const containerDetails = useStoreState(UIStore, s => s.containerDetails[did]);
    useEffect(() => {
        if (attachment.type === 'file') {
            actions.getFileDIDDetails(activeInstance.name, did);
        }
        else {
            actions.getContainerDIDDetails(activeInstance.name, did);
        }
    }, []);
    const deleteAttachment = () => {
        ExtensionStore.update(s => {
            s.activeNotebookAttachment = s.activeNotebookAttachment.filter(a => a.did !== did);
        });
    };
    const containerState = useMemo(() => {
        return containerDetails ? computeContainerState(containerDetails) : undefined;
    }, [containerDetails]);
    return (React.createElement("div", { className: classes.listItemContainer },
        React.createElement("div", { className: classes.listItemIconContainer },
            !fileDetails && !containerDetails && React.createElement(ResolverStatusIcon, { status: status }),
            !!fileDetails && React.createElement(FileStatusIcon, { status: fileDetails.status, resolverStatus: status }),
            !!containerState && React.createElement(ContainerStatusIcon, { status: containerState, resolverStatus: status })),
        React.createElement("div", { className: classes.listItemContent },
            React.createElement("div", { className: classes.did }, attachment.did),
            React.createElement("div", { className: classes.variableName }, attachment.variableName)),
        React.createElement("div", { className: classes.actionContainer },
            React.createElement("div", { className: classes.clearButton, onClick: deleteAttachment },
                React.createElement("i", { className: `${classes.clearIcon} material-icons` }, "clear")))));
};
const ResolverStatusIcon = ({ status }) => {
    const classes = useStyles();
    switch (status) {
        case 'RESOLVING':
            return React.createElement(Spinning, { className: `${classes.statusIcon} material-icons` }, "hourglass_top");
        case 'PENDING_INJECTION':
            return React.createElement("i", { className: `${classes.pendingInjectionIcon} material-icons` }, "lens");
        case 'READY':
            return React.createElement("i", { className: `${classes.availableIcon} material-icons` }, "check_circle");
        case 'FAILED':
            return React.createElement("i", { className: `${classes.notAvailableIcon} material-icons` }, "cancel");
        default:
            return React.createElement("i", { className: `${classes.notResolvedIcon} material-icons` }, "lens");
    }
};
const FileStatusIcon = ({ status, resolverStatus }) => {
    const classes = useStyles();
    switch (status) {
        case 'REPLICATING':
            return React.createElement(Spinning, { className: `${classes.replicatingIcon} material-icons` }, "hourglass_top");
        case 'NOT_AVAILABLE':
        case 'STUCK':
            return React.createElement("i", { className: `${classes.notAvailableIcon} material-icons` }, "lens");
        default:
            return React.createElement(ResolverStatusIcon, { status: resolverStatus });
    }
};
const ContainerStatusIcon = ({ status, resolverStatus }) => {
    const classes = useStyles();
    switch (status) {
        case 'REPLICATING':
            return React.createElement(Spinning, { className: `${classes.replicatingIcon} material-icons` }, "hourglass_top");
        case 'NOT_AVAILABLE':
        case 'STUCK':
        case 'PARTIALLY_AVAILABLE':
            return React.createElement("i", { className: `${classes.notAvailableIcon} material-icons` }, "lens");
        default:
            return React.createElement(ResolverStatusIcon, { status: resolverStatus });
    }
};
export const NotebookAttachmentListItem = withRequestAPI(_NotebookAttachmentListItem);
