import React, { useMemo, useState, useEffect } from 'react';
import { createUseStyles } from 'react-jss';
import Select from 'react-select';
import { useStoreState } from 'pullstate';
import { UIStore, resetRucioCaches } from '../stores/UIStore';
import { Button } from '../components/Button';
import { withRequestAPI } from '../utils/Actions';
import { authTypeOptions } from '../const';
import { UserPassAuth } from '../components/@Settings/UserPassAuth';
import { X509Auth } from '../components/@Settings/X509Auth';
import { HorizontalHeading } from '../components/HorizontalHeading';
import { Spinning } from '../components/Spinning';
const useStyles = createUseStyles({
    content: {
        height: '100%',
        display: 'flex',
        flexDirection: 'column'
    },
    scrollable: {
        flex: 1,
        overflow: 'auto'
    },
    container: {
        padding: '16px'
    },
    buttonContainer: {
        extend: 'container',
        borderTop: '1px solid #e0e0e0'
    },
    label: {},
    instanceName: {
        fontSize: '16pt'
    },
    formControl: {
        marginTop: '8px'
    },
    formItem: {
        marginBottom: '16px'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    iconText: {
        verticalAlign: 'middle',
        paddingLeft: '4px'
    }
});
const _Settings = props => {
    const { actions } = props;
    const classes = useStyles();
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const activeAuthType = useStoreState(UIStore, s => s.activeAuthType);
    const instances = useStoreState(UIStore, s => s.instances) || [];
    const instanceDefaultValue = activeInstance ? { label: activeInstance.displayName, value: activeInstance.name } : null;
    const authTypeDefaultValue = activeAuthType ? authTypeOptions.find(o => o.value === activeAuthType) : null;
    const [selectedInstance, setSelectedInstance] = useState(instanceDefaultValue === null || instanceDefaultValue === void 0 ? void 0 : instanceDefaultValue.value);
    const [selectedAuthType, setSelectedAuthType] = useState(activeAuthType);
    const [rucioAuthCredentials, setRucioAuthCredentials] = useState();
    const [credentialsLoading, setCredentialsLoading] = useState(true);
    const instanceOptions = useMemo(() => instances === null || instances === void 0 ? void 0 : instances.map(i => ({ label: i.displayName, value: i.name })), [instances]);
    const setActiveInstance = (instanceName, authType) => {
        UIStore.update(s => {
            var _a;
            if (((_a = s.activeInstance) === null || _a === void 0 ? void 0 : _a.name) !== instanceName) {
                resetRucioCaches();
                const instance = instances.find(i => i.name === instanceName);
                s.activeInstance = instance;
            }
            if (s.activeAuthType !== authType) {
                s.activeAuthType = authType;
            }
        });
        actions.postActiveInstance(instanceName, authType).catch(e => console.log(e));
    };
    const saveSettings = () => {
        if (selectedInstance && selectedAuthType) {
            setActiveInstance(selectedInstance, selectedAuthType);
        }
        if (!!selectedAuthType && !!rucioAuthCredentials) {
            actions.putAuthConfig(selectedInstance, selectedAuthType, rucioAuthCredentials);
        }
    };
    const reloadAuthConfig = () => {
        if (!selectedInstance) {
            return;
        }
        setCredentialsLoading(true);
        actions
            .fetchAuthConfig(selectedInstance, selectedAuthType)
            .then(c => setRucioAuthCredentials(c))
            .catch(() => setRucioAuthCredentials(undefined))
            .finally(() => setCredentialsLoading(false));
    };
    useEffect(reloadAuthConfig, [selectedInstance, selectedAuthType]);
    const settingsComplete = selectedInstance && selectedAuthType;
    const selectStyles = {
        control: (provided, state) => (Object.assign(Object.assign({}, provided), { borderRadius: 0 }))
    };
    return (React.createElement("div", { className: classes.content },
        React.createElement("div", { className: classes.scrollable },
            React.createElement("div", { className: classes.container },
                React.createElement("div", { className: classes.formItem },
                    React.createElement("div", { className: classes.label }, "Active Instance"),
                    React.createElement(Select, { className: classes.formControl, options: instanceOptions, styles: selectStyles, defaultValue: instanceDefaultValue, onChange: (value) => {
                            setSelectedInstance(value.value);
                        } })),
                React.createElement("div", { className: classes.formItem },
                    React.createElement("div", { className: classes.label }, "Rucio Authentication"),
                    React.createElement(Select, { className: classes.formControl, options: authTypeOptions, styles: selectStyles, defaultValue: authTypeDefaultValue, onChange: (value) => {
                            setSelectedAuthType(value.value);
                        } }))),
            React.createElement("div", null,
                selectedAuthType === 'userpass' && !!selectedInstance && (React.createElement(React.Fragment, null,
                    React.createElement(HorizontalHeading, { title: "Username & Password" }),
                    !credentialsLoading && (React.createElement(UserPassAuth, { params: rucioAuthCredentials, onChange: v => setRucioAuthCredentials(v) })),
                    credentialsLoading && (React.createElement("div", { className: classes.container },
                        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
                        React.createElement("span", { className: classes.iconText }, "Loading..."))))),
                selectedAuthType === 'x509' && !!selectedInstance && (React.createElement(React.Fragment, null,
                    React.createElement(HorizontalHeading, { title: "X.509 User Certificate" }),
                    !credentialsLoading && (React.createElement(X509Auth, { params: rucioAuthCredentials, onChange: v => setRucioAuthCredentials(v) })),
                    credentialsLoading && (React.createElement("div", { className: classes.container },
                        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
                        React.createElement("span", { className: classes.iconText }, "Loading..."))))))),
        React.createElement("div", { className: classes.buttonContainer },
            React.createElement(Button, { block: true, onClick: saveSettings, disabled: !settingsComplete }, "Save Settings"))));
};
export const Settings = withRequestAPI(_Settings);
