"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipRule = exports.TriggerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const sipRuleValidator_1 = require("./sipRuleValidator");
var TriggerType;
(function (TriggerType) {
    TriggerType["TO_PHONE_NUMBER"] = "ToPhoneNumber";
    TriggerType["REQUEST_URI_HOSTNAME"] = "RequestUriHostname";
})(TriggerType = exports.TriggerType || (exports.TriggerType = {}));
class ChimeSipRule extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, triggerType, triggerValue, targetApplications } = props;
        sipRuleValidator_1.sipRuleValidator(props);
        const sipRuleRequest = new pstnCustomResources_1.PSTNResources(this, 'sipRuleRequest', {
            resourceType: 'SMARule',
            uid: uid,
            properties: {
                name: name !== null && name !== void 0 ? name : uid,
                triggerType: triggerType,
                triggerValue: triggerValue,
                targetApplications: targetApplications,
            },
        });
        this.sipRuleId =
            sipRuleRequest.pstnCustomResource.getAttString('sipRuleId');
    }
}
exports.ChimeSipRule = ChimeSipRule;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipRule[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipRule", version: "0.1.7" };
//# sourceMappingURL=data:application/json;base64,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