# Hardware-101 für Hardwarebausteine

In diesem Repository befinden sich für verschiedene Hardwarebausteine
grundlegende Informationen wie Datenblätter, Quelltext- und
Schaltungsbeispiele sowie eine Beschreibung.

![logo](img/1x/hardware-101-logo_wide.png)

- [apa102](apa102): RGB-LED-Streifen mit dem Chipsatz APA102
- [74HC595](74HC595): 8Bit-Schieberegister
- [DS18B20](ds18b20): Temperatursensor (1-WIRE)
- [ESP8266](esp8266): Microcontroller mit WLAN und Micropython-Unterstützung
- [Gertboard](gertboard): Erweiterungsboard für den Raspberry Pi
- [gpiozero](gpiozero): Einfache Bibliothek zur Ansteuerung der GPIO-Pins.
- [HD44780](hd44780): LCD Controller
- [led_matrix](led_matrix): Eine 5x7 LED-Matrix
- [lm75](lm75): Temperatursensor
- [mcp23017](mcp23017): Portexpander (I²C)
- [mcp23s17](mcp23s17): Portexpander (SPI)
- [mcp3208](mcp3208): Analog-Digital-Wandler (SPI)
- [mcp3426](mcp3426): Analog-Digtial-Wandler (I²C)
- [mcp4151](mcp4151): Digitalpotentiometer (SPI)
- [mpu6050](mpu6050): Beschleunigungssensor und Gyrometer (I²C)
- [Orange Pi Zero](orange_pi_zero): Einplatinencomputer
- [RGB-LED](rgb_led): LEDs mit vielen Farben
- [Raspberry Pi](raspi): Einplatinencomputer
- [servo](servo): Servomotoren mittels PWM
- [sh1106](sh1106): OLED Display Treiber
- [ssd1306](ssd1306): OLED Display Treiber
- [ws2811/ws2812](ws281x): RGB-LED-Streifen

- [fake-rpi](fake-rpi): Hilfe für die Programmentwicklung
- [Transistoren](Transistoren): Eine Übersicht (noch sehr übersichtlich)
- [IO-Emulator](https://tbs1-bo.github.io/ioemu/): Emulator für Eingabe-Ausgabe-Operationen.


## Hilf mit

Du kannst das Projekt mit eigenen Beiträgen ergänzen. Schau dazu bei den  
["good first issues"](https://github.com/tbs1-bo/hardware-101/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
nach, welche Themen noch benötigt werden.


![logo](img/hardware-101-logo2.png)
