import * as appscaling from '@aws-cdk/aws-applicationautoscaling';
/**
 * Interface for scalable attributes.
 *
 * @stability stable
 */
export interface IScalableTableAttribute {
    /**
     * Add scheduled scaling for this scaling attribute.
     *
     * @stability stable
     */
    scaleOnSchedule(id: string, actions: appscaling.ScalingSchedule): void;
    /**
     * Scale out or in to keep utilization at a given level.
     *
     * @stability stable
     */
    scaleOnUtilization(props: UtilizationScalingProps): void;
}
/**
 * Properties for enabling DynamoDB capacity scaling.
 *
 * @stability stable
 */
export interface EnableScalingProps {
    /**
     * Minimum capacity to scale to.
     *
     * @stability stable
     */
    readonly minCapacity: number;
    /**
     * Maximum capacity to scale to.
     *
     * @stability stable
     */
    readonly maxCapacity: number;
}
/**
 * Properties for enabling DynamoDB utilization tracking.
 *
 * @stability stable
 */
export interface UtilizationScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * Target utilization percentage for the attribute.
     *
     * @stability stable
     */
    readonly targetUtilizationPercent: number;
}
