/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import java.nio.ByteBuffer;
import java.util.List;
import org.omg.CORBA.INTERNAL;

@SASScope
public abstract class Packet
implements Cloneable {
    protected static final int INTERNAL = 0;
    protected static final int REQUEST = 1;
    protected static final int REPLY = 2;
    protected static final int EVENT = 3;
    protected static final int REQUEST_BY_NAME = 4;
    protected static final int EVENT_BY_NAME = 5;
    protected static final int MODIFIER = 6;
    protected static final int PACKET_TYPE_COUNT = 7;
    private static final String _defaultUUID = "00000000-0000-0000-0000-000000000000";
    private int _size;
    private int _type;
    private int _clientId;
    private int _objectId;
    private int _methodId;
    private int _replyId = -1;
    private int _mapCount;
    private String _uuid = "00000000-0000-0000-0000-000000000000";
    private List _modifierLst;

    protected Packet() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            INTERNAL internal = new INTERNAL();
            internal.initCause((Throwable)cnse);
            throw internal;
        }
    }

    protected abstract boolean isInbound();

    protected int getSize() {
        return this._size;
    }

    protected int getType() {
        return this._type;
    }

    protected int getClientId() {
        return this._clientId;
    }

    protected int getObjectId() {
        return this._objectId;
    }

    protected int getMethodId() {
        return this._methodId;
    }

    protected int getReplyId() {
        return this._replyId;
    }

    protected int getMapCount() {
        return this._mapCount;
    }

    protected String getUuid() {
        return this._uuid;
    }

    protected List getModifierLst() {
        return this._modifierLst;
    }

    protected void setSize(int size) {
        this._size = size;
    }

    protected void setType(int type) {
        this._type = type;
    }

    protected void setClientId(int clientId) {
        this._clientId = clientId;
    }

    protected void setObjectId(int objectId) {
        this._objectId = objectId;
    }

    protected void setMethodId(int methodId) {
        this._methodId = methodId;
    }

    protected void setReplyId(int replyId) {
        this._replyId = replyId;
    }

    protected void setMapCount(int i) {
        this._mapCount = i;
    }

    protected void setUuid(String uuid) {
        this._uuid = uuid != null ? uuid : _defaultUUID;
    }

    protected void setModifierLst(List modifierLst) {
        this._modifierLst = modifierLst;
    }

    protected static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "INTERNAL";
            }
            case 1: {
                return "REQUEST";
            }
            case 2: {
                return "REPLY";
            }
            case 3: {
                return "EVENT";
            }
            case 4: {
                return "REQUEST_BY_NAME";
            }
            case 5: {
                return "EVENT_BY_NAME";
            }
            case 6: {
                return "MODIFIER";
            }
        }
        return "WHO_KNOWS?";
    }

    protected static void checkForReadOnlyBuffer(ByteBuffer buffer) {
        if (buffer != null && !buffer.isReadOnly()) {
            throw new IllegalArgumentException();
        }
    }

    @SASScope
    protected static class CorrelatorModifier
    extends Modifier {
        private String _correlator;

        protected CorrelatorModifier(String correlator) {
            super(Integer.MIN_VALUE);
            this._correlator = correlator;
        }

        protected String getCorrelator() {
            return this._correlator;
        }
    }

    @SASScope
    protected static class Modifier {
        protected static final int PEM_Correlator = Integer.MIN_VALUE;
        protected static final int PEM_EncryptedPkt = 0x40000000;
        private int _type;

        protected Modifier(int type) {
            this._type = type;
        }

        protected int getType() {
            return this._type;
        }

        protected static String modifierPatternToString(int modifierPattern) {
            StringBuffer buf = new StringBuffer(32);
            boolean first = true;
            if ((modifierPattern & Integer.MIN_VALUE) != 0) {
                buf.append("PEM_Correlator");
                first = false;
            }
            if ((modifierPattern & 0x40000000) != 0) {
                if (!first) {
                    buf.append("|");
                }
                buf.append("PEM_EncryptedPkt");
                first = false;
            }
            String str = buf.toString();
            return str;
        }
    }
}

