/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.rio.MVACallableStatement;
import com.sas.rio.MVAConnectionProperties;
import com.sas.rio.MVADatabaseMetaData;
import com.sas.rio.MVAPreparedStatement;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLExceptionUnsupported;
import com.sas.rio.MVASQLWarning;
import com.sas.rio.MVAStatement;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOListener;
import com.sas.rio.RIOUtil;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class MVAConnection
implements Connection {
    @SASScope
    public static final int XHRSQPRECS = 100;
    private static final String UNDO = "RESET UNDO_POLICY = NONE";
    private final String url;
    private boolean _closed;
    private final CopyOnWriteArrayList<MVAStatement> statementList;
    private SQLWarning _warnings;
    protected int resultSetType;
    protected int resultSetConcurrency;
    private final RIOUtil rioUtil;
    private final MVAConnectionProperties mvaConnProps;
    private DatabaseMetaData metaData;
    private static final Logger logger = Logger.getLogger(MVAConnection.class);
    private static final AtomicLong connectionCounter = new AtomicLong();
    final String idForLogger;
    final AtomicLong statementCounter;
    private final String logPrefix;
    private final String logClose;
    private final String rioUtilLayout;
    private final String sasDataServiceLayout;
    private final String sasWorkspaceLayout;
    private final String logCreateStatement;
    private final String logCommit;
    private final String logRollback;
    private final String logPrepareCall;
    private final String logPrepareStatement;
    final RIOListener rioListener;

    public MVAConnection(String url, Properties info) throws SQLException {
        block5: {
            block4: {
                this.statementList = new CopyOnWriteArrayList();
                this.resultSetType = 1003;
                this.resultSetConcurrency = 1007;
                this.idForLogger = String.valueOf(connectionCounter.incrementAndGet());
                this.statementCounter = new AtomicLong();
                this.logPrefix = "conn(" + this.idForLogger + ")";
                this.logClose = this.logPrefix + "#close";
                this.rioUtilLayout = this.logPrefix + ": RioUtil";
                this.sasDataServiceLayout = this.logPrefix + ": sasDataService";
                this.sasWorkspaceLayout = this.logPrefix + ": sasWorkspace";
                this.logCreateStatement = this.logPrefix + "#createStatement";
                this.logCommit = this.logPrefix + "#commit";
                this.logRollback = this.logPrefix + "#rollback";
                this.logPrepareCall = this.logPrefix + "#prepareCall";
                this.logPrepareStatement = this.logPrefix + "#prepareStatement";
                this.rioListener = new RIOListener(){

                    @Override
                    public void notifyClosed() throws SQLException {
                        MVAConnection.this.close(false);
                    }
                };
                this.mvaConnProps = new MVAConnectionProperties(info, url);
                this.addWarning(this.mvaConnProps.getWarnings());
                this.url = url;
                this.rioUtil = new RIOUtil(this.mvaConnProps, this.rioListener);
                this.addWarning(this.rioUtil.getWarnings());
                this.rioUtil.clearWarnings();
                this.executeUndoPolicyNoneStatement();
                if (!logger.isTraceEnabled()) break block4;
                Properties props = this.mvaConnProps.getProperties();
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String propertyName = (String)e.nextElement();
                    String propertyValue = props.getProperty(propertyName);
                    if (propertyName.equalsIgnoreCase("password") && !propertyValue.isEmpty()) {
                        propertyValue = "xxxxxxxx";
                    }
                    String propertyMessage = this.logPrefix + ":  " + propertyName + "=" + propertyValue;
                    logger.info((Object)propertyMessage);
                }
                break block5;
            }
            if (!logger.isInfoEnabled()) break block5;
            String urlMessage = this.logPrefix + ": URL=" + url;
            logger.info((Object)urlMessage);
            for (Map.Entry<Object, Object> entry : MVAConnectionProperties.getNonDefaultProperties(this.mvaConnProps).entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (propertyName.equalsIgnoreCase("password") && !propertyValue.isEmpty()) {
                    propertyValue = "xxxxxxxx";
                }
                String propertyMessage = this.logPrefix + ":  " + propertyName + "=" + propertyValue;
                logger.info((Object)propertyMessage);
            }
        }
    }

    public MVAConnection(IDataService sasDataService, Properties info) throws SQLException {
        this.statementList = new CopyOnWriteArrayList();
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.idForLogger = String.valueOf(connectionCounter.incrementAndGet());
        this.statementCounter = new AtomicLong();
        this.logPrefix = "conn(" + this.idForLogger + ")";
        this.logClose = this.logPrefix + "#close";
        this.rioUtilLayout = this.logPrefix + ": RioUtil";
        this.sasDataServiceLayout = this.logPrefix + ": sasDataService";
        this.sasWorkspaceLayout = this.logPrefix + ": sasWorkspace";
        this.logCreateStatement = this.logPrefix + "#createStatement";
        this.logCommit = this.logPrefix + "#commit";
        this.logRollback = this.logPrefix + "#rollback";
        this.logPrepareCall = this.logPrefix + "#prepareCall";
        this.logPrepareStatement = this.logPrefix + "#prepareStatement";
        this.rioListener = new /* invalid duplicate definition of identical inner class */;
        this.url = null;
        this.mvaConnProps = new MVAConnectionProperties(info);
        SQLWarning sqlw = this.mvaConnProps.getWarnings();
        this.addWarning(sqlw);
        try {
            this.rioUtil = new RIOUtil(sasDataService, this.mvaConnProps, this.rioListener);
            this.addWarning(this.rioUtil.getWarnings());
            this.rioUtil.clearWarnings();
            this.executeUndoPolicyNoneStatement();
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAConnection_error, (Throwable)e, new Object[0]);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.sasDataServiceLayout);
            for (Map.Entry<Object, Object> entry : MVAConnectionProperties.getNonDefaultProperties(this.mvaConnProps).entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (propertyName.equalsIgnoreCase("password") && !propertyValue.isEmpty()) {
                    propertyValue = "xxxxxxxx";
                }
                String propertyMessage = this.logPrefix + ":  " + propertyName + "=" + propertyValue;
                logger.info((Object)propertyMessage);
            }
        }
    }

    public MVAConnection(IWorkspace sasWorkspace, Properties info) throws SQLException {
        this.statementList = new CopyOnWriteArrayList();
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.idForLogger = String.valueOf(connectionCounter.incrementAndGet());
        this.statementCounter = new AtomicLong();
        this.logPrefix = "conn(" + this.idForLogger + ")";
        this.logClose = this.logPrefix + "#close";
        this.rioUtilLayout = this.logPrefix + ": RioUtil";
        this.sasDataServiceLayout = this.logPrefix + ": sasDataService";
        this.sasWorkspaceLayout = this.logPrefix + ": sasWorkspace";
        this.logCreateStatement = this.logPrefix + "#createStatement";
        this.logCommit = this.logPrefix + "#commit";
        this.logRollback = this.logPrefix + "#rollback";
        this.logPrepareCall = this.logPrefix + "#prepareCall";
        this.logPrepareStatement = this.logPrefix + "#prepareStatement";
        this.rioListener = new /* invalid duplicate definition of identical inner class */;
        if (sasWorkspace == null) {
            throw new MVASQLException(MessageCode.MVAConnection_error, new Object[0]);
        }
        this.url = null;
        this.mvaConnProps = new MVAConnectionProperties(info);
        SQLWarning sqlw = this.mvaConnProps.getWarnings();
        this.addWarning(sqlw);
        try {
            this.rioUtil = new RIOUtil(sasWorkspace, this.mvaConnProps, this.rioListener);
            this.addWarning(this.rioUtil.getWarnings());
            this.rioUtil.clearWarnings();
            this.executeUndoPolicyNoneStatement();
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAConnection_error, (Throwable)e, new Object[0]);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.sasWorkspaceLayout);
            for (Map.Entry<Object, Object> entry : MVAConnectionProperties.getNonDefaultProperties(this.mvaConnProps).entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (propertyName.equalsIgnoreCase("password") && !propertyValue.isEmpty()) {
                    propertyValue = "xxxxxxxx";
                }
                String propertyMessage = this.logPrefix + ":  " + propertyName + "=" + propertyValue;
                logger.info((Object)propertyMessage);
            }
        }
    }

    public MVAConnection(RIOUtil x, Properties info) throws SQLException {
        this.statementList = new CopyOnWriteArrayList();
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.idForLogger = String.valueOf(connectionCounter.incrementAndGet());
        this.statementCounter = new AtomicLong();
        this.logPrefix = "conn(" + this.idForLogger + ")";
        this.logClose = this.logPrefix + "#close";
        this.rioUtilLayout = this.logPrefix + ": RioUtil";
        this.sasDataServiceLayout = this.logPrefix + ": sasDataService";
        this.sasWorkspaceLayout = this.logPrefix + ": sasWorkspace";
        this.logCreateStatement = this.logPrefix + "#createStatement";
        this.logCommit = this.logPrefix + "#commit";
        this.logRollback = this.logPrefix + "#rollback";
        this.logPrepareCall = this.logPrefix + "#prepareCall";
        this.logPrepareStatement = this.logPrefix + "#prepareStatement";
        this.rioListener = new /* invalid duplicate definition of identical inner class */;
        this.url = null;
        this.mvaConnProps = new MVAConnectionProperties(info);
        SQLWarning sqlw = this.mvaConnProps.getWarnings();
        this.addWarning(sqlw);
        try {
            this.rioUtil = x;
            this.executeUndoPolicyNoneStatement();
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAConnection_error, (Throwable)e, new Object[0]);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.rioUtilLayout);
            Properties props = this.mvaConnProps.getProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String propertyValue = props.getProperty(propertyName);
                if (propertyName.equalsIgnoreCase("password") && !propertyValue.isEmpty()) {
                    propertyValue = "xxxxxxxx";
                }
                String propertyMessage = this.logPrefix + ":  " + propertyName + "=" + propertyValue;
                logger.info((Object)propertyMessage);
            }
        }
    }

    public String getIdForLogger() {
        return this.idForLogger;
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        long startTime = System.nanoTime();
        MVAStatement statement = new MVAStatement(this);
        if (logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            logger.info((Object)(this.logCreateStatement + " type=" + this.getTypeName(this.resultSetType) + ", concur=" + this.getConcurrencyName(this.resultSetConcurrency) + "; created statement " + statement.getIdForLogger() + "; time= " + formatter.format(elapsedSeconds) + " secs"));
        }
        this.statementList.add(statement);
        return statement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        long startTime = System.nanoTime();
        MVAPreparedStatement prepstatement = new MVAPreparedStatement(this, sql);
        this.statementList.add(prepstatement);
        if (logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startTime;
            double elapsedSeconds = (double)elapsedNanos / 1.0E9;
            DecimalFormat formatter = new DecimalFormat();
            logger.info((Object)(this.logPrepareStatement + " sql=" + sql + "; prepared statement " + prepstatement.getIdForLogger() + "; time= " + formatter.format(elapsedSeconds) + " secs"));
        }
        return prepstatement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        if (logger.isDebugEnabled()) {
            logger.info((Object)(this.logPrepareCall + " " + sql));
        }
        return new MVACallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!autoCommit) {
            throw new MVASQLExceptionUnsupported(MessageCode.MVAConnection_transactionError, new Object[0]);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.logCommit);
        }
        for (MVAStatement statement : this.statementList) {
            statement.closeResources();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.logRollback);
        }
        throw new MVASQLExceptionUnsupported(MessageCode.MVAConnection_transactionError, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean freeResources) throws SQLException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.logClose);
        }
        if (!this._closed) {
            this._closed = true;
            try {
                for (MVAStatement statement : this.statementList) {
                    statement.close();
                }
            }
            finally {
                this.statementList.clear();
                if (freeResources) {
                    try {
                        this.rioUtil.disconnect();
                    }
                    catch (SQLException e) {
                        throw new MVASQLException(MessageCode.MVAConnection_closeError, (Throwable)e, new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new MVADatabaseMetaData(this);
        }
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (level != 0) {
            throw new MVASQLExceptionUnsupported(MessageCode.MVAConnection_noTransactionsError, new Object[0]);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    private void addWarning(SQLWarning warning) {
        if (warning != null) {
            if (this._warnings == null) {
                this._warnings = warning;
            } else {
                this._warnings.setNextWarning(warning);
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this._warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this._warnings = null;
    }

    private void checkClosed() throws SQLException {
        if (this._closed) {
            throw new MVASQLException(MessageCode.MVAConnection_closed, new Object[0]);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        MVASQLWarning warning;
        this.checkClosed();
        if (resultSetType != 1004 && resultSetType != 1003) {
            if (resultSetType == 1005) {
                warning = new MVASQLWarning(MessageCode.MVAConnection_scrollTypesWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1004;
            } else {
                warning = new MVASQLWarning(MessageCode.MVAConnection_rsTypeWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1003;
            }
        } else {
            this.resultSetType = resultSetType;
        }
        if (resultSetConcurrency != 1008 && resultSetConcurrency != 1007) {
            warning = new MVASQLWarning(MessageCode.MVAConnection_concurrencyTypesWarning, new Object[0]);
            this.addWarning(warning);
            this.resultSetConcurrency = 1007;
        } else {
            this.resultSetConcurrency = resultSetConcurrency;
        }
        return this.createStatement();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MVASQLWarning warning;
        this.checkClosed();
        if (resultSetType != 1003 && resultSetType != 1004) {
            if (resultSetType == 1005) {
                warning = new MVASQLWarning(MessageCode.MVAConnection_scrollTypesWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1004;
            } else {
                warning = new MVASQLWarning(MessageCode.MVAConnection_rsTypeWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1003;
            }
        } else {
            this.resultSetType = resultSetType;
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            warning = new MVASQLWarning(MessageCode.MVAConnection_concurrencyTypesWarning, new Object[0]);
            this.addWarning(warning);
            this.resultSetConcurrency = 1007;
        } else {
            this.resultSetConcurrency = resultSetConcurrency;
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        MVASQLWarning warning;
        this.checkClosed();
        if (resultSetType != 1003 && resultSetType != 1004) {
            if (resultSetType == 1005) {
                warning = new MVASQLWarning(MessageCode.MVAConnection_scrollTypesWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1004;
            } else {
                warning = new MVASQLWarning(MessageCode.MVAConnection_rsTypeWarning, new Object[0]);
                this.addWarning(warning);
                this.resultSetType = 1003;
            }
        } else {
            this.resultSetType = resultSetType;
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            warning = new MVASQLWarning(MessageCode.MVAConnection_concurrencyTypesWarning, new Object[0]);
            this.addWarning(warning);
            this.resultSetConcurrency = 1007;
        } else {
            this.resultSetConcurrency = resultSetConcurrency;
        }
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    void deleteStatement(@Nonnull MVAStatement statement) {
        assert (statement != null);
        this.statementList.remove(statement);
    }

    @SASScope
    protected String getUrl() {
        return this.url;
    }

    private int executeUndoPolicyNoneStatement() throws SQLException {
        int status = 0;
        try {
            boolean undoPolicyNone = this.mvaConnProps.isUndoPolicyNone();
            boolean foreignDbms = this.mvaConnProps.isForeignDatabase();
            if (undoPolicyNone && !foreignDbms) {
                status = this.rioUtil.executeUpdate(UNDO);
                this.addWarning(this.rioUtil.getWarnings());
                this.rioUtil.clearWarnings();
            }
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAConnection_executeUndoPolicyError, (Throwable)e, new Object[0]);
        }
        return status;
    }

    protected RIOUtil getRioUtil() {
        return this.rioUtil;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        if (resultSetHoldability != 2) {
            throw new MVASQLExceptionUnsupported();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability != 2) {
            throw new MVASQLExceptionUnsupported();
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Nonnull
    MVAConnectionProperties getMVAConnectionProperties() {
        assert (this.mvaConnProps != null);
        return this.mvaConnProps;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean valid = false;
        if (timeout == 0) {
            try {
                this.rioUtil.getDBMSVersion();
                valid = true;
            }
            catch (SQLException e) {}
        } else {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Void> future = executor.submit(new ValidConnectionCheck(this.rioUtil));
            try {
                future.get(timeout, TimeUnit.SECONDS);
                valid = true;
            }
            catch (TimeoutException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this._closed) {
            SQLClientInfoException sqle = new SQLClientInfoException(MessageCode.MVAConnection_closed.getStringResource(), Collections.<String, ClientInfoStatus>emptyMap());
            throw sqle;
        }
        SQLClientInfoException sqle = new SQLClientInfoException(MessageCode.MVAConnection_setClientInfoNotSupported.getStringResource(), Collections.<String, ClientInfoStatus>emptyMap());
        throw sqle;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this._closed) {
            SQLClientInfoException sqle = new SQLClientInfoException(MessageCode.MVAStatement_closed.getStringResource(), Collections.<String, ClientInfoStatus>emptyMap());
            throw sqle;
        }
        for (Object o : properties.keySet()) {
            String s = (String)o;
            this.setClientInfo(s, null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new MVASQLException(MessageCode.General_unwrapFailInputParameterIsNull, new Object[0]);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new MVASQLException(MessageCode.General_unwrapFail, iface.getName(), this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    private String getTypeName(int type) {
        switch (type) {
            case 1003: {
                return "TYPE_FORWARD_ONLY";
            }
            case 1004: {
                return "TYPE_SCROLL_INSENSITIVE";
            }
            case 1005: {
                return "TYPE_SCROLL_SENSITIVE";
            }
        }
        return Integer.toString(type);
    }

    private String getConcurrencyName(int concur) {
        switch (concur) {
            case 1007: {
                return "CONCUR_READ_ONLY";
            }
            case 1008: {
                return "CONCUR_UPDATABLE";
            }
        }
        return Integer.toString(concur);
    }

    static class ValidConnectionCheck
    implements Callable<Void> {
        final RIOUtil rioUtil;

        public ValidConnectionCheck(RIOUtil rioUtil) {
            this.rioUtil = rioUtil;
        }

        @Override
        public Void call() throws Exception {
            this.rioUtil.getDBMSVersion();
            return null;
        }
    }
}

