/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Column;
import com.sas.rio.MVAConnection;
import com.sas.rio.MVAConnectionProperties;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLExceptionUnsupported;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOUtil;
import com.sas.rio.Sqpformat;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public class MVADatabaseMetaData
implements DatabaseMetaData {
    static final String FORMAT_EMPTY_STRING = "";
    static final int TABLE_CAT_LENGTH = 8;
    static final int TABLE_SCHEM_LENGTH = 8;
    private static final int TABLE_TABLE_LENGTH = 32;
    private final RIOUtil rioUtil;
    private final MVAConnection connection;
    private final MVAConnectionProperties mvaConnectionProperties;
    private final int majorVersion;
    private final int minorVersion;
    private final String sasVersion;

    @SASScope
    public MVADatabaseMetaData(MVAConnection connection) throws SQLException {
        this.connection = connection;
        this.rioUtil = connection.getRioUtil();
        this.mvaConnectionProperties = connection.getMVAConnectionProperties();
        this.sasVersion = this.rioUtil.getDBMSVersion().trim();
        String major = this.sasVersion.substring(0, this.sasVersion.indexOf(46));
        this.majorVersion = Integer.parseInt(major);
        String minor = this.sasVersion.substring(this.sasVersion.indexOf(46) + 1);
        this.minorVersion = Integer.parseInt(minor);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getMVAConnectionProperties().getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "SAS";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String s = this.rioUtil.getDBMSVersion();
        return s;
    }

    @Override
    public synchronized String getDriverName() throws SQLException {
        return "SAS/Integrated Object Model driver for JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        String impVersion = this.getClass().getPackage().getImplementationVersion();
        if (impVersion == null) {
            return 99;
        }
        try {
            StringBuffer majorVersion = new StringBuffer(impVersion.substring(0, impVersion.indexOf(46)));
            majorVersion.delete(majorVersion.length() - 3, majorVersion.length());
            majorVersion.delete(majorVersion.length() - 2, majorVersion.length());
            return Integer.parseInt(majorVersion.toString());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        catch (StringIndexOutOfBoundsException se) {
            return 0;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        String impVersion = null;
        if (this.getClass().getPackage() != null) {
            impVersion = this.getClass().getPackage().getImplementationVersion();
        }
        if (impVersion == null) {
            return 99;
        }
        try {
            StringBuffer minorVersion = new StringBuffer(impVersion.substring(0, impVersion.indexOf(46)));
            minorVersion.delete(minorVersion.length() - 3, minorVersion.length());
            String minorVersionStr = minorVersion.substring(minorVersion.length() - 2, minorVersion.length());
            return Integer.parseInt(minorVersionStr);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        catch (StringIndexOutOfBoundsException se) {
            return -1;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS, ACOS, ASIN, ATAN, ATAN2, CEILING, COS, COT, DEGREES, EXP, FLOOR, LOG, LOG10, MOD, PI, POWER, RADIANS, RAND, ROUND, SIGN, SIN, SQRT, TAN";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII, CHAR, CONCAT, LCASE, LEFT, LENGTH, LOCATE, LTRIM, REPEAT, REPLACE, RIGHT, RTRIM, SOUNDEX, SPACE, SUBSTRING, UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "IFNULL, USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE, CURTIME, DAYNAME, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, HOUR, MINUTE, MONTH, MONTHNAME, NOW, QUARTER, SECOND, WEEK, YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (this.majorVersion > 8) {
            return true;
        }
        return this.majorVersion == 8 && this.minorVersion >= 2;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "library";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return FORMAT_EMPTY_STRING;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVADatabaseMetaData_storedProcsUnsupported, new Object[0]);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported(MessageCode.MVADatabaseMetaData_storedProcsUnsupported, new Object[0]);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("TABLE_TYPE").sqlType(12).length(8).label("Member Type").build();
        Column c5 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Column Label").build();
        Column c6 = new Column.Builder().name("table_pass").sqlType(12).length(3).label("Type of Password Protection").build();
        if (tableNamePattern == null || FORMAT_EMPTY_STRING.equals(tableNamePattern)) {
            tableNamePattern = "%";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select libname as TABLE_SCHEM, memname as TABLE_NAME, memtype as TABLE_TYPE, ");
        if (this.connection.getMVAConnectionProperties().hasRemarks()) {
            sql.append("memlabel as REMARKS, ");
        } else {
            sql.append("'No comments' as REMARKS, ");
        }
        sql.append("protect as table_pass from dictionary.tables as tables ");
        sql.append("where memname like '" + tableNamePattern + "' ");
        if (schemaPattern != null && schemaPattern.length() != 0) {
            sql.append("and libname like '" + schemaPattern.toUpperCase() + "' ");
        }
        if (types != null && types.length != 0) {
            int i;
            for (i = 0; i < types.length; ++i) {
                if (types[i] == null || types[i].length() == 0 || !types[i].trim().toUpperCase().equals("TABLE")) continue;
                types[i] = "DATA";
            }
            sql.append("and memtype in ('" + types[0].toUpperCase() + "'");
            for (i = 1; i < types.length; ++i) {
                if (types[i] == null || types[i].length() == 0) continue;
                sql.append(", '" + types[i].toUpperCase() + "' ");
            }
            sql.append(") ");
        }
        sql.append("order by TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        int hashCode = this.rioUtil.executeQuery(sql.toString(), false);
        MVAResultSet rs = new MVAResultSet(hashCode, this.rioUtil);
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        String tableType = null;
        String protect = null;
        String privStr = null;
        while (rs.next()) {
            tableType = rs.getString("TABLE_TYPE").trim().toUpperCase();
            if ("DATA".equals(tableType)) {
                tableType = "TABLE";
            }
            protect = rs.getString("table_pass").trim().toUpperCase();
            privStr = FORMAT_EMPTY_STRING;
            if (protect.length() == 3) {
                char[] pc = protect.toCharArray();
                assert (pc.length == 3);
                if (pc[0] == 'R') {
                    privStr = "READ";
                }
                if (pc[1] == 'W') {
                    if (privStr.length() > 0) {
                        privStr = privStr + ",";
                    }
                    privStr = privStr + "WRITE";
                }
                if (pc[2] == 'A') {
                    if (privStr.length() > 0) {
                        privStr = privStr + ",";
                    }
                    privStr = privStr + "ALTER";
                }
            }
            if (FORMAT_EMPTY_STRING.equals(privStr)) {
                privStr = null;
            }
            rowData.add(new Object[]{FORMAT_EMPTY_STRING, rs.getString("TABLE_SCHEM").trim(), rs.getString("TABLE_NAME").trim(), tableType, rs.getString("REMARKS"), privStr});
        }
        rs.close();
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6}, rowData);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        List<String> l = this.connection.getRioUtil().getLibraries();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        for (String s : l) {
            rowData.add(new Object[]{s.trim()});
        }
        return new MVAResultSet(new Column[]{c1}, rowData);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        return new MVAResultSet(new Column[]{c1}, new ArrayList<Object[]>(0));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_TYPE").sqlType(12).length(8).label("Member Type").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        rowData.add(new Object[]{"TABLE"});
        rowData.add(new Object[]{"VIEW"});
        return new MVAResultSet(new Column[]{c1}, rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c5 = new Column.Builder().name("DATA_TYPE").sqlType(5).label("Data Type").build();
        Column c6 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(49).label("Column Format").build();
        Column c7 = new Column.Builder().name("COLUMN_SIZE").sqlType(4).label("Column Length").build();
        Column c8 = new Column.Builder().name("BUFFER_LENGTH").sqlType(4).label("Buffer Length").build();
        Column c9 = new Column.Builder().name("DECIMAL_DIGITS").sqlType(4).label("Decimal Digits").build();
        Column c10 = new Column.Builder().name("NUM_PREC_RADIX").sqlType(4).label("Num Prec Radix").build();
        Column c11 = new Column.Builder().name("NULLABLE").sqlType(4).label("Nullable").build();
        Column c12 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Column Label").build();
        Column c13 = new Column.Builder().name("COLUMN_DEF").sqlType(12).length(1).label("Column Default").build();
        Column c14 = new Column.Builder().name("SQL_DATA_TYPE").sqlType(4).label(FORMAT_EMPTY_STRING).build();
        Column c15 = new Column.Builder().name("SQL_DATETIME_SUB").sqlType(4).label(FORMAT_EMPTY_STRING).build();
        Column c16 = new Column.Builder().name("CHAR_OCTET_LENGTH").sqlType(4).label("Column Length").build();
        Column c17 = new Column.Builder().name("ORDINAL_POSITION").sqlType(4).label("Column Number in Table").build();
        Column c18 = new Column.Builder().name("IS_NULLABLE").sqlType(12).length(3).label("Is Nullable").build();
        StringBuffer sql = null;
        if (tableNamePattern != null && tableNamePattern.length() != 0 && tableNamePattern.indexOf(40) != -1) {
            ResultSetMetaData rsmd = null;
            Statement stmt = this.connection.createStatement();
            sql = new StringBuffer("select * from " + schemaPattern.trim() + "." + tableNamePattern.trim() + " WHERE 0");
            ResultSet rs = null;
            ArrayList<Object[]> rowData = new ArrayList<Object[]>();
            try {
                rs = stmt.executeQuery(sql.toString());
                rsmd = rs.getMetaData();
                int dataType = 0;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    dataType = rsmd.getColumnType(i);
                    rowData.add(new Object[]{FORMAT_EMPTY_STRING, rsmd.getSchemaName(i), rsmd.getTableName(i), rsmd.getColumnName(i), dataType, rsmd.getColumnTypeName(i), rsmd.getColumnDisplaySize(i), 0, rsmd.getScale(i), 10, rsmd.isNullable(i), rsmd.getColumnLabel(i), null, 0, 0, rsmd.getColumnDisplaySize(i), i, dataType == 12 ? "NO" : "YES"});
                }
                rs.close();
            }
            catch (Exception se) {
            }
            finally {
                try {
                    stmt.close();
                }
                catch (SQLException sqle) {}
            }
            return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18}, rowData);
        }
        if (tableNamePattern == null || tableNamePattern.length() == 0) {
            tableNamePattern = "%";
        }
        sql = new StringBuffer("select libname as TABLE_SCHEM, memname as TABLE_NAME, name as COLUMN_NAME, format as TYPE_NAME, length as COLUMN_SIZE, label as REMARKS, length as CHAR_OCTET_LENGTH, varnum as ORDINAL_POSITION, type as sastype from dictionary.columns as columns where memname like '" + tableNamePattern + "' ");
        if (schemaPattern != null && schemaPattern.length() != 0) {
            sql.append("and libname like '" + schemaPattern.toUpperCase() + "' ");
        }
        if (columnNamePattern != null && columnNamePattern.length() != 0) {
            sql.append("and name like '" + columnNamePattern + "' ");
        }
        sql.append("order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        int hashCode = this.rioUtil.executeQuery(sql.toString(), false);
        MVAResultSet rs = new MVAResultSet(hashCode, this.rioUtil);
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        while (rs.next()) {
            int dataType = 0;
            String tempFormat = rs.getString("sastype").trim();
            if (tempFormat.equals("char")) {
                dataType = 12;
            } else {
                String format = rs.getString("TYPE_NAME").trim();
                dataType = this.sasNumericFormatToSqlType(format);
            }
            rowData.add(new Object[]{FORMAT_EMPTY_STRING, rs.getString("TABLE_SCHEM").trim(), rs.getString("TABLE_NAME").trim(), rs.getString("COLUMN_NAME").trim(), dataType, rs.getString("TYPE_NAME").trim(), rs.getInt("COLUMN_SIZE"), 0, 0, 10, dataType == 12 ? 0 : 1, rs.getString("REMARKS"), null, 0, 0, rs.getDouble("CHAR_OCTET_LENGTH"), rs.getDouble("ORDINAL_POSITION"), dataType == 12 ? "NO" : "YES"});
        }
        rs.close();
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18}, rowData);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        if (table == null || table.trim().length() == 0) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_noTableNameError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("SCOPE").sqlType(5).label("Scope").build();
        Column c2 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c3 = new Column.Builder().name("DATA_TYPE").sqlType(5).length(32).label("Data Type").build();
        Column c4 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(32).label("Column Type").build();
        Column c5 = new Column.Builder().name("COLUMN_SIZE").sqlType(4).label("Column Length").build();
        Column c6 = new Column.Builder().name("BUFFER_LENGTH").sqlType(4).label("Buffer Length").build();
        Column c7 = new Column.Builder().name("DECIMAL_DIGITS").sqlType(5).label("Decimal Digits").build();
        Column c8 = new Column.Builder().name("PSEUDO_COLUMN").sqlType(5).label("Pseudo Column").build();
        StringBuffer sql = new StringBuffer();
        sql.append("select indexes.name as COLUMN_NAME, col.type as TYPE_NAME, col.length as COLUMN_SIZE, col.format as format, type as sastype from dictionary.indexes as indexes, dictionary.columns as col where ");
        sql.append("indexes.memname = '");
        sql.append(table.trim().toUpperCase());
        sql.append("' ");
        sql.append("and col.memname = '");
        sql.append(table.trim().toUpperCase());
        sql.append("' ");
        sql.append("and indexes.libname = col.libname and indexes.name = col.name ");
        if (schema != null && schema.length() != 0) {
            sql.append("and indexes.libname = '" + schema.trim().toUpperCase() + "' ");
            sql.append("and col.libname = '" + schema.trim().toUpperCase() + "' ");
        }
        sql.append("and indexes.unique = 'yes' ORDER BY indexes.indxname ");
        int hashCode = this.rioUtil.executeQuery(sql.toString(), false);
        MVAResultSet rs = new MVAResultSet(hashCode, this.rioUtil);
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        while (rs.next()) {
            int dataType = 0;
            String tempFormat = rs.getString("sastype").trim();
            if (tempFormat.equals("char")) {
                dataType = 12;
            } else {
                String format = rs.getString("format").trim();
                dataType = this.sasNumericFormatToSqlType(format);
            }
            String sqlTypeName = this.getSQLTypeString(dataType);
            rowData.add(new Object[]{2, rs.getString("COLUMN_NAME").trim(), dataType, sqlTypeName, rs.getInt("COLUMN_SIZE"), 0, 0, 1});
        }
        rs.close();
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8}, rowData);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        if (table == null || table.trim().length() == 0) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_noTableNameError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c5 = new Column.Builder().name("KEY_SEQ").sqlType(5).length(256).label("Position of Column in Concatenated Key").build();
        Column c6 = new Column.Builder().name("PK_NAME").sqlType(12).length(32).label("Index Name").build();
        StringBuffer sql = new StringBuffer();
        sql.append("select libname as TABLE_SCHEM, memname as TABLE_NAME, name as COLUMN_NAME, indxpos as KEY_SEQ, indxname as PK_NAME from dictionary.indexes as indexes ");
        sql.append("where memname = '" + table.trim().toUpperCase() + "' ");
        if (schema != null && schema.length() != 0) {
            sql.append("and libname = '" + schema.trim().toUpperCase() + "' ");
        }
        sql.append("and unique = 'yes' order by COLUMN_NAME ");
        int hashCode = this.rioUtil.executeQuery(sql.toString(), false);
        MVAResultSet rs = new MVAResultSet(hashCode, this.rioUtil);
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        int keySequence = 0;
        while (rs.next()) {
            keySequence = (int)rs.getDouble("KEY_SEQ");
            keySequence = keySequence / 8 + 1;
            rowData.add(new Object[]{FORMAT_EMPTY_STRING, rs.getString("TABLE_SCHEM").trim(), rs.getString("TABLE_NAME").trim(), rs.getString("COLUMN_NAME").trim(), keySequence, rs.getString("PK_NAME").trim()});
        }
        rs.close();
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6}, rowData);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new MVASQLException(MessageCode.MVADatabaseMetaData_foreignKeysError, new Object[0]);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new MVASQLException(MessageCode.MVADatabaseMetaData_foreignKeysError, new Object[0]);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new MVASQLException(MessageCode.MVADatabaseMetaData_foreignKeysError, new Object[0]);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Column c1 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(10).label("SQL Type Name").build();
        Column c2 = new Column.Builder().name("DATA_TYPE").sqlType(5).label("SQL Type").build();
        Column c3 = new Column.Builder().name("PRECISION").sqlType(4).label("Precision").build();
        Column c4 = new Column.Builder().name("LITERAL_PREFIX").sqlType(12).length(1).label("Prefix").build();
        Column c5 = new Column.Builder().name("LITERAL_SUFFIX").sqlType(12).length(1).label("Suffix").build();
        Column c6 = new Column.Builder().name("CREATE_PARAMS").sqlType(12).length(1).label("Parameters").build();
        Column c7 = new Column.Builder().name("NULLABLE").sqlType(5).label("Nullable").build();
        Column c8 = new Column.Builder().name("CASE_SENSITIVE").sqlType(16).label("Case Sensitive").build();
        Column c9 = new Column.Builder().name("SEARCHABLE").sqlType(5).label("Where").build();
        Column c10 = new Column.Builder().name("UNSIGNED_ATTRIBUTE").sqlType(16).label("Unsigned").build();
        Column c11 = new Column.Builder().name("FIXED_PREC_SCALE").sqlType(16).label("Money").build();
        Column c12 = new Column.Builder().name("AUTO_INCREMENT").sqlType(16).label("Auto-increment").build();
        Column c13 = new Column.Builder().name("LOCAL_TYPE_NAME").sqlType(12).length(5).label("Local Version Name").build();
        Column c14 = new Column.Builder().name("MINIMUM_SCALE").sqlType(5).label("Minimum Scale").formatName(FORMAT_EMPTY_STRING).build();
        Column c15 = new Column.Builder().name("MAXIMUM_SCALE").sqlType(5).label("Maximum Scale").build();
        Column c16 = new Column.Builder().name("SQL_DATA_TYPE").sqlType(4).label("Data Type").build();
        Column c17 = new Column.Builder().name("SQL_DATETIME_SUB").sqlType(4).label("DateTime").build();
        Column c18 = new Column.Builder().name("NUM_PREC_RADIX").sqlType(4).label("Radix").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(8);
        rowData.add(new Object[]{"CHAR", 1, Short.MAX_VALUE, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 0, true, 3, true, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"INTEGER", 4, 10, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"FLOAT", 6, 15, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"DOUBLE PRECISION", 8, 15, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"VARCHAR", 12, Short.MAX_VALUE, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 0, true, 3, true, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"DATE", 91, 10, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"TIME", 92, 8, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        rowData.add(new Object[]{"TIMESTAMP", 93, 21, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, FORMAT_EMPTY_STRING, 1, false, 3, false, false, false, FORMAT_EMPTY_STRING, 0, 0, 0, 0, 10});
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18}, rowData);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        if (table == null || table.trim().length() == 0) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_noTableNameError, new Object[0]);
        }
        Column c1 = new Column.Builder().name("TABLE_CAT").sqlType(12).length(8).label("Catalog").build();
        Column c2 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c3 = new Column.Builder().name("TABLE_NAME").sqlType(12).length(32).label("Member Name").build();
        Column c4 = new Column.Builder().name("NON_UNIQUE").sqlType(16).label("Non Unique").build();
        Column c5 = new Column.Builder().name("INDEX_QUALIFIER").sqlType(12).length(0).label("Index Qualifier").build();
        Column c6 = new Column.Builder().name("INDEX_NAME").sqlType(12).length(32).label("Index Name").build();
        Column c7 = new Column.Builder().name("TYPE").sqlType(5).label("Type").build();
        Column c8 = new Column.Builder().name("ORDINAL_POSITION").sqlType(5).label("Position of Column in Concatenated Key").build();
        Column c9 = new Column.Builder().name("COLUMN_NAME").sqlType(12).length(32).label("Column Name").build();
        Column c10 = new Column.Builder().name("ASC_OR_DESC").sqlType(12).length(1).label("Ascending or Descending").build();
        Column c11 = new Column.Builder().name("CARDINALITY").sqlType(4).label("Cardinality").build();
        Column c12 = new Column.Builder().name("PAGES").sqlType(4).label("Pages").build();
        Column c13 = new Column.Builder().name("FILTER_CONDITION").sqlType(12).length(0).label("Filter Condition").build();
        StringBuffer sql = new StringBuffer();
        sql.append("select libname as TABLE_SCHEM, memname as TABLE_NAME, unique ne 'yes' as NON_UNIQUE,  indxname as INDEX_NAME, indxpos as ORDINAL_POSITION, name as COLUMN_NAME from dictionary.indexes as indexes where ");
        sql.append(" memname = '" + table.toUpperCase() + "' ");
        if (schema != null && schema.length() != 0) {
            sql.append("and libname = '" + schema.toUpperCase() + "' ");
        }
        if (unique) {
            sql.append("and unique = 'yes' ");
        }
        sql.append("ORDER BY NON_UNIQUE, INDEX_NAME, ORDINAL_POSITION ");
        int hashCode = this.rioUtil.executeQuery(sql.toString(), false);
        MVAResultSet rs = new MVAResultSet(hashCode, this.rioUtil);
        int ordinalPosition = 0;
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        while (rs.next()) {
            ordinalPosition = (int)rs.getDouble("ORDINAL_POSITION");
            ordinalPosition = ordinalPosition / 8 + 1;
            rowData.add(new Object[]{FORMAT_EMPTY_STRING, rs.getString("TABLE_SCHEM").trim(), rs.getString("TABLE_NAME").trim(), rs.getBoolean("NON_UNIQUE"), FORMAT_EMPTY_STRING, rs.getString("INDEX_NAME").trim(), (short)1, ordinalPosition, rs.getString("COLUMN_NAME").trim(), "A", 0, 0, null});
        }
        rs.close();
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13}, rowData);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1004 || type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return !(type != 1004 && type != 1003 || concurrency != 1008 && concurrency != 1007);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Column c1 = new Column.Builder().name("TYPE_CAT").sqlType(12).length(1).label("Type Catalog").build();
        Column c2 = new Column.Builder().name("TYPE_SCHEM").sqlType(12).length(8).label("Type Schema").build();
        Column c3 = new Column.Builder().name("TYPE_NAME").sqlType(12).length(32).label("Type Name").build();
        Column c4 = new Column.Builder().name("CLASS_NAME").sqlType(12).length(255).label("Column Name").build();
        Column c5 = new Column.Builder().name("DATA_TYPE").sqlType(4).label("Data Type").build();
        Column c6 = new Column.Builder().name("REMARKS").sqlType(12).length(256).label("Column Label").build();
        Column c7 = new Column.Builder().name("BASE_TYPE").sqlType(12).length(1).label("Column Default").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(0);
        return new MVAResultSet(new Column[]{c1, c2, c3, c4, c5, c6, c7}, rowData);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.majorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.minorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    String getSQLTypeString(int type) {
        switch (type) {
            case 16: {
                return "BOOLEAN";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
        }
        return FORMAT_EMPTY_STRING;
    }

    int sasNumericFormatToSqlType(String format) {
        int dataType;
        String coerce = this.mvaConnectionProperties.getCoerceNumericTypes();
        assert (coerce != null);
        boolean coerceNumeric = Boolean.parseBoolean(coerce);
        int subtype = Sqpformat.intepretFormat(format);
        switch (subtype) {
            case 4: {
                dataType = coerceNumeric ? 4 : 8;
                break;
            }
            case 3: {
                dataType = 93;
                break;
            }
            case 1: {
                dataType = 91;
                break;
            }
            case 2: {
                dataType = 92;
                break;
            }
            default: {
                dataType = 8;
            }
        }
        return dataType;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.isClosed()) {
            throw new MVASQLException(MessageCode.General_noConnectionError, new Object[0]);
        }
        boolean emptyResult = false;
        if (catalog == null || FORMAT_EMPTY_STRING.equals(catalog)) {
            emptyResult = true;
        }
        if (null == schemaPattern) {
            schemaPattern = "%";
        }
        Column c1 = new Column.Builder().name("TABLE_SCHEM").sqlType(12).length(8).label("Library Name").build();
        Column c2 = new Column.Builder().name("TYPE_CATALOG").sqlType(12).length(8).label("Catalog Name").build();
        if (emptyResult) {
            ArrayList<Object[]> rowData = new ArrayList<Object[]>(0);
            return new MVAResultSet(new Column[]{c1, c2}, rowData);
        }
        String sql = "select unique libname as TABLE_SCHEM from dictionary.members as members where libname = '" + schemaPattern + "'" + "order by TABLE_SCHEM ";
        MVAResultSet rs = null;
        try {
            int hashCode = this.rioUtil.executeQuery(sql, false);
            rs = new MVAResultSet(hashCode, this.rioUtil);
            ArrayList<Object[]> rowData = new ArrayList<Object[]>();
            while (rs.next()) {
                rowData.add(new Object[]{rs.getString("TABLE_SCHEM").trim(), null});
            }
            rs.close();
            return new MVAResultSet(new Column[]{c1, c2}, rowData);
        }
        catch (Exception se) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_getSchemaError, (Throwable)se, new Object[0]);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Column c1 = new Column.Builder().name("NAME").sqlType(12).length(1).label("Name").build();
        Column c2 = new Column.Builder().name("MAXLEN").sqlType(4).label("Maximum Length").build();
        Column c3 = new Column.Builder().name("DEFAULT_VALUE").sqlType(12).length(256).label("Default Value").build();
        Column c4 = new Column.Builder().name("DESCRIPTION").sqlType(12).length(256).label("Description").build();
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(0);
        return new MVAResultSet(new Column[]{c1, c2, c3, c4}, rowData);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new MVASQLExceptionUnsupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new MVASQLException(MessageCode.General_unwrapFailInputParameterIsNull, new Object[0]);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new MVASQLException(MessageCode.General_unwrapFail, iface.getName(), this.getClass().getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

