/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.DiskFull;
import com.sas.iom.SAS.IDBMSConnection;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataServicePackage.InvalidEngine;
import com.sas.iom.SAS.IDataServicePackage.NoLibrary;
import com.sas.iom.SAS.IDataSet;
import com.sas.iom.SAS.IDataSetPackage.AccessReadOnly;
import com.sas.iom.SAS.IDataSetPackage.InvalidBookmark;
import com.sas.iom.SAS.IDataSetPackage.InvalidPosition;
import com.sas.iom.SAS.IDataSetPackage.NoDelete;
import com.sas.iom.SAS.IDataSetPackage.NoRandomAccess;
import com.sas.iom.SAS.IDataSetPackage.NoUpdate;
import com.sas.iom.SAS.IDataSet_1_4;
import com.sas.iom.SAS.IDataSet_1_4Helper;
import com.sas.iom.SAS.IDataSet_1_4Package.ExtendedAttributesError;
import com.sas.iom.SAS.IDataSet_1_4Package.FutureVersionError;
import com.sas.iom.SAS.IDataSet_1_4Package.InvalidOpenMode;
import com.sas.iom.SAS.IDataSet_1_4Package.NoAttributes;
import com.sas.iom.SAS.IDataSet_1_4Package.NotSupported;
import com.sas.iom.SAS.IExtendedAttributeSearch;
import com.sas.iom.SAS.IExtendedAttributeSearchPackage.NoMoreAttributes;
import com.sas.iom.SAS.IExtendedAttributes;
import com.sas.iom.SAS.IExtendedAttributesPackage.AttributeNameNeeded;
import com.sas.iom.SAS.IExtendedAttributesPackage.AttributeTruncated;
import com.sas.iom.SAS.IExtendedAttributesPackage.ColumnNameNeeded;
import com.sas.iom.SAS.IExtendedAttributesPackage.DupColumnAttribute;
import com.sas.iom.SAS.IExtendedAttributesPackage.DupTableAttribute;
import com.sas.iom.SAS.IExtendedAttributesPackage.ExtendedAttributesNameInvalid;
import com.sas.iom.SAS.IExtendedAttributesPackage.InvalidAttrFlags;
import com.sas.iom.SAS.IExtendedAttributesPackage.NoColumnAttribute;
import com.sas.iom.SAS.IExtendedAttributesPackage.NoColumnAttributeUpdated;
import com.sas.iom.SAS.IExtendedAttributesPackage.NoTableAttribute;
import com.sas.iom.SAS.IExtendedAttributesPackage.NoTableAttributeUpdated;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.ILibrefPackage.InvalidName;
import com.sas.iom.SAS.ILibrefPackage.NoMember;
import com.sas.iom.SAS.ILibrefPackage.OpenMember;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SAS.InvalidLName;
import com.sas.iom.SAS.InvalidPName;
import com.sas.iom.SAS.InvalidPassword;
import com.sas.iom.SAS.LNameNoAssign;
import com.sas.iom.SAS.NoAccessMethod;
import com.sas.iom.SAS.NoLock;
import com.sas.iom.SAS.NoReplace;
import com.sas.iom.SASIOMDefs.DateTimeHolder;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.rio.Column;
import com.sas.rio.DataHolder;
import com.sas.rio.MVAConnectionProperties;
import com.sas.rio.MVARow;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVASQLState;
import com.sas.rio.MVASQLWarning;
import com.sas.rio.Matrix;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOListener;
import com.sas.rio.Sqpformat;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

@SASScope
public class RIOUtil {
    @Nullable
    private final IWorkspace m_workspace;
    private final IDataService m_dataService;
    private final IDBMSConnection m_connection;
    private final ArrayList<ILibref> m_librefList;
    private final MVAConnectionProperties mvaConnProps;
    private ILibref m_libref;
    private IDataSet m_dataSet;
    private SQLWarning _warnings;
    private final HashMap<Integer, IDataSet> dataMap = new HashMap();
    private static final int EOF = -1;
    private static final int BOF = -2;
    private static final int AOK = -3;
    private int m_status = -3;
    private final boolean m_releaseWorkspaceOnExit;
    final RIOListener _rioListener;
    ConnectionInterface IOMcnxn;
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_PASSWORD = new String[]{"", "", ""};
    private static final Map<Integer, String> rioStatusStrValue;
    private IExtendedAttributes _attrs = null;
    private static final Logger logger;
    private static final String className;
    private static final String readRecordsLayout;
    private static final String openXaLayout;
    private static final String UNKNOWN_STATUS = "UNKNOWN STATUS";
    private static final String getAttrLayout;
    private static final String getAttrSearchLayout;
    private static final String getAttrNextLayout;
    private static final String getAttrNextFlagsLayout;
    private static final String getAttrNextValueDLayout;
    private static final String getAttrNextValueMLayout;
    private static final String getAttrNextValueSLayout;
    private static final String getAttrNextValueULayout;
    private static final String getAttrNextDoneLayout;
    private static final String setAttrLayout;
    private static final String setAttrAddSLayout;
    private static final String setAttrAddDLayout;
    private static final String setAttrAddMLayout;
    private static final String setAttrAddULayout;
    private static final String dropAttrLayout;
    private static final String dropAttrNameLayout;
    private static final String dropAttrDSLayout;
    private static final String dropAttrColLayout;
    private static final String closeXaLayout;
    private static final String closeGenericLayout;

    RIOUtil(IDataService ids, MVAConnectionProperties mvaConnectionProperties, RIOListener rioListener) throws SQLException {
        this.m_workspace = null;
        this.m_releaseWorkspaceOnExit = false;
        this.mvaConnProps = mvaConnectionProperties;
        this._rioListener = rioListener;
        this.m_dataService = ids;
        try {
            this.m_connection = this.getDBMSConnection(this.m_dataService);
            this.m_librefList = this.assignLibrefs(this.mvaConnProps.getLibrefMap());
        }
        catch (SQLException e) {
            try {
                this.disconnect();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
    }

    RIOUtil(IWorkspace iw, MVAConnectionProperties mvaConnectionProperties, RIOListener rioListener) throws SQLException {
        this.m_workspace = iw;
        this.m_releaseWorkspaceOnExit = false;
        this.mvaConnProps = mvaConnectionProperties;
        this._rioListener = rioListener;
        try {
            this.m_dataService = this.m_workspace.DataService();
            this.m_connection = this.getDBMSConnection(this.m_dataService);
            this.m_librefList = this.assignLibrefs(this.mvaConnProps.getLibrefMap());
        }
        catch (SQLException e) {
            try {
                this.disconnect();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
    }

    RIOUtil(MVAConnectionProperties mvaConnProperties, RIOListener rioListener) throws SQLException {
        this.mvaConnProps = mvaConnProperties;
        this._rioListener = rioListener;
        try {
            this.m_workspace = this.getWorkspace();
            this.m_releaseWorkspaceOnExit = true;
            this.m_dataService = this.m_workspace.DataService();
            this.m_connection = this.getDBMSConnection(this.m_dataService);
            this.m_librefList = this.assignLibrefs(this.mvaConnProps.getLibrefMap());
        }
        catch (SQLException e) {
            try {
                this.disconnect();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
    }

    protected RIOUtil(IDataService ids, Properties properties) throws SQLException {
        this(ids, properties, null);
    }

    protected RIOUtil(IDataService ids, Properties properties, RIOListener rioListener) throws SQLException {
        this.mvaConnProps = new MVAConnectionProperties(properties);
        this._rioListener = rioListener;
        this.m_workspace = null;
        this.m_releaseWorkspaceOnExit = false;
        this.m_dataService = ids;
        try {
            this.m_connection = this.getDBMSConnection(this.m_dataService);
            this.m_librefList = this.assignLibrefs(this.mvaConnProps.getLibrefMap());
        }
        catch (SQLException e) {
            try {
                this.disconnect();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
    }

    public String getDBMSVersion() throws MVASQLException {
        try {
            IWorkspace sasWorkspace = this.m_dataService.Parent();
            IUtilities sasUtilities = sasWorkspace.Utilities();
            IHostSystem hostSystem = sasUtilities.HostSystem();
            StringSeqHolder systemInfoHolder = new StringSeqHolder();
            VariableArray2dOfStringHolder machineInfoHolder = new VariableArray2dOfStringHolder();
            hostSystem.GetInfo(systemInfoHolder, machineInfoHolder);
            hostSystem._release();
            sasUtilities._release();
            sasWorkspace._release();
            String[] systemInfo = systemInfoHolder.value;
            String sasVersion = systemInfo[0];
            return sasVersion;
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_productVersionError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_productVersionError, (Throwable)e, new java.lang.Object[0]);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        int updateCount = 0;
        if (sql == null || sql.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_invalidQuery, new java.lang.Object[0]);
        }
        try {
            IntHolder statusHolder = new IntHolder();
            StringHolder warningHolder = new StringHolder();
            this.m_connection.ExecuteStatement(sql, statusHolder, warningHolder);
            updateCount = statusHolder.value;
            String wtxt = warningHolder.value;
            if (wtxt != null && wtxt.length() > 0) {
                MVASQLWarning warning = new MVASQLWarning(MessageCode.RIOUtil_generalWarning, wtxt);
                this.addWarning(warning);
            }
        }
        catch (GenericError e) {
            throw new MVASQLException(e.getMessage(), MVASQLState.SS_42000_SYNTAX_ACCESS_ERROR.ss(), (Throwable)((java.lang.Object)e));
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(e.getMessage(), MVASQLState.SS_42000_SYNTAX_ACCESS_ERROR.ss(), e);
        }
        return updateCount;
    }

    public int executeQuery(String sql, boolean randomAccess) throws SQLException {
        if (sql != null) {
            try {
                IntHolder statusHolder = new IntHolder();
                IntHolder bookmarkLengthHolder = new IntHolder();
                StringHolder warningHolder = new StringHolder();
                this.m_dataSet = this.m_connection.ExecuteQuery(sql, randomAccess, bookmarkLengthHolder, statusHolder, warningHolder);
                String wtxt = warningHolder.value;
                if (wtxt != null && wtxt.length() > 0) {
                    MVASQLWarning warning = new MVASQLWarning(MessageCode.RIOUtil_generalWarning, wtxt);
                    this.addWarning(warning);
                }
            }
            catch (GenericError e) {
                throw new MVASQLException(MessageCode.MVAStatement_genericQueryError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            }
            catch (RuntimeException e) {
                this.checkRuntimeException(e);
                throw new MVASQLException(MessageCode.MVAStatement_genericQueryError, (Throwable)e, new java.lang.Object[0]);
            }
        }
        if (this.m_dataSet != null) {
            int hashCode = this.m_dataSet.hashCode();
            this.dataMap.put(hashCode, this.m_dataSet);
            return hashCode;
        }
        return -1;
    }

    public void deleteTable(String libref, String tableName, String tableType, String alterPassword) throws SQLException {
        try {
            this.m_libref = this.useLibref(libref);
            if (tableName == null) {
                tableName = EMPTY_STRING;
            }
            if (tableType == null) {
                tableType = EMPTY_STRING;
            }
            if (alterPassword == null) {
                alterPassword = EMPTY_STRING;
            }
            this.m_libref.DeleteMember(tableName, tableType, alterPassword);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_deleteTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.RIOUtil_invalidPassword, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoMember e) {
            throw new MVASQLException(MessageCode.RIOUtil_tableNotFound, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoLock e) {
            throw new MVASQLException(MessageCode.RIOUtil_deleteTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (OpenMember e) {
            throw new MVASQLException(MessageCode.RIOUtil_deleteTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidName e) {
            throw new MVASQLException(MessageCode.RIOUtil_deleteTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_deleteTableFail, (Throwable)e, new java.lang.Object[0]);
        }
    }

    @Deprecated
    public boolean createTable(String libref, String tableName, Column[] columns, String options) throws SQLException {
        if (libref == null || libref.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_nullLibrefError, new java.lang.Object[0]);
        }
        if (tableName == null || tableName.length() == 0) {
            throw new MVASQLException(MessageCode.MVAStatement_nullTableNameError, new java.lang.Object[0]);
        }
        if (columns == null) {
            throw new MVASQLException(MessageCode.MVAStatement_nullArrayError, new java.lang.Object[0]);
        }
        int len = columns.length;
        String[] columnNames = new String[len];
        String[] columnLabels = new String[len];
        int[] columnTypes = new int[len];
        int[] columnLengths = new int[len];
        String[] columnFormatNames = new String[len];
        short[] columnFormatWidths = new short[len];
        short[] columnFormatDecimals = new short[len];
        String[] columnInformatNames = new String[len];
        short[] columnInformatWidths = new short[len];
        short[] columnInformatDecimals = new short[len];
        for (int i = 0; i < len; ++i) {
            if (columns[i] == null) continue;
            columnNames[i] = columns[i].getName();
            columnLabels[i] = columns[i].getLabel();
            columnTypes[i] = columns[i].getSqlType();
            columnLengths[i] = columns[i].getLength();
            columnFormatNames[i] = columns[i].getFormatName();
            columnFormatWidths[i] = columns[i].getFormatWidth();
            columnFormatDecimals[i] = columns[i].getFormatDecimal();
            columnInformatNames[i] = columns[i].getInformatName();
            columnInformatWidths[i] = columns[i].getInformatWidth();
            columnInformatDecimals[i] = columns[i].getInformatDecimal();
        }
        IntHolder bookmarkLengthHolder = new IntHolder();
        int flags = 0;
        String dataSetLabel = EMPTY_STRING;
        if (options == null) {
            options = EMPTY_STRING;
        }
        IDataSet dataSet = null;
        try {
            this.m_libref = this.useLibref(libref);
            dataSet = this.m_libref.CreateDataSet(flags, tableName, options, dataSetLabel, columnNames, columnLabels, columnTypes, columnLengths, columnFormatNames, columnFormatWidths, columnFormatDecimals, columnInformatNames, columnInformatWidths, columnInformatDecimals, bookmarkLengthHolder);
        }
        catch (NoReplace e) {
            throw new MVASQLException(MessageCode.RIOUtil_createTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_createTableFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_createTableFail, (Throwable)e, new java.lang.Object[0]);
        }
        try {
            if (dataSet != null) {
                dataSet.Close();
                dataSet._release();
                dataSet = null;
            }
        }
        catch (GenericError e) {
            dataSet = null;
        }
        catch (NoReplace e) {
            dataSet = null;
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            dataSet = null;
        }
        return true;
    }

    @Deprecated
    public boolean insertRow(int hashCode, java.lang.Object[] data, int bindKey, int[] columnTypes) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return false;
        }
        try {
            int i;
            int numericValuesCount = 0;
            int characterValuesCount = 0;
            for (int i2 = 0; i2 < data.length; ++i2) {
                if (columnTypes[i2] != 12) {
                    ++numericValuesCount;
                    continue;
                }
                ++characterValuesCount;
            }
            double[][] numericValuesForInsert = new double[1][numericValuesCount];
            String[][] characterValuesForInsert = new String[1][characterValuesCount];
            byte[][] missingNumericValuesForInsert = new byte[1][numericValuesCount];
            int j = 0;
            for (i = 0; i < data.length; ++i) {
                if (columnTypes[i] == 12) continue;
                numericValuesForInsert[0][j] = (Double)data[i];
                missingNumericValuesForInsert[0][j] = Double.isNaN(numericValuesForInsert[0][j]) ? 32 : 127;
                ++j;
            }
            j = 0;
            for (i = 0; i < data.length; ++i) {
                if (columnTypes[i] != 12) continue;
                characterValuesForInsert[0][j] = data[i] == null ? EMPTY_STRING : data[i].toString();
                ++j;
            }
            IntHolder statusHolder = new IntHolder();
            OctetSeqHolder bookmarksInsertHolder = new OctetSeqHolder();
            this.m_dataSet.AddRecords(2, numericValuesForInsert, missingNumericValuesForInsert, characterValuesForInsert, bookmarksInsertHolder, statusHolder);
            if (statusHolder.value != 0) {
                switch (statusHolder.value) {
                    case 6: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordLockedError, new java.lang.Object[0]);
                    }
                    case 8: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordBookmarkError, new java.lang.Object[0]);
                    }
                    case 9: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordDeletedError, new java.lang.Object[0]);
                    }
                    case 5: {
                        throw new MVASQLException(MessageCode.MVAResultSet_insertServerError, new java.lang.Object[0]);
                    }
                }
            }
        }
        catch (DiskFull e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AccessReadOnly e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)e, new java.lang.Object[0]);
        }
        return true;
    }

    byte[] insertRow(int hashCode, Column[] columns, MVARow insertRow) throws SQLException {
        int i;
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            throw new RuntimeException("Invalid");
        }
        int numericValuesCount = 0;
        int characterValuesCount = 0;
        for (Column c : columns) {
            if (c.getSqlType() != 12) {
                ++numericValuesCount;
                continue;
            }
            ++characterValuesCount;
        }
        double[][] numericValuesForInsert = new double[1][numericValuesCount];
        String[][] characterValuesForInsert = new String[1][characterValuesCount];
        byte[][] missingNumericValuesForInsert = new byte[1][numericValuesCount];
        java.lang.Object[] data = insertRow.getRowData();
        int j = 0;
        for (i = 0; i < data.length; ++i) {
            double d;
            if (columns[i].getSqlType() == 12) continue;
            numericValuesForInsert[0][j] = d = ((Double)data[i]).doubleValue();
            missingNumericValuesForInsert[0][j] = Double.isNaN(d) ? 32 : 127;
            ++j;
        }
        j = 0;
        for (i = 0; i < data.length; ++i) {
            String s;
            if (columns[i].getSqlType() != 12) continue;
            characterValuesForInsert[0][j] = s = data[i] == null ? EMPTY_STRING : data[i].toString();
            ++j;
        }
        IntHolder statusHolder = new IntHolder();
        OctetSeqHolder bookmarksInsertHolder = new OctetSeqHolder();
        try {
            this.m_dataSet.AddRecords(2, numericValuesForInsert, missingNumericValuesForInsert, characterValuesForInsert, bookmarksInsertHolder, statusHolder);
            if (statusHolder.value != 0) {
                switch (statusHolder.value) {
                    case 6: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordLockedError, new java.lang.Object[0]);
                    }
                    case 8: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordBookmarkError, new java.lang.Object[0]);
                    }
                    case 9: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordDeletedError, new java.lang.Object[0]);
                    }
                    case 5: {
                        throw new MVASQLException(MessageCode.MVAResultSet_insertServerError, new java.lang.Object[0]);
                    }
                }
            }
            byte[] bookmarks = bookmarksInsertHolder.value;
            int blen = bookmarks.length / characterValuesForInsert.length;
            byte[] b = Arrays.copyOfRange(bookmarks, 0, blen);
            return b;
        }
        catch (DiskFull e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AccessReadOnly e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)e, new java.lang.Object[0]);
        }
    }

    @SASScope
    public boolean insertMultipleRows(int hashCode, Matrix matrix) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return false;
        }
        try {
            IntHolder statusHolder = new IntHolder();
            OctetSeqHolder bookmarksInsertHolder = new OctetSeqHolder();
            this.m_dataSet.AddRecords(2, matrix.getNumericValuesForInsert(), matrix.getMissingNumericValuesForInsert(), matrix.getCharacterValuesForInsert(), bookmarksInsertHolder, statusHolder);
            if (statusHolder.value != 0) {
                switch (statusHolder.value) {
                    case 6: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordLockedError, new java.lang.Object[0]);
                    }
                    case 8: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordBookmarkError, new java.lang.Object[0]);
                    }
                    case 9: {
                        throw new MVASQLException(MessageCode.MVAResultSet_recordDeletedError, new java.lang.Object[0]);
                    }
                    case 5: {
                        throw new MVASQLException(MessageCode.MVAResultSet_insertServerError, new java.lang.Object[0]);
                    }
                }
            }
        }
        catch (DiskFull e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AccessReadOnly e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedError, (Throwable)e, new java.lang.Object[0]);
        }
        return true;
    }

    public boolean updateRow(int hashCode, java.lang.Object[] data, byte[] bookmark, int bindKey, int[] columnTypes) throws SQLException {
        double[] numericValuesFromLockRecords;
        String[] characterValuesFromLockRecords;
        byte[] bookmarksUpdate;
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return false;
        }
        try {
            bookmarksUpdate = bookmark;
            StringSeqHolder characterValuesHolder = new StringSeqHolder();
            DoubleSeqHolder numericValuesHolder = new DoubleSeqHolder();
            OctetSeqHolder missingNumericValuesHolder = new OctetSeqHolder();
            this.m_dataSet.LockRecord(0, 2, bookmarksUpdate, characterValuesHolder, numericValuesHolder, missingNumericValuesHolder);
            characterValuesFromLockRecords = characterValuesHolder.value;
            numericValuesFromLockRecords = numericValuesHolder.value;
        }
        catch (NoLock e1) {
            throw new MVASQLException(MessageCode.MVAResultSet_lockRecordsFailedError, (Throwable)((java.lang.Object)e1), new java.lang.Object[0]);
        }
        catch (InvalidBookmark e1) {
            throw new MVASQLException(MessageCode.MVAResultSet_lockRecordsFailedError, (Throwable)((java.lang.Object)e1), new java.lang.Object[0]);
        }
        catch (GenericError e1) {
            throw new MVASQLException(MessageCode.MVAResultSet_lockRecordsFailedError, (Throwable)((java.lang.Object)e1), new java.lang.Object[0]);
        }
        catch (RuntimeException e1) {
            this.checkRuntimeException(e1);
            throw new MVASQLException(MessageCode.MVAResultSet_lockRecordsFailedError, (Throwable)e1, new java.lang.Object[0]);
        }
        try {
            int i;
            IntHolder methodStatusHolder = null;
            double[][] numericValuesForUpdate = new double[1][numericValuesFromLockRecords.length];
            String[][] characterValuesForUpdate = new String[1][Math.max(characterValuesFromLockRecords.length, 1)];
            byte[][] missingNumericValuesForUpdate = new byte[1][numericValuesFromLockRecords.length];
            byte[][] changedNumericValuesForUpdate = new byte[1][0];
            byte[][] changedCharacterValuesForUpdate = new byte[1][0];
            int j = 0;
            for (i = 0; i < data.length; ++i) {
                String tv;
                if (columnTypes[i] == 12) continue;
                double tdv = bindKey == 3 ? ((tv = data[i].toString()).length() == 0 || tv.trim().equals(EMPTY_STRING) ? Double.NaN : Double.parseDouble(tv)) : (Double)data[i];
                numericValuesForUpdate[0][j] = tdv;
                missingNumericValuesForUpdate[0][j] = Double.isNaN(numericValuesForUpdate[0][j]) ? 32 : 127;
                ++j;
            }
            j = 0;
            for (i = 0; i < data.length; ++i) {
                if (columnTypes[i] != 12) continue;
                characterValuesForUpdate[0][j] = data[i] == null ? EMPTY_STRING : data[i].toString();
                ++j;
            }
            if (characterValuesFromLockRecords.length == 0) {
                characterValuesForUpdate[0][0] = EMPTY_STRING;
            }
            methodStatusHolder = new IntHolder();
            LongSeqHolder statusHolder = new LongSeqHolder();
            this.m_dataSet.UpdateRecords(bookmarksUpdate, 2, changedNumericValuesForUpdate, numericValuesForUpdate, missingNumericValuesForUpdate, changedCharacterValuesForUpdate, characterValuesForUpdate, methodStatusHolder, statusHolder);
            int[] status = statusHolder.value;
            if (methodStatusHolder.value != 0) {
                switch (status[0]) {
                    case 6: {
                        throw new MVASQLException(MessageCode.MVAResultSet_updateFailedRecordLocked, new java.lang.Object[0]);
                    }
                    case 8: {
                        throw new MVASQLException(MessageCode.MVAResultSet_updateFailedBadBookmark, new java.lang.Object[0]);
                    }
                    case 9: {
                        throw new MVASQLException(MessageCode.MVAResultSet_updateFailedRecordDeleted, new java.lang.Object[0]);
                    }
                    case 5: {
                        throw new MVASQLException(MessageCode.MVAResultSet_updateFailedServerError, new java.lang.Object[0]);
                    }
                }
            }
        }
        catch (DiskFull e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoLock e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoUpdate e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoDelete e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoRandomAccess e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AccessReadOnly e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidBookmark e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)e, new java.lang.Object[0]);
        }
        return true;
    }

    public boolean deleteRow(int hashCode, byte[] bookmark) throws SQLException {
        byte[] bookmarksDelete;
        int flags = 0;
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return false;
        }
        try {
            bookmarksDelete = bookmark;
            StringSeqHolder characterValuesHolder = new StringSeqHolder();
            DoubleSeqHolder numericValuesHolder = new DoubleSeqHolder();
            OctetSeqHolder missingNumericValuesHolder = new OctetSeqHolder();
            this.m_dataSet.LockRecord(flags, 2, bookmarksDelete, characterValuesHolder, numericValuesHolder, missingNumericValuesHolder);
        }
        catch (Exception se) {
            throw new MVASQLException(MessageCode.MVAResultSet_lockRecordsFailed, (Throwable)se, new java.lang.Object[0]);
        }
        try {
            IntHolder methodStatusHolder = new IntHolder();
            LongSeqHolder statusHolder = new LongSeqHolder();
            this.m_dataSet.DeleteRecords(bookmarksDelete, methodStatusHolder, statusHolder);
            int[] status = statusHolder.value;
            if (methodStatusHolder.value != 0) {
                switch (status[0]) {
                    case 6: {
                        throw new MVASQLException(MessageCode.MVAResultSet_deleteFailedRecordLocked, new java.lang.Object[0]);
                    }
                    case 8: {
                        throw new MVASQLException(MessageCode.MVAResultSet_deleteFailedBadBookmark, new java.lang.Object[0]);
                    }
                    case 9: {
                        throw new MVASQLException(MessageCode.MVAResultSet_deleteFailedRecordDeleted, new java.lang.Object[0]);
                    }
                    case 5: {
                        throw new MVASQLException(MessageCode.MVAResultSet_deleteFailedServerError, new java.lang.Object[0]);
                    }
                }
            }
        }
        catch (NoLock e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoDelete e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AccessReadOnly e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidBookmark e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)e, new java.lang.Object[0]);
        }
        return true;
    }

    public java.lang.Object[][] getColumnInfo(int hashCode) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return null;
        }
        boolean[] flags = new boolean[]{};
        IntHolder numberColumnsHolder = new IntHolder();
        StringSeqHolder columnNamesHolder = new StringSeqHolder();
        LongSeqHolder columnTypesHolder = new LongSeqHolder();
        LongSeqHolder columnLengthsHolder = new LongSeqHolder();
        StringSeqHolder columnLabelsHolder = new StringSeqHolder();
        StringSeqHolder formatNamesHolder = new StringSeqHolder();
        ShortSeqHolder formatWidthsHolder = new ShortSeqHolder();
        ShortSeqHolder formatDecimalsHolder = new ShortSeqHolder();
        ShortSeqHolder formatLengthsHolder = new ShortSeqHolder();
        StringSeqHolder informatNamesHolder = new StringSeqHolder();
        ShortSeqHolder informatWidthsHolder = new ShortSeqHolder();
        ShortSeqHolder informatDecimalsHolder = new ShortSeqHolder();
        OctetSeqHolder sortedByHolder = new OctetSeqHolder();
        try {
            this.m_dataSet.GetColumnDefs(flags, numberColumnsHolder, columnNamesHolder, columnTypesHolder, columnLengthsHolder, columnLabelsHolder, formatNamesHolder, formatWidthsHolder, formatDecimalsHolder, formatLengthsHolder, informatNamesHolder, informatWidthsHolder, informatDecimalsHolder, sortedByHolder);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_getColumnDefsFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_getColumnDefsFail, (Throwable)e, new java.lang.Object[0]);
        }
        int numberColumns = numberColumnsHolder.value;
        String[] columnNames = columnNamesHolder.value;
        int[] columnTypes = columnTypesHolder.value;
        int[] columnLengths = columnLengthsHolder.value;
        String[] columnLabels = columnLabelsHolder.value;
        String[] formatNames = formatNamesHolder.value;
        short[] formatWidths = formatWidthsHolder.value;
        short[] formatDecimals = formatDecimalsHolder.value;
        short[] formatLengths = formatLengthsHolder.value;
        String[] informatNames = informatNamesHolder.value;
        short[] informatWidths = informatWidthsHolder.value;
        short[] informatDecimals = informatDecimalsHolder.value;
        java.lang.Object[][] rval = new java.lang.Object[11][numberColumns];
        for (int i = 0; i < numberColumns; ++i) {
            rval[0][i] = columnNames[i];
            rval[1][i] = columnTypes[i];
            rval[2][i] = columnLengths[i];
            rval[3][i] = columnLabels[i];
            rval[4][i] = formatNames[i];
            rval[5][i] = formatWidths[i];
            rval[6][i] = formatDecimals[i];
            rval[7][i] = formatLengths[i];
            rval[8][i] = informatNames[i];
            rval[9][i] = informatWidths[i];
            rval[10][i] = informatDecimals[i];
        }
        return rval;
    }

    Column[] getColumns(int hashCode) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return new Column[0];
        }
        boolean[] flags = new boolean[]{};
        IntHolder numberColumnsHolder = new IntHolder();
        StringSeqHolder columnNamesHolder = new StringSeqHolder();
        LongSeqHolder columnTypesHolder = new LongSeqHolder();
        LongSeqHolder columnLengthsHolder = new LongSeqHolder();
        StringSeqHolder columnLabelsHolder = new StringSeqHolder();
        StringSeqHolder formatNamesHolder = new StringSeqHolder();
        ShortSeqHolder formatWidthsHolder = new ShortSeqHolder();
        ShortSeqHolder formatDecimalsHolder = new ShortSeqHolder();
        ShortSeqHolder formatLengthsHolder = new ShortSeqHolder();
        StringSeqHolder informatNamesHolder = new StringSeqHolder();
        ShortSeqHolder informatWidthsHolder = new ShortSeqHolder();
        ShortSeqHolder informatDecimalsHolder = new ShortSeqHolder();
        OctetSeqHolder sortedByHolder = new OctetSeqHolder();
        try {
            this.m_dataSet.GetColumnDefs(flags, numberColumnsHolder, columnNamesHolder, columnTypesHolder, columnLengthsHolder, columnLabelsHolder, formatNamesHolder, formatWidthsHolder, formatDecimalsHolder, formatLengthsHolder, informatNamesHolder, informatWidthsHolder, informatDecimalsHolder, sortedByHolder);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_getColumnDefsFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_getColumnDefsFail, (Throwable)e, new java.lang.Object[0]);
        }
        int numberColumns = numberColumnsHolder.value;
        Column[] columns = new Column[numberColumns];
        boolean coerceNumeric = this.mvaConnProps.isCoerceNumeric();
        for (int i = 0; i < numberColumns; ++i) {
            Column c;
            int sqlType;
            int sasType = columnTypesHolder.value[i];
            if (sasType != 0) {
                sqlType = 12;
            } else {
                Sqpformat sqpformat = new Sqpformat(formatNamesHolder.value[i], formatLengthsHolder.value[i], formatWidthsHolder.value[i], formatDecimalsHolder.value[i]);
                int spqType = sqpformat.findFormat(formatNamesHolder.value[i]);
                switch (spqType) {
                    case 1: {
                        sqlType = 91;
                        break;
                    }
                    case 2: {
                        sqlType = 92;
                        break;
                    }
                    case 3: {
                        sqlType = 93;
                        break;
                    }
                    case 4: {
                        if (coerceNumeric) {
                            sqlType = 4;
                            break;
                        }
                        sqlType = 8;
                        break;
                    }
                    default: {
                        sqlType = 8;
                    }
                }
            }
            columns[i] = c = new Column.Builder().name(columnNamesHolder.value[i]).length(columnLengthsHolder.value[i]).label(columnLabelsHolder.value[i]).formatName(formatNamesHolder.value[i]).formatWidth(formatWidthsHolder.value[i]).formatDecimal(formatDecimalsHolder.value[i]).formatLength(formatLengthsHolder.value[i]).informatName(informatNamesHolder.value[i]).informatWidth(informatWidthsHolder.value[i]).informatDecimal(informatDecimalsHolder.value[i]).sqlType(sqlType).build();
        }
        return columns;
    }

    @Deprecated
    protected int openDataSet(String libref, String tableName, String[] password, String options, int concurFlag, int typeFlag) throws RemoteException, SQLException {
        return this.openDataSet2(libref, tableName, password, options, concurFlag, typeFlag);
    }

    protected int openDataSet2(String libref, String tableName, String[] password, String options, int concurFlag, int typeFlag) throws SQLException {
        java.lang.Object[] openPass;
        this.m_dataSet = null;
        int flags = 0;
        if (concurFlag == 1007) {
            flags |= 1;
        }
        if (typeFlag == 1003) {
            flags |= 4;
        }
        if (password == null) {
            openPass = EMPTY_PASSWORD;
        } else if (password.length < 3) {
            openPass = new String[3];
            Arrays.fill(openPass, EMPTY_STRING);
            for (int i = 0; i < password.length; ++i) {
                openPass[i] = password[i] == null ? EMPTY_STRING : password[i];
            }
        } else {
            openPass = password;
            for (int xxx = 0; xxx < openPass.length; ++xxx) {
                if (openPass[xxx] != null) continue;
                openPass[xxx] = EMPTY_STRING;
            }
        }
        if (options == null) {
            options = EMPTY_STRING;
        }
        StringHolder dataSetLabelHolder = new StringHolder();
        StringHolder dataSetTypeHolder = new StringHolder();
        DateTimeHolder dateCreatedHolder = new DateTimeHolder();
        DateTimeHolder dateModifiedHolder = new DateTimeHolder();
        IntHolder recordLengthHolder = new IntHolder();
        StringHolder compressionRoutineHolder = new StringHolder();
        IntHolder bookmarkLengthHolder = new IntHolder();
        IntHolder logRecordCountHolder = new IntHolder();
        IntHolder phyRecordCountHolder = new IntHolder();
        IntHolder attributesHolder = new IntHolder();
        try {
            this.releaseLibref();
            this.m_libref = this.useLibref(libref);
            this.m_dataSet = this.m_libref.OpenDataSet(flags, tableName, options, (String[])openPass, dataSetLabelHolder, dataSetTypeHolder, dateCreatedHolder, dateModifiedHolder, recordLengthHolder, compressionRoutineHolder, bookmarkLengthHolder, logRecordCountHolder, phyRecordCountHolder, attributesHolder);
            int hashCode = this.m_dataSet.hashCode();
            this.dataMap.put(hashCode, this.m_dataSet);
            return hashCode;
        }
        catch (InvalidPassword e) {
            throw new MVASQLException(MessageCode.RIOUtil_invalidPassword, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoMember e) {
            throw new MVASQLException(MessageCode.RIOUtil_tableNotFound, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_dataSetOpenFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_dataSetOpenFail, (Throwable)e, new java.lang.Object[0]);
        }
    }

    private ILibref useLibref(String libref) throws SQLException {
        try {
            return this.m_dataService.UseLibref(libref);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_schemaInvalid, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (LNameNoAssign e) {
            throw new MVASQLException(MessageCode.RIOUtil_schemaInvalid, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoLibrary e) {
            throw new MVASQLException(MessageCode.RIOUtil_schemaInvalid, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_schemaInvalid, (Throwable)e, new java.lang.Object[0]);
        }
    }

    private IDBMSConnection getDBMSConnection(IDataService sasDataService) throws SQLException {
        try {
            IntHolder statusHolder = new IntHolder();
            StringHolder warningHolder = new StringHolder();
            String engine = this.mvaConnProps.getDbms();
            String options = this.mvaConnProps.getDbmsOptions();
            IDBMSConnection dbmsConnection = sasDataService.ConnectToDBMS(engine, options, statusHolder, warningHolder);
            if (warningHolder.value != null && warningHolder.value.length() != 0) {
                MVASQLWarning warning = new MVASQLWarning(MessageCode.RIOUtil_generalWarning, warningHolder.value);
                this.addWarning(warning);
            }
            return dbmsConnection;
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_connectionFailure, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionFailure, (Throwable)e, new java.lang.Object[0]);
        }
    }

    ArrayList<ILibref> assignLibrefs(Map<String, String> librefMap) throws SQLException {
        ArrayList<ILibref> iLibrefs = new ArrayList<ILibref>();
        try {
            for (Map.Entry<String, String> entry : librefMap.entrySet()) {
                String libref = entry.getKey();
                String path = entry.getValue();
                ILibref sasLibref = this.m_dataService.AssignLibref(libref, EMPTY_STRING, path, EMPTY_STRING);
                iLibrefs.add(sasLibref);
            }
        }
        catch (InvalidPName e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (NoAccessMethod e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (InvalidLName e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (NoLibrary e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (LNameNoAssign e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (InvalidEngine e) {
            MVASQLWarning w = new MVASQLWarning(MessageCode.RIOUtil_assignLibrefFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
            this.addWarning(w);
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAConnection_assignLibrefError, (Throwable)e, new java.lang.Object[0]);
        }
        iLibrefs.trimToSize();
        return iLibrefs;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void close(int hashCode) {
        IDataSet dataSet = this.dataMap.remove(hashCode);
        if (dataSet == null) {
            return;
        }
        try {
            dataSet.Close();
            dataSet._release();
        }
        catch (RuntimeException e) {
            try {
                this.checkRuntimeException(e);
            }
            catch (MVASQLException e2) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnect() throws SQLException {
        try {
            if (this.m_connection != null) {
                this.m_connection.Disconnect();
            }
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_connectionFailure, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            throw new MVASQLException(MessageCode.RIOUtil_connectionFailure, (Throwable)e, new java.lang.Object[0]);
        }
        finally {
            if (this.m_connection != null) {
                this.m_connection._release();
            }
            if (this.m_librefList != null) {
                for (ILibref libref : this.m_librefList) {
                    libref._release();
                }
            }
            if (this.m_releaseWorkspaceOnExit && this.m_workspace != null) {
                this.IOMcnxn.close();
            }
        }
    }

    public int countRecords(int hashCode) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return 0;
        }
        IntHolder logicalCount = new IntHolder();
        IntHolder physCount = new IntHolder();
        try {
            this.m_dataSet.GetRecordCounts(logicalCount, physCount);
            return logicalCount.value;
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_countRecordsFail, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_countRecordsFail, (Throwable)e, new java.lang.Object[0]);
        }
    }

    public void releaseLibref() throws SQLException {
        try {
            if (this.m_libref != null) {
                this.m_libref._release();
                this.m_libref = null;
            }
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_releaseLibrefFail, (Throwable)e, new java.lang.Object[0]);
        }
    }

    @Deprecated
    public DataHolder readRecords(int hashCode, int flags, int bindKey, int rows, int rowOffset, byte[] pos, int[] columnTypes) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        if (this.m_dataSet == null) {
            return null;
        }
        DataHolder data = this.readRecords2(hashCode, flags, bindKey, rows, rowOffset, pos);
        if (data.isEmpty()) {
            return null;
        }
        return data;
    }

    @Nonnull
    DataHolder readRecords2(int hashCode, int flags, int bindKey, int rows, int rowOffset, byte[] pos) throws SQLException {
        this.m_dataSet = this.dataMap.get(hashCode);
        assert (this.m_dataSet != null);
        VariableArray2dOfStringHolder characterValuesHolder = new VariableArray2dOfStringHolder();
        VariableArray2dOfDoubleHolder numericValuesHolder = new VariableArray2dOfDoubleHolder();
        VariableArray2dOfOctetHolder missingNumericValuesHolder = new VariableArray2dOfOctetHolder();
        OctetSeqHolder bookmarksHolder = new OctetSeqHolder();
        IntHolder statusHolder = new IntHolder();
        try {
            long endOffset = (long)rowOffset + (long)rows;
            if (endOffset > Integer.MAX_VALUE) {
                rows = Integer.MAX_VALUE - rowOffset;
            }
            this.m_dataSet.ReadRecords(flags, bindKey, pos == null ? new byte[]{} : pos, rows, rowOffset, characterValuesHolder, numericValuesHolder, missingNumericValuesHolder, bookmarksHolder, statusHolder);
            if (statusHolder.value == 2) {
                this.m_status = -2;
            }
            this.m_status = statusHolder.value == 3 ? -1 : -3;
            if (logger.isTraceEnabled()) {
                String rioStatus = rioStatusStrValue.get(statusHolder.value) == null ? UNKNOWN_STATUS : rioStatusStrValue.get(statusHolder.value);
                logger.trace((java.lang.Object)String.format(readRecordsLayout, hashCode, characterValuesHolder.value.length, rowOffset, rioStatus, rows));
            }
            DataHolder data = new DataHolder();
            data.characterValues = characterValuesHolder.value;
            data.numericValues = numericValuesHolder.value;
            data.missingNumericValues = missingNumericValuesHolder.value;
            data.bookmarkArray = bookmarksHolder.value;
            data.status = this.m_status;
            return data;
        }
        catch (NoLock e) {
            throw new MVASQLException(MessageCode.MVAResultSet_readRecordsFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoDelete e) {
            throw new MVASQLException(MessageCode.MVAResultSet_readRecordsFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoRandomAccess e) {
            throw new MVASQLException(MessageCode.MVAResultSet_readRecordsFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidPosition e) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVAResultSet_readRecordsFailed, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVAResultSet_readRecordsFailed, (Throwable)e, new java.lang.Object[0]);
        }
    }

    private IWorkspace getWorkspace() throws SQLException {
        String spn;
        int port;
        IWorkspace iworkspace = null;
        String host = this.mvaConnProps.getHost();
        String p = this.mvaConnProps.getPort();
        try {
            port = Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            throw new MVASQLException(MessageCode.MVAConnection_urlMustSpecifyServer, new java.lang.Object[0]);
        }
        BridgeServer server = new BridgeServer("440196D4-90F0-11D0-9F41-00A024BB830C", host, port);
        String encryptionPolicy = this.mvaConnProps.getEncryptionPolicy();
        String encryptionContent = this.mvaConnProps.getEncryptionContent();
        String encryptionAlgorithms = this.mvaConnProps.getEncryptionAlgorithms();
        if (encryptionPolicy != null && encryptionPolicy.length() > 0) {
            server.setEncryptionPolicy(encryptionPolicy);
        }
        if (encryptionContent != null && encryptionContent.length() > 0) {
            server.setEncryptionContent(encryptionContent);
        }
        if (encryptionAlgorithms != null && encryptionAlgorithms.length() > 0) {
            server.setEncryptionAlgorithms(encryptionAlgorithms);
        }
        boolean useSSPI = false;
        String xt = this.mvaConnProps.getSspi();
        if (xt.equalsIgnoreCase("kerberos")) {
            spn = this.mvaConnProps.getSpn();
            if (spn != null && spn.length() > 0) {
                server.setSPN(spn);
            }
            server.setSecurityPackage("Kerberos");
            useSSPI = true;
        } else if (xt.equalsIgnoreCase("ntlm")) {
            server.setSecurityPackage("NTLM");
            useSSPI = true;
        } else if (xt.equalsIgnoreCase("negotiate")) {
            spn = this.mvaConnProps.getSpn();
            if (spn != null && spn.length() > 0) {
                server.setSPN(spn);
            }
            server.setSecurityPackage("Negotiate");
            useSSPI = true;
        }
        try {
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(server);
            ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory(cxfConfig);
            if (useSSPI) {
                SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                this.IOMcnxn = cxf.getConnection(cred);
            } else {
                String strUserName = this.mvaConnProps.getUserName();
                String strPassword = this.mvaConnProps.getPassword();
                this.IOMcnxn = cxf.getConnection(strUserName, strPassword);
            }
            Object object = this.IOMcnxn.getObject();
            iworkspace = IWorkspaceHelper.narrow(object);
            return iworkspace;
        }
        catch (BAD_PARAM e) {
            throw new MVASQLException(MessageCode.RIOUtil_corbaFail, (Throwable)e, new java.lang.Object[0]);
        }
        catch (ConnectionFactoryException e) {
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_connectionUnableToEstablish, (Throwable)e, new java.lang.Object[0]);
        }
    }

    private void addWarning(SQLWarning warning) {
        if (warning != null) {
            if (this._warnings == null) {
                this._warnings = warning;
            } else {
                this._warnings.setNextWarning(warning);
            }
        }
    }

    public SQLWarning getWarnings() {
        return this._warnings;
    }

    public void clearWarnings() {
        this._warnings = null;
    }

    public List<String> getLibraries() throws SQLException {
        try {
            StringSeqHolder names = new StringSeqHolder();
            this.m_dataService.ListLibrefs(names);
            List<String> l = Arrays.asList(names.value);
            Collections.sort(l);
            return l;
        }
        catch (NoAccessMethod e) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_getSchemaError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (LNameNoAssign e) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_getSchemaError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_getSchemaError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.MVADatabaseMetaData_getSchemaError, (Throwable)e, new java.lang.Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRuntimeException(RuntimeException e) throws MVASQLException {
        if (e instanceof COMM_FAILURE) {
            try {
                if (this._rioListener != null) {
                    this._rioListener.notifyClosed();
                }
            }
            catch (SQLException e2) {
            }
            finally {
                try {
                    this.disconnect();
                }
                catch (SQLException e1) {}
            }
            throw new MVASQLException(MessageCode.RIOUtil_connectionFailure, (Throwable)e, new java.lang.Object[0]);
        }
        if (e instanceof NO_MEMORY) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesCorbaMemory, (Throwable)e, new java.lang.Object[0]);
        }
    }

    @SASScope
    public IDataSet getIDataSet() {
        return this.m_dataSet;
    }

    protected int putDataSet(IDataSet iDataSet) {
        int hc = iDataSet.hashCode();
        Integer key = hc;
        this.dataMap.put(key, iDataSet);
        return hc;
    }

    MVAConnectionProperties getMVAConnectionProperties() {
        return this.mvaConnProps;
    }

    protected long openExtendedAttributes(int iFlags, int iChunkSize) throws SQLException {
        LongHolder oNumAttrs = new LongHolder();
        IntHolder oChunkSize = new IntHolder();
        IntHolder oMaxValLen = new IntHolder();
        try {
            IDataSet_1_4 dataset_1_4 = IDataSet_1_4Helper.narrow(this.m_dataSet);
            if (dataset_1_4 == null) {
                throw new RuntimeException("IDataSet_1_4 is not supported");
            }
            this._attrs = dataset_1_4.OpenExtendedAttributes(iFlags, oNumAttrs, oMaxValLen, iChunkSize, oChunkSize);
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)String.format(openXaLayout, iFlags, oNumAttrs.value, oMaxValLen.value, iChunkSize, oChunkSize.value));
            }
        }
        catch (NoAttributes e) {
            return -1L;
        }
        catch (InvalidOpenMode e) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesInvalidOpenMode, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NotSupported e) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesNotSupported, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (ExtendedAttributesError e) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesInterfaceError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (FutureVersionError e) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesGeneric, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_openAttributesError, (Throwable)e, new java.lang.Object[0]);
        }
        return oNumAttrs.value;
    }

    protected Map<String, java.lang.Object> getAttributes(int iFlags, String columnName, int iRowsReturned) throws SQLException {
        IExtendedAttributeSearch attrSearch = null;
        HashMap<String, java.lang.Object> attrs = new HashMap<String, java.lang.Object>();
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)getAttrLayout);
        }
        try {
            attrSearch = this._attrs.OpenAttributeSearch(columnName, columnName.length(), iFlags, iRowsReturned);
            if (logger.isTraceEnabled()) {
                logger.trace((java.lang.Object)String.format(getAttrSearchLayout, columnName, iFlags, iRowsReturned));
            }
            StringSeqHolder oAttrNames = new StringSeqHolder();
            LongSeqHolder oAttrNamesL = new LongSeqHolder();
            StringSeqHolder oAttrColNames = new StringSeqHolder();
            LongSeqHolder oAttrColNamesL = new LongSeqHolder();
            StringSeqHolder oAttrValueS = new StringSeqHolder();
            LongSeqHolder oAttrValueL = new LongSeqHolder();
            DoubleSeqHolder oAttrValueD = new DoubleSeqHolder();
            OctetSeqHolder oAttrValueM = new OctetSeqHolder();
            LongSeqHolder oFlags = new LongSeqHolder();
            LongHolder oRowsReturned = new LongHolder();
            do {
                attrSearch.GetNextAttributeSearch(oAttrNames, oAttrNamesL, oAttrColNames, oAttrColNamesL, oAttrValueS, oAttrValueL, oAttrValueD, oAttrValueM, oFlags, oRowsReturned);
                if (logger.isTraceEnabled()) {
                    logger.trace((java.lang.Object)String.format(getAttrNextLayout, oRowsReturned.value));
                }
                int i = 0;
                while ((long)i < oRowsReturned.value) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((java.lang.Object)String.format(getAttrNextFlagsLayout, oFlags.value[i]));
                    }
                    if ((oFlags.value[i] & 0x10) != 0) {
                        if (oAttrValueM.value[i] == 0 || oAttrValueM.value[i] == 127) {
                            attrs.put(oAttrNames.value[i], oAttrValueD.value[i]);
                            if (logger.isTraceEnabled()) {
                                logger.trace((java.lang.Object)String.format(getAttrNextValueDLayout, oAttrNames.value[i], oAttrValueD.value[i]));
                            }
                        } else {
                            char missingValue = '.';
                            if (oAttrValueS.value[i] == null) {
                                missingValue = '.';
                            } else if (oAttrValueS.value[i].length() == 1) {
                                missingValue = oAttrValueS.value[i].charAt(0);
                            } else if (oAttrValueS.value[i].length() == 2) {
                                missingValue = oAttrValueS.value[i].charAt(1);
                            }
                            attrs.put(oAttrNames.value[i], Character.valueOf(missingValue));
                            if (logger.isTraceEnabled()) {
                                logger.trace((java.lang.Object)String.format(getAttrNextValueMLayout, oAttrNames.value[i], oAttrValueM.value[i]));
                            }
                        }
                    } else if ((oFlags.value[i] & 8) != 0) {
                        attrs.put(oAttrNames.value[i], oAttrValueS.value[i]);
                        if (logger.isTraceEnabled()) {
                            logger.trace((java.lang.Object)String.format(getAttrNextValueSLayout, oAttrNames.value[i], oAttrValueS.value[i]));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((java.lang.Object)getAttrNextValueULayout);
                    }
                    ++i;
                }
            } while (oRowsReturned.value > 0L);
        }
        catch (NoMoreAttributes e) {
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)getAttrNextDoneLayout);
            }
        }
        catch (InvalidAttrFlags e) {
            throw new MVASQLException(MessageCode.RIOUtil_getAttributesSearchFlags, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (com.sas.iom.SAS.IExtendedAttributesPackage.ExtendedAttributesError e) {
            throw new MVASQLException(MessageCode.RIOUtil_getAttributesSearch, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (com.sas.iom.SAS.IExtendedAttributeSearchPackage.ExtendedAttributesError e) {
            throw new MVASQLException(MessageCode.RIOUtil_getAttributesError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_getAttributesGeneric, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_getAttributesError, (Throwable)e, new java.lang.Object[0]);
        }
        if (attrSearch != null) {
            try {
                attrSearch.CloseAttributeSearch();
            }
            catch (UserException e) {
                // empty catch block
            }
        }
        return attrs;
    }

    protected void setAttributes(int iFlags, String varname, Map<String, java.lang.Object> data) throws SQLException {
        try {
            iFlags |= 0x100;
            Byte iAttrValueM = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((java.lang.Object)setAttrLayout);
            }
            Iterator<Map.Entry<String, java.lang.Object>> it = data.entrySet().iterator();
            int flags = 0;
            while (it.hasNext()) {
                Map.Entry<String, java.lang.Object> pairs = it.next();
                if (pairs.getValue() instanceof String) {
                    flags = iFlags | 8;
                    if (logger.isTraceEnabled()) {
                        logger.trace((java.lang.Object)String.format(setAttrAddSLayout, pairs.getKey(), pairs.getValue(), flags));
                    }
                    this._attrs.AddAttribute(pairs.getKey(), pairs.getKey().length(), varname, varname.length(), (String)pairs.getValue(), ((String)pairs.getValue()).length(), 0.0, iAttrValueM, flags);
                    continue;
                }
                if (pairs.getValue() instanceof Double) {
                    flags = iFlags | 0x10;
                    if (logger.isTraceEnabled()) {
                        logger.trace((java.lang.Object)String.format(setAttrAddDLayout, pairs.getKey(), pairs.getValue(), flags));
                    }
                    this._attrs.AddAttribute(pairs.getKey(), pairs.getKey().length(), varname, varname.length(), EMPTY_STRING, 0, (Double)pairs.getValue(), iAttrValueM, flags);
                    continue;
                }
                if (pairs.getValue() instanceof Byte) {
                    flags = iFlags | 0x10;
                    if (logger.isTraceEnabled()) {
                        logger.trace((java.lang.Object)String.format(setAttrAddMLayout, pairs.getKey(), pairs.getValue(), flags));
                    }
                    this._attrs.AddAttribute(pairs.getKey(), pairs.getKey().length(), varname, varname.length(), EMPTY_STRING, 0, 0.0, (Byte)pairs.getValue(), flags);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((java.lang.Object)setAttrAddULayout);
            }
        }
        catch (ExtendedAttributesNameInvalid e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesInvalidName, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (com.sas.iom.SAS.IExtendedAttributesPackage.ExtendedAttributesError e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoTableAttributeUpdated e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesTableAttr, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (NoColumnAttributeUpdated e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesColumnAttr, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (DupColumnAttribute e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesColumnDup, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AttributeNameNeeded e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesNoName, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (ColumnNameNeeded e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesNoColName, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (AttributeTruncated e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesTruncation, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (com.sas.iom.SAS.IExtendedAttributesPackage.InvalidOpenMode e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesInvalidOpenMode, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (DupTableAttribute e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesTableDup, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidAttrFlags e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesInvalidFlag, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesGeneric, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_setAttributesError, (Throwable)e, new java.lang.Object[0]);
        }
    }

    protected void dropAttributes(int iFlags, String varname, ArrayList<String> data) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((java.lang.Object)dropAttrLayout);
        }
        try {
            for (String attrName : data) {
                if (logger.isTraceEnabled()) {
                    logger.trace((java.lang.Object)String.format(dropAttrNameLayout, attrName, iFlags));
                }
                try {
                    this._attrs.DropAttribute(attrName, attrName.length(), varname, varname.length(), iFlags);
                }
                catch (NoTableAttribute e) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((java.lang.Object)String.format(dropAttrDSLayout, attrName));
                }
                catch (NoColumnAttribute e) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((java.lang.Object)String.format(dropAttrColLayout, attrName, varname));
                }
            }
        }
        catch (com.sas.iom.SAS.IExtendedAttributesPackage.InvalidOpenMode e) {
            throw new MVASQLException(MessageCode.RIOUtil_dropAttributesInvalidOpenMode, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (InvalidAttrFlags e) {
            throw new MVASQLException(MessageCode.RIOUtil_dropAttributesInvalidFlag, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (com.sas.iom.SAS.IExtendedAttributesPackage.ExtendedAttributesError e) {
            throw new MVASQLException(MessageCode.RIOUtil_dropAttributesInterfaceError, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (GenericError e) {
            throw new MVASQLException(MessageCode.RIOUtil_dropAttributesGeneric, (Throwable)((java.lang.Object)e), new java.lang.Object[0]);
        }
        catch (RuntimeException e) {
            this.checkRuntimeException(e);
            throw new MVASQLException(MessageCode.RIOUtil_dropAttributesError, (Throwable)e, new java.lang.Object[0]);
        }
    }

    protected void closeExtendedAttributes(int iFlags) {
        block8: {
            try {
                this._attrs.CloseExtendedAttributes(iFlags);
            }
            catch (com.sas.iom.SAS.IExtendedAttributesPackage.ExtendedAttributesError e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)String.format(closeXaLayout, e.getMessage()));
                }
            }
            catch (GenericError e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((java.lang.Object)String.format(closeGenericLayout, e.getMessage()));
                }
            }
            catch (RuntimeException e) {
                try {
                    this.checkRuntimeException(e);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((java.lang.Object)String.format(closeGenericLayout, e.getMessage()));
            }
        }
    }

    static {
        HashMap<Integer, String> _rioStatusStrValue = new HashMap<Integer, String>();
        _rioStatusStrValue.put(0, "S_OK");
        _rioStatusStrValue.put(2, "W_BegOfFile");
        _rioStatusStrValue.put(3, "W_EndOfFile");
        _rioStatusStrValue.put(4, "W_PathNotFound");
        _rioStatusStrValue.put(6, "E_RecordLocked");
        _rioStatusStrValue.put(7, "E_InvalidCellValue");
        _rioStatusStrValue.put(8, "E_InvalidBookmark");
        _rioStatusStrValue.put(9, "E_RecDeleted");
        _rioStatusStrValue.put(10, "W_FileNotFound");
        rioStatusStrValue = Collections.unmodifiableMap(_rioStatusStrValue);
        logger = Logger.getLogger(RIOUtil.class);
        className = RIOUtil.class.getSimpleName();
        readRecordsLayout = className + ".readRecords hash %d, read %3d rows, offset %3d, status= %s; %3d rows requested";
        openXaLayout = className + ".openExtendedAttributes iFlags=0x%x, oNumAttrs=%d, oMaxValLen=%d, iChunkSize=%d, oChunkSize=%d";
        getAttrLayout = className + ".getAttributes()";
        getAttrSearchLayout = className + "  IExtendedAttributes::OpenAttributeSearch() -- columnName=%s, flags=0x%x, rowsRequested=%d";
        getAttrNextLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- rowsReturned=%d";
        getAttrNextFlagsLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- oFlags=0x%x";
        getAttrNextValueDLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- '%s', %f";
        getAttrNextValueMLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- '%s', 0x%x";
        getAttrNextValueSLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- '%s', '%s'";
        getAttrNextValueULayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- unknown value skipped";
        getAttrNextDoneLayout = className + "  IExtendedAttributes::GetNextAttributeSearch() -- no more attributes";
        setAttrLayout = className + ".setAttributes()";
        setAttrAddSLayout = className + "  IExtendedAttributes::AddAttribute() -- '%s', '%s': flag=0x%x";
        setAttrAddDLayout = className + "  IExtendedAttributes::AddAttribute() -- '%s', %f: flag=0x%x";
        setAttrAddMLayout = className + "  IExtendedAttributes::AddAttribute() -- '%s', 0x%x: flag=0x%x";
        setAttrAddULayout = className + "  IExtendedAttributes::AddAttribute() -- unknown value skipped";
        dropAttrLayout = className + ".dropAttributes()";
        dropAttrNameLayout = className + "  IExtendedAttributes::DropAttribute() -- '%s': flag=0x%x";
        dropAttrDSLayout = className + "  Cannot drop '%s'.  Data set attribute does not exist.";
        dropAttrColLayout = className + "  Cannot drop '%s' on column %s.  Column attribute does not exist.";
        closeXaLayout = className + ".close() -- ExtendedAttributesError thrown: %s";
        closeGenericLayout = className + ".close() -- GenericError thrown: %s";
    }
}

