/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.RB;
import com.sas.util.ValueItem;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

@SASScope
public class DoubleRangeType
extends BaseRangeDataType {
    public static final DoubleRangeType DEFAULT_INSTANCE = new DoubleRangeType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof Double[] && ((Double[])inputValue).length == 2) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof double[] && ((double[])inputValue).length == 2) {
            double[] doubleArray = (double[])inputValue;
            Double[] values = new Double[]{new Double(doubleArray[0]), new Double(doubleArray[1])};
            return values;
        }
        if (inputValue instanceof String) {
            String toDecode = (String)inputValue;
            String[] minMaxValues = toDecode.split("--");
            if (minMaxValues.length == 2) {
                return this.coerceValue(new String[]{minMaxValues[0].trim(), minMaxValues[1].trim()}, inputLocale);
            }
        } else if (inputValue instanceof Object[]) {
            Object[] toDecode = (Object[])inputValue;
            if (toDecode.length == 2) {
                Object upper;
                Double[] values = new Double[2];
                Object lower = DoubleType.DEFAULT_INSTANCE.coerceValue(toDecode[0], inputLocale);
                if (lower instanceof Double) {
                    values[0] = (Double)lower;
                }
                if ((upper = DoubleType.DEFAULT_INSTANCE.coerceValue(toDecode[1], inputLocale)) instanceof Double) {
                    values[1] = (Double)upper;
                }
                return values;
            }
        } else if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("DoubleRangeType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        String[] values = (input = input.trim()).split("--");
        if (values.length != 2) {
            throw new IllegalArgumentException("Unable to convert value to range with 2 values");
        }
        Double[] returnValue = new Double[]{(Double)DoubleType.DEFAULT_INSTANCE.coerceValueFromPersistedString(values[0]), (Double)DoubleType.DEFAULT_INSTANCE.coerceValueFromPersistedString(values[1])};
        return returnValue;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 8;
    }

    @Override
    public DataTypeInterface getRangeMinMaxDataType() {
        return DoubleType.DEFAULT_INSTANCE;
    }

    @Override
    public Object[] getRangeDefaultValue() {
        return new Double[2];
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal instanceof Double[] && retVal == value && ((Double[])value).length == 2) {
            Double[] castRetVal = (Double[])retVal;
            Double[] copiedRetVal = new Double[]{castRetVal[0], castRetVal[1]};
            return copiedRetVal;
        }
        return retVal;
    }
}

