/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.codepolicy.SASScope;
import com.sas.io.RB;
import com.sas.io.RemoteReader;
import com.sas.io.RemoteReaderInterface;
import com.sas.util.UncheckedException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

@SASScope
public class ReaderAdapter
extends Reader
implements Serializable {
    static final long serialVersionUID = -6501975424007685167L;
    private RemoteReaderInterface reader;

    public ReaderAdapter(Reader reader) throws RemoteException {
        this(new RemoteReader(reader));
    }

    public ReaderAdapter(Reader reader, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this(new RemoteReader(reader, port, csf, ssf));
    }

    public ReaderAdapter(RemoteReaderInterface reader) {
        this.reader = reader;
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public synchronized void mark(int readlimit) throws IOException {
        this.reader.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        try {
            return this.reader.markSupported();
        }
        catch (RemoteException e) {
            throw new UncheckedException(e, RB.getStringResource("RCOM.wrapCheck.ex.txt"));
        }
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        char[] tempbuf = this.reader.read(cbuf.length);
        if (tempbuf == null) {
            return -1;
        }
        System.arraycopy(tempbuf, 0, cbuf, 0, tempbuf.length);
        return tempbuf.length;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        char[] tempbuf = this.reader.read(len);
        if (tempbuf == null) {
            return -1;
        }
        System.arraycopy(tempbuf, 0, cbuf, off, tempbuf.length);
        return tempbuf.length;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }
}

