/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.jce;

import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.jce.JceServices;
import com.sas.net.crypto.jce.RB;
import com.sas.util.log.CommonLoggerFactory;
import com.sas.util.log.CommonLoggerInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JceCipher
implements CipherInterface {
    private static final Set<KeyPairHolder> _pkcsKeySet = new HashSet<KeyPairHolder>();
    private static final Set<SecureRandomHolder> _prngSeedGeneratorSet = new HashSet<SecureRandomHolder>();
    private static final CommonLoggerInterface _logger = CommonLoggerFactory.getLogger(JceCipher.class);
    private static final int FIPS1402CAP_C = 8;
    private static final int FIPS1402CAP_S = 32;
    private static final int FIPS1402REQ_S = 64;
    private static final int SHA1CAP_C = 128;
    private static final int SHA256CAP_C = 256;
    private static final int SHA512CAP_C = 512;
    private static final int SHA1CAP_S = 1024;
    private static final int SHA256CAP_S = 2048;
    private static final int SHA512CAP_S = 4096;
    private static final int MAC = 1;
    private static final byte[] _keyMagicRSA = new byte[]{82, 83, 65, 49};
    private static final String[][] _hashCapabilityTable = new String[][]{{"SHA", Integer.toString(128)}, {"SHA1", Integer.toString(128)}, {"SHA256", Integer.toString(256)}, {"SHA512", Integer.toString(512)}, {"SHA-256", Integer.toString(256)}, {"SHA-512", Integer.toString(512)}};
    private static final String[] _csprngArr = new String[]{"FIPS186PRNG", "IBMSecureRandom"};
    private JceServices _jceServices;
    private SecureRandom _random;
    private boolean _mac;
    private boolean _fipsMode;
    private String _hashAlgorithm;
    private int _encryptedHashSize;
    private int _skcsKeyType;
    private int _skcsBlockSize;
    private int _skcsKeyDataSize;
    private int _skcsKeySaltSize;
    private String _skcsAlgorithm;
    private String _skcsTransformation;
    private AlgorithmParameterSpec _encryptCipherParamSpec1;
    private AlgorithmParameterSpec _encryptCipherParamSpec2;
    private AlgorithmParameterSpec _decryptCipherParamSpec1;
    private AlgorithmParameterSpec _decryptCipherParamSpec2;
    private byte[] _encryptCipherKeyData1Reversed;
    private byte[] _encryptCipherKeyData1;
    private byte[] _encryptCipherKeyData2;
    private byte[] _decryptCipherKeyData1Reversed;
    private byte[] _decryptCipherKeyData1;
    private byte[] _decryptCipherKeyData2;

    JceCipher() {
    }

    @Override
    public void keyExchange(InputStream iStream, OutputStream oStream) throws IOException, CryptoException {
        byte[] twosComplementPeerKeyData;
        BigInteger peerExponent;
        RSAPublicKeySpec rsaPublicKeySpec;
        int feature1 = this.getClientFeatureSet1();
        int pkcsKeyType = this.getPkcsKeyType();
        String pkcsAlgorithm = this.getAlgorithm(pkcsKeyType);
        String pkcsTransformation = this.getTransformation(pkcsKeyType);
        byte[] pkcsKeyMagic = this.getKeyMagic(pkcsKeyType);
        int pkcsAlgorithmKeySizeLimit = JceServices.keyTypeToKeySizeLimit(pkcsKeyType);
        int pkcsJurisdictionKeySizeLimit = this.getJurisdictionKeySizeLimit(pkcsTransformation);
        int pkcsKeySize = Math.min(pkcsAlgorithmKeySizeLimit, pkcsJurisdictionKeySizeLimit);
        int skcsAlgorithmKeySizeLimit = JceServices.keyTypeToKeySizeLimit(this._skcsKeyType);
        int skcsJurisdictionKeySizeLimit = this.getJurisdictionKeySizeLimit(this._skcsTransformation);
        int skcsKeySize = Math.min(skcsAlgorithmKeySizeLimit, skcsJurisdictionKeySizeLimit);
        int skcsKeyDataBufferSize = skcsKeySize / 8;
        SizePhase sizePhase = new SizePhase();
        sizePhase.setFeature1(feature1);
        sizePhase.setPkcsKeySize(pkcsKeySize);
        sizePhase.setSkcsKeySize(skcsKeySize);
        sizePhase.transmit(iStream, oStream);
        feature1 = sizePhase.getFeature1();
        pkcsKeySize = sizePhase.getPkcsKeySize();
        if (_logger.isDebugEnabled()) {
            _logger.debug("client and server agreed on PKCS key size " + pkcsKeySize);
        }
        if (this.isSkcsVariableKeyLength(this._skcsKeyType)) {
            skcsKeySize = sizePhase.getSkcsKeySize();
            if (_logger.isDebugEnabled()) {
                _logger.debug("client and server agreed on SKCS key size " + skcsKeySize);
            }
        }
        this._skcsKeyDataSize = skcsKeySize / 8;
        this._skcsKeySaltSize = skcsKeyDataBufferSize - this._skcsKeyDataSize;
        this._mac = this.isUsingMac(feature1);
        this._fipsMode = this.isFipsMode(feature1);
        this._random = this.getSecureRandom();
        KeyPair pkcsKeyPair = this.getKeyPair(pkcsAlgorithm, pkcsKeySize);
        PublicKey pkcsPublicKey = pkcsKeyPair.getPublic();
        KeySpec pkcsKeySpec = this.getPkcsKeySpecForKey(pkcsPublicKey);
        byte[] pkcsKeyData = null;
        int pkcsKeyExponent = 0;
        if (pkcsKeySpec instanceof RSAPublicKeySpec) {
            rsaPublicKeySpec = (RSAPublicKeySpec)pkcsKeySpec;
            BigInteger keyModulus = rsaPublicKeySpec.getModulus();
            int keyLength = keyModulus.bitLength();
            if (keyLength != pkcsKeySize) {
                throw new IllegalStateException("Unexpected PKCS key size");
            }
            byte[] twosComplementKeyData = keyModulus.toByteArray();
            if (keyLength % 8 == 0) {
                int keyDataL = twosComplementKeyData.length - 1;
                pkcsKeyData = new byte[keyDataL];
                System.arraycopy(twosComplementKeyData, 1, pkcsKeyData, 0, keyDataL);
            } else {
                pkcsKeyData = twosComplementKeyData;
            }
        } else {
            throw new IllegalStateException("Unsupported KeySpec type " + pkcsKeySpec.getClass().getName());
        }
        pkcsKeyExponent = rsaPublicKeySpec.getPublicExponent().intValue();
        PublicKeyPhase publicKeyPhase = new PublicKeyPhase();
        publicKeyPhase.setKeyType(pkcsKeyType);
        publicKeyPhase.setKeyMagic(pkcsKeyMagic);
        publicKeyPhase.setKeyData(pkcsKeyData);
        publicKeyPhase.setKeyExponent(pkcsKeyExponent);
        publicKeyPhase.setKeyLength(pkcsKeySize);
        publicKeyPhase.transmit(iStream, oStream);
        int peerPkcsKeyType = publicKeyPhase.getKeyType();
        byte[] peerPkcsKeyData = publicKeyPhase.getKeyData();
        String peerPkcsAlgorithm = this.getAlgorithm(peerPkcsKeyType);
        String peerPkcsTransformation = this.getTransformation(peerPkcsKeyType);
        RSAPublicKeySpec peerPkcsKeySpec = null;
        if (peerPkcsKeyType == 41984) {
            peerExponent = BigInteger.valueOf(publicKeyPhase.getKeyExponent());
            int keyLength = publicKeyPhase.getKeyLength();
            twosComplementPeerKeyData = null;
            if (keyLength % 8 == 0 && peerPkcsKeyData.length * 8 == keyLength) {
                int twosComplementPeerKeyDataL = peerPkcsKeyData.length + 1;
                twosComplementPeerKeyData = new byte[twosComplementPeerKeyDataL];
                twosComplementPeerKeyData[0] = 0;
                System.arraycopy(peerPkcsKeyData, 0, twosComplementPeerKeyData, 1, peerPkcsKeyData.length);
            } else {
                twosComplementPeerKeyData = peerPkcsKeyData;
            }
        } else {
            String msgIndex = "JceCipher.pkcs.keytype.unsupported.txt";
            String msg = RB.getStringResource("JceCipher.pkcs.keytype.unsupported.txt");
            throw new CryptoException(msg);
        }
        BigInteger peerModulus = new BigInteger(twosComplementPeerKeyData);
        peerPkcsKeySpec = new RSAPublicKeySpec(peerModulus, peerExponent);
        PublicKey peerPublicKey = this.getPkcsKeyForKeySpec(peerPkcsAlgorithm, peerPkcsKeySpec);
        _logger.debug("created peer public key for algorithm " + peerPkcsAlgorithm);
        SecretKeyPhase secretKeyPhase = new SecretKeyPhase();
        byte[] encryptCipherIV1 = new byte[this._skcsBlockSize];
        byte[] encryptCipherIV2 = new byte[this._skcsBlockSize];
        if (this.isSkcsBlockCipher(this._skcsKeyType)) {
            this._random.nextBytes(encryptCipherIV1);
            this._encryptCipherParamSpec1 = this.getSkcsParameterSpec(encryptCipherIV1);
            if (this._mac) {
                this._random.nextBytes(encryptCipherIV2);
                this._encryptCipherParamSpec2 = this.getSkcsParameterSpec(encryptCipherIV2);
            }
        }
        secretKeyPhase.setInitVector1(encryptCipherIV1);
        secretKeyPhase.setInitVector2(encryptCipherIV2);
        Cipher peerPublicKeyEncryptCipher = this.getCipher(peerPkcsTransformation, peerPublicKey, 1, null);
        KeyGenerator keyGen = this.getKeyGenerator(this._skcsKeyType, skcsKeySize);
        SecretKey skcsEncryptKey1 = keyGen.generateKey();
        KeySpec skcsKeySpec1 = this.getSkcsKeySpecForKey(skcsEncryptKey1);
        byte[] skcsKeyData1 = JceServices.keySpecToKeyData(skcsKeySpec1);
        this._encryptCipherKeyData1 = new byte[skcsKeyDataBufferSize];
        System.arraycopy(skcsKeyData1, 0, this._encryptCipherKeyData1, 0, skcsKeyData1.length);
        this._encryptCipherKeyData1Reversed = JceCipher.reverseBuffer(skcsKeyData1);
        byte[] encryptedSkcsKeyData1 = this.applyCipher(peerPublicKeyEncryptCipher, skcsKeyData1);
        secretKeyPhase.setEncryptedKeyData1(encryptedSkcsKeyData1);
        byte[] skcsKeyData2 = null;
        SecretKey skcsEncryptKey2 = null;
        if (this._mac) {
            skcsEncryptKey2 = keyGen.generateKey();
            KeySpec skcsKeySpec2 = this.getSkcsKeySpecForKey(skcsEncryptKey2);
            skcsKeyData2 = JceServices.keySpecToKeyData(skcsKeySpec2);
            this._encryptCipherKeyData2 = new byte[skcsKeyDataBufferSize];
            System.arraycopy(skcsKeyData2, 0, this._encryptCipherKeyData2, 0, skcsKeyData2.length);
            byte[] encryptedSkcsKeyData2 = this.applyCipher(peerPublicKeyEncryptCipher, skcsKeyData2);
            secretKeyPhase.setEncryptedKeyData2(encryptedSkcsKeyData2);
        }
        this._hashAlgorithm = this.getHashAlgorithm(feature1);
        MessageDigest messageDigest = this.getMessageDigest(this._hashAlgorithm);
        int hashSize = messageDigest.getDigestLength();
        secretKeyPhase.setHashSize(hashSize);
        secretKeyPhase.setKeyType(this._skcsKeyType);
        secretKeyPhase.setKeyEncryptionType(peerPkcsKeyType);
        secretKeyPhase.setPeerKeyEncryptionType(peerPkcsKeyType);
        secretKeyPhase.transmit(iStream, oStream);
        byte[] decryptCipherIV1 = secretKeyPhase.getPeerInitVector1();
        byte[] decryptCipherIV2 = secretKeyPhase.getPeerInitVector2();
        byte[] peerSkcsEncryptedKeyData1 = secretKeyPhase.getPeerEncryptedKeyData1();
        byte[] peerSkcsEncryptedKeyData2 = secretKeyPhase.getPeerEncryptedKeyData2();
        if (this.isSkcsBlockCipher(this._skcsKeyType)) {
            this._decryptCipherParamSpec1 = this.getSkcsParameterSpec(decryptCipherIV1);
            if (this._mac) {
                this._decryptCipherParamSpec2 = this.getSkcsParameterSpec(decryptCipherIV2);
            }
        }
        Cipher privateKeyDecryptCipher = this.getCipher(pkcsTransformation, pkcsKeyPair.getPrivate(), 2, null);
        byte[] peerSkcsKeyData1 = this.applyCipher(privateKeyDecryptCipher, peerSkcsEncryptedKeyData1);
        this._decryptCipherKeyData1Reversed = JceCipher.reverseBuffer(peerSkcsKeyData1);
        this._decryptCipherKeyData1 = new byte[skcsKeyDataBufferSize];
        System.arraycopy(peerSkcsKeyData1, 0, this._decryptCipherKeyData1, 0, peerSkcsKeyData1.length);
        byte[] peerSkcsKeyData2 = null;
        if (peerSkcsEncryptedKeyData2 != null) {
            peerSkcsKeyData2 = this.applyCipher(privateKeyDecryptCipher, peerSkcsEncryptedKeyData2);
            this._decryptCipherKeyData2 = new byte[skcsKeyDataBufferSize];
            System.arraycopy(peerSkcsKeyData2, 0, this._decryptCipherKeyData2, 0, peerSkcsKeyData2.length);
        }
        byte[] phase2 = new byte[]{112, 104, 97, 115, 101, 32, 50};
        byte[] skcsKeyData1Reversed = JceCipher.reverseBuffer(skcsKeyData1);
        byte[] peerSkcsKeyData1Reversed = JceCipher.reverseBuffer(peerSkcsKeyData1);
        byte[] secretKeyPhaseHash = null;
        if (this._mac) {
            byte[] skcsKeyData2Reversed = JceCipher.reverseBuffer(skcsKeyData2);
            byte[] peerSkcsKeyData2Reversed = JceCipher.reverseBuffer(peerSkcsKeyData2);
            secretKeyPhaseHash = this.computeHash(messageDigest, skcsKeyData1Reversed, skcsKeyData2Reversed, pkcsKeyData, peerSkcsKeyData1Reversed, peerSkcsKeyData2Reversed, peerPkcsKeyData, phase2);
        } else {
            secretKeyPhaseHash = this.computeHash(messageDigest, skcsKeyData1Reversed, pkcsKeyData, peerSkcsKeyData1Reversed, peerPkcsKeyData, phase2);
        }
        byte[] peerSecretKeyPhaseHash = secretKeyPhase.getPeerHash();
        if (!MessageDigest.isEqual(secretKeyPhaseHash, peerSecretKeyPhaseHash)) {
            String msgIndex = "JceCipher.skcs.auth.failed.txt";
            String msg = RB.getStringResource("JceCipher.skcs.auth.failed.txt");
            throw new CryptoException(msg);
        }
        byte[] phase3 = new byte[]{112, 104, 97, 115, 101, 32, 51};
        byte[] phase3Hash = null;
        if (this._mac) {
            byte[] peerSkcsKeyData2Reversed = JceCipher.reverseBuffer(peerSkcsKeyData2);
            phase3Hash = this.computeHash(messageDigest, peerSkcsKeyData1Reversed, peerSkcsKeyData2Reversed, pkcsKeyData, peerPkcsKeyData, phase3);
        } else {
            phase3Hash = this.computeHash(messageDigest, peerSkcsKeyData1Reversed, pkcsKeyData, peerPkcsKeyData, phase3);
        }
        oStream.write(phase3Hash);
        oStream.flush();
        byte[] encryptCipherKeyData2 = this.getKeyDataWithRandomSalt(this._encryptCipherKeyData2, this._skcsKeyDataSize, this._skcsKeySaltSize);
        KeySpec encryptCipherKeySpec2 = this.getSkcsKeySpecForKeyData(encryptCipherKeyData2);
        SecretKey encryptKey2 = this.getSkcsKeyForKeySpec(encryptCipherKeySpec2);
        Cipher encryptCipher2 = this.getCipher(this._skcsTransformation, encryptKey2, 1, this._encryptCipherParamSpec2);
        this._encryptedHashSize = encryptCipher2.getOutputSize(hashSize);
    }

    @Override
    public int getCipherTextLength(int plainTextLength) {
        this.checkState();
        int cipherTextLen = this._skcsKeySaltSize;
        cipherTextLen = this.isSkcsBlockCipher(this._skcsKeyType) ? (cipherTextLen += plainTextLength + this._skcsBlockSize & ~(this._skcsBlockSize - 1)) : (cipherTextLen += plainTextLength);
        if (this._mac) {
            cipherTextLen += this._encryptedHashSize + this._skcsKeySaltSize;
        }
        return cipherTextLen;
    }

    @Override
    public int getMaxPlainTextLength(int cipherTextLength) {
        this.checkState();
        int plainTextL = cipherTextLength - this._skcsKeySaltSize;
        if (this._mac) {
            plainTextL -= this._skcsKeySaltSize;
            plainTextL -= this._encryptedHashSize;
        }
        return Math.max(plainTextL, 0);
    }

    @Override
    public int encrypt(byte[] plainText, int offset, int length, OutputStream oStream) throws IOException, CryptoException {
        this.checkState();
        int cipherTextL = 0;
        byte[] encryptCipherKeyData1 = this.getKeyDataWithRandomSalt(this._encryptCipherKeyData1, this._skcsKeyDataSize, this._skcsKeySaltSize);
        if (this._skcsKeySaltSize > 0) {
            oStream.write(encryptCipherKeyData1, this._skcsKeyDataSize, this._skcsKeySaltSize);
            cipherTextL += this._skcsKeySaltSize;
        }
        if (this._mac) {
            byte[] encryptCipherKeyData2 = this.getKeyDataWithRandomSalt(this._encryptCipherKeyData2, this._skcsKeyDataSize, this._skcsKeySaltSize);
            if (this._skcsKeySaltSize > 0) {
                oStream.write(encryptCipherKeyData2, this._skcsKeyDataSize, this._skcsKeySaltSize);
                cipherTextL += this._skcsKeySaltSize;
            }
            ByteBuffer element1 = ByteBuffer.wrap(this._encryptCipherKeyData1Reversed);
            ByteBuffer element2 = ByteBuffer.wrap(plainText, offset, length);
            byte[] hash = this.computeHash(element1, element2);
            KeySpec encryptCipherKeySpec2 = this.getSkcsKeySpecForKeyData(encryptCipherKeyData2);
            SecretKey encryptCipherKey2 = this.getSkcsKeyForKeySpec(encryptCipherKeySpec2);
            Cipher encryptCipher2 = this.getCipher(this._skcsTransformation, encryptCipherKey2, 1, this._encryptCipherParamSpec2);
            byte[] encryptedHash = this.applyCipher(encryptCipher2, hash);
            oStream.write(encryptedHash);
            cipherTextL += encryptedHash.length;
        }
        KeySpec encryptCipherKeySpec1 = this.getSkcsKeySpecForKeyData(encryptCipherKeyData1);
        SecretKey encryptCipherKey1 = this.getSkcsKeyForKeySpec(encryptCipherKeySpec1);
        Cipher encryptCipher1 = this.getCipher(this._skcsTransformation, encryptCipherKey1, 1, this._encryptCipherParamSpec1);
        byte[] cipherText = this.applyCipher(encryptCipher1, plainText, offset, length);
        oStream.write(cipherText);
        oStream.flush();
        return cipherTextL += cipherText.length;
    }

    @Override
    public int decrypt(InputStream iStream, int cipherTextLength, byte[] buffer, int offset) throws IOException, CryptoException {
        int l;
        this.checkState();
        int remaining = cipherTextLength;
        byte[] decryptCipherKeyData1 = this.getKeyDataWithSaltFromPeer(this._decryptCipherKeyData1, this._skcsKeyDataSize, this._skcsKeySaltSize, iStream);
        remaining -= this._skcsKeySaltSize;
        byte[] peerHash = null;
        if (this._mac) {
            byte[] decryptCipherKeyData2 = this.getKeyDataWithSaltFromPeer(this._decryptCipherKeyData2, this._skcsKeyDataSize, this._skcsKeySaltSize, iStream);
            remaining -= this._skcsKeySaltSize;
            byte[] encryptedPeerHash = new byte[this._encryptedHashSize];
            JceCipher.readFully(iStream, encryptedPeerHash);
            remaining -= this._encryptedHashSize;
            KeySpec decryptCipherKeySpec2 = this.getSkcsKeySpecForKeyData(decryptCipherKeyData2);
            SecretKey decryptCipherKey2 = this.getSkcsKeyForKeySpec(decryptCipherKeySpec2);
            Cipher decryptCipher2 = this.getCipher(this._skcsTransformation, decryptCipherKey2, 2, this._decryptCipherParamSpec2);
            peerHash = this.applyCipher(decryptCipher2, encryptedPeerHash);
        }
        KeySpec decryptCipherKeySpec1 = this.getSkcsKeySpecForKeyData(decryptCipherKeyData1);
        SecretKey decryptCipherKey1 = this.getSkcsKeyForKeySpec(decryptCipherKeySpec1);
        Cipher decryptCipher1 = this.getCipher(this._skcsTransformation, decryptCipherKey1, 2, this._decryptCipherParamSpec1);
        int chunkSize = 8192;
        int chunkBufferSize = Math.min(8192, remaining);
        byte[] chunkBuffer = new byte[chunkBufferSize];
        int plainTextL = 0;
        try {
            while (remaining > 8192) {
                int r = JceCipher.read(iStream, chunkBuffer, 0, 8192);
                remaining -= r;
                int p = decryptCipher1.update(chunkBuffer, 0, 8192, buffer, offset + plainTextL);
                plainTextL += p;
            }
            JceCipher.readFully(iStream, chunkBuffer, 0, remaining);
            l = decryptCipher1.doFinal(chunkBuffer, 0, remaining, buffer, offset + plainTextL);
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
        ByteBuffer element1 = ByteBuffer.wrap(this._decryptCipherKeyData1Reversed);
        ByteBuffer element2 = ByteBuffer.wrap(buffer, offset, plainTextL += l);
        byte[] hash = this.computeHash(element1, element2);
        if (!MessageDigest.isEqual(peerHash, hash)) {
            String msgIndex = "JceCipher.decrypt.auth.failed.txt";
            String msg = RB.getStringResource("JceCipher.decrypt.auth.failed.txt");
            throw new CryptoException(msg);
        }
        return plainTextL;
    }

    @Override
    public void close() throws CryptoException {
    }

    void setJceServices(JceServices jceServices) {
        this._jceServices = jceServices;
    }

    void setSkcsKeyType(int skcsKeyType) {
        this._skcsKeyType = skcsKeyType;
        this._skcsAlgorithm = this.getAlgorithm(skcsKeyType);
        if (_logger.isDebugEnabled()) {
            _logger.debug("using JCE cipher name " + this._skcsAlgorithm);
        }
        this._skcsTransformation = this.getTransformation(skcsKeyType);
        this._skcsBlockSize = this.getBlockSize(skcsKeyType);
    }

    private void checkState() {
        if (this._encryptCipherKeyData1 == null) {
            throw new IllegalStateException("cipher key exchange has not happened yet");
        }
    }

    private int getClientFeatureSet1() {
        Set<String> hashAlgorithmSet = this._jceServices.getAlgorithms("MessageDigest", false);
        int feature1 = 0;
        for (String[] hashCapabilityEntry : _hashCapabilityTable) {
            if (!hashAlgorithmSet.contains(hashCapabilityEntry[0])) continue;
            feature1 |= Integer.parseInt(hashCapabilityEntry[1]);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("client supports hash algorithm " + hashCapabilityEntry[0]);
        }
        if (feature1 != 0 && this._jceServices.supportsFips() && 26128 == this._skcsKeyType) {
            feature1 |= 8;
            if (_logger.isDebugEnabled()) {
                _logger.debug("client supports FIPS 140-2 operation");
            }
        }
        return feature1;
    }

    private int getPkcsKeyType() {
        return 41984;
    }

    private String getAlgorithm(int keyType) {
        return JceServices.keyTypeToAlgorithm(keyType);
    }

    private String getTransformation(int keyType) {
        String algorithm = this.getAlgorithm(keyType);
        String feedbackMode = null;
        String paddingType = null;
        switch (keyType) {
            case 41984: {
                feedbackMode = "ECB";
                paddingType = "PKCS1Padding";
                break;
            }
            case 26113: 
            case 26114: 
            case 26115: 
            case 26128: {
                feedbackMode = "CBC";
                paddingType = "PKCS5Padding";
                break;
            }
            case 26625: {
                break;
            }
            default: {
                throw JceServices.unknownKeyType(keyType);
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append(algorithm);
        if (feedbackMode != null && paddingType != null) {
            buf.append("/").append(feedbackMode);
            buf.append("/").append(paddingType);
        }
        String transformation = buf.toString();
        if (_logger.isDebugEnabled()) {
            _logger.debug("transformation for algorithm " + algorithm + " is " + transformation);
        }
        return transformation;
    }

    private byte[] getKeyMagic(int keyType) {
        switch (keyType) {
            case 41984: {
                return _keyMagicRSA;
            }
        }
        throw JceServices.unknownKeyType(keyType);
    }

    private int getJurisdictionKeySizeLimit(String transformation) throws CryptoException {
        int maxKeySize = 0;
        try {
            maxKeySize = Cipher.getMaxAllowedKeyLength(transformation);
        }
        catch (GeneralSecurityException gse) {
            _logger.error("could not get max allowed key size for " + transformation, gse);
            throw new CryptoException(gse);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("max allowed key size for " + transformation + ": " + maxKeySize);
        }
        return maxKeySize;
    }

    private int getBlockSize(int keyType) {
        return keyType == 26625 ? 8 : JceServices.keyTypeToBlockSize(keyType);
    }

    private Cipher getCipher(String transformation, Key key, int opMode, AlgorithmParameterSpec algParams) throws CryptoException {
        try {
            Cipher cipher = this._jceServices.getCipher(transformation, this._fipsMode);
            if (algParams != null) {
                cipher.init(opMode, key, algParams, this._random);
            } else {
                cipher.init(opMode, key, this._random);
            }
            return cipher;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private String getHashAlgorithm(int feature1) {
        Set<String> hashAlgorithmSet = this._jceServices.getAlgorithms("MessageDigest", this._fipsMode);
        String hashAlgorithm = null;
        hashAlgorithm = (feature1 & 0x200) != 0 && (feature1 & 0x1000) != 0 ? (hashAlgorithmSet.contains("SHA512") ? "SHA512" : "SHA-512") : ((feature1 & 0x100) != 0 && (feature1 & 0x800) != 0 ? (hashAlgorithmSet.contains("SHA256") ? "SHA256" : "SHA-256") : ((feature1 & 0x80) != 0 && (feature1 & 0x400) != 0 ? (hashAlgorithmSet.contains("SHA1") ? "SHA1" : "SHA") : "MD5"));
        if (_logger.isDebugEnabled()) {
            _logger.debug("client and server agreed on hash algorithm " + hashAlgorithm);
        }
        return hashAlgorithm;
    }

    private MessageDigest getMessageDigest(String hashAlgorithm) throws CryptoException {
        try {
            return this._jceServices.getMessageDigest(hashAlgorithm, this._fipsMode);
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private byte[] computeHash(MessageDigest messageDigest, byte[] ... elements) {
        for (byte[] element : elements) {
            messageDigest.update(element);
        }
        byte[] hash = messageDigest.digest();
        return hash;
    }

    private byte[] computeHash(ByteBuffer ... elements) throws CryptoException {
        MessageDigest messageDigest = this.getMessageDigest(this._hashAlgorithm);
        for (ByteBuffer element : elements) {
            messageDigest.update(element);
        }
        byte[] hash = messageDigest.digest();
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair getKeyPair(String pkcsAlgorithm, int pkcsKeySize) throws CryptoException {
        KeyPairHolder keyPairHolder = null;
        boolean generate = false;
        Set<KeyPairHolder> set = _pkcsKeySet;
        synchronized (set) {
            for (KeyPairHolder kph : _pkcsKeySet) {
                if (!kph.match(pkcsAlgorithm, this._fipsMode, pkcsKeySize)) continue;
                keyPairHolder = kph;
                break;
            }
            if (keyPairHolder == null) {
                generate = true;
                keyPairHolder = new KeyPairHolder(pkcsAlgorithm, this._fipsMode, pkcsKeySize);
                _pkcsKeySet.add(keyPairHolder);
            }
        }
        set = keyPairHolder;
        synchronized (set) {
            if (generate) {
                try {
                    KeyPairGenerator keyPairGenerator = this._jceServices.getKeyPairGenerator(pkcsAlgorithm, this._fipsMode);
                    keyPairGenerator.initialize(pkcsKeySize, this._random);
                    KeyPair keyPair = keyPairGenerator.genKeyPair();
                    keyPairHolder.set(keyPair);
                    keyPairHolder.notifyAll();
                }
                catch (GeneralSecurityException gse) {
                    throw new CryptoException(gse);
                }
            } else {
                while (!keyPairHolder.has()) {
                    try {
                        keyPairHolder.wait();
                    }
                    catch (InterruptedException ie) {
                        String msgIndex = "JceCipher.keygen.interrupted.txt";
                        String msg = RB.getStringResource("JceCipher.keygen.interrupted.txt");
                        throw new CryptoException(msg, ie);
                    }
                }
            }
            return (KeyPair)keyPairHolder.get();
        }
    }

    private boolean isUsingMac(int feature1) {
        return (feature1 & 1) != 0;
    }

    private boolean isFipsMode(int feature1) {
        return (feature1 & 8) != 0 && ((feature1 & 0x20) != 0 || (feature1 & 0x40) != 0);
    }

    private boolean isSkcsBlockCipher(int keyType) {
        try {
            JceServices.keyTypeToBlockSize(keyType);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean isSkcsVariableKeyLength(int keyType) {
        try {
            JceServices.keyTypeToKeySize(keyType);
            return false;
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    private KeySpec getPkcsKeySpecForKey(Key key) throws CryptoException {
        try {
            String algorithm = key.getAlgorithm();
            KeyFactory keyFactory = this._jceServices.getKeyFactory(algorithm, this._fipsMode);
            return keyFactory.getKeySpec(key, RSAPublicKeySpec.class);
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private PublicKey getPkcsKeyForKeySpec(String algorithm, KeySpec keySpec) throws CryptoException {
        try {
            KeyFactory keyFactory = this._jceServices.getKeyFactory(algorithm, this._fipsMode);
            PublicKey key = keyFactory.generatePublic(keySpec);
            return key;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private KeySpec getSkcsKeySpecForKey(SecretKey key) throws CryptoException {
        try {
            Class<?> keySpecClass = this._jceServices.getKeySpecClass(this._skcsAlgorithm, this._fipsMode);
            SecretKeyFactory keyFactory = this._jceServices.getSecretKeyFactory(this._skcsAlgorithm, this._fipsMode);
            KeySpec keySpec = keyFactory.getKeySpec(key, keySpecClass);
            return keySpec;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private KeySpec getSkcsKeySpecForKeyData(byte[] keyData) throws CryptoException {
        try {
            switch (this._skcsKeyType) {
                case 26113: {
                    return new DESKeySpec(keyData);
                }
                case 26115: {
                    return new DESedeKeySpec(keyData);
                }
            }
            return new SecretKeySpec(keyData, this._skcsAlgorithm);
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private SecretKey getSkcsKeyForKeySpec(KeySpec keySpec) throws CryptoException {
        try {
            SecretKeyFactory keyFactory = this._jceServices.getSecretKeyFactory(this._skcsAlgorithm, this._fipsMode);
            SecretKey key = keyFactory.generateSecret(keySpec);
            return key;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private AlgorithmParameterSpec getSkcsParameterSpec(byte[] iv) {
        switch (this._skcsKeyType) {
            case 26113: 
            case 26115: 
            case 26128: {
                return new IvParameterSpec(iv);
            }
            case 26114: {
                return new RC2ParameterSpec((this._skcsKeyDataSize + this._skcsKeySaltSize) * 8, iv);
            }
        }
        throw new IllegalArgumentException(this._skcsAlgorithm);
    }

    private byte[] getKeyDataWithRandomSalt(byte[] keyData, int keyDataSize, int keySaltSize) throws CryptoException {
        if (keySaltSize == 0) {
            return keyData;
        }
        byte[] salt = new byte[keySaltSize];
        this._random.nextBytes(salt);
        return this.getKeyDataWithSalt(keyData, keyDataSize, salt);
    }

    private byte[] getKeyDataWithSaltFromPeer(byte[] keyData, int keyDataSize, int keySaltSize, InputStream iStream) throws IOException {
        if (keySaltSize == 0) {
            return keyData;
        }
        byte[] salt = new byte[keySaltSize];
        JceCipher.readFully(iStream, salt);
        return this.getKeyDataWithSalt(keyData, keyDataSize, salt);
    }

    private byte[] getKeyDataWithSalt(byte[] keyData, int keyDataSize, byte[] salt) {
        int keySaltSize = salt.length;
        int keyBufferSize = keyDataSize + keySaltSize;
        byte[] keyDataWithSalt = new byte[keyBufferSize];
        System.arraycopy(keyData, 0, keyDataWithSalt, 0, keyDataSize);
        System.arraycopy(salt, 0, keyDataWithSalt, keyDataSize, keySaltSize);
        return keyDataWithSalt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecureRandom getSecureRandom() throws CryptoException {
        Set<String> prngAlgorithmSet = this._jceServices.getAlgorithms("SecureRandom", this._fipsMode);
        String prngAlgorithmDefault = "";
        String prngAlgorithm = null;
        for (String alg : _csprngArr) {
            if (!prngAlgorithmSet.contains(alg)) continue;
            prngAlgorithm = alg;
            break;
        }
        if (prngAlgorithm == null) {
            prngAlgorithm = "";
        }
        SecureRandomHolder prngSeedGeneratorHolder = null;
        boolean generate = false;
        Set<SecureRandomHolder> i$ = _prngSeedGeneratorSet;
        synchronized (i$) {
            for (SecureRandomHolder srh : _prngSeedGeneratorSet) {
                if (!srh.match(prngAlgorithm, this._fipsMode)) continue;
                prngSeedGeneratorHolder = srh;
                break;
            }
            if (prngSeedGeneratorHolder == null) {
                generate = true;
                prngSeedGeneratorHolder = new SecureRandomHolder(prngAlgorithm, this._fipsMode);
                _prngSeedGeneratorSet.add(prngSeedGeneratorHolder);
            }
        }
        i$ = prngSeedGeneratorHolder;
        synchronized (i$) {
            if (generate) {
                try {
                    SecureRandom prngSeedGenerator;
                    SecureRandom secureRandom = prngSeedGenerator = !"".equals(prngAlgorithm) ? this._jceServices.getSecureRandom(prngAlgorithm, this._fipsMode) : new SecureRandom();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("random number generator algorithm is " + prngSeedGenerator.getAlgorithm());
                    }
                    prngSeedGenerator.generateSeed(8);
                    prngSeedGeneratorHolder.set(prngSeedGenerator);
                    prngSeedGeneratorHolder.notifyAll();
                }
                catch (GeneralSecurityException gse) {
                    throw new CryptoException(gse);
                }
            } else {
                while (!prngSeedGeneratorHolder.has()) {
                    try {
                        prngSeedGeneratorHolder.wait();
                    }
                    catch (InterruptedException ie) {
                        String msgIndex = "JceCipher.prng.interrupted.txt";
                        String msg = RB.getStringResource("JceCipher.prng.interrupted.txt");
                        throw new CryptoException(msg, ie);
                    }
                }
            }
        }
        SecureRandom prngSeedGenerator = (SecureRandom)prngSeedGeneratorHolder.get();
        byte[] seed = prngSeedGenerator.generateSeed(8);
        try {
            SecureRandom random = !"".equals(prngAlgorithm) ? this._jceServices.getSecureRandom(prngAlgorithm, this._fipsMode) : new SecureRandom();
            random.setSeed(seed);
            return random;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private KeyGenerator getKeyGenerator(int keyType, int keySize) throws CryptoException {
        try {
            String algorithm = this.getAlgorithm(keyType);
            KeyGenerator keyGen = this._jceServices.getKeyGenerator(algorithm, this._fipsMode);
            int ks = this.isSkcsVariableKeyLength(keyType) ? keySize : JceServices.keyTypeToKeySize(keyType);
            keyGen.init(ks, this._random);
            return keyGen;
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private byte[] applyCipher(Cipher cipher, byte[] data) throws CryptoException {
        return this.applyCipher(cipher, data, 0, data.length);
    }

    private byte[] applyCipher(Cipher cipher, byte[] data, int offset, int length) throws CryptoException {
        try {
            return cipher.doFinal(data, offset, length);
        }
        catch (GeneralSecurityException gse) {
            throw new CryptoException(gse);
        }
    }

    private static byte[] reverseBuffer(byte[] buf) {
        int bufL = buf.length;
        byte[] r = new byte[bufL];
        for (int i = 0; i < bufL; ++i) {
            r[i] = buf[bufL - i - 1];
        }
        return r;
    }

    private static void readFully(InputStream iStream, byte[] buffer) throws IOException {
        JceCipher.readFully(iStream, buffer, 0, buffer.length);
    }

    private static void readFully(InputStream iStream, byte[] buffer, int off, int len) throws IOException {
        int r;
        for (int bytesRead = 0; bytesRead < len; bytesRead += r) {
            r = JceCipher.read(iStream, buffer, off + bytesRead, len - bytesRead);
        }
    }

    private static int read(InputStream iStream, byte[] buffer, int off, int len) throws IOException {
        int r = iStream.read(buffer, off, len);
        if (r < 0) {
            throw new EOFException();
        }
        return r;
    }

    private static final class SecureRandomHolder
    extends BaseHolder<SecureRandom> {
        private SecureRandomHolder(String algorithm, boolean fipsMode) {
            super(algorithm, fipsMode);
        }
    }

    private static final class KeyPairHolder
    extends BaseHolder<KeyPair> {
        private int _keySize;

        private KeyPairHolder(String algorithm, boolean fipsMode, int keySize) {
            super(algorithm, fipsMode);
            this._keySize = keySize;
        }

        private boolean match(String algorithm, boolean fipsMode, int keySize) {
            return super.match(algorithm, fipsMode) && this._keySize == keySize;
        }
    }

    private static abstract class BaseHolder<T> {
        private String _algorithm;
        private boolean _fipsMode;
        private T _item;

        BaseHolder(String algorithm, boolean fipsMode) {
            this._algorithm = algorithm;
        }

        void set(T item) {
            this._item = item;
        }

        T get() {
            return this._item;
        }

        boolean has() {
            return this._item != null;
        }

        boolean match(String algorithm, boolean fipsMode) {
            return this._algorithm.equals(algorithm) && this._fipsMode == fipsMode;
        }
    }

    private static final class SecretKeyPhase
    extends BasePhase {
        private static final byte[] _secretKeyRecordId = new byte[]{83, 69, 67};
        private static final int _secretKeyRecordVersion = 1;
        private static final int _simpleBlob = 1;
        private static final int _blobVersion = 2;
        private byte[] _iv1;
        private byte[] _iv2;
        private byte[] _peerIv1;
        private byte[] _peerIv2;
        private byte[] _encryptedKeyData1;
        private byte[] _encryptedKeyData2;
        private byte[] _peerEncryptedKeyData1;
        private byte[] _peerEncryptedKeyData2;
        private byte[] _peerHash;
        private int _keyType;
        private int _keyEncryptionType;
        private int _peerKeyEncryptionType;
        private int _hashSize;

        private SecretKeyPhase() {
        }

        @Override
        void transmit(InputStream iStream, OutputStream oStream) throws IOException, CryptoException {
            if (this._encryptedKeyData1 == null) {
                throw new IllegalStateException("no key to send");
            }
            if (this._iv1 == null || this._iv2 == null) {
                throw new IllegalStateException("initialization vectors cannot be null");
            }
            int bufL = 8;
            bufL += this._iv1.length;
            bufL += this._iv2.length;
            bufL += this._encryptedKeyData1.length + 12;
            if (this._encryptedKeyData2 != null) {
                bufL += this._encryptedKeyData2.length + 12;
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(bufL);
            DataOutputStream dataOut = new DataOutputStream(byteOut);
            this.writeHeader(dataOut, _secretKeyRecordId, 1);
            dataOut.write(this._iv1);
            dataOut.write(this._iv2);
            this.writeSubrecord(dataOut, this._encryptedKeyData1);
            if (this._encryptedKeyData2 != null) {
                this.writeSubrecord(dataOut, this._encryptedKeyData2);
            }
            dataOut.flush();
            this.send(oStream, byteOut);
            int inBufL = bufL + this._hashSize;
            DataInputStream dataIn = this.recv(iStream, inBufL);
            int secretKeyRecordVersion = this.readHeader(dataIn);
            if (secretKeyRecordVersion != 1) {
                String msgIndex = "JceCipher.bad.skcs.record.version.txt";
                String msg = RB.getStringResource("JceCipher.bad.skcs.record.version.txt");
                throw new CryptoException(msg);
            }
            this._peerIv1 = new byte[this._iv1.length];
            dataIn.readFully(this._peerIv1);
            this._peerIv2 = new byte[this._iv2.length];
            dataIn.readFully(this._peerIv2);
            this._peerEncryptedKeyData1 = this.readSubrecord(dataIn, this._encryptedKeyData1.length);
            if (this._encryptedKeyData2 != null) {
                this._peerEncryptedKeyData2 = this.readSubrecord(dataIn, this._encryptedKeyData2.length);
            }
            this._peerHash = new byte[this._hashSize];
            dataIn.readFully(this._peerHash);
        }

        private void setInitVector1(byte[] iv1) {
            this._iv1 = iv1;
        }

        private void setInitVector2(byte[] iv2) {
            this._iv2 = iv2;
        }

        private void setEncryptedKeyData1(byte[] encryptedKeyData1) {
            this._encryptedKeyData1 = encryptedKeyData1;
        }

        private void setEncryptedKeyData2(byte[] encryptedKeyData2) {
            this._encryptedKeyData2 = encryptedKeyData2;
        }

        private void setKeyType(int keyType) {
            this._keyType = keyType;
        }

        private void setKeyEncryptionType(int keyEncryptionType) {
            this._keyEncryptionType = keyEncryptionType;
        }

        private void setPeerKeyEncryptionType(int peerKeyEncryptionType) {
            this._peerKeyEncryptionType = peerKeyEncryptionType;
        }

        private void setHashSize(int hashSize) {
            this._hashSize = hashSize;
        }

        private byte[] getPeerInitVector1() {
            return this._peerIv1;
        }

        private byte[] getPeerInitVector2() {
            return this._peerIv2;
        }

        private byte[] getPeerEncryptedKeyData1() {
            return this._peerEncryptedKeyData1;
        }

        private byte[] getPeerEncryptedKeyData2() {
            return this._peerEncryptedKeyData2;
        }

        private byte[] getPeerHash() {
            return this._peerHash;
        }

        private void writeSubrecord(DataOutputStream dataOut, byte[] keyData) throws IOException {
            dataOut.write(1);
            dataOut.write(2);
            dataOut.writeShort(0);
            dataOut.writeInt(this._keyType);
            dataOut.writeInt(this._keyEncryptionType);
            dataOut.write(keyData);
        }

        private byte[] readSubrecord(DataInputStream dataIn, int keyDataL) throws IOException, CryptoException {
            int blobType = dataIn.read();
            if (blobType != 1) {
                String msgIndex = "JceCipher.bad.skcs.subrecord.type.txt";
                String msg = RB.getStringResource("JceCipher.bad.skcs.subrecord.type.txt");
                throw new CryptoException(msg);
            }
            int blobVersion = dataIn.read();
            if (blobVersion != 2) {
                String msgIndex = "JceCipher.bad.skcs.subrecord.version.txt";
                String msg = RB.getStringResource("JceCipher.bad.skcs.subrecord.version.txt");
                throw new CryptoException(msg);
            }
            dataIn.readShort();
            int keyType = dataIn.readInt();
            if (keyType != this._keyType) {
                String msgIndex = "JceCipher.bad.skcs.type.txt";
                String msg = RB.getStringResource("JceCipher.bad.skcs.type.txt");
                throw new CryptoException(msg);
            }
            int keyEncryptionType = dataIn.readInt();
            if (keyEncryptionType != this._peerKeyEncryptionType) {
                String msgIndex = "JceCipher.bad.skcs.encryption.type.txt";
                String msg = RB.getStringResource("JceCipher.bad.skcs.encryption.type.txt");
                throw new CryptoException(msg);
            }
            byte[] keyData = new byte[keyDataL];
            dataIn.readFully(keyData);
            return keyData;
        }
    }

    private static final class PublicKeyPhase
    extends BasePhase {
        private static final byte[] _publicKeyRecordId = new byte[]{80, 85, 66};
        private static final int _publicKeyRecordVersion = 1;
        private static final int _publicKeyBlob = 6;
        private static final int _blobVersion = 2;
        private int _keyType;
        private byte[] _keyMagic;
        private int _keyLength;
        private int _keyExponent;
        private byte[] _keyData;

        private PublicKeyPhase() {
        }

        @Override
        void transmit(InputStream iStream, OutputStream oStream) throws IOException, CryptoException {
            int bufL = 28 + this._keyData.length;
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(bufL);
            DataOutputStream dataOut = new DataOutputStream(byteOut);
            this.writeHeader(dataOut, _publicKeyRecordId, 1);
            dataOut.write(6);
            dataOut.write(2);
            dataOut.writeShort(0);
            dataOut.writeInt(this._keyType);
            dataOut.write(this._keyMagic);
            dataOut.writeInt(this._keyLength);
            dataOut.writeInt(this._keyExponent);
            dataOut.write(this._keyData);
            dataOut.flush();
            this.send(oStream, byteOut);
            DataInputStream dataHeaderIn = this.recv(iStream, 28);
            int publicKeyRecordVersion = this.readHeader(dataHeaderIn);
            if (publicKeyRecordVersion != 1) {
                String msgIndex = "JceCipher.bad.pkcs.record.version.txt";
                String msg = RB.getStringResource("JceCipher.bad.pkcs.record.version.txt");
                throw new CryptoException(msg);
            }
            dataHeaderIn.readInt();
            this._keyType = dataHeaderIn.readInt();
            dataHeaderIn.readInt();
            this._keyLength = dataHeaderIn.readInt();
            this._keyExponent = dataHeaderIn.readInt();
            int keyDataL = this._keyLength / 8 + (this._keyLength % 8 == 0 ? 0 : 1);
            DataInputStream dataPayloadIn = this.recv(iStream, keyDataL);
            this._keyData = new byte[keyDataL];
            dataPayloadIn.readFully(this._keyData);
        }

        private void setKeyType(int keyType) {
            this._keyType = keyType;
        }

        private int getKeyType() {
            return this._keyType;
        }

        private void setKeyMagic(byte[] keyMagic) {
            this._keyMagic = keyMagic;
        }

        private void setKeyLength(int keyLength) {
            this._keyLength = keyLength;
        }

        private int getKeyLength() {
            return this._keyLength;
        }

        private void setKeyExponent(int keyExponent) {
            this._keyExponent = keyExponent;
        }

        private int getKeyExponent() {
            return this._keyExponent;
        }

        private void setKeyData(byte[] keyData) {
            this._keyData = keyData;
        }

        private byte[] getKeyData() {
            return this._keyData;
        }
    }

    private static final class SizePhase
    extends BasePhase {
        private static final byte[] _sizeRecordId = new byte[]{83, 73, 90};
        private static final int _sizeRecordVersion = 0;
        private int _feature1;
        private int _pkcsKeySize;
        private int _skcsKeySize;

        private SizePhase() {
        }

        @Override
        void transmit(InputStream iStream, OutputStream oStream) throws IOException, CryptoException {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(28);
            DataOutputStream dataOut = new DataOutputStream(byteOut);
            this.writeHeader(dataOut, _sizeRecordId, 0);
            dataOut.writeInt(this._pkcsKeySize);
            dataOut.writeInt(this._skcsKeySize);
            dataOut.writeInt(0);
            dataOut.writeInt(this._feature1);
            dataOut.writeInt(0);
            dataOut.flush();
            this.send(oStream, byteOut);
            DataInputStream dataIn = this.recv(iStream, 28);
            int sizeRecordVersion = this.readHeader(dataIn);
            if (sizeRecordVersion != 0) {
                String msgIndex = "JceCipher.bad.size.record.version.txt";
                String msg = RB.getStringResource("JceCipher.bad.size.record.version.txt");
                throw new CryptoException(msg);
            }
            this._pkcsKeySize = dataIn.readInt();
            this._skcsKeySize = dataIn.readInt();
            dataIn.readInt();
            this._feature1 = dataIn.readInt();
            dataIn.readInt();
        }

        private void setFeature1(int feature1) {
            this._feature1 = feature1;
        }

        private int getFeature1() {
            return this._feature1;
        }

        private void setPkcsKeySize(int pkcsKeySize) {
            this._pkcsKeySize = pkcsKeySize;
        }

        private int getPkcsKeySize() {
            return this._pkcsKeySize;
        }

        private void setSkcsKeySize(int skcsKeySize) {
            this._skcsKeySize = skcsKeySize;
        }

        private int getSkcsKeySize() {
            return this._skcsKeySize;
        }
    }

    private static abstract class BasePhase {
        private byte[] _recordId;

        private BasePhase() {
        }

        final void writeHeader(DataOutputStream dataOut, byte[] recordId, int recordVersion) throws IOException {
            this._recordId = recordId;
            dataOut.write(recordId);
            dataOut.write(recordVersion);
            dataOut.writeInt(0);
        }

        final int readHeader(DataInputStream dataIn) throws IOException, CryptoException {
            byte[] recordId = new byte[this._recordId.length];
            dataIn.readFully(recordId);
            if (!Arrays.equals(this._recordId, recordId)) {
                String msgIndex = "JceCipher.bad.record.id.txt";
                String msg = RB.getStringResource("JceCipher.bad.record.id.txt");
                throw new CryptoException(msg);
            }
            int recordVersion = dataIn.read();
            int status = dataIn.readInt();
            if (status != 0) {
                String msgIndex = "JceCipher.bad.status.id.txt";
                String msg = RB.getStringResource("JceCipher.bad.status.id.txt");
                throw new CryptoException(msg);
            }
            return recordVersion;
        }

        final void send(OutputStream oStream, ByteArrayOutputStream data) throws IOException {
            data.writeTo(oStream);
            oStream.flush();
        }

        final DataInputStream recv(InputStream iStream, int dataL) throws IOException {
            int r;
            byte[] dataBuf = new byte[dataL];
            for (int bytesRead = 0; bytesRead < dataL; bytesRead += r) {
                r = iStream.read(dataBuf, bytesRead, dataL - bytesRead);
                if (r >= 0) continue;
                throw new EOFException();
            }
            return new DataInputStream(new ByteArrayInputStream(dataBuf));
        }

        abstract void transmit(InputStream var1, OutputStream var2) throws IOException, CryptoException;
    }
}

