/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.jce;

import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.jce.JceCipher;
import com.sas.net.crypto.jce.JceServices;
import com.sas.util.log.CommonLoggerFactory;
import com.sas.util.log.CommonLoggerInterface;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;

public class JceCrypto
extends Crypto {
    private static final String[][] _skcsAlgorithmTable = new String[][]{{"AES", "AES", Integer.toString(26128), "256"}, {"DES", "DES", Integer.toString(26113), "0"}, {"RC2", "RC2", Integer.toString(26114), "40"}, {"RC4", "ARCFOUR", Integer.toString(26625), "40"}, {"TRIPLEDES", "DESEDE", Integer.toString(26115), "0"}};
    private static final CommonLoggerInterface _logger = CommonLoggerFactory.getLogger(JceCrypto.class);
    private static final JceServices _jceServices = JceServices.getInstance();
    private static final String _algorithms = JceCrypto.getSupportedAlgorithms(_jceServices);

    public JceCrypto(Properties p) {
    }

    @Override
    public CipherInterface openCipher() throws CryptoException {
        String algorithm = this.getName();
        if (_logger.isDebugEnabled()) {
            _logger.debug("opening cipher for algorithm " + algorithm);
        }
        int keyType = JceCrypto.algorithmToKeyType(algorithm);
        JceCipher cipher = new JceCipher();
        cipher.setJceServices(_jceServices);
        cipher.setSkcsKeyType(keyType);
        return cipher;
    }

    @Override
    public String getSupportedNames() {
        return _algorithms;
    }

    private static String getSupportedAlgorithms(JceServices jceServices) {
        Set<String> cipherAlgorithmSet = jceServices.getAlgorithms("Cipher", false);
        HashSet<String> supportedAlgorithmSet = new HashSet<String>();
        for (String[] skcsAlgorithmEntry : _skcsAlgorithmTable) {
            int maximumKeySize;
            if (!cipherAlgorithmSet.contains(skcsAlgorithmEntry[1])) continue;
            int minimumKeySize = Integer.parseInt(skcsAlgorithmEntry[3]);
            if (minimumKeySize < (maximumKeySize = JceCrypto.getMaximumKeySize(skcsAlgorithmEntry[1]))) {
                supportedAlgorithmSet.add(skcsAlgorithmEntry[0]);
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("ignoring algorithm " + skcsAlgorithmEntry[0] + " because the maximum key size is " + maximumKeySize);
        }
        StringBuffer algBuf = new StringBuffer();
        for (String alg : supportedAlgorithmSet) {
            if (algBuf.length() > 0) {
                algBuf.append(",");
            }
            algBuf.append(alg);
        }
        String algs = algBuf.toString();
        if (_logger.isDebugEnabled()) {
            _logger.debug("supported algorithms: " + algs);
        }
        return algs;
    }

    private static int algorithmToKeyType(String algorithm) {
        for (String[] skcsAlgorithmEntry : _skcsAlgorithmTable) {
            if (!skcsAlgorithmEntry[0].equals(algorithm)) continue;
            return Integer.parseInt(skcsAlgorithmEntry[2]);
        }
        throw new IllegalArgumentException("Unsupported algorithm " + algorithm);
    }

    private static int getMaximumKeySize(String algorithm) {
        try {
            return Cipher.getMaxAllowedKeyLength(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }
}

