/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.jce;

import com.sas.net.crypto.jce.FipsValidator;
import com.sas.net.crypto.jce.JsafeFipsValidator;
import com.sas.util.log.CommonLoggerFactory;
import com.sas.util.log.CommonLoggerInterface;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class JceServices {
    public static final int KEY_TYPE_RSA = 41984;
    public static final int KEY_TYPE_DES = 26113;
    public static final int KEY_TYPE_DES_EDE = 26115;
    public static final int KEY_TYPE_RC2 = 26114;
    public static final int KEY_TYPE_RC4 = 26625;
    public static final int KEY_TYPE_AES = 26128;
    public static final int KEY_SIZE_LIMIT_RSA = 15360;
    public static final int KEY_SIZE_LIMIT_AES = 256;
    public static final int KEY_SIZE_LIMIT_DES = 64;
    public static final int KEY_SIZE_LIMIT_DES_EDE = 192;
    public static final int KEY_SIZE_LIMIT_RC2 = 128;
    public static final int KEY_SIZE_LIMIT_RC4 = 128;
    public static final int KEY_SIZE_DES = 56;
    public static final int KEY_SIZE_DES_EDE = 168;
    public static final int BLOCK_SIZE_AES = 16;
    public static final int BLOCK_SIZE_DES = 8;
    public static final int BLOCK_SIZE_DES_EDE = 8;
    public static final int BLOCK_SIZE_RC2 = 8;
    public static final String ALGORITHM_AES = "AES";
    public static final String ALGORITHM_ARCFOUR = "ARCFOUR";
    public static final String ALGORITHM_DES = "DES";
    public static final String ALGORITHM_DES_EDE = "DESEDE";
    public static final String ALGORITHM_FIPS186PRNG = "FIPS186PRNG";
    public static final String ALGORITHM_IBM_SECURE_RANDOM = "IBMSecureRandom";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_MD5PRNG = "MD5PRNG";
    public static final String ALGORITHM_RC2 = "RC2";
    public static final String ALGORITHM_RC4 = "RC4";
    public static final String ALGORITHM_RSA = "RSA";
    public static final String ALGORITHM_SHA = "SHA";
    public static final String ALGORITHM_SHA1 = "SHA1";
    public static final String ALGORITHM_SHA1PRNG = "SHA1PRNG";
    public static final String ALGORITHM_SHA256 = "SHA256";
    public static final String ALGORITHM_SHA512 = "SHA512";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM_SHA_512 = "SHA-512";
    public static final String SERVICE_CIPHER = "Cipher";
    public static final String SERVICE_KEY_GENERATOR = "KeyGenerator";
    public static final String SERVICE_MESSAGE_DIGEST = "MessageDigest";
    public static final String SERVICE_SECRET_KEY_FACTORY = "SecretKeyFactory";
    public static final String SERVICE_SECURE_RANDOM = "SecureRandom";
    private static final CommonLoggerInterface _logger = CommonLoggerFactory.getLogger(JceServices.class);
    private static final String _jsafeProviderClass = "com.rsa.jsafe.provider.JsafeJCE";
    private static final String _jsafeValidatorClass = JsafeFipsValidator.class.getName();
    private static final String _ibmProviderName = "IBMJCEFIPS";
    private static final String _ibmProviderClass = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final String _ibmAesKeySpecClass = "com.ibm.crypto.fips.provider.AESKeySpec";
    private static final String _sasProviderName = "SASJCE";
    private static final String _sasProviderInfoTemplate = "SASJCE Provider (SecretKeyFactory for ?)";
    private static final String[] _sasProviderSkfAlgorithmArr = new String[]{"AES", "ARCFOUR", "RC2", "RC4"};
    private static final String _sasProviderInfo = JceServices.getSasProviderInfo();
    private static final SasProvider _sasProvider = new SasProvider();
    private static final SasSecretKeyFactorySpi _sasProviderSkfSpi = new SasSecretKeyFactorySpi();
    private static final String _defaultPreferredProviderClasses = "com.rsa.jsafe.provider.JsafeJCE,com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final Map<String, FipsValidator> _fipsValidatorMap = JceServices.getFipsValidatorMap();
    private Provider _fipsProvider;

    JceServices() {
    }

    public static JceServices getInstance() {
        String[] fipsModeProviderClassArr;
        boolean installFipsModeProviders;
        JceServices jceServices = new JceServices();
        String installFipsModeProvidersKey = "com.sas.net.crypto.jce.installFipsModeProviders";
        String installFipsModeProvidersValue = System.getProperty("com.sas.net.crypto.jce.installFipsModeProviders");
        if (_logger.isDebugEnabled()) {
            _logger.debug("com.sas.net.crypto.jce.installFipsModeProviders is " + installFipsModeProvidersValue);
            if (installFipsModeProvidersValue == null) {
                _logger.debug("default is " + Boolean.TRUE);
            }
        }
        boolean bl = installFipsModeProviders = installFipsModeProvidersValue == null ? true : Boolean.parseBoolean(installFipsModeProvidersValue);
        if (!installFipsModeProviders) {
            return jceServices;
        }
        String fipsModeProviderClassesKey = "com.sas.net.crypto.jce.fipsModeProviderClasses";
        String fipsModeProviderClassesValue = System.getProperty("com.sas.net.crypto.jce.fipsModeProviderClasses");
        if (_logger.isDebugEnabled()) {
            _logger.debug("com.sas.net.crypto.jce.fipsModeProviderClasses is " + fipsModeProviderClassesValue);
            if (fipsModeProviderClassesValue == null) {
                _logger.debug("default is com.rsa.jsafe.provider.JsafeJCE,com.ibm.crypto.fips.provider.IBMJCEFIPS");
            }
        }
        String fipsModeProviderClasses = fipsModeProviderClassesValue == null ? _defaultPreferredProviderClasses : fipsModeProviderClassesValue;
        for (String fipsModeProviderClass : fipsModeProviderClassArr = fipsModeProviderClasses.split(",")) {
            String providerName;
            Provider provider;
            block14: {
                String className;
                String string = className = fipsModeProviderClass != null ? fipsModeProviderClass.trim() : null;
                if (className == null || className.length() == 0) continue;
                provider = null;
                providerName = null;
                try {
                    Class<?> providerClass = Class.forName(className);
                    provider = (Provider)providerClass.newInstance();
                    providerName = provider.getName();
                    if (!_logger.isDebugEnabled()) break block14;
                    _logger.debug("found provider in classpath " + providerName);
                }
                catch (Exception e) {
                    if (_defaultPreferredProviderClasses.indexOf(className) >= 0) {
                        if (!_logger.isDebugEnabled()) continue;
                        _logger.debug("provider " + className + " is not in classpath or cannot be instantiated ");
                        continue;
                    }
                    _logger.warn("provider is not in classpath or cannot be instantiated: " + e);
                    continue;
                }
            }
            FipsValidator validator = _fipsValidatorMap.get(providerName);
            if (validator == null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("no validator installed for provider " + providerName);
                }
                jceServices.setFipsProvider(provider);
                break;
            }
            if (validator.validate(provider)) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("validator passed for provider " + providerName);
                }
                jceServices.setFipsProvider(provider);
                break;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("validator failed for provider " + providerName);
        }
        if (_logger.isDebugEnabled() && !jceServices.supportsFips()) {
            _logger.debug("no FIPS140 compliant JCE provider is available and configured for FIPS operations");
        }
        return jceServices;
    }

    public static String keyTypeToAlgorithm(int keyType) {
        switch (keyType) {
            case 26128: {
                return ALGORITHM_AES;
            }
            case 26113: {
                return ALGORITHM_DES;
            }
            case 26114: {
                return ALGORITHM_RC2;
            }
            case 26625: {
                return ALGORITHM_ARCFOUR;
            }
            case 41984: {
                return ALGORITHM_RSA;
            }
            case 26115: {
                return ALGORITHM_DES_EDE;
            }
        }
        throw JceServices.unknownKeyType(keyType);
    }

    public static int keyTypeToKeySizeLimit(int keyType) {
        switch (keyType) {
            case 26128: {
                return 256;
            }
            case 26113: {
                return 64;
            }
            case 26114: {
                return 128;
            }
            case 26625: {
                return 128;
            }
            case 41984: {
                return 15360;
            }
            case 26115: {
                return 192;
            }
        }
        throw JceServices.unknownKeyType(keyType);
    }

    public static int keyTypeToKeySize(int keyType) {
        switch (keyType) {
            case 26113: {
                return 56;
            }
            case 26115: {
                return 168;
            }
        }
        throw JceServices.unknownKeyType(keyType);
    }

    public static int keyTypeToBlockSize(int keyType) {
        switch (keyType) {
            case 26128: {
                return 16;
            }
            case 26113: {
                return 8;
            }
            case 26114: {
                return 8;
            }
            case 26115: {
                return 8;
            }
        }
        throw JceServices.unknownKeyType(keyType);
    }

    public static byte[] keySpecToKeyData(KeySpec keySpec) {
        byte[] keyData = null;
        if (keySpec instanceof SecretKeySpec) {
            keyData = ((SecretKeySpec)keySpec).getEncoded();
        } else if (keySpec instanceof DESKeySpec) {
            keyData = ((DESKeySpec)keySpec).getKey();
        } else if (keySpec instanceof DESedeKeySpec) {
            keyData = ((DESedeKeySpec)keySpec).getKey();
        } else {
            try {
                Class<?> aesKeySpecClass = Class.forName(_ibmAesKeySpecClass);
                if (aesKeySpecClass.isInstance(keySpec)) {
                    Method getKeyMethod = aesKeySpecClass.getMethod("getKey", new Class[0]);
                    keyData = (byte[])getKeyMethod.invoke((Object)keySpec, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                String msg = "could not invoke getKey() method in class com.ibm.crypto.fips.provider.AESKeySpec";
                throw new IllegalStateException("could not invoke getKey() method in class com.ibm.crypto.fips.provider.AESKeySpec", e);
            }
            if (keyData == null) {
                throw new IllegalArgumentException("Unexpected KeySpec type " + keySpec.getClass().getName());
            }
        }
        return keyData;
    }

    public Set<String> getAlgorithms(String serviceName, boolean fipsMode) {
        if (this.checkFipsMode(fipsMode)) {
            HashSet<String> algorithmSet = new HashSet<String>();
            Set<Provider.Service> serviceSet = this._fipsProvider.getServices();
            for (Provider.Service service : serviceSet) {
                String type = service.getType();
                if (!serviceName.equals(type)) continue;
                String algorithm = service.getAlgorithm();
                algorithmSet.add(algorithm);
            }
            return algorithmSet;
        }
        return Security.getAlgorithms(serviceName);
    }

    public Cipher getCipher(String transformation, boolean fipsMode) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher;
        Cipher cipher2 = cipher = this.checkFipsMode(fipsMode) ? Cipher.getInstance(transformation, this._fipsProvider) : Cipher.getInstance(transformation);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + transformation + " cipher is " + cipher.getProvider().getName());
        }
        return cipher;
    }

    public KeyFactory getKeyFactory(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        KeyFactory keyFactory;
        KeyFactory keyFactory2 = keyFactory = this.checkFipsMode(fipsMode) ? KeyFactory.getInstance(algorithm, this._fipsProvider) : KeyFactory.getInstance(algorithm);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " key factory is " + keyFactory.getProvider().getName());
        }
        return keyFactory;
    }

    public KeyGenerator getKeyGenerator(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator;
        KeyGenerator keyGenerator2 = keyGenerator = this.checkFipsMode(fipsMode) ? KeyGenerator.getInstance(algorithm, this._fipsProvider) : KeyGenerator.getInstance(algorithm);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " key generator is " + keyGenerator.getProvider().getName());
        }
        return keyGenerator;
    }

    public KeyPairGenerator getKeyPairGenerator(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator = this.checkFipsMode(fipsMode) ? KeyPairGenerator.getInstance(algorithm, this._fipsProvider) : KeyPairGenerator.getInstance(algorithm);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " key pair generator is " + keyPairGenerator.getProvider().getName());
        }
        return keyPairGenerator;
    }

    public MessageDigest getMessageDigest(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        MessageDigest messageDigest2 = messageDigest = this.checkFipsMode(fipsMode) ? MessageDigest.getInstance(algorithm, this._fipsProvider) : MessageDigest.getInstance(algorithm);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " message digest is " + messageDigest.getProvider().getName());
        }
        return messageDigest;
    }

    public SecretKeyFactory getSecretKeyFactory(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        SecretKeyFactory secretKeyFactory = null;
        try {
            secretKeyFactory = this.checkFipsMode(fipsMode) ? SecretKeyFactory.getInstance(algorithm, this._fipsProvider) : SecretKeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            List<String> sasProviderSkfAlgorithmLst = Arrays.asList(_sasProviderSkfAlgorithmArr);
            if (sasProviderSkfAlgorithmLst.contains(algorithm)) {
                secretKeyFactory = new SasSecretKeyFactory(_sasProviderSkfSpi, _sasProvider, algorithm);
            }
            throw nsae;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " secret key factory is " + secretKeyFactory.getProvider().getName());
        }
        return secretKeyFactory;
    }

    public SecureRandom getSecureRandom(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = this.checkFipsMode(fipsMode) ? SecureRandom.getInstance(algorithm, this._fipsProvider) : SecureRandom.getInstance(algorithm);
        if (_logger.isDebugEnabled()) {
            _logger.debug("provider for " + algorithm + " secure random is " + secureRandom.getProvider().getName());
        }
        return secureRandom;
    }

    public Class<?> getKeySpecClass(String algorithm, boolean fipsMode) throws NoSuchAlgorithmException {
        Class keySpecClass = null;
        if (ALGORITHM_AES.equals(algorithm)) {
            if (fipsMode && this._fipsProvider != null && _ibmProviderName.equals(this._fipsProvider.getName())) {
                try {
                    keySpecClass = Class.forName(_ibmAesKeySpecClass);
                }
                catch (ClassNotFoundException e) {
                    _logger.warn("unable to load AESKeySpec class for IBM AES Keys");
                }
            }
            if (keySpecClass == null) {
                keySpecClass = SecretKeySpec.class;
            }
        } else if (ALGORITHM_DES.equals(algorithm)) {
            keySpecClass = DESKeySpec.class;
        } else if (ALGORITHM_DES_EDE.equals(algorithm)) {
            keySpecClass = DESedeKeySpec.class;
        } else if (ALGORITHM_ARCFOUR.equals(algorithm) || ALGORITHM_RC2.equals(algorithm) || ALGORITHM_RC4.equals(algorithm)) {
            keySpecClass = SecretKeySpec.class;
        } else {
            throw new NoSuchAlgorithmException(algorithm);
        }
        return keySpecClass;
    }

    protected static IllegalArgumentException unknownKeyType(int keyType) {
        return new IllegalArgumentException("Unknown key type " + keyType);
    }

    protected boolean supportsFips() {
        return this._fipsProvider != null;
    }

    private void setFipsProvider(Provider fipsProvider) {
        this._fipsProvider = fipsProvider;
    }

    private boolean checkFipsMode(boolean fipsMode) {
        if (fipsMode && this._fipsProvider == null) {
            throw new IllegalStateException("FIPS140 operations are not available");
        }
        return fipsMode;
    }

    private static String getSasProviderInfo() {
        StringBuffer argBuf = new StringBuffer();
        for (String alg : _sasProviderSkfAlgorithmArr) {
            if (argBuf.length() > 0) {
                argBuf.append(",");
            }
            argBuf.append(alg);
        }
        return _sasProviderInfoTemplate.replace("?", argBuf);
    }

    private static Map<String, FipsValidator> getFipsValidatorMap() {
        String[] fipsValidatorClassArr;
        HashMap<String, FipsValidator> map = new HashMap<String, FipsValidator>();
        String fipsValidatorClassesKey = "com.sas.net.crypto.jce.fipsValidatorClasses";
        String fipsValidatorClassesValue = System.getProperty("com.sas.net.crypto.jce.fipsValidatorClasses");
        if (_logger.isDebugEnabled()) {
            _logger.debug("com.sas.net.crypto.jce.fipsValidatorClasses is " + fipsValidatorClassesValue);
            if (fipsValidatorClassesValue == null) {
                _logger.debug("default is " + _jsafeValidatorClass);
            }
        }
        String fipsValidatorClasses = fipsValidatorClassesValue == null ? _jsafeValidatorClass : fipsValidatorClassesValue;
        for (String fipsValidatorClass : fipsValidatorClassArr = fipsValidatorClasses.split(",")) {
            String className;
            String string = className = fipsValidatorClass != null ? fipsValidatorClass.trim() : null;
            if (className == null || className.length() == 0) continue;
            try {
                Class<?> c = Class.forName(className);
                FipsValidator fipsValidator = (FipsValidator)c.newInstance();
                String providerName = fipsValidator.getProviderName();
                map.put(providerName, fipsValidator);
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("added FIPS validator " + className + " for provider " + providerName);
            }
            catch (Exception e) {
                _logger.warn("fips validator is not in classpath or cannot be instantiated: " + e);
            }
        }
        return map;
    }

    private static final class SasSecretKeyFactory
    extends SecretKeyFactory {
        private SasSecretKeyFactory(SecretKeyFactorySpi spi, Provider provider, String algorithm) {
            super(spi, provider, algorithm);
        }
    }

    private static final class SasSecretKeyFactorySpi
    extends SecretKeyFactorySpi {
        private SasSecretKeyFactorySpi() {
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof SecretKey) {
                return (SecretKey)((Object)keySpec);
            }
            _logger.error("invalid key spec class " + keySpec.getClass().getName());
            throw new InvalidKeySpecException();
        }

        protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
            if (keySpecClass.isInstance(key)) {
                return (KeySpec)((Object)key);
            }
            if (SecretKeySpec.class.equals((Object)keySpecClass)) {
                String algorithm = key.getAlgorithm();
                byte[] keyData = key.getEncoded();
                SecretKeySpec keySpec = new SecretKeySpec(keyData, algorithm);
                return keySpec;
            }
            _logger.error("invalid key spec class " + keySpecClass.getName());
            throw new InvalidKeySpecException();
        }

        @Override
        protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
            if (key instanceof SecretKeySpec) {
                return key;
            }
            try {
                KeySpec keySpec = this.engineGetKeySpec(key, (Class)SecretKeySpec.class);
                return this.engineGenerateSecret(keySpec);
            }
            catch (InvalidKeySpecException ikse) {
                _logger.error("could not translate key", ikse);
                throw new InvalidKeyException(ikse);
            }
        }
    }

    private static final class SasProvider
    extends Provider {
        private static final long serialVersionUID = -2511667663449688616L;

        private SasProvider() {
            super(JceServices._sasProviderName, 1.0, _sasProviderInfo);
            String service = "SecretKeyFactory.AES";
            String spi = SasSecretKeyFactorySpi.class.getName();
            this.put("SecretKeyFactory.AES", spi);
        }
    }
}

