/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.codepolicy.SASScope;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

@SASScope
public class StackChecker
extends Writer {
    protected Vector m_stack;

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.m_stack == null) {
            this.m_stack = new Vector();
        }
        this.m_stack.addElement(new String(cbuf));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean isOnStack(Object o, String methodName) {
        return this.isOnStack(o.getClass(), methodName);
    }

    public boolean isOnStack(Class c, String methodName) {
        return this.isOnStack(c, methodName, 2);
    }

    public boolean isOnStack(Class c, String methodName, int atLeastNTimes) {
        boolean rc = false;
        if (c == null) {
            return false;
        }
        if (this.m_stack != null) {
            this.m_stack.removeAllElements();
            this.m_stack = null;
        }
        Throwable t = new Throwable();
        PrintWriter pw = new PrintWriter(this);
        t.printStackTrace(pw);
        String fullName = c.getName() + "." + methodName;
        int n = this.find(fullName);
        if (n >= atLeastNTimes) {
            rc = true;
        }
        return rc;
    }

    protected int find(String name) {
        int n = 0;
        if (this.m_stack != null) {
            for (int i = 0; i < this.m_stack.size(); ++i) {
                String s = (String)this.m_stack.elementAt(i);
                if (s == null || s.indexOf(name) < 0) continue;
                ++n;
            }
        }
        return n;
    }
}

