/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.util.Vector;

@SASScope(value="ALL")
@SubjectToChange
class StandardCharacter
extends SASCharacterFormat {
    private StringBuffer buffer = new StringBuffer(32);
    private static Object[] standardCharFormats;

    protected StandardCharacter() {
    }

    @Override
    public StringBuffer format(String value) {
        this.buffer.setLength(0);
        int width = this.info.getWidth();
        int length = value.length();
        String base = this.info.getBaseFormat();
        switch (base.length() > 1 ? (int)base.charAt(1) : 36) {
            case 72: {
                this.characterToHex(value, width, this.buffer);
                break;
            }
            case 66: {
                this.characterToBinary(value, width, this.buffer);
                break;
            }
            case 79: {
                this.characterToOctal(value, width, this.buffer);
                break;
            }
            default: {
                if (width - length < 0) {
                    this.buffer.append(value.substring(0, width));
                    break;
                }
                this.insertTrailingWhitespaces(this.buffer.append(value), width - length);
            }
        }
        return this.buffer;
    }

    @Override
    public StringBuffer informat(String value) {
        this.buffer.setLength(0);
        int width = this.info.getWidth();
        int length = value.length();
        String base = this.info.getBaseFormat();
        switch (base.length() > 1 ? (int)base.charAt(1) : 36) {
            case 72: {
                this.hexToCharacter(value, width, this.buffer);
                break;
            }
            case 66: {
                this.binaryToCharacter(value, width, this.buffer);
                break;
            }
            case 79: {
                this.octalToCharacter(value, width, this.buffer);
                break;
            }
            default: {
                if (width - length < 0) {
                    this.buffer.append(value.substring(0, width));
                    break;
                }
                this.insertTrailingWhitespaces(this.buffer.append(value), width - length);
            }
        }
        return this.buffer;
    }

    protected void characterToHex(String value, int width, StringBuffer result) {
        for (int i = 0; i < value.length(); ++i) {
            String binaryValue = Integer.toHexString(value.charAt(i)).toUpperCase();
            for (int j = binaryValue.length(); j < 2; ++j) {
                result.append('0');
            }
            result.append(binaryValue);
        }
        if (width - result.length() < 0) {
            result.setLength(width);
        } else {
            this.insertTrailingWhitespaces(result, width - result.length());
        }
    }

    protected void hexToCharacter(String value, int width, StringBuffer result) {
        int valueLength = value.length();
        int v = 0;
        boolean append = false;
        width = width < 2 ? width : width - width % 2;
        for (int i = 0; i < width && i < valueLength; ++i) {
            append = true;
            if ((i + 1) % 2 != 0) {
                v += Character.digit(value.charAt(i), 16) * 16;
                continue;
            }
            result.append((char)(v += Character.digit(value.charAt(i), 16)));
            v = 0;
            append = false;
        }
        if (append) {
            result.append((char)v);
        }
        if (result.length() < width / 2) {
            this.insertTrailingWhitespaces(result, width / 2 - result.length());
        }
    }

    protected void characterToBinary(String value, int width, StringBuffer result) {
        for (int i = 0; i < value.length(); ++i) {
            String binaryValue = Integer.toBinaryString(value.charAt(i));
            for (int j = binaryValue.length(); j < 8; ++j) {
                result.append('0');
            }
            result.append(binaryValue);
        }
        if (width - result.length() < 0) {
            result.setLength(width);
        } else {
            this.insertTrailingWhitespaces(result, width - result.length());
        }
    }

    protected void binaryToCharacter(String value, int width, StringBuffer result) {
        int valueLength = value.length();
        int v = 0;
        int power = 0;
        boolean append = false;
        width = width < 8 ? width : width - width % 8;
        for (int i = 0; i < width && i < valueLength; ++i) {
            append = true;
            power = (i + 1) % 8;
            if (power != 0) {
                v = (int)((double)v + (double)Character.digit(value.charAt(i), 2) * Math.pow(2.0, 8 - power));
                continue;
            }
            result.append((char)(v += Character.digit(value.charAt(i), 2)));
            v = 0;
            append = false;
        }
        if (append) {
            result.append((char)v);
        }
        if (result.length() < width / 8) {
            this.insertTrailingWhitespaces(result, width / 8 - result.length());
        }
    }

    protected void characterToOctal(String value, int width, StringBuffer result) {
        for (int i = 0; i < value.length(); ++i) {
            String binaryValue = Integer.toOctalString(value.charAt(i));
            for (int j = binaryValue.length(); j < 3; ++j) {
                result.append('0');
            }
            result.append(binaryValue);
        }
        if (width - result.length() < 0) {
            result.setLength(width);
        } else {
            this.insertTrailingWhitespaces(result, width - result.length());
        }
    }

    protected void octalToCharacter(String value, int width, StringBuffer result) {
        int valueLength = value.length();
        int v = 0;
        int power = 0;
        boolean append = false;
        width = width < 3 ? width : width - width % 3;
        for (int i = 0; i < width && i < valueLength; ++i) {
            append = true;
            power = (i + 1) % 3;
            if (power != 0) {
                v = (int)((double)v + (double)Character.digit(value.charAt(i), 8) * Math.pow(8.0, 3 - power));
                continue;
            }
            result.append((char)(v += Character.digit(value.charAt(i), 8)));
            v = 0;
            append = false;
        }
        if (append) {
            result.append((char)v);
        }
        if (result.length() < width / 3) {
            this.insertTrailingWhitespaces(result, width / 3 - result.length());
        }
    }

    static Object[] getDefinedFormats() {
        if (standardCharFormats == null) {
            Vector<SingleEntry> temp = new Vector<SingleEntry>(20, 5);
            String className = StandardCharacter.class.getName();
            SingleEntry entry = new SingleEntry("$ASCIIw", className);
            ((SASFormatEntry)entry).addPattern(1, Short.MAX_VALUE, null, true);
            temp.addElement(entry);
            entry = new SingleEntry("$BINARYw", className);
            ((SASFormatEntry)entry).addPattern(8, Short.MAX_VALUE, null, true);
            ((SASFormatEntry)entry).addPattern(1, 7, null);
            temp.addElement(entry);
            entry = new SingleEntry("$CHARw", className);
            ((SASFormatEntry)entry).addPattern(1, Short.MAX_VALUE, null, true);
            temp.addElement(entry);
            entry = new SingleEntry("$HEXw", className);
            ((SASFormatEntry)entry).addPattern(4, Short.MAX_VALUE, null, true);
            ((SASFormatEntry)entry).addPattern(1, 3, null);
            temp.addElement(entry);
            entry = new SingleEntry("$OCTALw", className);
            ((SASFormatEntry)entry).addPattern(8, Short.MAX_VALUE, null, true);
            ((SASFormatEntry)entry).addPattern(1, 7, null);
            temp.addElement(entry);
            entry = new SingleEntry("$w", className);
            ((SASFormatEntry)entry).addPattern(1, Short.MAX_VALUE, null, true);
            temp.addElement(entry);
            entry = new SingleEntry("$Fw", className);
            ((SASFormatEntry)entry).addPattern(1, Short.MAX_VALUE, null, true);
            temp.addElement(entry);
            standardCharFormats = new Object[temp.size()];
            temp.copyInto(standardCharFormats);
        }
        return standardCharFormats;
    }
}

