/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

@SASScope
public final class ListFactory {
    private static final String PROP_STRATEGY_KEY = "com.sas.util.ListFactory.strategy";
    private static final String PROP_COW_LIST = "COWList";
    private static final String PROP_ARRAY_LIST = "ArrayList";
    private static final String PROP_SYNC_LIST = "SynchronizedList";
    private static final int ALLOC_COW_LIST = 0;
    private static final int ALLOC_LIST = 1;
    private static final int ALLOC_SYNC_LIST = 2;
    private static final int ALLOC_STRATEGY;

    private ListFactory() {
    }

    public static List newList(Collection source) {
        switch (ALLOC_STRATEGY) {
            case 1: {
                return new ArrayList(source);
            }
            case 2: {
                return Collections.synchronizedList(new ArrayList(source));
            }
        }
        return new COWList(source);
    }

    public static List newList() {
        switch (ALLOC_STRATEGY) {
            case 1: {
                return new ArrayList();
            }
            case 2: {
                return Collections.synchronizedList(new ArrayList());
            }
        }
        return new COWList();
    }

    public static List newList(int initSize) {
        switch (ALLOC_STRATEGY) {
            case 1: {
                return new ArrayList(initSize);
            }
            case 2: {
                return Collections.synchronizedList(new ArrayList(initSize));
            }
        }
        return new COWList(initSize);
    }

    static {
        int strategy = 0;
        try {
            String strategyRequested = System.getProperty(PROP_STRATEGY_KEY);
            if (strategyRequested != null && strategyRequested.length() > 0) {
                System.out.println("*** ListFactory - Strategy OVERRIDE requested (" + strategyRequested + ") ***");
                if (strategyRequested.equalsIgnoreCase(PROP_COW_LIST)) {
                    strategy = 0;
                } else if (strategyRequested.equalsIgnoreCase(PROP_ARRAY_LIST)) {
                    strategy = 1;
                } else if (strategyRequested.equalsIgnoreCase(PROP_SYNC_LIST)) {
                    strategy = 2;
                } else {
                    System.out.println("*** ListFactory ignoring unrecognized option (" + strategyRequested + ") ***");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ALLOC_STRATEGY = strategy;
    }

    @SASScope
    private static class COWList
    extends AbstractList
    implements List,
    RandomAccess,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 8683452581122892189L;
        private static final int INITIAL_ARRAY_SIZE = 10;
        private transient Shared _shared;

        public COWList(COWList cowListToShare) {
            this.share(cowListToShare);
        }

        public COWList(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this._shared = new Shared(initialCapacity);
        }

        public COWList() {
            this(10);
        }

        public COWList(Collection c) {
            if (c instanceof COWList) {
                this.share((COWList)c);
            } else {
                this._shared = new Shared(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void share(COWList cowListToShare) {
            if (this._shared != null) {
                --this._shared._useCount;
                this._shared = null;
            }
            Shared shared = cowListToShare._shared;
            synchronized (shared) {
                this._shared = cowListToShare._shared;
                ++this._shared._useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unshare() {
            Shared shared = this._shared;
            synchronized (shared) {
                if (this._shared.isShared()) {
                    this._shared = new Shared(this._shared, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            if (this._shared != null) {
                Shared shared = this._shared;
                synchronized (shared) {
                    --this._shared._useCount;
                    this._shared = null;
                }
            }
            ++this.modCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.destroy();
            }
            finally {
                super.finalize();
            }
        }

        public synchronized void trimToSize() {
            this.unshare();
            ++this.modCount;
            int oldCapacity = this._shared._elementData.length;
            if (this._shared._size < oldCapacity) {
                Object[] oldData = this._shared._elementData;
                this._shared._elementData = new Object[this._shared._size];
                System.arraycopy(oldData, 0, this._shared._elementData, 0, this._shared._size);
            }
        }

        public synchronized void ensureCapacity(int minCapacity) {
            this.unshare();
            ++this.modCount;
            int oldCapacity = this._shared._elementData.length;
            if (minCapacity > oldCapacity) {
                Object[] oldData = this._shared._elementData;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this._shared._elementData = new Object[newCapacity];
                System.arraycopy(oldData, 0, this._shared._elementData, 0, this._shared._size);
            }
        }

        @Override
        public synchronized int size() {
            return this._shared._size;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this._shared._size == 0;
        }

        @Override
        public synchronized boolean contains(Object elem) {
            return this.indexOf(elem) >= 0;
        }

        @Override
        public synchronized int indexOf(Object elem) {
            if (elem == null) {
                for (int i = 0; i < this._shared._size; ++i) {
                    if (this._shared._elementData[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this._shared._size; ++i) {
                    if (!elem.equals(this._shared._elementData[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public synchronized int lastIndexOf(Object elem) {
            if (elem == null) {
                for (int i = this._shared._size - 1; i >= 0; --i) {
                    if (this._shared._elementData[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = this._shared._size - 1; i >= 0; --i) {
                    if (!elem.equals(this._shared._elementData[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        public synchronized Object clone() {
            return new COWList(this);
        }

        @Override
        public synchronized Object[] toArray() {
            Object[] result = new Object[this._shared._size];
            System.arraycopy(this._shared._elementData, 0, result, 0, this._shared._size);
            return result;
        }

        @Override
        public synchronized Object[] toArray(Object[] a) {
            if (a.length < this._shared._size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this._shared._size);
            }
            System.arraycopy(this._shared._elementData, 0, a, 0, this._shared._size);
            if (a.length > this._shared._size) {
                a[this._shared._size] = null;
            }
            return a;
        }

        public synchronized Object get(int index) {
            this.RangeCheck(index);
            return this._shared._elementData[index];
        }

        public synchronized Object set(int index, Object element) {
            this.RangeCheck(index);
            Object oldValue = this._shared._elementData[index];
            if (oldValue != element) {
                this.unshare();
                this._shared._elementData[index] = element;
            }
            return oldValue;
        }

        @Override
        public synchronized boolean add(Object o) {
            this.ensureCapacity(this._shared._size + 1);
            this._shared._elementData[this._shared._size++] = o;
            return true;
        }

        public synchronized void add(int index, Object element) {
            if (index > this._shared._size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._shared._size);
            }
            this.ensureCapacity(this._shared._size + 1);
            System.arraycopy(this._shared._elementData, index, this._shared._elementData, index + 1, this._shared._size - index);
            this._shared._elementData[index] = element;
            ++this._shared._size;
        }

        public synchronized Object remove(int index) {
            this.RangeCheck(index);
            this.unshare();
            ++this.modCount;
            Object oldValue = this._shared._elementData[index];
            int numMoved = this._shared._size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this._shared._elementData, index + 1, this._shared._elementData, index, numMoved);
            }
            this._shared._elementData[--this._shared._size] = null;
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void clear() {
            if (this._shared != null) {
                Shared shared = this._shared;
                synchronized (shared) {
                    --this._shared._useCount;
                }
            }
            this._shared = new Shared(0);
            ++this.modCount;
        }

        @Override
        public synchronized boolean addAll(Collection c) {
            this.unshare();
            ++this.modCount;
            int numNew = c.size();
            this.ensureCapacity(this._shared._size + numNew);
            Iterator e = c.iterator();
            for (int i = 0; i < numNew; ++i) {
                this._shared._elementData[this._shared._size++] = e.next();
            }
            return numNew != 0;
        }

        public synchronized boolean addAll(int index, Collection c) {
            if (index > this._shared._size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._shared._size);
            }
            int numNew = c.size();
            this.ensureCapacity(this._shared._size + numNew);
            int numMoved = this._shared._size - index;
            if (numMoved > 0) {
                System.arraycopy(this._shared._elementData, index, this._shared._elementData, index + numNew, numMoved);
            }
            Iterator e = c.iterator();
            for (int i = 0; i < numNew; ++i) {
                this._shared._elementData[index++] = e.next();
            }
            this._shared._size += numNew;
            return numNew != 0;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.unshare();
            ++this.modCount;
            int numMoved = this._shared._size - toIndex;
            System.arraycopy(this._shared._elementData, toIndex, this._shared._elementData, fromIndex, numMoved);
            int newSize = this._shared._size - (toIndex - fromIndex);
            while (this._shared._size != newSize) {
                this._shared._elementData[--this._shared._size] = null;
            }
        }

        private void RangeCheck(int index) {
            if (index >= this._shared._size || index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._shared._size);
            }
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this._shared._size);
            for (int i = 0; i < this._shared._size; ++i) {
                s.writeObject(this._shared._elementData[i]);
            }
        }

        private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int size = s.readInt();
            Object[] elementData = new Object[size];
            for (int i = 0; i < size; ++i) {
                elementData[i] = s.readObject();
            }
            this._shared = new Shared(elementData);
        }

        @SASScope
        private static class Shared {
            Object[] _elementData;
            int _size;
            int _useCount;

            Shared(int initialCapacity) {
                this._elementData = new Object[initialCapacity];
                this._useCount = 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Shared(Shared orig, boolean decrementOrigUseCount) {
                Shared shared = orig;
                synchronized (shared) {
                    this._size = orig._size;
                    this._useCount = 1;
                    this._elementData = new Object[this._size];
                    System.arraycopy(orig._elementData, 0, this._elementData, 0, this._size);
                    if (decrementOrigUseCount) {
                        --orig._useCount;
                    }
                }
            }

            Shared(Collection c) {
                this._size = c.size();
                this._elementData = new Object[(int)Math.min((long)this._size * 110L / 100L, Integer.MAX_VALUE)];
                c.toArray(this._elementData);
                this._useCount = 1;
            }

            private Shared(Object[] elementData) {
                this._elementData = elementData;
                this._size = elementData.length;
                this._useCount = 1;
            }

            synchronized boolean isShared() {
                return this._useCount > 1;
            }
        }
    }
}

