/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.log;

import com.sas.util.log.AbstractLoggerAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JavaLoggerAdapter
extends AbstractLoggerAdapter {
    private Logger _logger;

    JavaLoggerAdapter(Logger javaLogger) {
        this._logger = javaLogger;
    }

    @Override
    protected void log(int level, String message, Throwable t) {
        Level l = this.getLevel(level);
        this._logger.log(l, message, t);
    }

    @Override
    protected boolean isEnabledFor(int level) {
        Level l = this.getLevel(level);
        return this._logger.isLoggable(l);
    }

    private Level getLevel(int level) {
        switch (level) {
            case 100: {
                return Level.FINE;
            }
            case 200: {
                return Level.INFO;
            }
            case 300: {
                return Level.WARNING;
            }
            case 400: 
            case 500: {
                return Level.SEVERE;
            }
        }
        throw new IllegalArgumentException("unknown level " + level);
    }
}

