/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.NumberUtil;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.util.Locale;

public class StringToDoubleTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = -7757250351074975763L;
    public static final StringToDoubleTransform defaultInstance = new StringToDoubleTransform();
    private Locale locale;

    public StringToDoubleTransform() {
        this(null);
    }

    public StringToDoubleTransform(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Object transform(Object input) {
        if (input == null) {
            return new Double(0.0);
        }
        String trimmedInput = ((String)input).trim();
        if (trimmedInput.length() == 0) {
            return new Double(0.0);
        }
        if (this.locale == null) {
            return new Double(NumberUtil.doubleValueOf(trimmedInput));
        }
        return new Double(NumberUtil.doubleValueOf(trimmedInput, this.locale));
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return Double.class;
    }
}

