import { PackageJson } from 'type-fest';
/**
 * CLI executable name
 */
export declare const NAME_BIN = "appium-docs";
/**
 * Expected name of the `mkdocs.yml` config file
 */
export declare const NAME_MKDOCS_YML = "mkdocs.yml";
/**
 * Default name of the `tsconfig.json` config file
 */
export declare const NAME_TSCONFIG_JSON = "tsconfig.json";
/**
 * `python` executable
 */
export declare const NAME_PYTHON = "python";
/**
 * It's `package.json`!
 */
export declare const NAME_PACKAGE_JSON = "package.json";
/**
 * Name of the `requirements.txt` file for `pip`
 */
export declare const NAME_REQUIREMENTS_TXT = "requirements.txt";
/**
 * Name of the `$schema` property which can be present in JSON files; it may need to be removed to
 * avoid warnings/errors by 3p libs
 */
export declare const NAME_SCHEMA = "$schema";
/**
 * Name of the `mkdocs` executable
 */
export declare const NAME_MKDOCS = "mkdocs";
/**
 * Name of the `mike` executable
 */
export declare const NAME_MIKE = "mike";
/**
 * Name of the `pip` module.
 *
 * @remarks We don't execute the `pip` executable; but rather use `python -m pip` since that seems
 * to work better ... on my computer.
 */
export declare const NAME_PIP = "pip";
/**
 * Name of the `npm` executable, which we use to check for
 */
export declare const NAME_NPM = "npm";
/**
 * The name of the `typescript` package (not the `tsc` executable)
 */
export declare const NAME_TYPESCRIPT = "typescript";
/**
 * Code for a "file not found" error
 */
export declare const NAME_ERR_ENOENT = "ENOENT";
/**
 * Code for a "file already exists" error
 */
export declare const NAME_ERR_EEXIST = "EEXIST";
/**
 * Name of the default theme
 */
export declare const NAME_THEME = "material";
/**
 * Default log level
 */
export declare const DEFAULT_LOG_LEVEL = "info";
/**
 * Blocking I/O
 */
export declare const PKG_ROOT_DIR: string;
/**
 * Blocking I/O
 */
export declare const DOCUTILS_PKG: PackageJson;
/**
 * Path to the `requirements.txt` file (in this package)
 */
export declare const REQUIREMENTS_TXT_PATH: string;
/**
 * The default alias creation strategy to pass to `mike` when deploying
 * (`symlink`, `redirect` or `copy`)
 */
export declare const DEFAULT_DEPLOY_ALIAS_TYPE = "symlink";
/**
 * The default branch to deploy to
 */
export declare const DEFAULT_DEPLOY_BRANCH = "gh-pages";
/**
 * The default remote to push the deployed branch to
 */
export declare const DEFAULT_DEPLOY_REMOTE = "origin";
/**
 * The default port for serving docs
 */
export declare const DEFAULT_SERVE_PORT = 8000;
/**
 * The default host for serving docs
 */
export declare const DEFAULT_SERVE_HOST = "localhost";
/**
 * Mapping of `@appium/docutils`' log levels to `consola` log levels
 */
export declare const LogLevelMap: {
    readonly silent: any;
    readonly error: any;
    readonly warn: any;
    readonly info: any;
    readonly debug: any;
};
/**
 * If the user does not specify a site directory _and_ the `mkdocs.yml` doesn't either, use this dir.
 */
export declare const DEFAULT_SITE_DIR = "site";
//# sourceMappingURL=constants.d.ts.map