"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FixSkippedError = exports.nokOptional = exports.okOptional = exports.nok = exports.ok = void 0;
/**
 * A shortcut for a successful required doctor check
 *
 * @param {string} message
 * @returns {DoctorCheckResult}
 */
function ok(message) {
    return { ok: true, optional: false, message };
}
exports.ok = ok;
/**
 * A shortcut for an unsuccessful required doctor check
 *
 * @param {string} message
 * @returns {DoctorCheckResult}
 */
function nok(message) {
    return { ok: false, optional: false, message };
}
exports.nok = nok;
/**
 * A shortcut for a successful optional doctor check
 *
 * @param {string} message
 * @returns {DoctorCheckResult}
 */
function okOptional(message) {
    return { ok: true, optional: true, message };
}
exports.okOptional = okOptional;
/**
 * A shortcut for an unsuccessful optional doctor check
 *
 * @param {string} message
 * @returns {DoctorCheckResult}
 */
function nokOptional(message) {
    return { ok: false, optional: true, message };
}
exports.nokOptional = nokOptional;
/**
 * Throw this exception in the fix() method
 * of your doctor check to skip the actual fix if hasAutofix() is true
 */
class FixSkippedError extends Error {
}
exports.FixSkippedError = FixSkippedError;
/**
 * @typedef {import('@appium/types').DoctorCheckResult} DoctorCheckResult
 */
//# sourceMappingURL=doctor.js.map