/// <reference types="node" />
export default SubProcess;
export type StartDetector = (stdout: string, stderr?: string | undefined) => any;
export class SubProcess extends events {
    /**
     * @param {string} cmd
     * @param {string[]} [args]
     * @param {any} [opts]
     */
    constructor(cmd: string, args?: string[] | undefined, opts?: any);
    /**
     * @type { {stdout: string, stderr: string} }
     */
    lastLinePortion: {
        stdout: string;
        stderr: string;
    };
    /** @type {import('child_process').ChildProcess?} */
    proc: import('child_process').ChildProcess | null;
    /** @type {string[]} */
    args: string[];
    /**
     * @type {string}
     */
    cmd: string;
    /**
     * @type {any}
    */
    opts: any;
    /**
     * @type {boolean}
     */
    expectingExit: boolean;
    /**
     * @type {string}
     */
    rep: string;
    get isRunning(): boolean;
    /**
     *
     * @param {string} stream
     * @param {Iterable<string>} lines
     */
    emitLines(stream: string, lines: Iterable<string>): void;
    /**
     *
     * @param {StartDetector|number?} startDetector
     * @param {number?} timeoutMs
     * @param {boolean} detach
     * @returns {Promise<void>}
     */
    start(startDetector?: StartDetector | (number | null), timeoutMs?: number | null, detach?: boolean): Promise<void>;
    handleLastLines(): void;
    /**
     *
     * @param {NodeJS.Signals} signal
     * @param {number} timeout
     * @returns {Promise<void>}
     */
    stop(signal?: NodeJS.Signals, timeout?: number): Promise<void>;
    join(allowedExitCodes?: number[]): Promise<any>;
    detachProcess(): void;
    get pid(): number | null | undefined;
}
import events from 'events';
//# sourceMappingURL=subprocess.d.ts.map