from typing import Any, ClassVar

Maximization: OptimizationType
Minimization: OptimizationType

class AbstractIntegerConstraint:
    enforced: Any
    weight: float
    
    def __call__(self, *args, **kwargs) -> Any: ...
    def is_feasible(self, *args, **kwargs) -> Any: ...
    def compute_violation(self, *args, **kwargs) -> Any: ...
    def penalize(self, *args, **kwargs) -> Any: ...
    def violation(self, *args, **kwargs) -> Any: ...
    def penalty(self, *args, **kwargs) -> Any: ...

class AbstractRealConstraint:
    enforced: Any
    weight: float
    
    def __call__(self, *args, **kwargs) -> Any: ...
    def is_feasible(self, *args, **kwargs) -> Any: ...
    def compute_violation(self, *args, **kwargs) -> Any: ...
    def penalize(self, *args, **kwargs) -> Any: ...
    def violation(self, *args, **kwargs) -> Any: ...
    def penalty(self, *args, **kwargs) -> Any: ...

class IntegerConstraint(AbstractIntegerConstraint):
    def __init__(self, *args, **kwargs) -> None: ...

class RealConstraint(AbstractRealConstraint):
    def __init__(self, *args, **kwargs) -> None: ...

class IntegerBounds:
    def __init__(self, *args, **kwargs) -> None: ...
    def compute_violation(self, *args, **kwargs) -> Any: ...
    @property
    def lb(self) -> Any: ...
    @property
    def ub(self) -> Any: ...

class IntegerSolution:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...

class IntegerState:
    def __init__(self, initial: IntegerSolution) -> None: ...
    @property
    def current(self) -> IntegerSolution: ...
    @property
    def current_best(self) -> IntegerSolution: ...
    @property
    def current_best_internal(self) -> IntegerSolution: ...
    @property
    def current_internal(self) -> IntegerSolution: ...
    @property
    def evaluations(self) -> int: ...
    @property
    def optimum_found(self) -> bool: ...

class LogInfo:
    def __init__(self, evaluations: int, raw_y_best: float, transformed_y: float, transformed_y_best: float, current: RealSolution, optimum: RealSolution) -> None: ...
    @property
    def current(self) -> RealSolution: ...
    @property
    def evaluations(self) -> int: ...
    @property
    def objective(self) -> RealSolution: ...
    @property
    def transformed_y(self) -> float: ...
    @property
    def transformed_y_best(self) -> float: ...
    @property
    def y_best(self) -> float: ...

class MetaData:
    def __init__(self, problem_id: int, instance: int, name: str, n_variables: int, optimization_type: OptimizationType) -> None: ...
    @property
    def instance(self) -> int: ...
    @property
    def n_variables(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def optimization_type(self) -> Any: ...
    @property
    def problem_id(self) -> int: ...

class OptimizationType:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    Maximization: ClassVar[OptimizationType] = ...
    Minimization: ClassVar[OptimizationType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RealBounds:
    def __init__(self, *args, **kwargs) -> None: ...
    def compute_violation(self, *args, **kwargs) -> Any: ...
    @property
    def lb(self) -> Any: ...
    @property
    def ub(self) -> Any: ...

class RealSolution:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def x(self) -> Any: ...
    @property
    def y(self) -> Any: ...

class RealState:
    def __init__(self, initial: RealSolution) -> None: ...
    @property
    def current(self) -> RealSolution: ...
    @property
    def current_best(self) -> RealSolution: ...
    @property
    def current_best_internal(self) -> RealSolution: ...
    @property
    def current_internal(self) -> RealSolution: ...
    @property
    def evaluations(self) -> int: ...
    @property
    def optimum_found(self) -> bool: ...
