import * as acm from '@aws-cdk/aws-certificatemanager';
import { IBucket } from '@aws-cdk/aws-s3';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BasePathMapping, BasePathMappingOptions } from './base-path-mapping';
import { EndpointType, IRestApi } from './restapi';
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 *
 * @stability stable
 */
export declare enum SecurityPolicy {
    /**
     * Cipher suite TLS 1.0.
     *
     * @stability stable
     */
    TLS_1_0 = "TLS_1_0",
    /**
     * Cipher suite TLS 1.2.
     *
     * @stability stable
     */
    TLS_1_2 = "TLS_1_2"
}
/**
 * @stability stable
 */
export interface DomainNameOptions {
    /**
     * The custom domain name for your API.
     *
     * Uppercase letters are not supported.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
     *
     * For "EDGE" domain names, the certificate
     * needs to be in the US East (N. Virginia) region.
     *
     * @stability stable
     */
    readonly certificate: acm.ICertificate;
    /**
     * The type of endpoint for this DomainName.
     *
     * @default REGIONAL
     * @stability stable
     */
    readonly endpointType?: EndpointType;
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this domain name.
     *
     * @default SecurityPolicy.TLS_1_0
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html
     * @stability stable
     */
    readonly securityPolicy?: SecurityPolicy;
    /**
     * The mutual TLS authentication configuration for a custom domain name.
     *
     * @default - mTLS is not configured.
     * @stability stable
     */
    readonly mtls?: MTLSConfig;
}
/**
 * @stability stable
 */
export interface DomainNameProps extends DomainNameOptions {
    /**
     * If specified, all requests to this domain will be mapped to the production deployment of this API.
     *
     * If you wish to map this domain to multiple APIs
     * with different base paths, don't specify this option and use
     * `addBasePathMapping`.
     *
     * @default - you will have to call `addBasePathMapping` to map this domain to
     * API endpoints.
     * @stability stable
     */
    readonly mapping?: IRestApi;
}
/**
 * @stability stable
 */
export interface IDomainName extends IResource {
    /**
     * The domain name (e.g. `example.com`).
     *
     * @stability stable
     * @attribute DomainName
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     * @attribute DistributionDomainName,RegionalDomainName
     */
    readonly domainNameAliasDomainName: string;
    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     * @attribute DistributionHostedZoneId,RegionalHostedZoneId
     */
    readonly domainNameAliasHostedZoneId: string;
}
/**
 * @stability stable
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * Imports an existing domain name.
     *
     * @stability stable
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * The domain name (e.g. `example.com`).
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     */
    readonly domainNameAliasDomainName: string;
    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     */
    readonly domainNameAliasHostedZoneId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
    /**
     * Maps this domain to an API endpoint.
     *
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage.
     * @param options Options for mapping to base path with or without a stage.
     * @stability stable
     */
    addBasePathMapping(targetApi: IRestApi, options?: BasePathMappingOptions): BasePathMapping;
    private configureMTLS;
}
/**
 * @stability stable
 */
export interface DomainNameAttributes {
    /**
     * The domain name (e.g. `example.com`).
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     */
    readonly domainNameAliasTarget: string;
    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     *
     * @stability stable
     */
    readonly domainNameAliasHostedZoneId: string;
}
/**
 * The mTLS authentication configuration for a custom domain name.
 *
 * @stability stable
 */
export interface MTLSConfig {
    /**
     * The bucket that the trust store is hosted in.
     *
     * @stability stable
     */
    readonly bucket: IBucket;
    /**
     * The key in S3 to look at for the trust store.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The version of the S3 object that contains your truststore.
     *
     * To specify a version, you must have versioning enabled for the S3 bucket.
     *
     * @default - latest version
     * @stability stable
     */
    readonly version?: string;
}
