"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 *
 * @stability stable
 */
class LambdaRestApi extends restapi_1.RestApi {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
_a = JSII_RTTI_SYMBOL_1;
LambdaRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.LambdaRestApi", version: "1.110.0" };
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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