actions = {
    "account": ["DisableRegion", "EnableRegion", "ListRegions"],
    "amplify": [
        "CreateApp",
        "CreateBackendEnvironment",
        "CreateBranch",
        "CreateDeployment",
        "CreateDomainAssociation",
        "CreateWebHook",
        "DeleteApp",
        "DeleteBackendEnvironment",
        "DeleteBranch",
        "DeleteDomainAssociation",
        "DeleteJob",
        "DeleteWebHook",
        "GenerateAccessLogs",
        "GetApp",
        "GetArtifactUrl",
        "GetBackendEnvironment",
        "GetBranch",
        "GetDomainAssociation",
        "GetJob",
        "GetWebHook",
        "ListApps",
        "ListArtifacts",
        "ListBackendEnvironments",
        "ListBranches",
        "ListDomainAssociations",
        "ListJobs",
        "ListWebHooks",
        "StartDeployment",
        "StartJob",
        "StopJob",
        "TagResource",
        "UntagResource",
        "UpdateApp",
        "UpdateBranch",
        "UpdateDomainAssociation",
        "UpdateWebHook",
    ],
    "appmesh": [
        "CreateMesh",
        "CreateRoute",
        "CreateVirtualNode",
        "CreateVirtualRouter",
        "CreateVirtualService",
        "DeleteMesh",
        "DeleteRoute",
        "DeleteVirtualNode",
        "DeleteVirtualRouter",
        "DeleteVirtualService",
        "DescribeMesh",
        "DescribeRoute",
        "DescribeVirtualNode",
        "DescribeVirtualRouter",
        "DescribeVirtualService",
        "ListMeshes",
        "ListRoutes",
        "ListTagsForResource",
        "ListVirtualNodes",
        "ListVirtualRouters",
        "ListVirtualServices",
        "StreamAggregatedResources",
        "TagResource",
        "UntagResource",
        "UpdateMesh",
        "UpdateRoute",
        "UpdateVirtualNode",
        "UpdateVirtualRouter",
        "UpdateVirtualService",
    ],
    "appmesh-preview": [
        "CreateMesh",
        "CreateRoute",
        "CreateVirtualNode",
        "CreateVirtualRouter",
        "CreateVirtualService",
        "DeleteMesh",
        "DeleteRoute",
        "DeleteVirtualNode",
        "DeleteVirtualRouter",
        "DeleteVirtualService",
        "DescribeMesh",
        "DescribeRoute",
        "DescribeVirtualNode",
        "DescribeVirtualRouter",
        "DescribeVirtualService",
        "ListMeshes",
        "ListRoutes",
        "ListVirtualNodes",
        "ListVirtualRouters",
        "ListVirtualServices",
        "StreamAggregatedResources",
        "UpdateMesh",
        "UpdateRoute",
        "UpdateVirtualNode",
        "UpdateVirtualRouter",
        "UpdateVirtualService",
    ],
    "appconfig": [
        "CreateApplication",
        "CreateConfigurationProfile",
        "CreateDeploymentStrategy",
        "CreateEnvironment",
        "DeleteApplication",
        "DeleteConfigurationProfile",
        "DeleteDeploymentStrategy",
        "DeleteEnvironment",
        "GetApplication",
        "GetConfiguration",
        "GetConfigurationProfile",
        "GetDeployment",
        "GetDeploymentStrategy",
        "GetEnvironment",
        "ListApplications",
        "ListConfigurationProfiles",
        "ListDeploymentStrategies",
        "ListDeployments",
        "ListEnvironments",
        "ListTagsForResource",
        "StartDeployment",
        "StopDeployment",
        "TagResource",
        "UntagResource",
        "UpdateApplication",
        "UpdateConfigurationProfile",
        "UpdateDeploymentStrategy",
        "UpdateEnvironment",
        "ValidateConfiguration",
    ],
    "appsync": [
        "CreateApiKey",
        "CreateDataSource",
        "CreateFunction",
        "CreateGraphqlApi",
        "CreateResolver",
        "CreateType",
        "DeleteApiKey",
        "DeleteDataSource",
        "DeleteFunction",
        "DeleteGraphqlApi",
        "DeleteResolver",
        "DeleteType",
        "GetDataSource",
        "GetFunction",
        "GetGraphqlApi",
        "GetIntrospectionSchema",
        "GetResolver",
        "GetSchemaCreationStatus",
        "GetType",
        "GraphQL",
        "ListApiKeys",
        "ListDataSources",
        "ListFunctions",
        "ListGraphqlApis",
        "ListResolvers",
        "ListResolversByFunction",
        "ListTagsForResource",
        "ListTypes",
        "StartSchemaCreation",
        "TagResource",
        "UntagResource",
        "UpdateApiKey",
        "UpdateDataSource",
        "UpdateFunction",
        "UpdateGraphqlApi",
        "UpdateResolver",
        "UpdateType",
    ],
    "artifact": ["AcceptAgreement", "DownloadAgreement", "Get", "TerminateAgreement"],
    "autoscaling-plans": [
        "CreateScalingPlan",
        "DeleteScalingPlan",
        "DescribeScalingPlanResources",
        "DescribeScalingPlans",
        "GetScalingPlanResourceForecastData",
        "UpdateScalingPlan",
    ],
    "backup": [
        "CopyIntoBackupVault",
        "CreateBackupPlan",
        "CreateBackupSelection",
        "CreateBackupVault",
        "DeleteBackupPlan",
        "DeleteBackupSelection",
        "DeleteBackupVault",
        "DeleteBackupVaultAccessPolicy",
        "DeleteBackupVaultNotifications",
        "DeleteRecoveryPoint",
        "DescribeBackupJob",
        "DescribeBackupVault",
        "DescribeCopyJob",
        "DescribeProtectedResource",
        "DescribeRecoveryPoint",
        "DescribeRestoreJob",
        "ExportBackupPlanTemplate",
        "GetBackupPlan",
        "GetBackupPlanFromJSON",
        "GetBackupPlanFromTemplate",
        "GetBackupSelection",
        "GetBackupVaultAccessPolicy",
        "GetBackupVaultNotifications",
        "GetRecoveryPointRestoreMetadata",
        "GetSupportedResourceTypes",
        "ListBackupJobs",
        "ListBackupPlanTemplates",
        "ListBackupPlanVersions",
        "ListBackupPlans",
        "ListBackupSelections",
        "ListBackupVaults",
        "ListCopyJobs",
        "ListProtectedResources",
        "ListRecoveryPointsByBackupVault",
        "ListRecoveryPointsByResource",
        "ListRestoreJobs",
        "ListTags",
        "PutBackupVaultAccessPolicy",
        "PutBackupVaultNotifications",
        "StartBackupJob",
        "StartCopyJob",
        "StartRestoreJob",
        "StopBackupJob",
        "TagResource",
        "UntagResource",
        "UpdateBackupPlan",
        "UpdateRecoveryPointLifecycle",
    ],
    "backup-storage": ["MountCapsule"],
    "batch": [
        "CancelJob",
        "CreateComputeEnvironment",
        "CreateJobQueue",
        "DeleteComputeEnvironment",
        "DeleteJobQueue",
        "DeregisterJobDefinition",
        "DescribeComputeEnvironments",
        "DescribeJobDefinitions",
        "DescribeJobQueues",
        "DescribeJobs",
        "ListJobs",
        "RegisterJobDefinition",
        "SubmitJob",
        "TerminateJob",
        "UpdateComputeEnvironment",
        "UpdateJobQueue",
    ],
    "aws-portal": [
        "ModifyAccount",
        "ModifyBilling",
        "ModifyPaymentMethods",
        "ViewAccount",
        "ViewBilling",
        "ViewPaymentMethods",
        "ViewUsage",
    ],
    "budgets": ["ModifyBudget", "ViewBudget"],
    "acm": [
        "AddTagsToCertificate",
        "DeleteCertificate",
        "DescribeCertificate",
        "ExportCertificate",
        "GetCertificate",
        "ImportCertificate",
        "ListCertificates",
        "ListTagsForCertificate",
        "RemoveTagsFromCertificate",
        "RenewCertificate",
        "RequestCertificate",
        "ResendValidationEmail",
        "UpdateCertificateOptions",
    ],
    "acm-pca": [
        "CreateCertificateAuthority",
        "CreateCertificateAuthorityAuditReport",
        "CreatePermission",
        "DeleteCertificateAuthority",
        "DeletePermission",
        "DescribeCertificateAuthority",
        "DescribeCertificateAuthorityAuditReport",
        "GetCertificate",
        "GetCertificateAuthorityCertificate",
        "GetCertificateAuthorityCsr",
        "ImportCertificateAuthorityCertificate",
        "IssueCertificate",
        "ListCertificateAuthorities",
        "ListPermissions",
        "ListTags",
        "RestoreCertificateAuthority",
        "RevokeCertificate",
        "TagCertificateAuthority",
        "UntagCertificateAuthority",
        "UpdateCertificateAuthority",
    ],
    "chatbot": [
        "CreateChimeWebhookConfiguration",
        "CreateSlackChannelConfiguration",
        "DeleteChimeWebhookConfiguration",
        "DeleteSlackChannelConfiguration",
        "DescribeChimeWebhookConfigurations",
        "DescribeSlackChannelConfigurations",
        "DescribeSlackChannels",
        "DescribeSlackWorkspaces",
        "GetSlackOauthParameters",
        "RedeemSlackOauthCode",
        "UpdateChimeWebhookConfiguration",
        "UpdateSlackChannelConfiguration",
    ],
    "servicediscovery": [
        "CreateHttpNamespace",
        "CreatePrivateDnsNamespace",
        "CreatePublicDnsNamespace",
        "CreateService",
        "DeleteNamespace",
        "DeleteService",
        "DeregisterInstance",
        "DiscoverInstances",
        "GetInstance",
        "GetInstancesHealthStatus",
        "GetNamespace",
        "GetOperation",
        "GetService",
        "ListInstances",
        "ListNamespaces",
        "ListOperations",
        "ListServices",
        "RegisterInstance",
        "UpdateInstanceCustomHealthStatus",
        "UpdateService",
    ],
    "cloud9": [
        "CreateEnvironmentEC2",
        "CreateEnvironmentMembership",
        "DeleteEnvironment",
        "DeleteEnvironmentMembership",
        "DescribeEnvironmentMemberships",
        "DescribeEnvironmentStatus",
        "DescribeEnvironments",
        "GetUserSettings",
        "ListEnvironments",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateEnvironment",
        "UpdateEnvironmentMembership",
        "UpdateUserSettings",
    ],
    "cloudformation": [
        "CancelUpdateStack",
        "ContinueUpdateRollback",
        "CreateChangeSet",
        "CreateStack",
        "CreateStackInstances",
        "CreateStackSet",
        "CreateUploadBucket",
        "DeleteChangeSet",
        "DeleteStack",
        "DeleteStackInstances",
        "DeleteStackSet",
        "DescribeAccountLimits",
        "DescribeChangeSet",
        "DescribeStackDriftDetectionStatus",
        "DescribeStackEvents",
        "DescribeStackInstance",
        "DescribeStackResource",
        "DescribeStackResourceDrifts",
        "DescribeStackResources",
        "DescribeStackSet",
        "DescribeStackSetOperation",
        "DescribeStacks",
        "DetectStackDrift",
        "DetectStackResourceDrift",
        "DetectStackSetDrift",
        "EstimateTemplateCost",
        "ExecuteChangeSet",
        "GetStackPolicy",
        "GetTemplate",
        "GetTemplateSummary",
        "ListChangeSets",
        "ListExports",
        "ListImports",
        "ListStackInstances",
        "ListStackResources",
        "ListStackSetOperationResults",
        "ListStackSetOperations",
        "ListStackSets",
        "ListStacks",
        "SetStackPolicy",
        "SignalResource",
        "StopStackSetOperation",
        "TagResource",
        "UntagResource",
        "UpdateStack",
        "UpdateStackInstances",
        "UpdateStackSet",
        "UpdateTerminationProtection",
        "ValidateTemplate",
    ],
    "cloudhsm": [
        "AddTagsToResource",
        "CopyBackupToRegion",
        "CreateCluster",
        "CreateHapg",
        "CreateHsm",
        "CreateLunaClient",
        "DeleteBackup",
        "DeleteCluster",
        "DeleteHapg",
        "DeleteHsm",
        "DeleteLunaClient",
        "DescribeBackups",
        "DescribeClusters",
        "DescribeHapg",
        "DescribeHsm",
        "DescribeLunaClient",
        "GetConfig",
        "InitializeCluster",
        "ListAvailableZones",
        "ListHapgs",
        "ListHsms",
        "ListLunaClients",
        "ListTags",
        "ListTagsForResource",
        "ModifyHapg",
        "ModifyHsm",
        "ModifyLunaClient",
        "RemoveTagsFromResource",
        "RestoreBackup",
        "TagResource",
        "UntagResource",
    ],
    "cloudtrail": [
        "AddTags",
        "CreateTrail",
        "DeleteTrail",
        "DescribeTrails",
        "GetEventSelectors",
        "GetInsightSelectors",
        "GetTrail",
        "GetTrailStatus",
        "ListPublicKeys",
        "ListTags",
        "ListTrails",
        "LookupEvents",
        "PutEventSelectors",
        "PutInsightSelectors",
        "RemoveTags",
        "StartLogging",
        "StopLogging",
        "UpdateTrail",
    ],
    "signer": [
        "CancelSigningProfile",
        "DescribeSigningJob",
        "GetSigningPlatform",
        "GetSigningProfile",
        "ListSigningJobs",
        "ListSigningPlatforms",
        "ListSigningProfiles",
        "ListTagsForResource",
        "PutSigningProfile",
        "StartSigningJob",
        "TagResource",
        "UntagResource",
    ],
    "codebuild": [
        "BatchDeleteBuilds",
        "BatchGetBuilds",
        "BatchGetProjects",
        "BatchGetReportGroups",
        "BatchGetReports",
        "BatchPutTestCases",
        "CreateProject",
        "CreateReport",
        "CreateReportGroup",
        "CreateWebhook",
        "DeleteOAuthToken",
        "DeleteProject",
        "DeleteReport",
        "DeleteReportGroup",
        "DeleteResourcePolicy",
        "DeleteSourceCredentials",
        "DeleteWebhook",
        "DescribeTestCases",
        "GetResourcePolicy",
        "ImportSourceCredentials",
        "InvalidateProjectCache",
        "ListBuilds",
        "ListBuildsForProject",
        "ListConnectedOAuthAccounts",
        "ListCuratedEnvironmentImages",
        "ListProjects",
        "ListReportGroups",
        "ListReports",
        "ListReportsForReportGroup",
        "ListRepositories",
        "ListSharedProjects",
        "ListSharedReportGroups",
        "ListSourceCredentials",
        "PersistOAuthToken",
        "PutResourcePolicy",
        "StartBuild",
        "StopBuild",
        "UpdateProject",
        "UpdateReport",
        "UpdateReportGroup",
        "UpdateWebhook",
    ],
    "codecommit": [
        "AssociateApprovalRuleTemplateWithRepository",
        "BatchAssociateApprovalRuleTemplateWithRepositories",
        "BatchDescribeMergeConflicts",
        "BatchDisassociateApprovalRuleTemplateFromRepositories",
        "BatchGetCommits",
        "BatchGetPullRequests",
        "BatchGetRepositories",
        "CancelUploadArchive",
        "CreateApprovalRuleTemplate",
        "CreateBranch",
        "CreateCommit",
        "CreatePullRequest",
        "CreatePullRequestApprovalRule",
        "CreateRepository",
        "CreateUnreferencedMergeCommit",
        "DeleteApprovalRuleTemplate",
        "DeleteBranch",
        "DeleteCommentContent",
        "DeleteFile",
        "DeletePullRequestApprovalRule",
        "DeleteRepository",
        "DescribeMergeConflicts",
        "DescribePullRequestEvents",
        "DisassociateApprovalRuleTemplateFromRepository",
        "EvaluatePullRequestApprovalRules",
        "GetApprovalRuleTemplate",
        "GetBlob",
        "GetBranch",
        "GetComment",
        "GetCommentsForComparedCommit",
        "GetCommentsForPullRequest",
        "GetCommit",
        "GetCommitHistory",
        "GetCommitsFromMergeBase",
        "GetDifferences",
        "GetFile",
        "GetFolder",
        "GetMergeCommit",
        "GetMergeConflicts",
        "GetMergeOptions",
        "GetObjectIdentifier",
        "GetPullRequest",
        "GetPullRequestApprovalStates",
        "GetPullRequestOverrideState",
        "GetReferences",
        "GetRepository",
        "GetRepositoryTriggers",
        "GetTree",
        "GetUploadArchiveStatus",
        "GitPull",
        "GitPush",
        "ListApprovalRuleTemplates",
        "ListAssociatedApprovalRuleTemplatesForRepository",
        "ListBranches",
        "ListPullRequests",
        "ListRepositories",
        "ListRepositoriesForApprovalRuleTemplate",
        "ListTagsForResource",
        "MergeBranchesByFastForward",
        "MergeBranchesBySquash",
        "MergeBranchesByThreeWay",
        "MergePullRequestByFastForward",
        "MergePullRequestBySquash",
        "MergePullRequestByThreeWay",
        "OverridePullRequestApprovalRules",
        "PostCommentForComparedCommit",
        "PostCommentForPullRequest",
        "PostCommentReply",
        "PutFile",
        "PutRepositoryTriggers",
        "TagResource",
        "TestRepositoryTriggers",
        "UntagResource",
        "UpdateApprovalRuleTemplateContent",
        "UpdateApprovalRuleTemplateDescription",
        "UpdateApprovalRuleTemplateName",
        "UpdateComment",
        "UpdateDefaultBranch",
        "UpdatePullRequestApprovalRuleContent",
        "UpdatePullRequestApprovalState",
        "UpdatePullRequestDescription",
        "UpdatePullRequestStatus",
        "UpdatePullRequestTitle",
        "UpdateRepositoryDescription",
        "UpdateRepositoryName",
        "UploadArchive",
    ],
    "codedeploy": [
        "AddTagsToOnPremisesInstances",
        "BatchGetApplicationRevisions",
        "BatchGetApplications",
        "BatchGetDeploymentGroups",
        "BatchGetDeploymentInstances",
        "BatchGetDeploymentTargets",
        "BatchGetDeployments",
        "BatchGetOnPremisesInstances",
        "ContinueDeployment",
        "CreateApplication",
        "CreateDeployment",
        "CreateDeploymentConfig",
        "CreateDeploymentGroup",
        "DeleteApplication",
        "DeleteDeploymentConfig",
        "DeleteDeploymentGroup",
        "DeleteGitHubAccountToken",
        "DeregisterOnPremisesInstance",
        "GetApplication",
        "GetApplicationRevision",
        "GetDeployment",
        "GetDeploymentConfig",
        "GetDeploymentGroup",
        "GetDeploymentInstance",
        "GetDeploymentTarget",
        "GetOnPremisesInstance",
        "ListApplicationRevisions",
        "ListApplications",
        "ListDeploymentConfigs",
        "ListDeploymentGroups",
        "ListDeploymentInstances",
        "ListDeploymentTargets",
        "ListDeployments",
        "ListGitHubAccountTokenNames",
        "ListOnPremisesInstances",
        "ListTagsForResource",
        "PutLifecycleEventHookExecutionStatus",
        "RegisterApplicationRevision",
        "RegisterOnPremisesInstance",
        "RemoveTagsFromOnPremisesInstances",
        "SkipWaitTimeForInstanceTermination",
        "StopDeployment",
        "TagResource",
        "UntagResource",
        "UpdateApplication",
        "UpdateDeploymentGroup",
    ],
    "codepipeline": [
        "AcknowledgeJob",
        "AcknowledgeThirdPartyJob",
        "CreateCustomActionType",
        "CreatePipeline",
        "DeleteCustomActionType",
        "DeletePipeline",
        "DeleteWebhook",
        "DeregisterWebhookWithThirdParty",
        "DisableStageTransition",
        "EnableStageTransition",
        "GetJobDetails",
        "GetPipeline",
        "GetPipelineExecution",
        "GetPipelineState",
        "GetThirdPartyJobDetails",
        "ListActionExecutions",
        "ListActionTypes",
        "ListPipelineExecutions",
        "ListPipelines",
        "ListTagsForResource",
        "ListWebhooks",
        "PollForJobs",
        "PollForThirdPartyJobs",
        "PutActionRevision",
        "PutApprovalResult",
        "PutJobFailureResult",
        "PutJobSuccessResult",
        "PutThirdPartyJobFailureResult",
        "PutThirdPartyJobSuccessResult",
        "PutWebhook",
        "RegisterWebhookWithThirdParty",
        "RetryStageExecution",
        "StartPipelineExecution",
        "StopPipelineExecution",
        "TagResource",
        "UntagResource",
        "UpdatePipeline",
    ],
    "codestar": [
        "AssociateTeamMember",
        "CreateProject",
        "CreateUserProfile",
        "DeleteExtendedAccess",
        "DeleteProject",
        "DeleteUserProfile",
        "DescribeProject",
        "DescribeUserProfile",
        "DisassociateTeamMember",
        "GetExtendedAccess",
        "ListProjects",
        "ListResources",
        "ListTagsForProject",
        "ListTeamMembers",
        "ListUserProfiles",
        "PutExtendedAccess",
        "TagProject",
        "UntagProject",
        "UpdateProject",
        "UpdateTeamMember",
        "UpdateUserProfile",
    ],
    "codestar-notifications": [
        "CreateNotificationRule",
        "DeleteNotificationRule",
        "DeleteTarget",
        "DescribeNotificationRule",
        "ListEventTypes",
        "ListNotificationRules",
        "ListTagsForResource",
        "ListTargets",
        "Subscribe",
        "TagResource",
        "Unsubscribe",
        "UntagResource",
        "UpdateNotificationRule",
    ],
    "config": [
        "BatchGetAggregateResourceConfig",
        "BatchGetResourceConfig",
        "DeleteAggregationAuthorization",
        "DeleteConfigRule",
        "DeleteConfigurationAggregator",
        "DeleteConfigurationRecorder",
        "DeleteConformancePack",
        "DeleteDeliveryChannel",
        "DeleteEvaluationResults",
        "DeleteOrganizationConfigRule",
        "DeleteOrganizationConformancePack",
        "DeletePendingAggregationRequest",
        "DeleteRemediationConfiguration",
        "DeleteRemediationExceptions",
        "DeleteRetentionConfiguration",
        "DeliverConfigSnapshot",
        "DescribeAggregateComplianceByConfigRules",
        "DescribeAggregationAuthorizations",
        "DescribeComplianceByConfigRule",
        "DescribeComplianceByResource",
        "DescribeConfigRuleEvaluationStatus",
        "DescribeConfigRules",
        "DescribeConfigurationAggregatorSourcesStatus",
        "DescribeConfigurationAggregators",
        "DescribeConfigurationRecorderStatus",
        "DescribeConfigurationRecorders",
        "DescribeConformancePackCompliance",
        "DescribeConformancePackStatus",
        "DescribeConformancePacks",
        "DescribeDeliveryChannelStatus",
        "DescribeDeliveryChannels",
        "DescribeOrganizationConfigRuleStatuses",
        "DescribeOrganizationConfigRules",
        "DescribeOrganizationConformancePackStatuses",
        "DescribeOrganizationConformancePacks",
        "DescribePendingAggregationRequests",
        "DescribeRemediationConfigurations",
        "DescribeRemediationExceptions",
        "DescribeRemediationExecutionStatus",
        "DescribeRetentionConfigurations",
        "GetAggregateComplianceDetailsByConfigRule",
        "GetAggregateConfigRuleComplianceSummary",
        "GetAggregateDiscoveredResourceCounts",
        "GetAggregateResourceConfig",
        "GetComplianceDetailsByConfigRule",
        "GetComplianceDetailsByResource",
        "GetComplianceSummaryByConfigRule",
        "GetComplianceSummaryByResourceType",
        "GetConformancePackComplianceDetails",
        "GetConformancePackComplianceSummary",
        "GetDiscoveredResourceCounts",
        "GetOrganizationConfigRuleDetailedStatus",
        "GetOrganizationConformancePackDetailedStatus",
        "GetResourceConfigHistory",
        "GetResources",
        "GetTagKeys",
        "ListAggregateDiscoveredResources",
        "ListDiscoveredResources",
        "ListTagsForResource",
        "PutAggregationAuthorization",
        "PutConfigRule",
        "PutConfigurationAggregator",
        "PutConfigurationRecorder",
        "PutConformancePack",
        "PutDeliveryChannel",
        "PutEvaluations",
        "PutOrganizationConfigRule",
        "PutOrganizationConformancePack",
        "PutRemediationConfigurations",
        "PutRemediationExceptions",
        "PutRetentionConfiguration",
        "SelectResourceConfig",
        "StartConfigRulesEvaluation",
        "StartConfigurationRecorder",
        "StartRemediationExecution",
        "StopConfigurationRecorder",
        "TagResource",
        "UntagResource",
    ],
    "awsconnector": ["GetConnectorHealth", "RegisterConnector", "ValidateConnectorId"],
    "ce": [
        "CreateCostCategoryDefinition",
        "DeleteCostCategoryDefinition",
        "DescribeCostCategoryDefinition",
        "GetCostAndUsage",
        "GetCostAndUsageWithResources",
        "GetCostForecast",
        "GetDimensionValues",
        "GetReservationCoverage",
        "GetReservationPurchaseRecommendation",
        "GetReservationUtilization",
        "GetRightsizingRecommendation",
        "GetSavingsPlansCoverage",
        "GetSavingsPlansPurchaseRecommendation",
        "GetSavingsPlansUtilization",
        "GetSavingsPlansUtilizationDetails",
        "GetTags",
        "GetUsageForecast",
        "ListCostCategoryDefinitions",
        "UpdateCostCategoryDefinition",
    ],
    "cur": [
        "DeleteReportDefinition",
        "DescribeReportDefinitions",
        "ModifyReportDefinition",
        "PutReportDefinition",
    ],
    "dataexchange": [
        "CancelJob",
        "CreateDataSet",
        "CreateJob",
        "CreateRevision",
        "DeleteAsset",
        "DeleteDataSet",
        "DeleteRevision",
        "GetAsset",
        "GetDataSet",
        "GetJob",
        "GetRevision",
        "ListDataSetRevisions",
        "ListDataSets",
        "ListJobs",
        "ListRevisionAssets",
        "ListTagsForResource",
        "StartJob",
        "TagResource",
        "UntagResource",
        "UpdateAsset",
        "UpdateDataSet",
        "UpdateRevision",
    ],
    "dms": [
        "AddTagsToResource",
        "ApplyPendingMaintenanceAction",
        "CreateEndpoint",
        "CreateEventSubscription",
        "CreateReplicationInstance",
        "CreateReplicationSubnetGroup",
        "CreateReplicationTask",
        "DeleteCertificate",
        "DeleteEndpoint",
        "DeleteEventSubscription",
        "DeleteReplicationInstance",
        "DeleteReplicationSubnetGroup",
        "DeleteReplicationTask",
        "DescribeAccountAttributes",
        "DescribeCertificates",
        "DescribeConnections",
        "DescribeEndpointTypes",
        "DescribeEndpoints",
        "DescribeEventCategories",
        "DescribeEventSubscriptions",
        "DescribeEvents",
        "DescribeOrderableReplicationInstances",
        "DescribeRefreshSchemasStatus",
        "DescribeReplicationInstanceTaskLogs",
        "DescribeReplicationInstances",
        "DescribeReplicationSubnetGroups",
        "DescribeReplicationTaskAssessmentResults",
        "DescribeReplicationTasks",
        "DescribeSchemas",
        "DescribeTableStatistics",
        "ImportCertificate",
        "ListTagsForResource",
        "ModifyEndpoint",
        "ModifyEventSubscription",
        "ModifyReplicationInstance",
        "ModifyReplicationSubnetGroup",
        "ModifyReplicationTask",
        "RebootReplicationInstance",
        "RefreshSchemas",
        "ReloadTables",
        "RemoveTagsFromResource",
        "StartReplicationTask",
        "StartReplicationTaskAssessment",
        "StopReplicationTask",
        "TestConnection",
    ],
    "deepcomposer": [
        "AssociateCoupon",
        "CreateAudio",
        "CreateComposition",
        "CreateModel",
        "DeleteComposition",
        "DeleteModel",
        "GetComposition",
        "GetModel",
        "GetSampleModel",
        "ListCompositions",
        "ListModels",
        "ListSampleModels",
        "ListTrainingTopics",
        "UpdateComposition",
        "UpdateModel",
    ],
    "deeplens": [
        "AssociateServiceRoleToAccount",
        "BatchGetDevice",
        "BatchGetModel",
        "BatchGetProject",
        "CreateDeviceCertificates",
        "CreateModel",
        "CreateProject",
        "DeleteModel",
        "DeleteProject",
        "DeployProject",
        "DeregisterDevice",
        "GetAssociatedResources",
        "GetDeploymentStatus",
        "GetDevice",
        "GetModel",
        "GetProject",
        "ImportProjectFromTemplate",
        "ListDeployments",
        "ListDevices",
        "ListModels",
        "ListProjects",
        "RegisterDevice",
        "RemoveProject",
        "UpdateProject",
    ],
    "deepracer": [
        "CloneReinforcementLearningModel",
        "CreateAccountResources",
        "CreateLeaderboardSubmission",
        "CreateReinforcementLearningModel",
        "DeleteAccountResources",
        "DeleteModel",
        "GetAccountResources",
        "GetAlias",
        "GetEvaluation",
        "GetLatestUserSubmission",
        "GetLeaderboard",
        "GetModel",
        "GetRankedUserSubmission",
        "GetTrack",
        "GetTrainingJob",
        "ListEvaluations",
        "ListLeaderboardSubmissions",
        "ListLeaderboards",
        "ListModels",
        "ListTracks",
        "ListTrainingJobs",
        "SetAlias",
        "StartEvaluation",
        "StopEvaluation",
        "StopTrainingReinforcementLearningModel",
        "TestRewardFunction",
    ],
    "devicefarm": [
        "CreateDevicePool",
        "CreateInstanceProfile",
        "CreateNetworkProfile",
        "CreateProject",
        "CreateRemoteAccessSession",
        "CreateTestGridProject",
        "CreateTestGridUrl",
        "CreateUpload",
        "CreateVPCEConfiguration",
        "DeleteDevicePool",
        "DeleteInstanceProfile",
        "DeleteNetworkProfile",
        "DeleteProject",
        "DeleteRemoteAccessSession",
        "DeleteRun",
        "DeleteTestGridProject",
        "DeleteUpload",
        "DeleteVPCEConfiguration",
        "GetAccountSettings",
        "GetDevice",
        "GetDeviceInstance",
        "GetDevicePool",
        "GetDevicePoolCompatibility",
        "GetInstanceProfile",
        "GetJob",
        "GetNetworkProfile",
        "GetOfferingStatus",
        "GetProject",
        "GetRemoteAccessSession",
        "GetRun",
        "GetSuite",
        "GetTest",
        "GetTestGridProject",
        "GetTestGridSession",
        "GetUpload",
        "GetVPCEConfiguration",
        "InstallToRemoteAccessSession",
        "ListArtifacts",
        "ListDeviceInstances",
        "ListDevicePools",
        "ListDevices",
        "ListInstanceProfiles",
        "ListJobs",
        "ListNetworkProfiles",
        "ListOfferingPromotions",
        "ListOfferingTransactions",
        "ListOfferings",
        "ListProjects",
        "ListRemoteAccessSessions",
        "ListRuns",
        "ListSamples",
        "ListSuites",
        "ListTagsForResource",
        "ListTestGridProjects",
        "ListTestGridSessionActions",
        "ListTestGridSessionArtifacts",
        "ListTestGridSessions",
        "ListTests",
        "ListUniqueProblems",
        "ListUploads",
        "ListVPCEConfigurations",
        "PurchaseOffering",
        "RenewOffering",
        "ScheduleRun",
        "StopJob",
        "StopRemoteAccessSession",
        "StopRun",
        "TagResource",
        "UntagResource",
        "UpdateDeviceInstance",
        "UpdateDevicePool",
        "UpdateInstanceProfile",
        "UpdateNetworkProfile",
        "UpdateProject",
        "UpdateTestGridProject",
        "UpdateUpload",
        "UpdateVPCEConfiguration",
    ],
    "directconnect": [
        "AcceptDirectConnectGatewayAssociationProposal",
        "AllocateConnectionOnInterconnect",
        "AllocateHostedConnection",
        "AllocatePrivateVirtualInterface",
        "AllocatePublicVirtualInterface",
        "AllocateTransitVirtualInterface",
        "AssociateConnectionWithLag",
        "AssociateHostedConnection",
        "AssociateVirtualInterface",
        "ConfirmConnection",
        "ConfirmPrivateVirtualInterface",
        "ConfirmPublicVirtualInterface",
        "ConfirmTransitVirtualInterface",
        "CreateBGPPeer",
        "CreateConnection",
        "CreateDirectConnectGateway",
        "CreateDirectConnectGatewayAssociation",
        "CreateDirectConnectGatewayAssociationProposal",
        "CreateInterconnect",
        "CreateLag",
        "CreatePrivateVirtualInterface",
        "CreatePublicVirtualInterface",
        "CreateTransitVirtualInterface",
        "DeleteBGPPeer",
        "DeleteConnection",
        "DeleteDirectConnectGateway",
        "DeleteDirectConnectGatewayAssociation",
        "DeleteDirectConnectGatewayAssociationProposal",
        "DeleteInterconnect",
        "DeleteLag",
        "DeleteVirtualInterface",
        "DescribeConnectionLoa",
        "DescribeConnections",
        "DescribeConnectionsOnInterconnect",
        "DescribeDirectConnectGatewayAssociationProposals",
        "DescribeDirectConnectGatewayAssociations",
        "DescribeDirectConnectGatewayAttachments",
        "DescribeDirectConnectGateways",
        "DescribeHostedConnections",
        "DescribeInterconnectLoa",
        "DescribeInterconnects",
        "DescribeLags",
        "DescribeLoa",
        "DescribeLocations",
        "DescribeTags",
        "DescribeVirtualGateways",
        "DescribeVirtualInterfaces",
        "DisassociateConnectionFromLag",
        "TagResource",
        "UntagResource",
        "UpdateDirectConnectGatewayAssociation",
        "UpdateLag",
        "UpdateVirtualInterfaceAttributes",
    ],
    "ds": [
        "AcceptSharedDirectory",
        "AddIpRoutes",
        "AddTagsToResource",
        "AuthorizeApplication",
        "CancelSchemaExtension",
        "CheckAlias",
        "ConnectDirectory",
        "CreateAlias",
        "CreateComputer",
        "CreateConditionalForwarder",
        "CreateDirectory",
        "CreateIdentityPoolDirectory",
        "CreateLogSubscription",
        "CreateMicrosoftAD",
        "CreateSnapshot",
        "CreateTrust",
        "DeleteConditionalForwarder",
        "DeleteDirectory",
        "DeleteLogSubscription",
        "DeleteSnapshot",
        "DeleteTrust",
        "DeregisterCertificate",
        "DeregisterEventTopic",
        "DescribeCertificate",
        "DescribeConditionalForwarders",
        "DescribeDirectories",
        "DescribeDomainControllers",
        "DescribeEventTopics",
        "DescribeLDAPSSettings",
        "DescribeSharedDirectories",
        "DescribeSnapshots",
        "DescribeTrusts",
        "DisableLDAPS",
        "DisableRadius",
        "DisableSso",
        "EnableLDAPS",
        "EnableRadius",
        "EnableSso",
        "GetAuthorizedApplicationDetails",
        "GetDirectoryLimits",
        "GetSnapshotLimits",
        "ListAuthorizedApplications",
        "ListCertificates",
        "ListIpRoutes",
        "ListLogSubscriptions",
        "ListSchemaExtensions",
        "ListTagsForResource",
        "RegisterCertificate",
        "RegisterEventTopic",
        "RejectSharedDirectory",
        "RemoveIpRoutes",
        "RemoveTagsFromResource",
        "ResetUserPassword",
        "RestoreFromSnapshot",
        "ShareDirectory",
        "StartSchemaExtension",
        "UnauthorizeApplication",
        "UnshareDirectory",
        "UpdateConditionalForwarder",
        "UpdateNumberOfDomainControllers",
        "UpdateRadius",
        "UpdateTrust",
        "VerifyTrust",
    ],
    "elasticbeanstalk": [
        "AbortEnvironmentUpdate",
        "AddTags",
        "ApplyEnvironmentManagedAction",
        "CheckDNSAvailability",
        "ComposeEnvironments",
        "CreateApplication",
        "CreateApplicationVersion",
        "CreateConfigurationTemplate",
        "CreateEnvironment",
        "CreatePlatformVersion",
        "CreateStorageLocation",
        "DeleteApplication",
        "DeleteApplicationVersion",
        "DeleteConfigurationTemplate",
        "DeleteEnvironmentConfiguration",
        "DeletePlatformVersion",
        "DescribeAccountAttributes",
        "DescribeApplicationVersions",
        "DescribeApplications",
        "DescribeConfigurationOptions",
        "DescribeConfigurationSettings",
        "DescribeEnvironmentHealth",
        "DescribeEnvironmentManagedActionHistory",
        "DescribeEnvironmentManagedActions",
        "DescribeEnvironmentResources",
        "DescribeEnvironments",
        "DescribeEvents",
        "DescribeInstancesHealth",
        "DescribePlatformVersion",
        "ListAvailableSolutionStacks",
        "ListPlatformVersions",
        "ListTagsForResource",
        "RebuildEnvironment",
        "RemoveTags",
        "RequestEnvironmentInfo",
        "RestartAppServer",
        "RetrieveEnvironmentInfo",
        "SwapEnvironmentCNAMEs",
        "TerminateEnvironment",
        "UpdateApplication",
        "UpdateApplicationResourceLifecycle",
        "UpdateApplicationVersion",
        "UpdateConfigurationTemplate",
        "UpdateEnvironment",
        "ValidateConfigurationSettings",
    ],
    "mediaconnect": [
        "AddFlowOutputs",
        "CreateFlow",
        "DeleteFlow",
        "DescribeFlow",
        "GrantFlowEntitlements",
        "ListEntitlements",
        "ListFlows",
        "RemoveFlowOutput",
        "RevokeFlowEntitlement",
        "StartFlow",
        "StopFlow",
        "UpdateFlowEntitlement",
        "UpdateFlowOutput",
        "UpdateFlowSource",
    ],
    "mediaconvert": [
        "AssociateCertificate",
        "CancelJob",
        "CreateJob",
        "CreateJobTemplate",
        "CreatePreset",
        "CreateQueue",
        "DeleteJobTemplate",
        "DeletePreset",
        "DeleteQueue",
        "DescribeEndpoints",
        "DisassociateCertificate",
        "GetJob",
        "GetJobTemplate",
        "GetPreset",
        "GetQueue",
        "ListJobTemplates",
        "ListJobs",
        "ListPresets",
        "ListQueues",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateJobTemplate",
        "UpdatePreset",
        "UpdateQueue",
    ],
    "medialive": [
        "BatchUpdateSchedule",
        "CreateChannel",
        "CreateInput",
        "CreateInputSecurityGroup",
        "CreateMultiplex",
        "CreateTags",
        "DeleteChannel",
        "DeleteInput",
        "DeleteInputSecurityGroup",
        "DeleteMultiplex",
        "DeleteReservation",
        "DeleteTags",
        "DescribeChannel",
        "DescribeInput",
        "DescribeInputSecurityGroup",
        "DescribeMultiplex",
        "DescribeOffering",
        "DescribeReservation",
        "DescribeSchedule",
        "ListChannels",
        "ListInputSecurityGroups",
        "ListInputs",
        "ListMultiplexes",
        "ListOfferings",
        "ListReservations",
        "ListTagsForResource",
        "PurchaseOffering",
        "StartChannel",
        "StartMultiplex",
        "StopChannel",
        "StopMultiplex",
        "UpdateChannel",
        "UpdateChannelClass",
        "UpdateInput",
        "UpdateInputSecurityGroup",
        "UpdateMultiplex",
        "UpdateReservation",
    ],
    "mediapackage": [
        "CreateChannel",
        "CreateOriginEndpoint",
        "DeleteChannel",
        "DeleteOriginEndpoint",
        "DescribeChannel",
        "DescribeOriginEndpoint",
        "ListChannels",
        "ListOriginEndpoints",
        "ListTagsForResource",
        "RotateIngestEndpointCredentials",
        "TagResource",
        "UntagResource",
        "UpdateChannel",
        "UpdateOriginEndpoint",
    ],
    "mediapackage-vod": [
        "CreateAsset",
        "CreatePackagingConfiguration",
        "CreatePackagingGroup",
        "DeleteAsset",
        "DeletePackagingConfiguration",
        "DeletePackagingGroup",
        "DescribeAsset",
        "DescribePackagingConfiguration",
        "DescribePackagingGroup",
        "ListAssets",
        "ListPackagingConfigurations",
        "ListPackagingGroups",
    ],
    "mediastore": [
        "CreateContainer",
        "DeleteContainer",
        "DeleteContainerPolicy",
        "DeleteCorsPolicy",
        "DeleteLifecyclePolicy",
        "DeleteMetricPolicy",
        "DeleteObject",
        "DescribeContainer",
        "DescribeObject",
        "GetContainerPolicy",
        "GetCorsPolicy",
        "GetLifecyclePolicy",
        "GetMetricPolicy",
        "GetObject",
        "ListContainers",
        "ListItems",
        "ListTagsForResource",
        "PutContainerPolicy",
        "PutCorsPolicy",
        "PutLifecyclePolicy",
        "PutMetricPolicy",
        "PutObject",
        "StartAccessLogging",
        "StopAccessLogging",
        "TagResource",
        "UntagResource",
    ],
    "mediatailor": [
        "DeletePlaybackConfiguration",
        "GetPlaybackConfiguration",
        "ListPlaybackConfigurations",
        "ListTagsForResource",
        "PutPlaybackConfiguration",
        "TagResource",
        "UntagResource",
    ],
    "fms": [
        "AssociateAdminAccount",
        "DeleteNotificationChannel",
        "DeletePolicy",
        "DisassociateAdminAccount",
        "GetAdminAccount",
        "GetComplianceDetail",
        "GetNotificationChannel",
        "GetPolicy",
        "GetProtectionStatus",
        "ListComplianceStatus",
        "ListMemberAccounts",
        "ListPolicies",
        "ListTagsForResource",
        "PutNotificationChannel",
        "PutPolicy",
        "TagResource",
        "UntagResource",
    ],
    "globalaccelerator": [
        "AdvertiseByoipCidr",
        "CreateAccelerator",
        "CreateEndpointGroup",
        "CreateListener",
        "DeleteAccelerator",
        "DeleteEndpointGroup",
        "DeleteListener",
        "DeprovisionByoipCidr",
        "DescribeAccelerator",
        "DescribeAcceleratorAttributes",
        "DescribeEndpointGroup",
        "DescribeListener",
        "ListAccelerators",
        "ListByoipCidrs",
        "ListEndpointGroups",
        "ListListeners",
        "ListTagsForResource",
        "ProvisionByoipCidr",
        "TagResource",
        "UntagResource",
        "UpdateAccelerator",
        "UpdateAcceleratorAttributes",
        "UpdateEndpointGroup",
        "UpdateListener",
        "WithdrawByoipCidr",
    ],
    "glue": [
        "BatchCreatePartition",
        "BatchDeleteConnection",
        "BatchDeletePartition",
        "BatchDeleteTable",
        "BatchDeleteTableVersion",
        "BatchGetCrawlers",
        "BatchGetDevEndpoints",
        "BatchGetJobs",
        "BatchGetPartition",
        "BatchGetTriggers",
        "BatchGetWorkflows",
        "BatchStopJobRun",
        "CancelMLTaskRun",
        "CreateClassifier",
        "CreateConnection",
        "CreateCrawler",
        "CreateDatabase",
        "CreateDevEndpoint",
        "CreateJob",
        "CreateMLTransform",
        "CreatePartition",
        "CreateScript",
        "CreateSecurityConfiguration",
        "CreateTable",
        "CreateTrigger",
        "CreateUserDefinedFunction",
        "CreateWorkflow",
        "DeleteClassifier",
        "DeleteConnection",
        "DeleteCrawler",
        "DeleteDatabase",
        "DeleteDevEndpoint",
        "DeleteJob",
        "DeleteMLTransform",
        "DeletePartition",
        "DeleteResourcePolicy",
        "DeleteSecurityConfiguration",
        "DeleteTable",
        "DeleteTableVersion",
        "DeleteTrigger",
        "DeleteUserDefinedFunction",
        "DeleteWorkflow",
        "GetCatalogImportStatus",
        "GetClassifier",
        "GetClassifiers",
        "GetConnection",
        "GetConnections",
        "GetCrawler",
        "GetCrawlerMetrics",
        "GetCrawlers",
        "GetDataCatalogEncryptionSettings",
        "GetDatabase",
        "GetDatabases",
        "GetDataflowGraph",
        "GetDevEndpoint",
        "GetDevEndpoints",
        "GetJob",
        "GetJobBookmark",
        "GetJobRun",
        "GetJobRuns",
        "GetJobs",
        "GetMLTaskRun",
        "GetMLTaskRuns",
        "GetMLTransform",
        "GetMLTransforms",
        "GetMapping",
        "GetPartition",
        "GetPartitions",
        "GetPlan",
        "GetResourcePolicy",
        "GetSecurityConfiguration",
        "GetSecurityConfigurations",
        "GetTable",
        "GetTableVersion",
        "GetTableVersions",
        "GetTables",
        "GetTags",
        "GetTrigger",
        "GetTriggers",
        "GetUserDefinedFunction",
        "GetUserDefinedFunctions",
        "GetWorkflow",
        "GetWorkflowRun",
        "GetWorkflowRunProperties",
        "GetWorkflowRuns",
        "ImportCatalogToGlue",
        "ListCrawlers",
        "ListDevEndpoints",
        "ListJobs",
        "ListMLTransforms",
        "ListTriggers",
        "ListWorkflows",
        "PutDataCatalogEncryptionSettings",
        "PutResourcePolicy",
        "PutWorkflowRunProperties",
        "ResetJobBookmark",
        "SearchTables",
        "StartCrawler",
        "StartCrawlerSchedule",
        "StartExportLabelsTaskRun",
        "StartImportLabelsTaskRun",
        "StartJobRun",
        "StartMLEvaluationTaskRun",
        "StartMLLabelingSetGenerationTaskRun",
        "StartTrigger",
        "StartWorkflowRun",
        "StopCrawler",
        "StopCrawlerSchedule",
        "StopTrigger",
        "TagResource",
        "UntagResource",
        "UpdateClassifier",
        "UpdateConnection",
        "UpdateCrawler",
        "UpdateCrawlerSchedule",
        "UpdateDatabase",
        "UpdateDevEndpoint",
        "UpdateJob",
        "UpdateMLTransform",
        "UpdatePartition",
        "UpdateTable",
        "UpdateTrigger",
        "UpdateUserDefinedFunction",
        "UpdateWorkflow",
        "UseMLTransforms",
    ],
    "groundstation": [
        "CancelContact",
        "CreateConfig",
        "CreateDataflowEndpointGroup",
        "CreateMissionProfile",
        "DeleteConfig",
        "DeleteDataflowEndpointGroup",
        "DeleteMissionProfile",
        "DescribeContact",
        "GetConfig",
        "GetDataflowEndpointGroup",
        "GetMinuteUsage",
        "GetMissionProfile",
        "GetSatellite",
        "ListConfigs",
        "ListContacts",
        "ListDataflowEndpointGroups",
        "ListGroundStations",
        "ListMissionProfiles",
        "ListSatellites",
        "ListTagsForResource",
        "ReserveContact",
        "TagResource",
        "UntagResource",
        "UpdateConfig",
        "UpdateMissionProfile",
    ],
    "health": [
        "DescribeAffectedAccountsForOrganization",
        "DescribeAffectedEntities",
        "DescribeAffectedEntitiesForOrganization",
        "DescribeEntityAggregates",
        "DescribeEventAggregates",
        "DescribeEventDetails",
        "DescribeEventDetailsForOrganization",
        "DescribeEventTypes",
        "DescribeEvents",
        "DescribeEventsForOrganization",
        "DescribeHealthServiceStatusForOrganization",
        "DisableHealthServiceAccessForOrganization",
        "EnableHealthServiceAccessForOrganization",
    ],
    "iq": [],
    "iq-permission": [],
    "importexport": [
        "CancelJob",
        "CreateJob",
        "GetShippingLabel",
        "GetStatus",
        "ListJobs",
        "UpdateJob",
    ],
    "iot": [
        "AcceptCertificateTransfer",
        "AddThingToBillingGroup",
        "AddThingToThingGroup",
        "AssociateTargetsWithJob",
        "AttachPolicy",
        "AttachPrincipalPolicy",
        "AttachSecurityProfile",
        "AttachThingPrincipal",
        "CancelAuditTask",
        "CancelCertificateTransfer",
        "CancelJob",
        "CancelJobExecution",
        "ClearDefaultAuthorizer",
        "CloseTunnel",
        "Connect",
        "CreateAuthorizer",
        "CreateBillingGroup",
        "CreateCertificateFromCsr",
        "CreateDynamicThingGroup",
        "CreateJob",
        "CreateKeysAndCertificate",
        "CreateOTAUpdate",
        "CreatePolicy",
        "CreatePolicyVersion",
        "CreateProvisioningClaim",
        "CreateProvisioningTemplate",
        "CreateProvisioningTemplateVersion",
        "CreateRoleAlias",
        "CreateScheduledAudit",
        "CreateSecurityProfile",
        "CreateStream",
        "CreateThing",
        "CreateThingGroup",
        "CreateThingType",
        "CreateTopicRule",
        "DeleteAccountAuditConfiguration",
        "DeleteAuthorizer",
        "DeleteBillingGroup",
        "DeleteCACertificate",
        "DeleteCertificate",
        "DeleteDynamicThingGroup",
        "DeleteJob",
        "DeleteJobExecution",
        "DeleteOTAUpdate",
        "DeletePolicy",
        "DeletePolicyVersion",
        "DeleteProvisioningTemplate",
        "DeleteProvisioningTemplateVersion",
        "DeleteRegistrationCode",
        "DeleteRoleAlias",
        "DeleteScheduledAudit",
        "DeleteSecurityProfile",
        "DeleteStream",
        "DeleteThing",
        "DeleteThingGroup",
        "DeleteThingShadow",
        "DeleteThingType",
        "DeleteTopicRule",
        "DeleteV2LoggingLevel",
        "DeprecateThingType",
        "DescribeAccountAuditConfiguration",
        "DescribeAuditTask",
        "DescribeAuthorizer",
        "DescribeBillingGroup",
        "DescribeCACertificate",
        "DescribeCertificate",
        "DescribeDefaultAuthorizer",
        "DescribeEndpoint",
        "DescribeEventConfigurations",
        "DescribeIndex",
        "DescribeJob",
        "DescribeJobExecution",
        "DescribeProvisioningTemplate",
        "DescribeProvisioningTemplateVersion",
        "DescribeRoleAlias",
        "DescribeScheduledAudit",
        "DescribeSecurityProfile",
        "DescribeStream",
        "DescribeThing",
        "DescribeThingGroup",
        "DescribeThingRegistrationTask",
        "DescribeThingType",
        "DescribeTunnel",
        "DetachPolicy",
        "DetachPrincipalPolicy",
        "DetachSecurityProfile",
        "DetachThingPrincipal",
        "DisableTopicRule",
        "EnableTopicRule",
        "GetCardinality",
        "GetEffectivePolicies",
        "GetIndexingConfiguration",
        "GetJobDocument",
        "GetLoggingOptions",
        "GetOTAUpdate",
        "GetPendingJobExecutions",
        "GetPercentiles",
        "GetPolicy",
        "GetPolicyVersion",
        "GetRegistrationCode",
        "GetStatistics",
        "GetThingShadow",
        "GetTopicRule",
        "GetV2LoggingOptions",
        "ListActiveViolations",
        "ListAttachedPolicies",
        "ListAuditFindings",
        "ListAuditTasks",
        "ListAuthorizers",
        "ListBillingGroups",
        "ListCACertificates",
        "ListCertificates",
        "ListCertificatesByCA",
        "ListIndices",
        "ListJobExecutionsForJob",
        "ListJobExecutionsForThing",
        "ListJobs",
        "ListOTAUpdates",
        "ListOutgoingCertificates",
        "ListPolicies",
        "ListPolicyPrincipals",
        "ListPolicyVersions",
        "ListPrincipalPolicies",
        "ListPrincipalThings",
        "ListProvisioningTemplateVersions",
        "ListProvisioningTemplates",
        "ListRoleAliases",
        "ListScheduledAudits",
        "ListSecurityProfiles",
        "ListSecurityProfilesForTarget",
        "ListStreams",
        "ListTagsForResource",
        "ListTargetsForPolicy",
        "ListTargetsForSecurityProfile",
        "ListThingGroups",
        "ListThingGroupsForThing",
        "ListThingPrincipals",
        "ListThingRegistrationTaskReports",
        "ListThingRegistrationTasks",
        "ListThingTypes",
        "ListThings",
        "ListThingsInBillingGroup",
        "ListThingsInThingGroup",
        "ListTopicRules",
        "ListTunnels",
        "ListV2LoggingLevels",
        "ListViolationEvents",
        "OpenTunnel",
        "Publish",
        "Receive",
        "RegisterCACertificate",
        "RegisterCertificate",
        "RegisterThing",
        "RejectCertificateTransfer",
        "RemoveThingFromBillingGroup",
        "RemoveThingFromThingGroup",
        "ReplaceTopicRule",
        "SearchIndex",
        "SetDefaultAuthorizer",
        "SetDefaultPolicyVersion",
        "SetLoggingOptions",
        "SetV2LoggingLevel",
        "SetV2LoggingOptions",
        "StartNextPendingJobExecution",
        "StartOnDemandAuditTask",
        "StartThingRegistrationTask",
        "StopThingRegistrationTask",
        "Subscribe",
        "TagResource",
        "TestAuthorization",
        "TestInvokeAuthorizer",
        "TransferCertificate",
        "UntagResource",
        "UpdateAccountAuditConfiguration",
        "UpdateAuthorizer",
        "UpdateBillingGroup",
        "UpdateCACertificate",
        "UpdateCertificate",
        "UpdateDynamicThingGroup",
        "UpdateEventConfigurations",
        "UpdateIndexingConfiguration",
        "UpdateJob",
        "UpdateJobExecution",
        "UpdateProvisioningTemplate",
        "UpdateRoleAlias",
        "UpdateScheduledAudit",
        "UpdateSecurityProfile",
        "UpdateStream",
        "UpdateThing",
        "UpdateThingGroup",
        "UpdateThingGroupsForThing",
        "UpdateThingShadow",
        "ValidateSecurityProfileBehaviors",
    ],
    "iot1click": [
        "AssociateDeviceWithPlacement",
        "ClaimDevicesByClaimCode",
        "CreatePlacement",
        "CreateProject",
        "DeletePlacement",
        "DeleteProject",
        "DescribeDevice",
        "DescribePlacement",
        "DescribeProject",
        "DisassociateDeviceFromPlacement",
        "FinalizeDeviceClaim",
        "GetDeviceMethods",
        "GetDevicesInPlacement",
        "InitiateDeviceClaim",
        "InvokeDeviceMethod",
        "ListDeviceEvents",
        "ListDevices",
        "ListPlacements",
        "ListProjects",
        "ListTagsForResource",
        "TagResource",
        "UnclaimDevice",
        "UntagResource",
        "UpdateDeviceState",
        "UpdatePlacement",
        "UpdateProject",
    ],
    "iotanalytics": [
        "BatchPutMessage",
        "CancelPipelineReprocessing",
        "CreateChannel",
        "CreateDataset",
        "CreateDatasetContent",
        "CreateDatastore",
        "CreatePipeline",
        "DeleteChannel",
        "DeleteDataset",
        "DeleteDatasetContent",
        "DeleteDatastore",
        "DeletePipeline",
        "DescribeChannel",
        "DescribeDataset",
        "DescribeDatastore",
        "DescribeLoggingOptions",
        "DescribePipeline",
        "GetDatasetContent",
        "ListChannels",
        "ListDatasets",
        "ListDatastores",
        "ListPipelines",
        "ListTagsForResource",
        "PutLoggingOptions",
        "RunPipelineActivity",
        "SampleChannelData",
        "StartPipelineReprocessing",
        "TagResource",
        "UntagResource",
        "UpdateChannel",
        "UpdateDataset",
        "UpdateDatastore",
        "UpdatePipeline",
    ],
    "iot-device-tester": [
        "CheckVersion",
        "DownloadTestSuite",
        "LatestIdt",
        "SendMetrics",
        "SupportedVersion",
    ],
    "iotevents": [
        "BatchPutMessage",
        "BatchUpdateDetector",
        "CreateDetectorModel",
        "CreateInput",
        "DeleteDetectorModel",
        "DeleteInput",
        "DescribeDetector",
        "DescribeDetectorModel",
        "DescribeInput",
        "DescribeLoggingOptions",
        "ListDetectorModelVersions",
        "ListDetectorModels",
        "ListDetectors",
        "ListInputs",
        "ListTagsForResource",
        "PutLoggingOptions",
        "TagResource",
        "UntagResource",
        "UpdateDetectorModel",
        "UpdateInput",
        "UpdateInputRouting",
    ],
    "greengrass": [
        "AssociateRoleToGroup",
        "AssociateServiceRoleToAccount",
        "CreateConnectorDefinition",
        "CreateConnectorDefinitionVersion",
        "CreateCoreDefinition",
        "CreateCoreDefinitionVersion",
        "CreateDeployment",
        "CreateDeviceDefinition",
        "CreateDeviceDefinitionVersion",
        "CreateFunctionDefinition",
        "CreateFunctionDefinitionVersion",
        "CreateGroup",
        "CreateGroupCertificateAuthority",
        "CreateGroupVersion",
        "CreateLoggerDefinition",
        "CreateLoggerDefinitionVersion",
        "CreateResourceDefinition",
        "CreateResourceDefinitionVersion",
        "CreateSoftwareUpdateJob",
        "CreateSubscriptionDefinition",
        "CreateSubscriptionDefinitionVersion",
        "DeleteConnectorDefinition",
        "DeleteCoreDefinition",
        "DeleteDeviceDefinition",
        "DeleteFunctionDefinition",
        "DeleteGroup",
        "DeleteLoggerDefinition",
        "DeleteResourceDefinition",
        "DeleteSubscriptionDefinition",
        "DisassociateRoleFromGroup",
        "DisassociateServiceRoleFromAccount",
        "GetAssociatedRole",
        "GetBulkDeploymentStatus",
        "GetConnectivityInfo",
        "GetConnectorDefinition",
        "GetConnectorDefinitionVersion",
        "GetCoreDefinition",
        "GetCoreDefinitionVersion",
        "GetDeploymentStatus",
        "GetDeviceDefinition",
        "GetDeviceDefinitionVersion",
        "GetFunctionDefinition",
        "GetFunctionDefinitionVersion",
        "GetGroup",
        "GetGroupCertificateAuthority",
        "GetGroupCertificateConfiguration",
        "GetGroupVersion",
        "GetLoggerDefinition",
        "GetLoggerDefinitionVersion",
        "GetResourceDefinition",
        "GetResourceDefinitionVersion",
        "GetServiceRoleForAccount",
        "GetSubscriptionDefinition",
        "GetSubscriptionDefinitionVersion",
        "ListBulkDeploymentDetailedReports",
        "ListBulkDeployments",
        "ListConnectorDefinitionVersions",
        "ListConnectorDefinitions",
        "ListCoreDefinitionVersions",
        "ListCoreDefinitions",
        "ListDeployments",
        "ListDeviceDefinitionVersions",
        "ListDeviceDefinitions",
        "ListFunctionDefinitionVersions",
        "ListFunctionDefinitions",
        "ListGroupCertificateAuthorities",
        "ListGroupVersions",
        "ListGroups",
        "ListLoggerDefinitionVersions",
        "ListLoggerDefinitions",
        "ListResourceDefinitionVersions",
        "ListResourceDefinitions",
        "ListSubscriptionDefinitionVersions",
        "ListSubscriptionDefinitions",
        "ListTagsForResource",
        "ResetDeployments",
        "StartBulkDeployment",
        "StopBulkDeployment",
        "TagResource",
        "UntagResource",
        "UpdateConnectivityInfo",
        "UpdateConnectorDefinition",
        "UpdateCoreDefinition",
        "UpdateDeviceDefinition",
        "UpdateFunctionDefinition",
        "UpdateGroup",
        "UpdateGroupCertificateConfiguration",
        "UpdateLoggerDefinition",
        "UpdateResourceDefinition",
        "UpdateSubscriptionDefinition",
    ],
    "iotsitewise": [
        "AssociateAssets",
        "AssociateViewEntities",
        "BatchAssociateProjectAssets",
        "BatchDisassociateProjectAssets",
        "BatchPutAssetPropertyValue",
        "CreateAccessPolicy",
        "CreateAsset",
        "CreateAssetModel",
        "CreateAssetTemplate",
        "CreateDashboard",
        "CreateGroup",
        "CreateMeasurementDataStore",
        "CreateMetricType",
        "CreatePortal",
        "CreateProject",
        "CreateView",
        "DeleteAccessPolicy",
        "DeleteAsset",
        "DeleteAssetModel",
        "DeleteAssetTemplate",
        "DeleteDashboard",
        "DeleteGroup",
        "DeleteMeasurementDataStore",
        "DeleteMetricType",
        "DeletePortal",
        "DeleteProject",
        "DeleteView",
        "DeregisterViewEntities",
        "DescribeAccessPolicy",
        "DescribeAsset",
        "DescribeAssetModel",
        "DescribeAssetProperty",
        "DescribeAssetTemplates",
        "DescribeAssets",
        "DescribeDashboard",
        "DescribeGroups",
        "DescribeLoggingOptions",
        "DescribeMeasurementDataStores",
        "DescribeMetricTypes",
        "DescribePortal",
        "DescribeProject",
        "DescribeViews",
        "DisassociateAssets",
        "DisassociateViewEntities",
        "GetAssetPropertyAggregates",
        "GetAssetPropertyValue",
        "GetAssetPropertyValueHistory",
        "GetMeasurementData",
        "GetMetricData",
        "ListAccessPolicies",
        "ListAssetModels",
        "ListAssetTemplates",
        "ListAssets",
        "ListAssociatedAssets",
        "ListDashboards",
        "ListGroups",
        "ListMeasurementDataStores",
        "ListMeasurementDataStreams",
        "ListMetricTypes",
        "ListPortals",
        "ListProjectAssets",
        "ListProjects",
        "ListViewEntities",
        "ListViews",
        "PutLoggingOptions",
        "RegisterViewEntities",
        "UpdateAccessPolicy",
        "UpdateAsset",
        "UpdateAssetModel",
        "UpdateAssetProperty",
        "UpdateAssetTemplate",
        "UpdateDashboard",
        "UpdateGroup",
        "UpdateMeasurementDataStore",
        "UpdatePortal",
        "UpdateProject",
        "UpdateView",
    ],
    "iotthingsgraph": [
        "AssociateEntityToThing",
        "CreateFlowTemplate",
        "CreateSystemInstance",
        "CreateSystemTemplate",
        "DeleteFlowTemplate",
        "DeleteNamespace",
        "DeleteSystemInstance",
        "DeleteSystemTemplate",
        "DeploySystemInstance",
        "DeprecateFlowTemplate",
        "DeprecateSystemTemplate",
        "DescribeNamespace",
        "DissociateEntityFromThing",
        "GetEntities",
        "GetFlowTemplate",
        "GetFlowTemplateRevisions",
        "GetNamespaceDeletionStatus",
        "GetSystemInstance",
        "GetSystemTemplate",
        "GetSystemTemplateRevisions",
        "GetUploadStatus",
        "ListFlowExecutionMessages",
        "ListTagsForResource",
        "SearchEntities",
        "SearchFlowExecutions",
        "SearchFlowTemplates",
        "SearchSystemInstances",
        "SearchSystemTemplates",
        "SearchThings",
        "TagResource",
        "UndeploySystemInstance",
        "UntagResource",
        "UpdateFlowTemplate",
        "UpdateSystemTemplate",
        "UploadEntityDefinitions",
    ],
    "kms": [
        "CancelKeyDeletion",
        "ConnectCustomKeyStore",
        "CreateAlias",
        "CreateCustomKeyStore",
        "CreateGrant",
        "CreateKey",
        "Decrypt",
        "DeleteAlias",
        "DeleteCustomKeyStore",
        "DeleteImportedKeyMaterial",
        "DescribeCustomKeyStores",
        "DescribeKey",
        "DisableKey",
        "DisableKeyRotation",
        "DisconnectCustomKeyStore",
        "EnableKey",
        "EnableKeyRotation",
        "Encrypt",
        "GenerateDataKey",
        "GenerateDataKeyPair",
        "GenerateDataKeyPairWithoutPlaintext",
        "GenerateDataKeyWithoutPlaintext",
        "GenerateRandom",
        "GetKeyPolicy",
        "GetKeyRotationStatus",
        "GetParametersForImport",
        "GetPublicKey",
        "ImportKeyMaterial",
        "ListAliases",
        "ListGrants",
        "ListKeyPolicies",
        "ListKeys",
        "ListResourceTags",
        "ListRetirableGrants",
        "PutKeyPolicy",
        "ReEncryptFrom",
        "ReEncryptTo",
        "RetireGrant",
        "RevokeGrant",
        "ScheduleKeyDeletion",
        "Sign",
        "TagResource",
        "UntagResource",
        "UpdateAlias",
        "UpdateCustomKeyStore",
        "UpdateKeyDescription",
        "Verify",
    ],
    "lakeformation": [
        "BatchGrantPermissions",
        "BatchRevokePermissions",
        "DeregisterResource",
        "DescribeResource",
        "GetDataAccess",
        "GetDataLakeSettings",
        "GetEffectivePermissionsForPath",
        "GrantPermissions",
        "ListPermissions",
        "ListResources",
        "PutDataLakeSettings",
        "RegisterResource",
        "RevokePermissions",
        "UpdateResource",
    ],
    "lambda": [
        "AddLayerVersionPermission",
        "AddPermission",
        "CreateAlias",
        "CreateEventSourceMapping",
        "CreateFunction",
        "DeleteAlias",
        "DeleteEventSourceMapping",
        "DeleteFunction",
        "DeleteFunctionConcurrency",
        "DeleteFunctionEventInvokeConfig",
        "DeleteLayerVersion",
        "DeleteProvisionedConcurrencyConfig",
        "DisableReplication",
        "EnableReplication",
        "GetAccountSettings",
        "GetAlias",
        "GetEventSourceMapping",
        "GetFunction",
        "GetFunctionConcurrency",
        "GetFunctionConfiguration",
        "GetFunctionEventInvokeConfig",
        "GetLayerVersion",
        "GetLayerVersionPolicy",
        "GetPolicy",
        "GetProvisionedConcurrencyConfig",
        "InvokeAsync",
        "InvokeFunction",
        "ListAliases",
        "ListEventSourceMappings",
        "ListFunctionEventInvokeConfigs",
        "ListFunctions",
        "ListLayerVersions",
        "ListLayers",
        "ListProvisionedConcurrencyConfigs",
        "ListTags",
        "ListVersionsByFunction",
        "PublishLayerVersion",
        "PublishVersion",
        "PutFunctionConcurrency",
        "PutFunctionEventInvokeConfig",
        "PutProvisionedConcurrencyConfig",
        "RemoveLayerVersionPermission",
        "RemovePermission",
        "TagResource",
        "UntagResource",
        "UpdateAlias",
        "UpdateEventSourceMapping",
        "UpdateFunctionCode",
        "UpdateFunctionConfiguration",
        "UpdateFunctionEventInvokeConfig",
    ],
    "license-manager": [
        "CreateLicenseConfiguration",
        "DeleteLicenseConfiguration",
        "GetLicenseConfiguration",
        "GetServiceSettings",
        "ListAssociationsForLicenseConfiguration",
        "ListLicenseConfigurations",
        "ListLicenseSpecificationsForResource",
        "ListResourceInventory",
        "ListTagsForResource",
        "ListUsageForLicenseConfiguration",
        "TagResource",
        "UntagResource",
        "UpdateLicenseConfiguration",
        "UpdateLicenseSpecificationsForResource",
        "UpdateServiceSettings",
    ],
    "cassandra": ["Alter", "Create", "Drop", "Modify", "Select"],
    "aws-marketplace": [
        "AcceptAgreementApprovalRequest",
        "AssociateProductsWithPrivateMarketplace",
        "BatchMeterUsage",
        "CancelAgreementRequest",
        "CancelChangeSet",
        "CompleteTask",
        "CreatePrivateMarketplace",
        "CreatePrivateMarketplaceProfile",
        "CreatePrivateMarketplaceRequests",
        "DescribeBuilds",
        "DescribeChangeSet",
        "DescribeEntity",
        "DescribePrivateMarketplaceProducts",
        "DescribePrivateMarketplaceProfile",
        "DescribePrivateMarketplaceRequests",
        "DescribePrivateMarketplaceSettings",
        "DescribePrivateMarketplaceStatus",
        "DescribeProcurementSystemConfiguration",
        "DescribeTask",
        "DisassociateProductsFromPrivateMarketplace",
        "GetAgreementApprovalRequest",
        "GetAgreementRequest",
        "GetEntitlements",
        "ListAgreementApprovalRequests",
        "ListAgreementRequests",
        "ListBuilds",
        "ListChangeSets",
        "ListEntities",
        "ListPrivateMarketplaceProducts",
        "ListPrivateMarketplaceRequests",
        "ListTasks",
        "MeterUsage",
        "PutProcurementSystemConfiguration",
        "RegisterUsage",
        "RejectAgreementApprovalRequest",
        "ResolveCustomer",
        "StartBuild",
        "StartChangeSet",
        "StartPrivateMarketplace",
        "StopPrivateMarketplace",
        "Subscribe",
        "Unsubscribe",
        "UpdateAgreementApprovalRequest",
        "UpdatePrivateMarketplaceProfile",
        "UpdatePrivateMarketplaceSettings",
        "UpdateTask",
        "ViewSubscriptions",
    ],
    "aws-marketplace-management": [
        "uploadFiles",
        "viewMarketing",
        "viewReports",
        "viewSettings",
        "viewSupport",
    ],
    "mgh": [
        "AssociateCreatedArtifact",
        "AssociateDiscoveredResource",
        "CreateHomeRegionControl",
        "CreateProgressUpdateStream",
        "DeleteProgressUpdateStream",
        "DescribeApplicationState",
        "DescribeHomeRegionControls",
        "DescribeMigrationTask",
        "DisassociateCreatedArtifact",
        "DisassociateDiscoveredResource",
        "GetHomeRegion",
        "ImportMigrationTask",
        "ListCreatedArtifacts",
        "ListDiscoveredResources",
        "ListMigrationTasks",
        "ListProgressUpdateStreams",
        "NotifyApplicationState",
        "NotifyMigrationTaskState",
        "PutResourceAttributes",
    ],
    "mobilehub": [
        "CreateProject",
        "CreateServiceRole",
        "DeleteProject",
        "DeleteProjectSnapshot",
        "DeployToStage",
        "DescribeBundle",
        "ExportBundle",
        "ExportProject",
        "GenerateProjectParameters",
        "GetProject",
        "GetProjectSnapshot",
        "ImportProject",
        "InstallBundle",
        "ListAvailableConnectors",
        "ListAvailableFeatures",
        "ListAvailableRegions",
        "ListBundles",
        "ListProjectSnapshots",
        "ListProjects",
        "SynchronizeProject",
        "UpdateProject",
        "ValidateProject",
        "VerifyServiceRole",
    ],
    "opsworks": [
        "AssignInstance",
        "AssignVolume",
        "AssociateElasticIp",
        "AttachElasticLoadBalancer",
        "CloneStack",
        "CreateApp",
        "CreateDeployment",
        "CreateInstance",
        "CreateLayer",
        "CreateStack",
        "CreateUserProfile",
        "DeleteApp",
        "DeleteInstance",
        "DeleteLayer",
        "DeleteStack",
        "DeleteUserProfile",
        "DeregisterEcsCluster",
        "DeregisterElasticIp",
        "DeregisterInstance",
        "DeregisterRdsDbInstance",
        "DeregisterVolume",
        "DescribeAgentVersions",
        "DescribeApps",
        "DescribeCommands",
        "DescribeDeployments",
        "DescribeEcsClusters",
        "DescribeElasticIps",
        "DescribeElasticLoadBalancers",
        "DescribeInstances",
        "DescribeLayers",
        "DescribeLoadBasedAutoScaling",
        "DescribeMyUserProfile",
        "DescribePermissions",
        "DescribeRaidArrays",
        "DescribeRdsDbInstances",
        "DescribeServiceErrors",
        "DescribeStackProvisioningParameters",
        "DescribeStackSummary",
        "DescribeStacks",
        "DescribeTimeBasedAutoScaling",
        "DescribeUserProfiles",
        "DescribeVolumes",
        "DetachElasticLoadBalancer",
        "DisassociateElasticIp",
        "GetHostnameSuggestion",
        "GrantAccess",
        "ListTags",
        "RebootInstance",
        "RegisterEcsCluster",
        "RegisterElasticIp",
        "RegisterInstance",
        "RegisterRdsDbInstance",
        "RegisterVolume",
        "SetLoadBasedAutoScaling",
        "SetPermission",
        "SetTimeBasedAutoScaling",
        "StartInstance",
        "StartStack",
        "StopInstance",
        "StopStack",
        "TagResource",
        "UnassignInstance",
        "UnassignVolume",
        "UntagResource",
        "UpdateApp",
        "UpdateElasticIp",
        "UpdateInstance",
        "UpdateLayer",
        "UpdateMyUserProfile",
        "UpdateRdsDbInstance",
        "UpdateStack",
        "UpdateUserProfile",
        "UpdateVolume",
    ],
    "opsworks-cm": [
        "AssociateNode",
        "CreateBackup",
        "CreateServer",
        "DeleteBackup",
        "DeleteServer",
        "DescribeAccountAttributes",
        "DescribeBackups",
        "DescribeEvents",
        "DescribeNodeAssociationStatus",
        "DescribeServers",
        "DisassociateNode",
        "RestoreServer",
        "StartMaintenance",
        "UpdateServer",
        "UpdateServerEngineAttributes",
    ],
    "organizations": [
        "AcceptHandshake",
        "AttachPolicy",
        "CancelHandshake",
        "CreateAccount",
        "CreateGovCloudAccount",
        "CreateOrganization",
        "CreateOrganizationalUnit",
        "CreatePolicy",
        "DeclineHandshake",
        "DeleteOrganization",
        "DeleteOrganizationalUnit",
        "DeletePolicy",
        "DescribeAccount",
        "DescribeCreateAccountStatus",
        "DescribeEffectivePolicy",
        "DescribeHandshake",
        "DescribeOrganization",
        "DescribeOrganizationalUnit",
        "DescribePolicy",
        "DetachPolicy",
        "DisableAWSServiceAccess",
        "DisablePolicyType",
        "EnableAWSServiceAccess",
        "EnableAllFeatures",
        "EnablePolicyType",
        "InviteAccountToOrganization",
        "LeaveOrganization",
        "ListAWSServiceAccessForOrganization",
        "ListAccounts",
        "ListAccountsForParent",
        "ListChildren",
        "ListCreateAccountStatus",
        "ListHandshakesForAccount",
        "ListHandshakesForOrganization",
        "ListOrganizationalUnitsForParent",
        "ListParents",
        "ListPolicies",
        "ListPoliciesForTarget",
        "ListRoots",
        "ListTagsForResource",
        "ListTargetsForPolicy",
        "MoveAccount",
        "RemoveAccountFromOrganization",
        "TagResource",
        "UntagResource",
        "UpdateOrganizationalUnit",
        "UpdatePolicy",
    ],
    "outposts": [
        "CreateOutpost",
        "GetOutpost",
        "GetOutpostInstanceTypes",
        "ListOutposts",
        "ListSites",
    ],
    "pi": ["DescribeDimensionKeys", "GetResourceMetrics"],
    "pricing": ["DescribeServices", "GetAttributeValues", "GetProducts"],
    "ram": [
        "AcceptResourceShareInvitation",
        "AssociateResourceShare",
        "AssociateResourceSharePermission",
        "CreateResourceShare",
        "DeleteResourceShare",
        "DisassociateResourceShare",
        "DisassociateResourceSharePermission",
        "EnableSharingWithAwsOrganization",
        "GetPermission",
        "GetResourcePolicies",
        "GetResourceShareAssociations",
        "GetResourceShareInvitations",
        "GetResourceShares",
        "ListPendingInvitationResources",
        "ListPermissions",
        "ListPrincipals",
        "ListResourceSharePermissions",
        "ListResources",
        "RejectResourceShareInvitation",
        "TagResource",
        "UntagResource",
        "UpdateResourceShare",
    ],
    "resource-groups": [
        "CreateGroup",
        "DeleteGroup",
        "GetGroup",
        "GetGroupQuery",
        "GetTags",
        "ListGroupResources",
        "ListGroups",
        "SearchResources",
        "Tag",
        "Untag",
        "UpdateGroup",
        "UpdateGroupQuery",
    ],
    "robomaker": [
        "BatchDescribeSimulationJob",
        "CancelDeploymentJob",
        "CancelSimulationJob",
        "CancelSimulationJobBatch",
        "CreateDeploymentJob",
        "CreateFleet",
        "CreateRobot",
        "CreateRobotApplication",
        "CreateRobotApplicationVersion",
        "CreateSimulationApplication",
        "CreateSimulationApplicationVersion",
        "CreateSimulationJob",
        "DeleteFleet",
        "DeleteRobot",
        "DeleteRobotApplication",
        "DeleteSimulationApplication",
        "DeregisterRobot",
        "DescribeDeploymentJob",
        "DescribeFleet",
        "DescribeRobot",
        "DescribeRobotApplication",
        "DescribeSimulationApplication",
        "DescribeSimulationJob",
        "DescribeSimulationJobBatch",
        "ListDeploymentJobs",
        "ListFleets",
        "ListRobotApplications",
        "ListRobots",
        "ListSimulationApplications",
        "ListSimulationJobBatches",
        "ListSimulationJobs",
        "ListTagsForResource",
        "RegisterRobot",
        "RestartSimulationJob",
        "StartSimulationJobBatch",
        "SyncDeploymentJob",
        "TagResource",
        "UntagResource",
        "UpdateRobotApplication",
        "UpdateSimulationApplication",
    ],
    "sso": [
        "AssociateDirectory",
        "AssociateProfile",
        "CreateApplicationInstance",
        "CreateApplicationInstanceCertificate",
        "CreateManagedApplicationInstance",
        "CreatePermissionSet",
        "CreateProfile",
        "CreateTrust",
        "DeleteApplicationInstance",
        "DeleteApplicationInstanceCertificate",
        "DeleteManagedApplicationInstance",
        "DeletePermissionSet",
        "DeletePermissionsPolicy",
        "DeleteProfile",
        "DescribePermissionsPolicies",
        "DisassociateDirectory",
        "DisassociateProfile",
        "GetApplicationInstance",
        "GetApplicationTemplate",
        "GetManagedApplicationInstance",
        "GetMfaDeviceManagementForDirectory",
        "GetPermissionSet",
        "GetPermissionsPolicy",
        "GetProfile",
        "GetSSOStatus",
        "GetSharedSsoConfiguration",
        "GetSsoConfiguration",
        "GetTrust",
        "ImportApplicationInstanceServiceProviderMetadata",
        "ListApplicationInstanceCertificates",
        "ListApplicationInstances",
        "ListApplicationTemplates",
        "ListApplications",
        "ListDirectoryAssociations",
        "ListPermissionSets",
        "ListProfileAssociations",
        "ListProfiles",
        "PutMfaDeviceManagementForDirectory",
        "PutPermissionsPolicy",
        "StartSSO",
        "UpdateApplicationInstanceActiveCertificate",
        "UpdateApplicationInstanceDisplayData",
        "UpdateApplicationInstanceResponseConfiguration",
        "UpdateApplicationInstanceResponseSchemaConfiguration",
        "UpdateApplicationInstanceSecurityConfiguration",
        "UpdateApplicationInstanceServiceProviderConfiguration",
        "UpdateApplicationInstanceStatus",
        "UpdateDirectoryAssociation",
        "UpdateManagedApplicationInstanceStatus",
        "UpdatePermissionSet",
        "UpdateProfile",
        "UpdateSSOConfiguration",
        "UpdateTrust",
    ],
    "sso-directory": [
        "AddMemberToGroup",
        "CompleteVirtualMfaDeviceRegistration",
        "CreateAlias",
        "CreateBearerToken",
        "CreateExternalIdPConfigurationForDirectory",
        "CreateGroup",
        "CreateProvisioningTenant",
        "CreateUser",
        "DeleteBearerToken",
        "DeleteExternalIdPConfigurationForDirectory",
        "DeleteGroup",
        "DeleteMfaDeviceForUser",
        "DeleteProvisioningTenant",
        "DeleteUser",
        "DescribeDirectory",
        "DescribeGroups",
        "DescribeUsers",
        "DisableExternalIdPConfigurationForDirectory",
        "DisableUser",
        "EnableExternalIdPConfigurationForDirectory",
        "EnableUser",
        "GetAWSSPConfigurationForDirectory",
        "ListBearerTokens",
        "ListExternalIdPConfigurationsForDirectory",
        "ListGroupsForUser",
        "ListMembersInGroup",
        "ListMfaDevicesForUser",
        "ListProvisioningTenants",
        "RemoveMemberFromGroup",
        "SearchGroups",
        "SearchUsers",
        "StartVirtualMfaDeviceRegistration",
        "UpdateExternalIdPConfigurationForDirectory",
        "UpdateGroup",
        "UpdatePassword",
        "UpdateUser",
        "VerifyEmail",
    ],
    "savingsplans": [
        "CreateSavingsPlan",
        "DescribeSavingsPlanRates",
        "DescribeSavingsPlans",
        "DescribeSavingsPlansOfferingRates",
        "DescribeSavingsPlansOfferings",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
    ],
    "secretsmanager": [
        "CancelRotateSecret",
        "CreateSecret",
        "DeleteResourcePolicy",
        "DeleteSecret",
        "DescribeSecret",
        "GetRandomPassword",
        "GetResourcePolicy",
        "GetSecretValue",
        "ListSecretVersionIds",
        "ListSecrets",
        "PutResourcePolicy",
        "PutSecretValue",
        "RestoreSecret",
        "RotateSecret",
        "TagResource",
        "UntagResource",
        "UpdateSecret",
        "UpdateSecretVersionStage",
    ],
    "securityhub": [
        "AcceptInvitation",
        "BatchDisableStandards",
        "BatchEnableStandards",
        "BatchImportFindings",
        "CreateActionTarget",
        "CreateInsight",
        "CreateMembers",
        "DeclineInvitations",
        "DeleteActionTarget",
        "DeleteInsight",
        "DeleteInvitations",
        "DeleteMembers",
        "DescribeActionTargets",
        "DescribeHub",
        "DescribeProducts",
        "DescribeStandards",
        "DescribeStandardsControls",
        "DisableImportFindingsForProduct",
        "DisableSecurityHub",
        "DisassociateFromMasterAccount",
        "DisassociateMembers",
        "EnableImportFindingsForProduct",
        "EnableSecurityHub",
        "GetEnabledStandards",
        "GetFindings",
        "GetInsightResults",
        "GetInsights",
        "GetInvitationsCount",
        "GetMasterAccount",
        "GetMembers",
        "InviteMembers",
        "ListEnabledProductsForImport",
        "ListInvitations",
        "ListMembers",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateActionTarget",
        "UpdateFindings",
        "UpdateInsight",
        "UpdateStandardsControl",
    ],
    "sts": [
        "AssumeRole",
        "AssumeRoleWithSAML",
        "AssumeRoleWithWebIdentity",
        "DecodeAuthorizationMessage",
        "GetAccessKeyInfo",
        "GetCallerIdentity",
        "GetFederationToken",
        "GetSessionToken",
        "TagSession",
    ],
    "sms": [
        "CreateApp",
        "CreateReplicationJob",
        "DeleteApp",
        "DeleteAppLaunchConfiguration",
        "DeleteAppReplicationConfiguration",
        "DeleteReplicationJob",
        "DeleteServerCatalog",
        "DisassociateConnector",
        "GenerateChangeSet",
        "GenerateTemplate",
        "GetApp",
        "GetAppLaunchConfiguration",
        "GetAppReplicationConfiguration",
        "GetConnectors",
        "GetMessages",
        "GetReplicationJobs",
        "GetReplicationRuns",
        "GetServers",
        "ImportServerCatalog",
        "LaunchApp",
        "ListApps",
        "PutAppLaunchConfiguration",
        "PutAppReplicationConfiguration",
        "SendMessage",
        "StartAppReplication",
        "StartOnDemandReplicationRun",
        "StopAppReplication",
        "TerminateApp",
        "UpdateApp",
        "UpdateReplicationJob",
    ],
    "serverlessrepo": [
        "CreateApplication",
        "CreateApplicationVersion",
        "CreateCloudFormationChangeSet",
        "CreateCloudFormationTemplate",
        "DeleteApplication",
        "GetApplication",
        "GetApplicationPolicy",
        "GetCloudFormationTemplate",
        "ListApplicationDependencies",
        "ListApplicationVersions",
        "ListApplications",
        "PutApplicationPolicy",
        "SearchApplications",
        "UnshareApplication",
        "UpdateApplication",
    ],
    "servicecatalog": [
        "AcceptPortfolioShare",
        "AssociateBudgetWithResource",
        "AssociatePrincipalWithPortfolio",
        "AssociateProductWithPortfolio",
        "AssociateServiceActionWithProvisioningArtifact",
        "AssociateTagOptionWithResource",
        "BatchAssociateServiceActionWithProvisioningArtifact",
        "BatchDisassociateServiceActionFromProvisioningArtifact",
        "CopyProduct",
        "CreateConstraint",
        "CreatePortfolio",
        "CreatePortfolioShare",
        "CreateProduct",
        "CreateProvisionedProductPlan",
        "CreateProvisioningArtifact",
        "CreateServiceAction",
        "CreateTagOption",
        "DeleteConstraint",
        "DeletePortfolio",
        "DeletePortfolioShare",
        "DeleteProduct",
        "DeleteProvisionedProductPlan",
        "DeleteProvisioningArtifact",
        "DeleteServiceAction",
        "DeleteTagOption",
        "DescribeConstraint",
        "DescribeCopyProductStatus",
        "DescribePortfolio",
        "DescribePortfolioShareStatus",
        "DescribeProduct",
        "DescribeProductAsAdmin",
        "DescribeProductView",
        "DescribeProvisionedProduct",
        "DescribeProvisionedProductPlan",
        "DescribeProvisioningArtifact",
        "DescribeProvisioningParameters",
        "DescribeRecord",
        "DescribeServiceAction",
        "DescribeServiceActionExecutionParameters",
        "DescribeTagOption",
        "DisableAWSOrganizationsAccess",
        "DisassociateBudgetFromResource",
        "DisassociatePrincipalFromPortfolio",
        "DisassociateProductFromPortfolio",
        "DisassociateServiceActionFromProvisioningArtifact",
        "DisassociateTagOptionFromResource",
        "EnableAWSOrganizationsAccess",
        "ExecuteProvisionedProductPlan",
        "ExecuteProvisionedProductServiceAction",
        "GetAWSOrganizationsAccessStatus",
        "ListAcceptedPortfolioShares",
        "ListBudgetsForResource",
        "ListConstraintsForPortfolio",
        "ListLaunchPaths",
        "ListOrganizationPortfolioAccess",
        "ListPortfolioAccess",
        "ListPortfolios",
        "ListPortfoliosForProduct",
        "ListPrincipalsForPortfolio",
        "ListProvisionedProductPlans",
        "ListProvisioningArtifacts",
        "ListProvisioningArtifactsForServiceAction",
        "ListRecordHistory",
        "ListResourcesForTagOption",
        "ListServiceActions",
        "ListServiceActionsForProvisioningArtifact",
        "ListStackInstancesForProvisionedProduct",
        "ListTagOptions",
        "ProvisionProduct",
        "RejectPortfolioShare",
        "ScanProvisionedProducts",
        "SearchProducts",
        "SearchProductsAsAdmin",
        "SearchProvisionedProducts",
        "TerminateProvisionedProduct",
        "UpdateConstraint",
        "UpdatePortfolio",
        "UpdateProduct",
        "UpdateProvisionedProduct",
        "UpdateProvisionedProductProperties",
        "UpdateProvisioningArtifact",
        "UpdateServiceAction",
        "UpdateTagOption",
    ],
    "shield": [
        "AssociateDRTLogBucket",
        "AssociateDRTRole",
        "CreateProtection",
        "CreateSubscription",
        "DeleteProtection",
        "DeleteSubscription",
        "DescribeAttack",
        "DescribeDRTAccess",
        "DescribeEmergencyContactSettings",
        "DescribeProtection",
        "DescribeSubscription",
        "DisassociateDRTLogBucket",
        "DisassociateDRTRole",
        "GetSubscriptionState",
        "ListAttacks",
        "ListProtections",
        "UpdateEmergencyContactSettings",
        "UpdateSubscription",
    ],
    "snowball": [
        "CancelCluster",
        "CancelJob",
        "CreateAddress",
        "CreateCluster",
        "CreateJob",
        "DescribeAddress",
        "DescribeAddresses",
        "DescribeCluster",
        "DescribeJob",
        "GetJobManifest",
        "GetJobUnlockCode",
        "GetSnowballUsage",
        "ListClusterJobs",
        "ListClusters",
        "ListJobs",
        "UpdateCluster",
        "UpdateJob",
    ],
    "states": [
        "CreateActivity",
        "CreateStateMachine",
        "DeleteActivity",
        "DeleteStateMachine",
        "DescribeActivity",
        "DescribeExecution",
        "DescribeStateMachine",
        "DescribeStateMachineForExecution",
        "GetActivityTask",
        "GetExecutionHistory",
        "ListActivities",
        "ListExecutions",
        "ListStateMachines",
        "ListTagsForResource",
        "SendTaskFailure",
        "SendTaskHeartbeat",
        "SendTaskSuccess",
        "StartExecution",
        "StopExecution",
        "TagResource",
        "UntagResource",
        "UpdateStateMachine",
    ],
    "support": [
        "AddAttachmentsToSet",
        "AddCommunicationToCase",
        "CreateCase",
        "DescribeAttachment",
        "DescribeCaseAttributes",
        "DescribeCases",
        "DescribeCommunications",
        "DescribeIssueTypes",
        "DescribeServices",
        "DescribeSeverityLevels",
        "DescribeSupportLevel",
        "DescribeTrustedAdvisorCheckRefreshStatuses",
        "DescribeTrustedAdvisorCheckResult",
        "DescribeTrustedAdvisorCheckSummaries",
        "DescribeTrustedAdvisorChecks",
        "InitiateCallForCase",
        "InitiateChatForCase",
        "PutCaseAttributes",
        "RateCaseCommunication",
        "RefreshTrustedAdvisorCheck",
        "ResolveCase",
        "SearchForCases",
    ],
    "ssm": [
        "AddTagsToResource",
        "CancelCommand",
        "CancelMaintenanceWindowExecution",
        "CreateActivation",
        "CreateAssociation",
        "CreateAssociationBatch",
        "CreateDocument",
        "CreateMaintenanceWindow",
        "CreateOpsItem",
        "CreatePatchBaseline",
        "CreateResourceDataSync",
        "DeleteActivation",
        "DeleteAssociation",
        "DeleteDocument",
        "DeleteInventory",
        "DeleteMaintenanceWindow",
        "DeleteParameter",
        "DeleteParameters",
        "DeletePatchBaseline",
        "DeleteResourceDataSync",
        "DeregisterManagedInstance",
        "DeregisterPatchBaselineForPatchGroup",
        "DeregisterTargetFromMaintenanceWindow",
        "DeregisterTaskFromMaintenanceWindow",
        "DescribeActivations",
        "DescribeAssociation",
        "DescribeAssociationExecutionTargets",
        "DescribeAssociationExecutions",
        "DescribeAutomationExecutions",
        "DescribeAutomationStepExecutions",
        "DescribeAvailablePatches",
        "DescribeDocument",
        "DescribeDocumentParameters",
        "DescribeDocumentPermission",
        "DescribeEffectiveInstanceAssociations",
        "DescribeEffectivePatchesForPatchBaseline",
        "DescribeInstanceAssociationsStatus",
        "DescribeInstanceInformation",
        "DescribeInstancePatchStates",
        "DescribeInstancePatchStatesForPatchGroup",
        "DescribeInstancePatches",
        "DescribeInstanceProperties",
        "DescribeInventoryDeletions",
        "DescribeMaintenanceWindowExecutionTaskInvocations",
        "DescribeMaintenanceWindowExecutionTasks",
        "DescribeMaintenanceWindowExecutions",
        "DescribeMaintenanceWindowSchedule",
        "DescribeMaintenanceWindowTargets",
        "DescribeMaintenanceWindowTasks",
        "DescribeMaintenanceWindows",
        "DescribeMaintenanceWindowsForTarget",
        "DescribeOpsItems",
        "DescribeParameters",
        "DescribePatchBaselines",
        "DescribePatchGroupState",
        "DescribePatchGroups",
        "DescribePatchProperties",
        "DescribeSessions",
        "GetAutomationExecution",
        "GetCommandInvocation",
        "GetConnectionStatus",
        "GetDefaultPatchBaseline",
        "GetDeployablePatchSnapshotForInstance",
        "GetDocument",
        "GetInventory",
        "GetInventorySchema",
        "GetMaintenanceWindow",
        "GetMaintenanceWindowExecution",
        "GetMaintenanceWindowExecutionTask",
        "GetMaintenanceWindowExecutionTaskInvocation",
        "GetMaintenanceWindowTask",
        "GetManifest",
        "GetOpsItem",
        "GetOpsSummary",
        "GetParameter",
        "GetParameterHistory",
        "GetParameters",
        "GetParametersByPath",
        "GetPatchBaseline",
        "GetPatchBaselineForPatchGroup",
        "GetServiceSetting",
        "LabelParameterVersion",
        "ListAssociationVersions",
        "ListAssociations",
        "ListCommandInvocations",
        "ListCommands",
        "ListComplianceItems",
        "ListComplianceSummaries",
        "ListDocumentVersions",
        "ListDocuments",
        "ListInstanceAssociations",
        "ListInventoryEntries",
        "ListResourceComplianceSummaries",
        "ListResourceDataSync",
        "ListTagsForResource",
        "ModifyDocumentPermission",
        "PutComplianceItems",
        "PutConfigurePackageResult",
        "PutInventory",
        "PutParameter",
        "RegisterDefaultPatchBaseline",
        "RegisterPatchBaselineForPatchGroup",
        "RegisterTargetWithMaintenanceWindow",
        "RegisterTaskWithMaintenanceWindow",
        "RemoveTagsFromResource",
        "ResetServiceSetting",
        "ResumeSession",
        "SendAutomationSignal",
        "SendCommand",
        "StartAssociationsOnce",
        "StartAutomationExecution",
        "StartSession",
        "StopAutomationExecution",
        "TerminateSession",
        "UpdateAssociation",
        "UpdateAssociationStatus",
        "UpdateDocument",
        "UpdateDocumentDefaultVersion",
        "UpdateInstanceAssociationStatus",
        "UpdateInstanceInformation",
        "UpdateMaintenanceWindow",
        "UpdateMaintenanceWindowTarget",
        "UpdateMaintenanceWindowTask",
        "UpdateManagedInstanceRole",
        "UpdateOpsItem",
        "UpdatePatchBaseline",
        "UpdateResourceDataSync",
        "UpdateServiceSetting",
    ],
    "transfer": [
        "CreateServer",
        "CreateUser",
        "DeleteServer",
        "DeleteSshPublicKey",
        "DeleteUser",
        "DescribeServer",
        "DescribeUser",
        "ImportSshPublicKey",
        "ListServers",
        "ListTagsForResource",
        "ListUsers",
        "StartServer",
        "StopServer",
        "TagResource",
        "TestIdentityProvider",
        "UntagResource",
        "UpdateServer",
        "UpdateUser",
    ],
    "trustedadvisor": [
        "DescribeAccount",
        "DescribeAccountAccess",
        "DescribeCheckItems",
        "DescribeCheckRefreshStatuses",
        "DescribeCheckSummaries",
        "DescribeChecks",
        "DescribeNotificationPreferences",
        "ExcludeCheckItems",
        "IncludeCheckItems",
        "RefreshCheck",
        "SetAccountAccess",
        "UpdateNotificationPreferences",
    ],
    "waf": [
        "CreateByteMatchSet",
        "CreateGeoMatchSet",
        "CreateIPSet",
        "CreateRateBasedRule",
        "CreateRegexMatchSet",
        "CreateRegexPatternSet",
        "CreateRule",
        "CreateRuleGroup",
        "CreateSizeConstraintSet",
        "CreateSqlInjectionMatchSet",
        "CreateWebACL",
        "CreateXssMatchSet",
        "DeleteByteMatchSet",
        "DeleteGeoMatchSet",
        "DeleteIPSet",
        "DeleteLoggingConfiguration",
        "DeletePermissionPolicy",
        "DeleteRateBasedRule",
        "DeleteRegexMatchSet",
        "DeleteRegexPatternSet",
        "DeleteRule",
        "DeleteRuleGroup",
        "DeleteSizeConstraintSet",
        "DeleteSqlInjectionMatchSet",
        "DeleteWebACL",
        "DeleteXssMatchSet",
        "GetByteMatchSet",
        "GetChangeToken",
        "GetChangeTokenStatus",
        "GetGeoMatchSet",
        "GetIPSet",
        "GetLoggingConfiguration",
        "GetPermissionPolicy",
        "GetRateBasedRule",
        "GetRateBasedRuleManagedKeys",
        "GetRegexMatchSet",
        "GetRegexPatternSet",
        "GetRule",
        "GetRuleGroup",
        "GetSampledRequests",
        "GetSizeConstraintSet",
        "GetSqlInjectionMatchSet",
        "GetWebACL",
        "GetXssMatchSet",
        "ListActivatedRulesInRuleGroup",
        "ListByteMatchSets",
        "ListGeoMatchSets",
        "ListIPSets",
        "ListLoggingConfigurations",
        "ListRateBasedRules",
        "ListRegexMatchSets",
        "ListRegexPatternSets",
        "ListRuleGroups",
        "ListRules",
        "ListSizeConstraintSets",
        "ListSqlInjectionMatchSets",
        "ListSubscribedRuleGroups",
        "ListTagsForResource",
        "ListWebACLs",
        "ListXssMatchSets",
        "PutLoggingConfiguration",
        "PutPermissionPolicy",
        "TagResource",
        "UntagResource",
        "UpdateByteMatchSet",
        "UpdateGeoMatchSet",
        "UpdateIPSet",
        "UpdateRateBasedRule",
        "UpdateRegexMatchSet",
        "UpdateRegexPatternSet",
        "UpdateRule",
        "UpdateRuleGroup",
        "UpdateSizeConstraintSet",
        "UpdateSqlInjectionMatchSet",
        "UpdateWebACL",
        "UpdateXssMatchSet",
    ],
    "waf-regional": [
        "AssociateWebACL",
        "CreateByteMatchSet",
        "CreateGeoMatchSet",
        "CreateIPSet",
        "CreateRateBasedRule",
        "CreateRegexMatchSet",
        "CreateRegexPatternSet",
        "CreateRule",
        "CreateRuleGroup",
        "CreateSizeConstraintSet",
        "CreateSqlInjectionMatchSet",
        "CreateWebACL",
        "CreateXssMatchSet",
        "DeleteByteMatchSet",
        "DeleteGeoMatchSet",
        "DeleteIPSet",
        "DeleteLoggingConfiguration",
        "DeletePermissionPolicy",
        "DeleteRateBasedRule",
        "DeleteRegexMatchSet",
        "DeleteRegexPatternSet",
        "DeleteRule",
        "DeleteRuleGroup",
        "DeleteSizeConstraintSet",
        "DeleteSqlInjectionMatchSet",
        "DeleteWebACL",
        "DeleteXssMatchSet",
        "DisassociateWebACL",
        "GetByteMatchSet",
        "GetChangeToken",
        "GetChangeTokenStatus",
        "GetGeoMatchSet",
        "GetIPSet",
        "GetLoggingConfiguration",
        "GetPermissionPolicy",
        "GetRateBasedRule",
        "GetRateBasedRuleManagedKeys",
        "GetRegexMatchSet",
        "GetRegexPatternSet",
        "GetRule",
        "GetRuleGroup",
        "GetSampledRequests",
        "GetSizeConstraintSet",
        "GetSqlInjectionMatchSet",
        "GetWebACL",
        "GetWebACLForResource",
        "GetXssMatchSet",
        "ListActivatedRulesInRuleGroup",
        "ListByteMatchSets",
        "ListGeoMatchSets",
        "ListIPSets",
        "ListLoggingConfigurations",
        "ListRateBasedRules",
        "ListRegexMatchSets",
        "ListRegexPatternSets",
        "ListResourcesForWebACL",
        "ListRuleGroups",
        "ListRules",
        "ListSizeConstraintSets",
        "ListSqlInjectionMatchSets",
        "ListSubscribedRuleGroups",
        "ListTagsForResource",
        "ListWebACLs",
        "ListXssMatchSets",
        "PutLoggingConfiguration",
        "PutPermissionPolicy",
        "TagResource",
        "UntagResource",
        "UpdateByteMatchSet",
        "UpdateGeoMatchSet",
        "UpdateIPSet",
        "UpdateRateBasedRule",
        "UpdateRegexMatchSet",
        "UpdateRegexPatternSet",
        "UpdateRule",
        "UpdateRuleGroup",
        "UpdateSizeConstraintSet",
        "UpdateSqlInjectionMatchSet",
        "UpdateWebACL",
        "UpdateXssMatchSet",
    ],
    "wafv2": [
        "AssociateWebACL",
        "CheckCapacity",
        "CreateIPSet",
        "CreateRegexPatternSet",
        "CreateRuleGroup",
        "CreateWebACL",
        "DeleteIPSet",
        "DeleteLoggingConfiguration",
        "DeleteRegexPatternSet",
        "DeleteRuleGroup",
        "DeleteWebACL",
        "DescribeManagedRuleGroup",
        "DisassociateWebACL",
        "GetIPSet",
        "GetLoggingConfiguration",
        "GetRateBasedStatementManagedKeys",
        "GetRegexPatternSet",
        "GetRuleGroup",
        "GetSampledRequests",
        "GetWebACL",
        "GetWebACLForResource",
        "ListAvailableManagedRuleGroups",
        "ListIPSets",
        "ListLoggingConfigurations",
        "ListRegexPatternSets",
        "ListResourcesForWebACL",
        "ListRuleGroups",
        "ListTagsForResource",
        "ListWebACLs",
        "PutLoggingConfiguration",
        "TagResource",
        "UntagResource",
        "UpdateIPSet",
        "UpdateRegexPatternSet",
        "UpdateRuleGroup",
        "UpdateWebACL",
    ],
    "wellarchitected": [
        "CreateWorkload",
        "CreateWorkloadShare",
        "DeleteWorkload",
        "GetWorkload",
        "ListWorkloads",
    ],
    "xray": [
        "BatchGetTraces",
        "CreateGroup",
        "CreateSamplingRule",
        "DeleteGroup",
        "DeleteSamplingRule",
        "GetEncryptionConfig",
        "GetGroup",
        "GetGroups",
        "GetSamplingRules",
        "GetSamplingStatisticSummaries",
        "GetSamplingTargets",
        "GetServiceGraph",
        "GetTimeSeriesServiceStatistics",
        "GetTraceGraph",
        "GetTraceSummaries",
        "PutEncryptionConfig",
        "PutTelemetryRecords",
        "PutTraceSegments",
        "UpdateGroup",
        "UpdateSamplingRule",
    ],
    "a4b": [
        "ApproveSkill",
        "AssociateContactWithAddressBook",
        "AssociateDeviceWithRoom",
        "AssociateSkillGroupWithRoom",
        "AssociateSkillWithSkillGroup",
        "AssociateSkillWithUsers",
        "CompleteRegistration",
        "CreateAddressBook",
        "CreateBusinessReportSchedule",
        "CreateConferenceProvider",
        "CreateContact",
        "CreateProfile",
        "CreateRoom",
        "CreateSkillGroup",
        "CreateUser",
        "DeleteAddressBook",
        "DeleteBusinessReportSchedule",
        "DeleteConferenceProvider",
        "DeleteContact",
        "DeleteDevice",
        "DeleteProfile",
        "DeleteRoom",
        "DeleteRoomSkillParameter",
        "DeleteSkillAuthorization",
        "DeleteSkillGroup",
        "DeleteUser",
        "DisassociateContactFromAddressBook",
        "DisassociateDeviceFromRoom",
        "DisassociateSkillFromSkillGroup",
        "DisassociateSkillFromUsers",
        "DisassociateSkillGroupFromRoom",
        "ForgetSmartHomeAppliances",
        "GetAddressBook",
        "GetConferencePreference",
        "GetConferenceProvider",
        "GetContact",
        "GetDevice",
        "GetNetworkProfile",
        "GetProfile",
        "GetRoom",
        "GetRoomSkillParameter",
        "GetSkillGroup",
        "ListBusinessReportSchedules",
        "ListConferenceProviders",
        "ListDeviceEvents",
        "ListSkills",
        "ListSkillsStoreCategories",
        "ListSkillsStoreSkillsByCategory",
        "ListSmartHomeAppliances",
        "ListTags",
        "PutConferencePreference",
        "PutDeviceSetupEvents",
        "PutRoomSkillParameter",
        "PutSkillAuthorization",
        "RegisterAVSDevice",
        "RegisterDevice",
        "RejectSkill",
        "ResolveRoom",
        "RevokeInvitation",
        "SearchAddressBooks",
        "SearchContacts",
        "SearchDevices",
        "SearchNetworkProfiles",
        "SearchProfiles",
        "SearchRooms",
        "SearchSkillGroups",
        "SearchUsers",
        "SendInvitation",
        "StartDeviceSync",
        "StartSmartHomeApplianceDiscovery",
        "TagResource",
        "UntagResource",
        "UpdateAddressBook",
        "UpdateBusinessReportSchedule",
        "UpdateConferenceProvider",
        "UpdateContact",
        "UpdateDevice",
        "UpdateProfile",
        "UpdateRoom",
        "UpdateSkillGroup",
    ],
    "execute-api": ["InvalidateCache", "Invoke", "ManageConnections"],
    "appstream": [
        "AssociateFleet",
        "BatchAssociateUserStack",
        "BatchDisassociateUserStack",
        "CopyImage",
        "CreateDirectoryConfig",
        "CreateFleet",
        "CreateImageBuilder",
        "CreateImageBuilderStreamingURL",
        "CreateStack",
        "CreateStreamingURL",
        "CreateUsageReportSubscription",
        "CreateUser",
        "DeleteDirectoryConfig",
        "DeleteFleet",
        "DeleteImage",
        "DeleteImageBuilder",
        "DeleteImagePermissions",
        "DeleteStack",
        "DeleteUsageReportSubscription",
        "DeleteUser",
        "DescribeDirectoryConfigs",
        "DescribeFleets",
        "DescribeImageBuilders",
        "DescribeImagePermissions",
        "DescribeImages",
        "DescribeSessions",
        "DescribeStacks",
        "DescribeUsageReportSubscriptions",
        "DescribeUserStackAssociations",
        "DescribeUsers",
        "DisableUser",
        "DisassociateFleet",
        "EnableUser",
        "ExpireSession",
        "GetImageBuilders",
        "GetParametersForThemeAssetUpload",
        "ListAssociatedFleets",
        "ListAssociatedStacks",
        "ListTagsForResource",
        "StartFleet",
        "StartImageBuilder",
        "StopFleet",
        "StopImageBuilder",
        "Stream",
        "TagResource",
        "UntagResource",
        "UpdateDirectoryConfig",
        "UpdateFleet",
        "UpdateImagePermissions",
        "UpdateStack",
    ],
    "athena": [
        "BatchGetNamedQuery",
        "BatchGetQueryExecution",
        "CancelQueryExecution",
        "CreateNamedQuery",
        "CreateWorkGroup",
        "DeleteNamedQuery",
        "DeleteWorkGroup",
        "GetCatalogs",
        "GetExecutionEngine",
        "GetExecutionEngines",
        "GetNamedQuery",
        "GetNamespace",
        "GetNamespaces",
        "GetQueryExecution",
        "GetQueryExecutions",
        "GetQueryResults",
        "GetQueryResultsStream",
        "GetTable",
        "GetTables",
        "GetWorkGroup",
        "ListNamedQueries",
        "ListQueryExecutions",
        "ListTagsForResource",
        "ListWorkGroups",
        "RunQuery",
        "StartQueryExecution",
        "StopQueryExecution",
        "TagResource",
        "UntagResource",
        "UpdateWorkGroup",
    ],
    "chime": [
        "AcceptDelegate",
        "ActivateUsers",
        "AddDomain",
        "AddOrUpdateGroups",
        "AssociatePhoneNumberWithUser",
        "AssociatePhoneNumbersWithVoiceConnector",
        "AssociatePhoneNumbersWithVoiceConnectorGroup",
        "AssociateSigninDelegateGroupsWithAccount",
        "AuthorizeDirectory",
        "BatchCreateAttendee",
        "BatchCreateRoomMembership",
        "BatchDeletePhoneNumber",
        "BatchSuspendUser",
        "BatchUnsuspendUser",
        "BatchUpdatePhoneNumber",
        "BatchUpdateUser",
        "ConnectDirectory",
        "CreateAccount",
        "CreateApiKey",
        "CreateAttendee",
        "CreateBot",
        "CreateBotMembership",
        "CreateCDRBucket",
        "CreateMeeting",
        "CreatePhoneNumberOrder",
        "CreateRoom",
        "CreateRoomMembership",
        "CreateUser",
        "CreateVoiceConnector",
        "CreateVoiceConnectorGroup",
        "DeleteAccount",
        "DeleteAccountOpenIdConfig",
        "DeleteApiKey",
        "DeleteAttendee",
        "DeleteCDRBucket",
        "DeleteDelegate",
        "DeleteDomain",
        "DeleteEventsConfiguration",
        "DeleteGroups",
        "DeleteMeeting",
        "DeletePhoneNumber",
        "DeleteRoom",
        "DeleteRoomMembership",
        "DeleteVoiceConnector",
        "DeleteVoiceConnectorGroup",
        "DeleteVoiceConnectorOrigination",
        "DeleteVoiceConnectorStreamingConfiguration",
        "DeleteVoiceConnectorTermination",
        "DeleteVoiceConnectorTerminationCredentials",
        "DisassociatePhoneNumberFromUser",
        "DisassociatePhoneNumbersFromVoiceConnector",
        "DisassociatePhoneNumbersFromVoiceConnectorGroup",
        "DisassociateSigninDelegateGroupsFromAccount",
        "DisconnectDirectory",
        "GetAccount",
        "GetAccountResource",
        "GetAccountSettings",
        "GetAccountWithOpenIdConfig",
        "GetAttendee",
        "GetBot",
        "GetCDRBucket",
        "GetDomain",
        "GetEventsConfiguration",
        "GetGlobalSettings",
        "GetMeeting",
        "GetMeetingDetail",
        "GetPhoneNumber",
        "GetPhoneNumberOrder",
        "GetPhoneNumberSettings",
        "GetRoom",
        "GetTelephonyLimits",
        "GetUser",
        "GetUserActivityReportData",
        "GetUserByEmail",
        "GetUserSettings",
        "GetVoiceConnector",
        "GetVoiceConnectorGroup",
        "GetVoiceConnectorLoggingConfiguration",
        "GetVoiceConnectorOrigination",
        "GetVoiceConnectorStreamingConfiguration",
        "GetVoiceConnectorTermination",
        "GetVoiceConnectorTerminationHealth",
        "InviteDelegate",
        "InviteUsers",
        "InviteUsersFromProvider",
        "ListAccountUsageReportData",
        "ListAccounts",
        "ListApiKeys",
        "ListAttendees",
        "ListBots",
        "ListCDRBucket",
        "ListCallingRegions",
        "ListDelegates",
        "ListDirectories",
        "ListDomains",
        "ListGroups",
        "ListMeetingEvents",
        "ListMeetings",
        "ListMeetingsReportData",
        "ListPhoneNumberOrders",
        "ListPhoneNumbers",
        "ListRoomMemberships",
        "ListRooms",
        "ListUsers",
        "ListVoiceConnectorGroups",
        "ListVoiceConnectorTerminationCredentials",
        "ListVoiceConnectors",
        "LogoutUser",
        "PutEventsConfiguration",
        "PutVoiceConnectorLoggingConfiguration",
        "PutVoiceConnectorOrigination",
        "PutVoiceConnectorStreamingConfiguration",
        "PutVoiceConnectorTermination",
        "PutVoiceConnectorTerminationCredentials",
        "RegenerateSecurityToken",
        "RenameAccount",
        "RenewDelegate",
        "ResetAccountResource",
        "ResetPersonalPIN",
        "RestorePhoneNumber",
        "RetrieveDataExports",
        "SearchAvailablePhoneNumbers",
        "StartDataExport",
        "SubmitSupportRequest",
        "SuspendUsers",
        "UnauthorizeDirectory",
        "UpdateAccount",
        "UpdateAccountOpenIdConfig",
        "UpdateAccountResource",
        "UpdateAccountSettings",
        "UpdateBot",
        "UpdateCDRSettings",
        "UpdateGlobalSettings",
        "UpdatePhoneNumber",
        "UpdatePhoneNumberSettings",
        "UpdateRoom",
        "UpdateRoomMembership",
        "UpdateSupportedLicenses",
        "UpdateUser",
        "UpdateUserLicenses",
        "UpdateUserSettings",
        "UpdateVoiceConnector",
        "UpdateVoiceConnectorGroup",
        "ValidateAccountResource",
    ],
    "clouddirectory": [
        "AddFacetToObject",
        "ApplySchema",
        "AttachObject",
        "AttachPolicy",
        "AttachToIndex",
        "AttachTypedLink",
        "BatchRead",
        "BatchWrite",
        "CreateDirectory",
        "CreateFacet",
        "CreateIndex",
        "CreateObject",
        "CreateSchema",
        "CreateTypedLinkFacet",
        "DeleteDirectory",
        "DeleteFacet",
        "DeleteObject",
        "DeleteSchema",
        "DeleteTypedLinkFacet",
        "DetachFromIndex",
        "DetachObject",
        "DetachPolicy",
        "DetachTypedLink",
        "DisableDirectory",
        "EnableDirectory",
        "GetDirectory",
        "GetFacet",
        "GetLinkAttributes",
        "GetObjectAttributes",
        "GetObjectInformation",
        "GetSchemaAsJson",
        "GetTypedLinkFacetInformation",
        "ListAppliedSchemaArns",
        "ListAttachedIndices",
        "ListDevelopmentSchemaArns",
        "ListDirectories",
        "ListFacetAttributes",
        "ListFacetNames",
        "ListIncomingTypedLinks",
        "ListIndex",
        "ListObjectAttributes",
        "ListObjectChildren",
        "ListObjectParentPaths",
        "ListObjectParents",
        "ListObjectPolicies",
        "ListOutgoingTypedLinks",
        "ListPolicyAttachments",
        "ListPublishedSchemaArns",
        "ListTagsForResource",
        "ListTypedLinkFacetAttributes",
        "ListTypedLinkFacetNames",
        "LookupPolicy",
        "PublishSchema",
        "PutSchemaFromJson",
        "RemoveFacetFromObject",
        "TagResource",
        "UntagResource",
        "UpdateFacet",
        "UpdateLinkAttributes",
        "UpdateObjectAttributes",
        "UpdateSchema",
        "UpdateTypedLinkFacet",
    ],
    "cloudfront": [
        "CreateCloudFrontOriginAccessIdentity",
        "CreateDistribution",
        "CreateDistributionWithTags",
        "CreateFieldLevelEncryptionConfig",
        "CreateFieldLevelEncryptionProfile",
        "CreateInvalidation",
        "CreatePublicKey",
        "CreateStreamingDistribution",
        "CreateStreamingDistributionWithTags",
        "DeleteCloudFrontOriginAccessIdentity",
        "DeleteDistribution",
        "DeleteFieldLevelEncryptionConfig",
        "DeleteFieldLevelEncryptionProfile",
        "DeletePublicKey",
        "DeleteStreamingDistribution",
        "GetCloudFrontOriginAccessIdentity",
        "GetCloudFrontOriginAccessIdentityConfig",
        "GetDistribution",
        "GetDistributionConfig",
        "GetFieldLevelEncryption",
        "GetFieldLevelEncryptionConfig",
        "GetFieldLevelEncryptionProfile",
        "GetFieldLevelEncryptionProfileConfig",
        "GetInvalidation",
        "GetPublicKey",
        "GetPublicKeyConfig",
        "GetStreamingDistribution",
        "GetStreamingDistributionConfig",
        "ListCloudFrontOriginAccessIdentities",
        "ListDistributions",
        "ListDistributionsByWebACLId",
        "ListFieldLevelEncryptionConfigs",
        "ListFieldLevelEncryptionProfiles",
        "ListInvalidations",
        "ListPublicKeys",
        "ListStreamingDistributions",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateCloudFrontOriginAccessIdentity",
        "UpdateDistribution",
        "UpdateFieldLevelEncryptionConfig",
        "UpdateFieldLevelEncryptionProfile",
        "UpdatePublicKey",
        "UpdateStreamingDistribution",
    ],
    "cloudsearch": [
        "AddTags",
        "BuildSuggesters",
        "CreateDomain",
        "DefineAnalysisScheme",
        "DefineExpression",
        "DefineIndexField",
        "DefineSuggester",
        "DeleteAnalysisScheme",
        "DeleteDomain",
        "DeleteExpression",
        "DeleteIndexField",
        "DeleteSuggester",
        "DescribeAnalysisSchemes",
        "DescribeAvailabilityOptions",
        "DescribeDomainEndpointOptions",
        "DescribeDomains",
        "DescribeExpressions",
        "DescribeIndexFields",
        "DescribeScalingParameters",
        "DescribeServiceAccessPolicies",
        "DescribeSuggesters",
        "IndexDocuments",
        "ListDomainNames",
        "ListTags",
        "RemoveTags",
        "UpdateAvailabilityOptions",
        "UpdateDomainEndpointOptions",
        "UpdateScalingParameters",
        "UpdateServiceAccessPolicies",
        "document",
        "search",
        "suggest",
    ],
    "cloudwatch": [
        "DeleteAlarms",
        "DeleteAnomalyDetector",
        "DeleteDashboards",
        "DeleteInsightRules",
        "DescribeAlarmHistory",
        "DescribeAlarms",
        "DescribeAlarmsForMetric",
        "DescribeAnomalyDetectors",
        "DescribeInsightRules",
        "DisableAlarmActions",
        "DisableInsightRules",
        "EnableAlarmActions",
        "EnableInsightRules",
        "GetDashboard",
        "GetInsightRuleReport",
        "GetMetricData",
        "GetMetricStatistics",
        "GetMetricWidgetImage",
        "ListDashboards",
        "ListMetrics",
        "ListTagsForResource",
        "PutAnomalyDetector",
        "PutDashboard",
        "PutInsightRule",
        "PutMetricAlarm",
        "PutMetricData",
        "SetAlarmState",
        "TagResource",
        "UntagResource",
    ],
    "logs": [
        "AssociateKmsKey",
        "CancelExportTask",
        "CreateExportTask",
        "CreateLogDelivery",
        "CreateLogGroup",
        "CreateLogStream",
        "DeleteDestination",
        "DeleteLogDelivery",
        "DeleteLogGroup",
        "DeleteLogStream",
        "DeleteMetricFilter",
        "DeleteResourcePolicy",
        "DeleteRetentionPolicy",
        "DeleteSubscriptionFilter",
        "DescribeDestinations",
        "DescribeExportTasks",
        "DescribeLogGroups",
        "DescribeLogStreams",
        "DescribeMetricFilters",
        "DescribeQueries",
        "DescribeResourcePolicies",
        "DescribeSubscriptionFilters",
        "DisassociateKmsKey",
        "FilterLogEvents",
        "GetLogDelivery",
        "GetLogEvents",
        "GetLogGroupFields",
        "GetLogRecord",
        "GetQueryResults",
        "ListLogDeliveries",
        "ListTagsLogGroup",
        "PutDestination",
        "PutDestinationPolicy",
        "PutLogEvents",
        "PutMetricFilter",
        "PutResourcePolicy",
        "PutRetentionPolicy",
        "PutSubscriptionFilter",
        "StartQuery",
        "StopQuery",
        "TagLogGroup",
        "TestMetricFilter",
        "UntagLogGroup",
        "UpdateLogDelivery",
    ],
    "synthetics": [
        "CreateCanary",
        "DeleteCanary",
        "DescribeCanaries",
        "DescribeTestRuns",
        "ListTagsForResource",
        "StartCanary",
        "StopCanary",
        "TagResource",
        "UntagResource",
        "UpdateCanary",
    ],
    "codeguru": ["GetCodeGuruFreeTrialSummary"],
    "codeguru-profiler": [
        "ConfigureAgent",
        "CreateProfilingGroup",
        "DeleteProfilingGroup",
        "DescribeProfilingGroup",
        "GetFindingsReport",
        "GetFindingsReportAccountSummary",
        "GetProfile",
        "ListFindingsReports",
        "ListProfileTimes",
        "ListProfilingGroups",
        "PostAgentProfile",
        "UpdateProfilingGroup",
    ],
    "codeguru-reviewer": [
        "AssociateRepository",
        "CreateConnectionToken",
        "DescribeRepositoryAssociation",
        "DisassociateRepository",
        "GetMetricsData",
        "ListRepositoryAssociations",
        "ListThirdPartyRepositories",
    ],
    "cognito-identity": [
        "CreateIdentityPool",
        "DeleteIdentities",
        "DeleteIdentityPool",
        "DescribeIdentity",
        "DescribeIdentityPool",
        "GetCredentialsForIdentity",
        "GetId",
        "GetIdentityPoolRoles",
        "GetOpenIdToken",
        "GetOpenIdTokenForDeveloperIdentity",
        "ListIdentities",
        "ListIdentityPools",
        "ListTagsForResource",
        "LookupDeveloperIdentity",
        "MergeDeveloperIdentities",
        "SetIdentityPoolRoles",
        "TagResource",
        "UnlinkDeveloperIdentity",
        "UnlinkIdentity",
        "UntagResource",
        "UpdateIdentityPool",
    ],
    "cognito-sync": [
        "BulkPublish",
        "DeleteDataset",
        "DescribeDataset",
        "DescribeIdentityPoolUsage",
        "DescribeIdentityUsage",
        "GetBulkPublishDetails",
        "GetCognitoEvents",
        "GetIdentityPoolConfiguration",
        "ListDatasets",
        "ListIdentityPoolUsage",
        "ListRecords",
        "QueryRecords",
        "RegisterDevice",
        "SetCognitoEvents",
        "SetDatasetConfiguration",
        "SetIdentityPoolConfiguration",
        "SubscribeToDataset",
        "UnsubscribeFromDataset",
        "UpdateRecords",
    ],
    "cognito-idp": [
        "AddCustomAttributes",
        "AdminAddUserToGroup",
        "AdminConfirmSignUp",
        "AdminCreateUser",
        "AdminDeleteUser",
        "AdminDeleteUserAttributes",
        "AdminDisableProviderForUser",
        "AdminDisableUser",
        "AdminEnableUser",
        "AdminForgetDevice",
        "AdminGetDevice",
        "AdminGetUser",
        "AdminInitiateAuth",
        "AdminLinkProviderForUser",
        "AdminListDevices",
        "AdminListGroupsForUser",
        "AdminListUserAuthEvents",
        "AdminRemoveUserFromGroup",
        "AdminResetUserPassword",
        "AdminRespondToAuthChallenge",
        "AdminSetUserMFAPreference",
        "AdminSetUserPassword",
        "AdminSetUserSettings",
        "AdminUpdateAuthEventFeedback",
        "AdminUpdateDeviceStatus",
        "AdminUpdateUserAttributes",
        "AdminUserGlobalSignOut",
        "AssociateSoftwareToken",
        "ChangePassword",
        "ConfirmDevice",
        "ConfirmForgotPassword",
        "ConfirmSignUp",
        "CreateGroup",
        "CreateIdentityProvider",
        "CreateResourceServer",
        "CreateUserImportJob",
        "CreateUserPool",
        "CreateUserPoolClient",
        "CreateUserPoolDomain",
        "DeleteGroup",
        "DeleteIdentityProvider",
        "DeleteResourceServer",
        "DeleteUser",
        "DeleteUserAttributes",
        "DeleteUserPool",
        "DeleteUserPoolClient",
        "DeleteUserPoolDomain",
        "DescribeIdentityProvider",
        "DescribeResourceServer",
        "DescribeRiskConfiguration",
        "DescribeUserImportJob",
        "DescribeUserPool",
        "DescribeUserPoolClient",
        "DescribeUserPoolDomain",
        "ForgetDevice",
        "ForgotPassword",
        "GetCSVHeader",
        "GetDevice",
        "GetGroup",
        "GetIdentityProviderByIdentifier",
        "GetSigningCertificate",
        "GetUICustomization",
        "GetUser",
        "GetUserAttributeVerificationCode",
        "GetUserPoolMfaConfig",
        "GlobalSignOut",
        "InitiateAuth",
        "ListDevices",
        "ListGroups",
        "ListIdentityProviders",
        "ListResourceServers",
        "ListTagsForResource",
        "ListUserImportJobs",
        "ListUserPoolClients",
        "ListUserPools",
        "ListUsers",
        "ListUsersInGroup",
        "ResendConfirmationCode",
        "RespondToAuthChallenge",
        "SetRiskConfiguration",
        "SetUICustomization",
        "SetUserMFAPreference",
        "SetUserPoolMfaConfig",
        "SetUserSettings",
        "SignUp",
        "StartUserImportJob",
        "StopUserImportJob",
        "TagResource",
        "UntagResource",
        "UpdateAuthEventFeedback",
        "UpdateDeviceStatus",
        "UpdateGroup",
        "UpdateIdentityProvider",
        "UpdateResourceServer",
        "UpdateUserAttributes",
        "UpdateUserPool",
        "UpdateUserPoolClient",
        "UpdateUserPoolDomain",
        "VerifySoftwareToken",
        "VerifyUserAttribute",
    ],
    "comprehend": [
        "BatchDetectDominantLanguage",
        "BatchDetectEntities",
        "BatchDetectKeyPhrases",
        "BatchDetectSentiment",
        "BatchDetectSyntax",
        "ClassifyDocument",
        "CreateDocumentClassifier",
        "CreateEndpoint",
        "CreateEntityRecognizer",
        "DeleteDocumentClassifier",
        "DeleteEndpoint",
        "DeleteEntityRecognizer",
        "DescribeDocumentClassificationJob",
        "DescribeDocumentClassifier",
        "DescribeDominantLanguageDetectionJob",
        "DescribeEndpoint",
        "DescribeEntitiesDetectionJob",
        "DescribeEntityRecognizer",
        "DescribeKeyPhrasesDetectionJob",
        "DescribeSentimentDetectionJob",
        "DescribeTopicsDetectionJob",
        "DetectDominantLanguage",
        "DetectEntities",
        "DetectKeyPhrases",
        "DetectSentiment",
        "DetectSyntax",
        "ListDocumentClassificationJobs",
        "ListDocumentClassifiers",
        "ListDominantLanguageDetectionJobs",
        "ListEndpoints",
        "ListEntitiesDetectionJobs",
        "ListEntityRecognizers",
        "ListKeyPhrasesDetectionJobs",
        "ListSentimentDetectionJobs",
        "ListTagsForResource",
        "ListTopicsDetectionJobs",
        "StartDocumentClassificationJob",
        "StartDominantLanguageDetectionJob",
        "StartEntitiesDetectionJob",
        "StartKeyPhrasesDetectionJob",
        "StartSentimentDetectionJob",
        "StartTopicsDetectionJob",
        "StopDominantLanguageDetectionJob",
        "StopEntitiesDetectionJob",
        "StopKeyPhrasesDetectionJob",
        "StopSentimentDetectionJob",
        "StopTrainingDocumentClassifier",
        "StopTrainingEntityRecognizer",
        "TagResource",
        "UntagResource",
        "UpdateEndpoint",
    ],
    "connect": [
        "CreateInstance",
        "CreateUser",
        "DeleteUser",
        "DescribeInstance",
        "DescribeUser",
        "DescribeUserHierarchyGroup",
        "DescribeUserHierarchyStructure",
        "DestroyInstance",
        "GetContactAttributes",
        "GetCurrentMetricData",
        "GetFederationToken",
        "GetFederationTokens",
        "GetMetricData",
        "ListContactFlows",
        "ListHoursOfOperations",
        "ListInstances",
        "ListPhoneNumbers",
        "ListQueues",
        "ListRoutingProfiles",
        "ListSecurityProfiles",
        "ListTagsForResource",
        "ListUserHierarchyGroups",
        "ListUsers",
        "ModifyInstance",
        "StartChatContact",
        "StartOutboundVoiceContact",
        "StopContact",
        "TagResource",
        "UntagResource",
        "UpdateContactAttributes",
        "UpdateUserHierarchy",
        "UpdateUserIdentityInfo",
        "UpdateUserPhoneConfig",
        "UpdateUserRoutingProfile",
        "UpdateUserSecurityProfiles",
    ],
    "dlm": [
        "CreateLifecyclePolicy",
        "DeleteLifecyclePolicy",
        "GetLifecyclePolicies",
        "GetLifecyclePolicy",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateLifecyclePolicy",
    ],
    "detective": [
        "AcceptInvitation",
        "CreateGraph",
        "CreateMembers",
        "DeleteGraph",
        "DeleteMembers",
        "DisassociateMembership",
        "GetFreeTrialEligibility",
        "GetGraphIngestState",
        "GetMembers",
        "GetPricingInformation",
        "GetUsageInformation",
        "ListGraphs",
        "ListInvitations",
        "ListMembers",
        "RejectInvitation",
        "SearchGraph",
    ],
    "dynamodb": [
        "BatchGetItem",
        "BatchWriteItem",
        "ConditionCheckItem",
        "CreateBackup",
        "CreateGlobalTable",
        "CreateTable",
        "CreateTableReplica",
        "DeleteBackup",
        "DeleteItem",
        "DeleteTable",
        "DeleteTableReplica",
        "DescribeBackup",
        "DescribeContinuousBackups",
        "DescribeContributorInsights",
        "DescribeGlobalTable",
        "DescribeGlobalTableSettings",
        "DescribeLimits",
        "DescribeReservedCapacity",
        "DescribeReservedCapacityOfferings",
        "DescribeStream",
        "DescribeTable",
        "DescribeTableReplicaAutoScaling",
        "DescribeTimeToLive",
        "GetItem",
        "GetRecords",
        "GetShardIterator",
        "ListBackups",
        "ListContributorInsights",
        "ListGlobalTables",
        "ListStreams",
        "ListTables",
        "ListTagsOfResource",
        "PurchaseReservedCapacityOfferings",
        "PutItem",
        "Query",
        "RestoreTableFromBackup",
        "RestoreTableToPointInTime",
        "Scan",
        "TagResource",
        "UntagResource",
        "UpdateContinuousBackups",
        "UpdateContributorInsights",
        "UpdateGlobalTable",
        "UpdateGlobalTableSettings",
        "UpdateItem",
        "UpdateTable",
        "UpdateTableReplicaAutoScaling",
        "UpdateTimeToLive",
    ],
    "dax": [
        "BatchGetItem",
        "BatchWriteItem",
        "ConditionCheckItem",
        "CreateCluster",
        "CreateParameterGroup",
        "CreateSubnetGroup",
        "DecreaseReplicationFactor",
        "DeleteCluster",
        "DeleteItem",
        "DeleteParameterGroup",
        "DeleteSubnetGroup",
        "DescribeClusters",
        "DescribeDefaultParameters",
        "DescribeEvents",
        "DescribeParameterGroups",
        "DescribeParameters",
        "DescribeSubnetGroups",
        "GetItem",
        "IncreaseReplicationFactor",
        "ListTags",
        "PutItem",
        "Query",
        "RebootNode",
        "Scan",
        "TagResource",
        "UntagResource",
        "UpdateCluster",
        "UpdateItem",
        "UpdateParameterGroup",
        "UpdateSubnetGroup",
    ],
    "ec2": [
        "AcceptReservedInstancesExchangeQuote",
        "AcceptTransitGatewayPeeringAttachment",
        "AcceptTransitGatewayVpcAttachment",
        "AcceptVpcEndpointConnections",
        "AcceptVpcPeeringConnection",
        "AdvertiseByoipCidr",
        "AllocateAddress",
        "AllocateHosts",
        "ApplySecurityGroupsToClientVpnTargetNetwork",
        "AssignIpv6Addresses",
        "AssignPrivateIpAddresses",
        "AssociateAddress",
        "AssociateClientVpnTargetNetwork",
        "AssociateDhcpOptions",
        "AssociateIamInstanceProfile",
        "AssociateRouteTable",
        "AssociateSubnetCidrBlock",
        "AssociateTransitGatewayMulticastDomain",
        "AssociateTransitGatewayRouteTable",
        "AssociateVpcCidrBlock",
        "AttachClassicLinkVpc",
        "AttachInternetGateway",
        "AttachNetworkInterface",
        "AttachVolume",
        "AttachVpnGateway",
        "AuthorizeClientVpnIngress",
        "AuthorizeSecurityGroupEgress",
        "AuthorizeSecurityGroupIngress",
        "BundleInstance",
        "CancelBundleTask",
        "CancelCapacityReservation",
        "CancelConversionTask",
        "CancelExportTask",
        "CancelImportTask",
        "CancelReservedInstancesListing",
        "CancelSpotFleetRequests",
        "CancelSpotInstanceRequests",
        "ConfirmProductInstance",
        "CopyFpgaImage",
        "CopyImage",
        "CopySnapshot",
        "CreateCapacityReservation",
        "CreateClientVpnEndpoint",
        "CreateClientVpnRoute",
        "CreateCustomerGateway",
        "CreateDefaultSubnet",
        "CreateDefaultVpc",
        "CreateDhcpOptions",
        "CreateEgressOnlyInternetGateway",
        "CreateFleet",
        "CreateFlowLogs",
        "CreateFpgaImage",
        "CreateImage",
        "CreateInstanceExportTask",
        "CreateInternetGateway",
        "CreateKeyPair",
        "CreateLaunchTemplate",
        "CreateLaunchTemplateVersion",
        "CreateLocalGatewayRoute",
        "CreateLocalGatewayRouteTableVpcAssociation",
        "CreateNatGateway",
        "CreateNetworkAcl",
        "CreateNetworkAclEntry",
        "CreateNetworkInterface",
        "CreateNetworkInterfacePermission",
        "CreatePlacementGroup",
        "CreateReservedInstancesListing",
        "CreateRoute",
        "CreateRouteTable",
        "CreateSecurityGroup",
        "CreateSnapshot",
        "CreateSnapshots",
        "CreateSpotDatafeedSubscription",
        "CreateSubnet",
        "CreateTags",
        "CreateTrafficMirrorFilter",
        "CreateTrafficMirrorFilterRule",
        "CreateTrafficMirrorSession",
        "CreateTrafficMirrorTarget",
        "CreateTransitGateway",
        "CreateTransitGatewayMulticastDomain",
        "CreateTransitGatewayPeeringAttachment",
        "CreateTransitGatewayRoute",
        "CreateTransitGatewayRouteTable",
        "CreateTransitGatewayVpcAttachment",
        "CreateVolume",
        "CreateVpc",
        "CreateVpcEndpoint",
        "CreateVpcEndpointConnectionNotification",
        "CreateVpcEndpointServiceConfiguration",
        "CreateVpcPeeringConnection",
        "CreateVpnConnection",
        "CreateVpnConnectionRoute",
        "CreateVpnGateway",
        "DeleteClientVpnEndpoint",
        "DeleteClientVpnRoute",
        "DeleteCustomerGateway",
        "DeleteDhcpOptions",
        "DeleteEgressOnlyInternetGateway",
        "DeleteFleets",
        "DeleteFlowLogs",
        "DeleteFpgaImage",
        "DeleteInternetGateway",
        "DeleteKeyPair",
        "DeleteLaunchTemplate",
        "DeleteLaunchTemplateVersions",
        "DeleteLocalGatewayRoute",
        "DeleteLocalGatewayRouteTableVpcAssociation",
        "DeleteNatGateway",
        "DeleteNetworkAcl",
        "DeleteNetworkAclEntry",
        "DeleteNetworkInterface",
        "DeleteNetworkInterfacePermission",
        "DeletePlacementGroup",
        "DeleteRoute",
        "DeleteRouteTable",
        "DeleteSecurityGroup",
        "DeleteSnapshot",
        "DeleteSpotDatafeedSubscription",
        "DeleteSubnet",
        "DeleteTags",
        "DeleteTrafficMirrorFilter",
        "DeleteTrafficMirrorFilterRule",
        "DeleteTrafficMirrorSession",
        "DeleteTrafficMirrorTarget",
        "DeleteTransitGateway",
        "DeleteTransitGatewayMulticastDomain",
        "DeleteTransitGatewayPeeringAttachment",
        "DeleteTransitGatewayRoute",
        "DeleteTransitGatewayRouteTable",
        "DeleteTransitGatewayVpcAttachment",
        "DeleteVolume",
        "DeleteVpc",
        "DeleteVpcEndpointConnectionNotifications",
        "DeleteVpcEndpointServiceConfigurations",
        "DeleteVpcEndpoints",
        "DeleteVpcPeeringConnection",
        "DeleteVpnConnection",
        "DeleteVpnConnectionRoute",
        "DeleteVpnGateway",
        "DeprovisionByoipCidr",
        "DeregisterImage",
        "DeregisterTransitGatewayMulticastGroupMembers",
        "DeregisterTransitGatewayMulticastGroupSources",
        "DescribeAccountAttributes",
        "DescribeAddresses",
        "DescribeAggregateIdFormat",
        "DescribeAvailabilityZones",
        "DescribeBundleTasks",
        "DescribeByoipCidrs",
        "DescribeCapacityReservations",
        "DescribeClassicLinkInstances",
        "DescribeClientVpnAuthorizationRules",
        "DescribeClientVpnConnections",
        "DescribeClientVpnEndpoints",
        "DescribeClientVpnRoutes",
        "DescribeClientVpnTargetNetworks",
        "DescribeConversionTasks",
        "DescribeCustomerGateways",
        "DescribeDhcpOptions",
        "DescribeEgressOnlyInternetGateways",
        "DescribeElasticGpus",
        "DescribeExportImageTasks",
        "DescribeExportTasks",
        "DescribeFastSnapshotRestores",
        "DescribeFleetHistory",
        "DescribeFleetInstances",
        "DescribeFleets",
        "DescribeFlowLogs",
        "DescribeFpgaImageAttribute",
        "DescribeFpgaImages",
        "DescribeHostReservationOfferings",
        "DescribeHostReservations",
        "DescribeHosts",
        "DescribeIamInstanceProfileAssociations",
        "DescribeIdFormat",
        "DescribeIdentityIdFormat",
        "DescribeImageAttribute",
        "DescribeImages",
        "DescribeImportImageTasks",
        "DescribeImportSnapshotTasks",
        "DescribeInstanceAttribute",
        "DescribeInstanceCreditSpecifications",
        "DescribeInstanceStatus",
        "DescribeInstanceTypes",
        "DescribeInstances",
        "DescribeInternetGateways",
        "DescribeKeyPairs",
        "DescribeLaunchTemplateVersions",
        "DescribeLaunchTemplates",
        "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
        "DescribeLocalGatewayRouteTableVpcAssociations",
        "DescribeLocalGatewayRouteTables",
        "DescribeLocalGatewayVirtualInterfaceGroups",
        "DescribeLocalGatewayVirtualInterfaces",
        "DescribeLocalGateways",
        "DescribeMovingAddresses",
        "DescribeNatGateways",
        "DescribeNetworkAcls",
        "DescribeNetworkInterfaceAttribute",
        "DescribeNetworkInterfacePermissions",
        "DescribeNetworkInterfaces",
        "DescribePlacementGroups",
        "DescribePrefixLists",
        "DescribePrincipalIdFormat",
        "DescribePublicIpv4Pools",
        "DescribeRegions",
        "DescribeReservedInstances",
        "DescribeReservedInstancesListings",
        "DescribeReservedInstancesModifications",
        "DescribeReservedInstancesOfferings",
        "DescribeRouteTables",
        "DescribeScheduledInstanceAvailability",
        "DescribeScheduledInstances",
        "DescribeSecurityGroupReferences",
        "DescribeSecurityGroups",
        "DescribeSnapshotAttribute",
        "DescribeSnapshots",
        "DescribeSpotDatafeedSubscription",
        "DescribeSpotFleetInstances",
        "DescribeSpotFleetRequestHistory",
        "DescribeSpotFleetRequests",
        "DescribeSpotInstanceRequests",
        "DescribeSpotPriceHistory",
        "DescribeStaleSecurityGroups",
        "DescribeSubnets",
        "DescribeTags",
        "DescribeTrafficMirrorFilters",
        "DescribeTrafficMirrorSessions",
        "DescribeTrafficMirrorTargets",
        "DescribeTransitGatewayAttachments",
        "DescribeTransitGatewayMulticastDomains",
        "DescribeTransitGatewayPeeringAttachments",
        "DescribeTransitGatewayRouteTables",
        "DescribeTransitGatewayVpcAttachments",
        "DescribeTransitGateways",
        "DescribeVolumeAttribute",
        "DescribeVolumeStatus",
        "DescribeVolumes",
        "DescribeVolumesModifications",
        "DescribeVpcAttribute",
        "DescribeVpcClassicLink",
        "DescribeVpcClassicLinkDnsSupport",
        "DescribeVpcEndpointConnectionNotifications",
        "DescribeVpcEndpointConnections",
        "DescribeVpcEndpointServiceConfigurations",
        "DescribeVpcEndpointServicePermissions",
        "DescribeVpcEndpointServices",
        "DescribeVpcEndpoints",
        "DescribeVpcPeeringConnections",
        "DescribeVpcs",
        "DescribeVpnConnections",
        "DescribeVpnGateways",
        "DetachClassicLinkVpc",
        "DetachInternetGateway",
        "DetachNetworkInterface",
        "DetachVolume",
        "DetachVpnGateway",
        "DisableEbsEncryptionByDefault",
        "DisableFastSnapshotRestores",
        "DisableTransitGatewayRouteTablePropagation",
        "DisableVgwRoutePropagation",
        "DisableVpcClassicLink",
        "DisableVpcClassicLinkDnsSupport",
        "DisassociateAddress",
        "DisassociateClientVpnTargetNetwork",
        "DisassociateIamInstanceProfile",
        "DisassociateRouteTable",
        "DisassociateSubnetCidrBlock",
        "DisassociateTransitGatewayMulticastDomain",
        "DisassociateTransitGatewayRouteTable",
        "DisassociateVpcCidrBlock",
        "EnableEbsEncryptionByDefault",
        "EnableFastSnapshotRestores",
        "EnableTransitGatewayRouteTablePropagation",
        "EnableVgwRoutePropagation",
        "EnableVolumeIO",
        "EnableVpcClassicLink",
        "EnableVpcClassicLinkDnsSupport",
        "ExportClientVpnClientCertificateRevocationList",
        "ExportClientVpnClientConfiguration",
        "ExportImage",
        "ExportTransitGatewayRoutes",
        "GetCapacityReservationUsage",
        "GetConsoleOutput",
        "GetConsoleScreenshot",
        "GetDefaultCreditSpecification",
        "GetEbsDefaultKmsKeyId",
        "GetEbsEncryptionByDefault",
        "GetHostReservationPurchasePreview",
        "GetLaunchTemplateData",
        "GetPasswordData",
        "GetReservedInstancesExchangeQuote",
        "GetTransitGatewayAttachmentPropagations",
        "GetTransitGatewayMulticastDomainAssociations",
        "GetTransitGatewayRouteTableAssociations",
        "GetTransitGatewayRouteTablePropagations",
        "ImportClientVpnClientCertificateRevocationList",
        "ImportImage",
        "ImportInstance",
        "ImportKeyPair",
        "ImportSnapshot",
        "ImportVolume",
        "ModifyCapacityReservation",
        "ModifyClientVpnEndpoint",
        "ModifyDefaultCreditSpecification",
        "ModifyEbsDefaultKmsKeyId",
        "ModifyFleet",
        "ModifyFpgaImageAttribute",
        "ModifyHosts",
        "ModifyIdFormat",
        "ModifyIdentityIdFormat",
        "ModifyImageAttribute",
        "ModifyInstanceAttribute",
        "ModifyInstanceCapacityReservationAttributes",
        "ModifyInstanceCreditSpecification",
        "ModifyInstanceEventStartTime",
        "ModifyInstanceMetadataOptions",
        "ModifyInstancePlacement",
        "ModifyLaunchTemplate",
        "ModifyNetworkInterfaceAttribute",
        "ModifyReservedInstances",
        "ModifySnapshotAttribute",
        "ModifySpotFleetRequest",
        "ModifySubnetAttribute",
        "ModifyTrafficMirrorFilterNetworkServices",
        "ModifyTrafficMirrorFilterRule",
        "ModifyTrafficMirrorSession",
        "ModifyTransitGatewayVpcAttachment",
        "ModifyVolume",
        "ModifyVolumeAttribute",
        "ModifyVpcAttribute",
        "ModifyVpcEndpoint",
        "ModifyVpcEndpointConnectionNotification",
        "ModifyVpcEndpointServiceConfiguration",
        "ModifyVpcEndpointServicePermissions",
        "ModifyVpcPeeringConnectionOptions",
        "ModifyVpcTenancy",
        "ModifyVpnConnection",
        "ModifyVpnTunnelCertificate",
        "ModifyVpnTunnelOptions",
        "MonitorInstances",
        "MoveAddressToVpc",
        "ProvisionByoipCidr",
        "PurchaseHostReservation",
        "PurchaseReservedInstancesOffering",
        "PurchaseScheduledInstances",
        "RebootInstances",
        "RegisterImage",
        "RegisterTransitGatewayMulticastGroupMembers",
        "RegisterTransitGatewayMulticastGroupSources",
        "RejectTransitGatewayPeeringAttachment",
        "RejectTransitGatewayVpcAttachment",
        "RejectVpcEndpointConnections",
        "RejectVpcPeeringConnection",
        "ReleaseAddress",
        "ReleaseHosts",
        "ReplaceIamInstanceProfileAssociation",
        "ReplaceNetworkAclAssociation",
        "ReplaceNetworkAclEntry",
        "ReplaceRoute",
        "ReplaceRouteTableAssociation",
        "ReplaceTransitGatewayRoute",
        "ReportInstanceStatus",
        "RequestSpotFleet",
        "RequestSpotInstances",
        "ResetEbsDefaultKmsKeyId",
        "ResetFpgaImageAttribute",
        "ResetImageAttribute",
        "ResetInstanceAttribute",
        "ResetNetworkInterfaceAttribute",
        "ResetSnapshotAttribute",
        "RestoreAddressToClassic",
        "RevokeClientVpnIngress",
        "RevokeSecurityGroupEgress",
        "RevokeSecurityGroupIngress",
        "RunInstances",
        "RunScheduledInstances",
        "SearchLocalGatewayRoutes",
        "SearchTransitGatewayMulticastGroups",
        "SearchTransitGatewayRoutes",
        "SendDiagnosticInterrupt",
        "StartInstances",
        "StartVpcEndpointServicePrivateDnsVerification",
        "StopInstances",
        "TerminateClientVpnConnections",
        "TerminateInstances",
        "UnassignIpv6Addresses",
        "UnassignPrivateIpAddresses",
        "UnmonitorInstances",
        "UpdateSecurityGroupRuleDescriptionsEgress",
        "UpdateSecurityGroupRuleDescriptionsIngress",
        "WithdrawByoipCidr",
    ],
    "autoscaling": [
        "AttachInstances",
        "AttachLoadBalancerTargetGroups",
        "AttachLoadBalancers",
        "BatchDeleteScheduledAction",
        "BatchPutScheduledUpdateGroupAction",
        "CompleteLifecycleAction",
        "CreateAutoScalingGroup",
        "CreateLaunchConfiguration",
        "CreateOrUpdateTags",
        "DeleteAutoScalingGroup",
        "DeleteLaunchConfiguration",
        "DeleteLifecycleHook",
        "DeleteNotificationConfiguration",
        "DeletePolicy",
        "DeleteScheduledAction",
        "DeleteTags",
        "DescribeAccountLimits",
        "DescribeAdjustmentTypes",
        "DescribeAutoScalingGroups",
        "DescribeAutoScalingInstances",
        "DescribeAutoScalingNotificationTypes",
        "DescribeLaunchConfigurations",
        "DescribeLifecycleHookTypes",
        "DescribeLifecycleHooks",
        "DescribeLoadBalancerTargetGroups",
        "DescribeLoadBalancers",
        "DescribeMetricCollectionTypes",
        "DescribeNotificationConfigurations",
        "DescribePolicies",
        "DescribeScalingActivities",
        "DescribeScalingProcessTypes",
        "DescribeScheduledActions",
        "DescribeTags",
        "DescribeTerminationPolicyTypes",
        "DetachInstances",
        "DetachLoadBalancerTargetGroups",
        "DetachLoadBalancers",
        "DisableMetricsCollection",
        "EnableMetricsCollection",
        "EnterStandby",
        "ExecutePolicy",
        "ExitStandby",
        "PutLifecycleHook",
        "PutNotificationConfiguration",
        "PutScalingPolicy",
        "PutScheduledUpdateGroupAction",
        "RecordLifecycleActionHeartbeat",
        "ResumeProcesses",
        "SetDesiredCapacity",
        "SetInstanceHealth",
        "SetInstanceProtection",
        "SuspendProcesses",
        "TerminateInstanceInAutoScalingGroup",
        "UpdateAutoScalingGroup",
    ],
    "imagebuilder": [
        "CancelImageCreation",
        "CreateComponent",
        "CreateDistributionConfiguration",
        "CreateImage",
        "CreateImagePipeline",
        "CreateImageRecipe",
        "CreateInfrastructureConfiguration",
        "DeleteComponent",
        "DeleteDistributionConfiguration",
        "DeleteImage",
        "DeleteImagePipeline",
        "DeleteImageRecipe",
        "DeleteInfrastructureConfiguration",
        "GetComponent",
        "GetComponentPolicy",
        "GetDistributionConfiguration",
        "GetImage",
        "GetImagePipeline",
        "GetImagePolicy",
        "GetImageRecipe",
        "GetImageRecipePolicy",
        "GetInfrastructureConfiguration",
        "ListComponentBuildVersions",
        "ListComponents",
        "ListDistributionConfigurations",
        "ListImageBuildVersions",
        "ListImagePipelines",
        "ListImageRecipes",
        "ListImages",
        "ListInfrastructureConfigurations",
        "ListTagsForResource",
        "PutComponentPolicy",
        "PutImagePolicy",
        "PutImageRecipePolicy",
        "StartImagePipelineExecution",
        "TagResource",
        "UntagResource",
        "UpdateDistributionConfiguration",
        "UpdateImagePipeline",
        "UpdateInfrastructureConfiguration",
    ],
    "ec2-instance-connect": ["SendSSHPublicKey"],
    "elasticache": [
        "AddTagsToResource",
        "AuthorizeCacheSecurityGroupIngress",
        "CopySnapshot",
        "CreateCacheCluster",
        "CreateCacheParameterGroup",
        "CreateCacheSecurityGroup",
        "CreateCacheSubnetGroup",
        "CreateReplicationGroup",
        "CreateSnapshot",
        "DecreaseReplicaCount",
        "DeleteCacheCluster",
        "DeleteCacheParameterGroup",
        "DeleteCacheSecurityGroup",
        "DeleteCacheSubnetGroup",
        "DeleteReplicationGroup",
        "DeleteSnapshot",
        "DescribeCacheClusters",
        "DescribeCacheEngineVersions",
        "DescribeCacheParameterGroups",
        "DescribeCacheParameters",
        "DescribeCacheSecurityGroups",
        "DescribeCacheSubnetGroups",
        "DescribeEngineDefaultParameters",
        "DescribeEvents",
        "DescribeReplicationGroups",
        "DescribeReservedCacheNodes",
        "DescribeReservedCacheNodesOfferings",
        "DescribeSnapshots",
        "IncreaseReplicaCount",
        "ListAllowedNodeTypeModifications",
        "ListTagsForResource",
        "ModifyCacheCluster",
        "ModifyCacheParameterGroup",
        "ModifyCacheSubnetGroup",
        "ModifyReplicationGroup",
        "ModifyReplicationGroupShardConfiguration",
        "PurchaseReservedCacheNodesOffering",
        "RebootCacheCluster",
        "RemoveTagsFromResource",
        "ResetCacheParameterGroup",
        "RevokeCacheSecurityGroupIngress",
        "TestFailover",
    ],
    "ebs": ["GetSnapshotBlock", "ListChangedBlocks", "ListSnapshotBlocks"],
    "ecr": [
        "BatchCheckLayerAvailability",
        "BatchDeleteImage",
        "BatchGetImage",
        "CompleteLayerUpload",
        "CreateRepository",
        "DeleteLifecyclePolicy",
        "DeleteRepository",
        "DeleteRepositoryPolicy",
        "DescribeImageScanFindings",
        "DescribeImages",
        "DescribeRepositories",
        "GetAuthorizationToken",
        "GetDownloadUrlForLayer",
        "GetLifecyclePolicy",
        "GetLifecyclePolicyPreview",
        "GetRepositoryPolicy",
        "InitiateLayerUpload",
        "ListImages",
        "ListTagsForResource",
        "PutImage",
        "PutImageScanningConfiguration",
        "PutImageTagMutability",
        "PutLifecyclePolicy",
        "SetRepositoryPolicy",
        "StartImageScan",
        "StartLifecyclePolicyPreview",
        "TagResource",
        "UntagResource",
        "UploadLayerPart",
    ],
    "ecs": [
        "CreateCluster",
        "CreateService",
        "CreateTaskSet",
        "DeleteAccountSetting",
        "DeleteAttributes",
        "DeleteCluster",
        "DeleteService",
        "DeleteTaskSet",
        "DeregisterContainerInstance",
        "DeregisterTaskDefinition",
        "DescribeClusters",
        "DescribeContainerInstances",
        "DescribeServices",
        "DescribeTaskDefinition",
        "DescribeTaskSets",
        "DescribeTasks",
        "DiscoverPollEndpoint",
        "ListAccountSettings",
        "ListAttributes",
        "ListClusters",
        "ListContainerInstances",
        "ListServices",
        "ListTagsForResource",
        "ListTaskDefinitionFamilies",
        "ListTaskDefinitions",
        "ListTasks",
        "Poll",
        "PutAccountSetting",
        "PutAccountSettingDefault",
        "PutAttributes",
        "RegisterContainerInstance",
        "RegisterTaskDefinition",
        "RunTask",
        "StartTask",
        "StartTelemetrySession",
        "StopTask",
        "SubmitAttachmentStateChanges",
        "SubmitContainerStateChange",
        "SubmitTaskStateChange",
        "TagResource",
        "UntagResource",
        "UpdateContainerAgent",
        "UpdateContainerInstancesState",
        "UpdateService",
        "UpdateServicePrimaryTaskSet",
        "UpdateTaskSet",
    ],
    "eks": [
        "CreateCluster",
        "CreateFargateProfile",
        "CreateNodegroup",
        "DeleteCluster",
        "DeleteFargateProfile",
        "DeleteNodegroup",
        "DescribeCluster",
        "DescribeFargateProfile",
        "DescribeNodegroup",
        "DescribeUpdate",
        "ListClusters",
        "ListFargateProfiles",
        "ListNodegroups",
        "ListTagsForResource",
        "ListUpdates",
        "TagResource",
        "UntagResource",
        "UpdateClusterConfig",
        "UpdateClusterVersion",
        "UpdateNodegroupConfig",
        "UpdateNodegroupVersion",
    ],
    "elasticfilesystem": [
        "Backup",
        "ClientMount",
        "ClientRootAccess",
        "ClientWrite",
        "CreateAccessPoint",
        "CreateFileSystem",
        "CreateMountTarget",
        "CreateTags",
        "DeleteAccessPoint",
        "DeleteFileSystem",
        "DeleteFileSystemPolicy",
        "DeleteMountTarget",
        "DeleteTags",
        "DescribeAccessPoints",
        "DescribeFileSystemPolicy",
        "DescribeFileSystems",
        "DescribeLifecycleConfiguration",
        "DescribeMountTargetSecurityGroups",
        "DescribeMountTargets",
        "DescribeTags",
        "ListTagsForResource",
        "ModifyMountTargetSecurityGroups",
        "PutFileSystemPolicy",
        "PutLifecycleConfiguration",
        "Restore",
        "TagResource",
        "UntagResource",
        "UpdateFileSystem",
    ],
    "elastic-inference": ["Connect"],
    "elasticmapreduce": [
        "AddInstanceFleet",
        "AddInstanceGroups",
        "AddJobFlowSteps",
        "AddTags",
        "CancelSteps",
        "CreateEditor",
        "CreateSecurityConfiguration",
        "DeleteEditor",
        "DeleteSecurityConfiguration",
        "DescribeCluster",
        "DescribeEditor",
        "DescribeJobFlows",
        "DescribeSecurityConfiguration",
        "DescribeStep",
        "GetBlockPublicAccessConfiguration",
        "ListBootstrapActions",
        "ListClusters",
        "ListEditors",
        "ListInstanceFleets",
        "ListInstanceGroups",
        "ListInstances",
        "ListSecurityConfigurations",
        "ListSteps",
        "ModifyCluster",
        "ModifyInstanceFleet",
        "ModifyInstanceGroups",
        "OpenEditorInConsole",
        "PutAutoScalingPolicy",
        "PutBlockPublicAccessConfiguration",
        "RemoveAutoScalingPolicy",
        "RemoveTags",
        "RunJobFlow",
        "SetTerminationProtection",
        "StartEditor",
        "StopEditor",
        "TerminateJobFlows",
        "ViewEventsFromAllClustersInConsole",
    ],
    "elastictranscoder": [
        "CancelJob",
        "CreateJob",
        "CreatePipeline",
        "CreatePreset",
        "DeletePipeline",
        "DeletePreset",
        "ListJobsByPipeline",
        "ListJobsByStatus",
        "ListPipelines",
        "ListPresets",
        "ReadJob",
        "ReadPipeline",
        "ReadPreset",
        "TestRole",
        "UpdatePipeline",
        "UpdatePipelineNotifications",
        "UpdatePipelineStatus",
    ],
    "es": [
        "AddTags",
        "CreateElasticsearchDomain",
        "CreateElasticsearchServiceRole",
        "DeleteElasticsearchDomain",
        "DeleteElasticsearchServiceRole",
        "DescribeElasticsearchDomain",
        "DescribeElasticsearchDomainConfig",
        "DescribeElasticsearchDomains",
        "DescribeElasticsearchInstanceTypeLimits",
        "DescribeReservedElasticsearchInstanceOfferings",
        "DescribeReservedElasticsearchInstances",
        "ESHttpDelete",
        "ESHttpGet",
        "ESHttpHead",
        "ESHttpPatch",
        "ESHttpPost",
        "ESHttpPut",
        "GetCompatibleElasticsearchVersions",
        "GetUpgradeHistory",
        "GetUpgradeStatus",
        "ListDomainNames",
        "ListElasticsearchInstanceTypeDetails",
        "ListElasticsearchInstanceTypes",
        "ListElasticsearchVersions",
        "ListTags",
        "PurchaseReservedElasticsearchInstanceOffering",
        "RemoveTags",
        "UpdateElasticsearchDomainConfig",
        "UpgradeElasticsearchDomain",
    ],
    "events": [
        "ActivateEventSource",
        "CreateEventBus",
        "CreatePartnerEventSource",
        "DeactivateEventSource",
        "DeleteEventBus",
        "DeletePartnerEventSource",
        "DeleteRule",
        "DescribeEventBus",
        "DescribeEventSource",
        "DescribePartnerEventSource",
        "DescribeRule",
        "DisableRule",
        "EnableRule",
        "ListEventBuses",
        "ListEventSources",
        "ListPartnerEventSourceAccounts",
        "ListPartnerEventSources",
        "ListRuleNamesByTarget",
        "ListRules",
        "ListTagsForResource",
        "ListTargetsByRule",
        "PutEvents",
        "PutPartnerEvents",
        "PutPermission",
        "PutRule",
        "PutTargets",
        "RemovePermission",
        "RemoveTargets",
        "TagResource",
        "TestEventPattern",
        "UntagResource",
    ],
    "schemas": [
        "CreateDiscoverer",
        "CreateRegistry",
        "CreateSchema",
        "DeleteDiscoverer",
        "DeleteRegistry",
        "DeleteSchema",
        "DeleteSchemaVersion",
        "DescribeCodeBinding",
        "DescribeDiscoverer",
        "DescribeRegistry",
        "DescribeSchema",
        "GetCodeBindingSource",
        "GetDiscoveredSchema",
        "ListDiscoverers",
        "ListRegistries",
        "ListSchemaVersions",
        "ListSchemas",
        "ListTagsForResource",
        "PutCodeBinding",
        "SearchSchemas",
        "StartDiscoverer",
        "StopDiscoverer",
        "TagResource",
        "UntagResource",
        "UpdateDiscoverer",
        "UpdateRegistry",
        "UpdateSchema",
    ],
    "fsx": [
        "CancelDataRepositoryTask",
        "CreateBackup",
        "CreateDataRepositoryTask",
        "CreateFileSystem",
        "CreateFileSystemFromBackup",
        "DeleteBackup",
        "DeleteFileSystem",
        "DescribeBackups",
        "DescribeDataRepositoryTasks",
        "DescribeFileSystems",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateFileSystem",
    ],
    "forecast": [
        "CreateDataset",
        "CreateDatasetGroup",
        "CreateDatasetImportJob",
        "CreateForecast",
        "CreateForecastExportJob",
        "CreatePredictor",
        "DeleteDataset",
        "DeleteDatasetGroup",
        "DeleteDatasetImportJob",
        "DeleteForecast",
        "DeleteForecastExportJob",
        "DeletePredictor",
        "DescribeDataset",
        "DescribeDatasetGroup",
        "DescribeDatasetImportJob",
        "DescribeForecast",
        "DescribeForecastExportJob",
        "DescribePredictor",
        "GetAccuracyMetrics",
        "ListDatasetGroups",
        "ListDatasetImportJobs",
        "ListDatasets",
        "ListForecastExportJobs",
        "ListForecasts",
        "ListPredictors",
        "QueryForecast",
        "UpdateDatasetGroup",
    ],
    "frauddetector": [
        "BatchCreateVariable",
        "BatchGetVariable",
        "CreateDetectorVersion",
        "CreateModelVersion",
        "CreateRule",
        "CreateVariable",
        "DeleteDetectorVersion",
        "DeleteEvent",
        "DescribeDetector",
        "DescribeModelVersions",
        "GetDetectorVersion",
        "GetDetectors",
        "GetExternalModels",
        "GetModelVersion",
        "GetModels",
        "GetOutcomes",
        "GetPrediction",
        "GetRules",
        "GetVariables",
        "PutDetector",
        "PutExternalModel",
        "PutModel",
        "PutOutcome",
        "UpdateDetectorVersion",
        "UpdateDetectorVersionMetadata",
        "UpdateDetectorVersionStatus",
        "UpdateModelVersion",
        "UpdateRuleMetadata",
        "UpdateRuleVersion",
        "UpdateVariable",
    ],
    "freertos": [
        "CreateSoftwareConfiguration",
        "DeleteSoftwareConfiguration",
        "DescribeHardwarePlatform",
        "DescribeSoftwareConfiguration",
        "GetSoftwareURL",
        "GetSoftwareURLForConfiguration",
        "ListFreeRTOSVersions",
        "ListHardwarePlatforms",
        "ListHardwareVendors",
        "ListSoftwareConfigurations",
        "UpdateSoftwareConfiguration",
    ],
    "gamelift": [
        "AcceptMatch",
        "CreateAlias",
        "CreateBuild",
        "CreateFleet",
        "CreateGameSession",
        "CreateGameSessionQueue",
        "CreateMatchmakingConfiguration",
        "CreateMatchmakingRuleSet",
        "CreatePlayerSession",
        "CreatePlayerSessions",
        "CreateScript",
        "CreateVpcPeeringAuthorization",
        "CreateVpcPeeringConnection",
        "DeleteAlias",
        "DeleteBuild",
        "DeleteFleet",
        "DeleteGameSessionQueue",
        "DeleteMatchmakingConfiguration",
        "DeleteMatchmakingRuleSet",
        "DeleteScalingPolicy",
        "DeleteScript",
        "DeleteVpcPeeringAuthorization",
        "DeleteVpcPeeringConnection",
        "DescribeAlias",
        "DescribeBuild",
        "DescribeEC2InstanceLimits",
        "DescribeFleetAttributes",
        "DescribeFleetCapacity",
        "DescribeFleetEvents",
        "DescribeFleetPortSettings",
        "DescribeFleetUtilization",
        "DescribeGameSessionDetails",
        "DescribeGameSessionPlacement",
        "DescribeGameSessionQueues",
        "DescribeGameSessions",
        "DescribeInstances",
        "DescribeMatchmaking",
        "DescribeMatchmakingConfigurations",
        "DescribeMatchmakingRuleSets",
        "DescribePlayerSessions",
        "DescribeRuntimeConfiguration",
        "DescribeScalingPolicies",
        "DescribeScript",
        "DescribeVpcPeeringAuthorizations",
        "DescribeVpcPeeringConnections",
        "GetGameSessionLogUrl",
        "GetInstanceAccess",
        "ListAliases",
        "ListBuilds",
        "ListFleets",
        "ListScripts",
        "ListTagsForResource",
        "PutScalingPolicy",
        "RequestUploadCredentials",
        "ResolveAlias",
        "SearchGameSessions",
        "StartFleetActions",
        "StartGameSessionPlacement",
        "StartMatchBackfill",
        "StartMatchmaking",
        "StopFleetActions",
        "StopGameSessionPlacement",
        "StopMatchmaking",
        "TagResource",
        "UntagResource",
        "UpdateAlias",
        "UpdateBuild",
        "UpdateFleetAttributes",
        "UpdateFleetCapacity",
        "UpdateFleetPortSettings",
        "UpdateGameSession",
        "UpdateGameSessionQueue",
        "UpdateMatchmakingConfiguration",
        "UpdateRuntimeConfiguration",
        "UpdateScript",
        "ValidateMatchmakingRuleSet",
    ],
    "glacier": [
        "AbortMultipartUpload",
        "AbortVaultLock",
        "AddTagsToVault",
        "CompleteMultipartUpload",
        "CompleteVaultLock",
        "CreateVault",
        "DeleteArchive",
        "DeleteVault",
        "DeleteVaultAccessPolicy",
        "DeleteVaultNotifications",
        "DescribeJob",
        "DescribeVault",
        "GetDataRetrievalPolicy",
        "GetJobOutput",
        "GetVaultAccessPolicy",
        "GetVaultLock",
        "GetVaultNotifications",
        "InitiateJob",
        "InitiateMultipartUpload",
        "InitiateVaultLock",
        "ListJobs",
        "ListMultipartUploads",
        "ListParts",
        "ListProvisionedCapacity",
        "ListTagsForVault",
        "ListVaults",
        "PurchaseProvisionedCapacity",
        "RemoveTagsFromVault",
        "SetDataRetrievalPolicy",
        "SetVaultAccessPolicy",
        "SetVaultNotifications",
        "UploadArchive",
        "UploadMultipartPart",
    ],
    "groundtruthlabeling": [
        "DescribeConsoleJob",
        "ListDatasetObjects",
        "RunFilterOrSampleDatasetJob",
        "RunGenerateManifestByCrawlingJob",
    ],
    "guardduty": [
        "AcceptInvitation",
        "ArchiveFindings",
        "CreateDetector",
        "CreateFilter",
        "CreateIPSet",
        "CreateMembers",
        "CreatePublishingDestination",
        "CreateSampleFindings",
        "CreateThreatIntelSet",
        "DeclineInvitations",
        "DeleteDetector",
        "DeleteFilter",
        "DeleteIPSet",
        "DeleteInvitations",
        "DeleteMembers",
        "DeletePublishingDestination",
        "DeleteThreatIntelSet",
        "DescribePublishingDestination",
        "DisassociateFromMasterAccount",
        "DisassociateMembers",
        "GetDetector",
        "GetFilter",
        "GetFindings",
        "GetFindingsStatistics",
        "GetIPSet",
        "GetInvitationsCount",
        "GetMasterAccount",
        "GetMembers",
        "GetThreatIntelSet",
        "InviteMembers",
        "ListDetectors",
        "ListFilters",
        "ListFindings",
        "ListInvitations",
        "ListMembers",
        "ListPublishingDestinations",
        "ListTagsForResource",
        "ListThreatIntelSets",
        "StartMonitoringMembers",
        "StopMonitoringMembers",
        "TagResource",
        "UnarchiveFindings",
        "UntagResource",
        "UpdateDetector",
        "UpdateFilter",
        "UpdateFindingsFeedback",
        "UpdateIPSet",
        "UpdatePublishingDestination",
        "UpdateThreatIntelSet",
    ],
    "inspector": [
        "AddAttributesToFindings",
        "CreateAssessmentTarget",
        "CreateAssessmentTemplate",
        "CreateResourceGroup",
        "DeleteAssessmentRun",
        "DeleteAssessmentTarget",
        "DeleteAssessmentTemplate",
        "DescribeAssessmentRuns",
        "DescribeAssessmentTargets",
        "DescribeAssessmentTemplates",
        "DescribeCrossAccountAccessRole",
        "DescribeFindings",
        "DescribeResourceGroups",
        "DescribeRulesPackages",
        "GetTelemetryMetadata",
        "ListAssessmentRunAgents",
        "ListAssessmentRuns",
        "ListAssessmentTargets",
        "ListAssessmentTemplates",
        "ListEventSubscriptions",
        "ListFindings",
        "ListRulesPackages",
        "ListTagsForResource",
        "PreviewAgents",
        "RegisterCrossAccountAccessRole",
        "RemoveAttributesFromFindings",
        "SetTagsForResource",
        "StartAssessmentRun",
        "StopAssessmentRun",
        "SubscribeToEvent",
        "UnsubscribeFromEvent",
        "UpdateAssessmentTarget",
    ],
    "kendra": [
        "BatchDeleteDocument",
        "BatchPutDocument",
        "CreateDataSource",
        "CreateFaq",
        "CreateIndex",
        "DeleteFaq",
        "DeleteIndex",
        "DescribeDataSource",
        "DescribeFaq",
        "DescribeIndex",
        "ListDataSourceSyncJobs",
        "ListDataSources",
        "ListFaqs",
        "ListIndices",
        "Query",
        "StartDataSourceSyncJob",
        "StopDataSourceSyncJob",
        "SubmitFeedback",
        "UpdateDataSource",
        "UpdateIndex",
    ],
    "kinesis": [
        "AddTagsToStream",
        "CreateStream",
        "DecreaseStreamRetentionPeriod",
        "DeleteStream",
        "DeregisterStreamConsumer",
        "DescribeLimits",
        "DescribeStream",
        "DescribeStreamConsumer",
        "DescribeStreamSummary",
        "DisableEnhancedMonitoring",
        "EnableEnhancedMonitoring",
        "GetRecords",
        "GetShardIterator",
        "IncreaseStreamRetentionPeriod",
        "ListShards",
        "ListStreamConsumers",
        "ListStreams",
        "ListTagsForStream",
        "MergeShards",
        "PutRecord",
        "PutRecords",
        "RegisterStreamConsumer",
        "RemoveTagsFromStream",
        "SplitShard",
        "SubscribeToShard",
        "UpdateShardCount",
    ],
    "kinesisanalytics": [
        "AddApplicationCloudWatchLoggingOption",
        "AddApplicationInput",
        "AddApplicationInputProcessingConfiguration",
        "AddApplicationOutput",
        "AddApplicationReferenceDataSource",
        "AddApplicationVpcConfiguration",
        "CreateApplication",
        "CreateApplicationSnapshot",
        "DeleteApplication",
        "DeleteApplicationCloudWatchLoggingOption",
        "DeleteApplicationInputProcessingConfiguration",
        "DeleteApplicationOutput",
        "DeleteApplicationReferenceDataSource",
        "DeleteApplicationSnapshot",
        "DeleteApplicationVpcConfiguration",
        "DescribeApplication",
        "DescribeApplicationSnapshot",
        "DiscoverInputSchema",
        "GetApplicationState",
        "ListApplicationSnapshots",
        "ListApplications",
        "ListTagsForResource",
        "StartApplication",
        "StopApplication",
        "TagResource",
        "UntagResource",
        "UpdateApplication",
    ],
    "firehose": [
        "CreateDeliveryStream",
        "DeleteDeliveryStream",
        "DescribeDeliveryStream",
        "ListDeliveryStreams",
        "ListTagsForDeliveryStream",
        "PutRecord",
        "PutRecordBatch",
        "StartDeliveryStreamEncryption",
        "StopDeliveryStreamEncryption",
        "TagDeliveryStream",
        "UntagDeliveryStream",
        "UpdateDestination",
    ],
    "kinesisvideo": [
        "ConnectAsMaster",
        "ConnectAsViewer",
        "CreateSignalingChannel",
        "CreateStream",
        "DeleteSignalingChannel",
        "DeleteStream",
        "DescribeSignalingChannel",
        "DescribeStream",
        "GetDASHStreamingSessionURL",
        "GetDataEndpoint",
        "GetHLSStreamingSessionURL",
        "GetIceServerConfig",
        "GetMedia",
        "GetMediaForFragmentList",
        "GetSignalingChannelEndpoint",
        "ListFragments",
        "ListSignalingChannels",
        "ListStreams",
        "ListTagsForResource",
        "ListTagsForStream",
        "PutMedia",
        "SendAlexaOfferToMaster",
        "TagResource",
        "TagStream",
        "UntagResource",
        "UntagStream",
        "UpdateDataRetention",
        "UpdateSignalingChannel",
        "UpdateStream",
    ],
    "lex": [
        "CreateBotVersion",
        "CreateIntentVersion",
        "CreateSlotTypeVersion",
        "DeleteBot",
        "DeleteBotAlias",
        "DeleteBotChannelAssociation",
        "DeleteBotVersion",
        "DeleteIntent",
        "DeleteIntentVersion",
        "DeleteSlotType",
        "DeleteSlotTypeVersion",
        "DeleteUtterances",
        "GetBot",
        "GetBotAlias",
        "GetBotAliases",
        "GetBotChannelAssociation",
        "GetBotChannelAssociations",
        "GetBotVersions",
        "GetBots",
        "GetBuiltinIntent",
        "GetBuiltinIntents",
        "GetBuiltinSlotTypes",
        "GetIntent",
        "GetIntentVersions",
        "GetIntents",
        "GetSlotType",
        "GetSlotTypeVersions",
        "GetSlotTypes",
        "GetUtterancesView",
        "PostContent",
        "PostText",
        "PutBot",
        "PutBotAlias",
        "PutIntent",
        "PutSlotType",
    ],
    "lightsail": [
        "AllocateStaticIp",
        "AttachDisk",
        "AttachInstancesToLoadBalancer",
        "AttachLoadBalancerTlsCertificate",
        "AttachStaticIp",
        "CloseInstancePublicPorts",
        "CopySnapshot",
        "CreateCloudFormationStack",
        "CreateDisk",
        "CreateDiskFromSnapshot",
        "CreateDiskSnapshot",
        "CreateDomain",
        "CreateDomainEntry",
        "CreateInstanceSnapshot",
        "CreateInstances",
        "CreateInstancesFromSnapshot",
        "CreateKeyPair",
        "CreateLoadBalancer",
        "CreateLoadBalancerTlsCertificate",
        "CreateRelationalDatabase",
        "CreateRelationalDatabaseFromSnapshot",
        "CreateRelationalDatabaseSnapshot",
        "DeleteDisk",
        "DeleteDiskSnapshot",
        "DeleteDomain",
        "DeleteDomainEntry",
        "DeleteInstance",
        "DeleteInstanceSnapshot",
        "DeleteKeyPair",
        "DeleteKnownHostKeys",
        "DeleteLoadBalancer",
        "DeleteLoadBalancerTlsCertificate",
        "DeleteRelationalDatabase",
        "DeleteRelationalDatabaseSnapshot",
        "DetachDisk",
        "DetachInstancesFromLoadBalancer",
        "DetachStaticIp",
        "DownloadDefaultKeyPair",
        "ExportSnapshot",
        "GetActiveNames",
        "GetBlueprints",
        "GetBundles",
        "GetCloudFormationStackRecords",
        "GetDisk",
        "GetDiskSnapshot",
        "GetDiskSnapshots",
        "GetDisks",
        "GetDomain",
        "GetDomains",
        "GetExportSnapshotRecords",
        "GetInstance",
        "GetInstanceAccessDetails",
        "GetInstanceMetricData",
        "GetInstancePortStates",
        "GetInstanceSnapshot",
        "GetInstanceSnapshots",
        "GetInstanceState",
        "GetInstances",
        "GetKeyPair",
        "GetKeyPairs",
        "GetLoadBalancer",
        "GetLoadBalancerMetricData",
        "GetLoadBalancerTlsCertificates",
        "GetLoadBalancers",
        "GetOperation",
        "GetOperations",
        "GetOperationsForResource",
        "GetRegions",
        "GetRelationalDatabase",
        "GetRelationalDatabaseBlueprints",
        "GetRelationalDatabaseBundles",
        "GetRelationalDatabaseEvents",
        "GetRelationalDatabaseLogEvents",
        "GetRelationalDatabaseLogStreams",
        "GetRelationalDatabaseMasterUserPassword",
        "GetRelationalDatabaseMetricData",
        "GetRelationalDatabaseParameters",
        "GetRelationalDatabaseSnapshot",
        "GetRelationalDatabaseSnapshots",
        "GetRelationalDatabases",
        "GetStaticIp",
        "GetStaticIps",
        "ImportKeyPair",
        "IsVpcPeered",
        "OpenInstancePublicPorts",
        "PeerVpc",
        "PutInstancePublicPorts",
        "RebootInstance",
        "RebootRelationalDatabase",
        "ReleaseStaticIp",
        "StartInstance",
        "StartRelationalDatabase",
        "StopInstance",
        "StopRelationalDatabase",
        "TagResource",
        "UnpeerVpc",
        "UntagResource",
        "UpdateDomainEntry",
        "UpdateLoadBalancerAttribute",
        "UpdateRelationalDatabase",
        "UpdateRelationalDatabaseParameters",
    ],
    "mq": [
        "CreateBroker",
        "CreateConfiguration",
        "CreateTags",
        "CreateUser",
        "DeleteBroker",
        "DeleteTags",
        "DeleteUser",
        "DescribeBroker",
        "DescribeBrokerEngineTypes",
        "DescribeBrokerInstanceOptions",
        "DescribeConfiguration",
        "DescribeConfigurationRevision",
        "DescribeUser",
        "ListBrokers",
        "ListConfigurationRevisions",
        "ListConfigurations",
        "ListTags",
        "ListUsers",
        "RebootBroker",
        "UpdateBroker",
        "UpdateConfiguration",
        "UpdateUser",
    ],
    "machinelearning": [
        "AddTags",
        "CreateBatchPrediction",
        "CreateDataSourceFromRDS",
        "CreateDataSourceFromRedshift",
        "CreateDataSourceFromS3",
        "CreateEvaluation",
        "CreateMLModel",
        "CreateRealtimeEndpoint",
        "DeleteBatchPrediction",
        "DeleteDataSource",
        "DeleteEvaluation",
        "DeleteMLModel",
        "DeleteRealtimeEndpoint",
        "DeleteTags",
        "DescribeBatchPredictions",
        "DescribeDataSources",
        "DescribeEvaluations",
        "DescribeMLModels",
        "DescribeTags",
        "GetBatchPrediction",
        "GetDataSource",
        "GetEvaluation",
        "GetMLModel",
        "Predict",
        "UpdateBatchPrediction",
        "UpdateDataSource",
        "UpdateEvaluation",
        "UpdateMLModel",
    ],
    "macie": [
        "AssociateMemberAccount",
        "AssociateS3Resources",
        "DisassociateMemberAccount",
        "DisassociateS3Resources",
        "ListMemberAccounts",
        "ListS3Resources",
        "UpdateS3Resources",
    ],
    "managedblockchain": [
        "CreateMember",
        "CreateNetwork",
        "CreateNode",
        "CreateProposal",
        "DeleteMember",
        "DeleteNode",
        "GetMember",
        "GetNetwork",
        "GetNode",
        "GetProposal",
        "ListInvitations",
        "ListMembers",
        "ListNetworks",
        "ListNodes",
        "ListProposalVotes",
        "ListProposals",
        "RejectInvitation",
        "VoteOnProposal",
    ],
    "kafka": [
        "CreateCluster",
        "CreateConfiguration",
        "DeleteCluster",
        "DescribeCluster",
        "DescribeClusterOperation",
        "DescribeConfiguration",
        "DescribeConfigurationRevision",
        "GetBootstrapBrokers",
        "ListClusterOperations",
        "ListClusters",
        "ListConfigurations",
        "ListNodes",
        "ListTagsForResource",
        "TagResource",
        "UntagResource",
        "UpdateBrokerStorage",
        "UpdateClusterConfiguration",
    ],
    "mechanicalturk": [
        "AcceptQualificationRequest",
        "ApproveAssignment",
        "AssociateQualificationWithWorker",
        "CreateAdditionalAssignmentsForHIT",
        "CreateHIT",
        "CreateHITType",
        "CreateHITWithHITType",
        "CreateQualificationType",
        "CreateWorkerBlock",
        "DeleteHIT",
        "DeleteQualificationType",
        "DeleteWorkerBlock",
        "DisassociateQualificationFromWorker",
        "GetAccountBalance",
        "GetAssignment",
        "GetFileUploadURL",
        "GetHIT",
        "GetQualificationScore",
        "GetQualificationType",
        "ListAssignmentsForHIT",
        "ListBonusPayments",
        "ListHITs",
        "ListHITsForQualificationType",
        "ListQualificationRequests",
        "ListQualificationTypes",
        "ListReviewPolicyResultsForHIT",
        "ListReviewableHITs",
        "ListWorkerBlocks",
        "ListWorkersWithQualificationType",
        "NotifyWorkers",
        "RejectAssignment",
        "RejectQualificationRequest",
        "SendBonus",
        "SendTestEventNotification",
        "UpdateExpirationForHIT",
        "UpdateHITReviewStatus",
        "UpdateHITTypeOfHIT",
        "UpdateNotificationSettings",
        "UpdateQualificationType",
    ],
    "ec2messages": [
        "AcknowledgeMessage",
        "DeleteMessage",
        "FailMessage",
        "GetEndpoint",
        "GetMessages",
        "SendReply",
    ],
    "mobileanalytics": ["GetFinancialReports", "GetReports", "PutEvents"],
    "neptune-db": ["connect"],
    "personalize": [
        "CreateCampaign",
        "CreateDataset",
        "CreateDatasetGroup",
        "CreateDatasetImportJob",
        "CreateEventTracker",
        "CreateSchema",
        "CreateSolution",
        "CreateSolutionVersion",
        "DeleteCampaign",
        "DeleteDataset",
        "DeleteDatasetGroup",
        "DeleteEventTracker",
        "DeleteSchema",
        "DeleteSolution",
        "DescribeAlgorithm",
        "DescribeCampaign",
        "DescribeDataset",
        "DescribeDatasetGroup",
        "DescribeDatasetImportJob",
        "DescribeEventTracker",
        "DescribeFeatureTransformation",
        "DescribeRecipe",
        "DescribeSchema",
        "DescribeSolution",
        "DescribeSolutionVersion",
        "GetPersonalizedRanking",
        "GetRecommendations",
        "GetSolutionMetrics",
        "ListCampaigns",
        "ListDatasetGroups",
        "ListDatasetImportJobs",
        "ListDatasets",
        "ListEventTrackers",
        "ListRecipes",
        "ListSchemas",
        "ListSolutionVersions",
        "ListSolutions",
        "PutEvents",
        "UpdateCampaign",
    ],
    "mobiletargeting": [
        "CreateApp",
        "CreateCampaign",
        "CreateEmailTemplate",
        "CreateExportJob",
        "CreateImportJob",
        "CreateJourney",
        "CreatePushTemplate",
        "CreateRecommenderConfiguration",
        "CreateSegment",
        "CreateSmsTemplate",
        "CreateVoiceTemplate",
        "DeleteAdmChannel",
        "DeleteApnsChannel",
        "DeleteApnsSandboxChannel",
        "DeleteApnsVoipChannel",
        "DeleteApnsVoipSandboxChannel",
        "DeleteApp",
        "DeleteBaiduChannel",
        "DeleteCampaign",
        "DeleteEmailChannel",
        "DeleteEmailTemplate",
        "DeleteEndpoint",
        "DeleteEventStream",
        "DeleteGcmChannel",
        "DeleteJourney",
        "DeletePushTemplate",
        "DeleteRecommenderConfiguration",
        "DeleteSegment",
        "DeleteSmsChannel",
        "DeleteSmsTemplate",
        "DeleteUserEndpoints",
        "DeleteVoiceChannel",
        "DeleteVoiceTemplate",
        "GetAdmChannel",
        "GetApnsChannel",
        "GetApnsSandboxChannel",
        "GetApnsVoipChannel",
        "GetApnsVoipSandboxChannel",
        "GetApp",
        "GetApplicationSettings",
        "GetApps",
        "GetBaiduChannel",
        "GetCampaign",
        "GetCampaignActivities",
        "GetCampaignVersion",
        "GetCampaignVersions",
        "GetCampaigns",
        "GetChannels",
        "GetEmailChannel",
        "GetEmailTemplate",
        "GetEndpoint",
        "GetEventStream",
        "GetExportJob",
        "GetExportJobs",
        "GetGcmChannel",
        "GetImportJob",
        "GetImportJobs",
        "GetJourney",
        "GetPushTemplate",
        "GetRecommenderConfiguration",
        "GetRecommenderConfigurations",
        "GetSegment",
        "GetSegmentExportJobs",
        "GetSegmentImportJobs",
        "GetSegmentVersion",
        "GetSegmentVersions",
        "GetSegments",
        "GetSmsChannel",
        "GetSmsTemplate",
        "GetUserEndpoints",
        "GetVoiceChannel",
        "GetVoiceTemplate",
        "ListJourneys",
        "ListTagsForResource",
        "ListTemplateVersions",
        "ListTemplates",
        "PhoneNumberValidate",
        "PutEventStream",
        "PutEvents",
        "RemoveAttributes",
        "SendMessages",
        "SendUsersMessages",
        "TagResource",
        "UntagResource",
        "UpdateAdmChannel",
        "UpdateApnsChannel",
        "UpdateApnsSandboxChannel",
        "UpdateApnsVoipChannel",
        "UpdateApnsVoipSandboxChannel",
        "UpdateApplicationSettings",
        "UpdateBaiduChannel",
        "UpdateCampaign",
        "UpdateEmailChannel",
        "UpdateEmailTemplate",
        "UpdateEndpoint",
        "UpdateEndpointsBatch",
        "UpdateGcmChannel",
        "UpdateJourney",
        "UpdateJourneyState",
        "UpdatePushTemplate",
        "UpdateRecommenderConfiguration",
        "UpdateSegment",
        "UpdateSmsChannel",
        "UpdateSmsTemplate",
        "UpdateTemplateActiveVersion",
        "UpdateVoiceChannel",
        "UpdateVoiceTemplate",
    ],
    "ses": [
        "CloneReceiptRuleSet",
        "CreateConfigurationSet",
        "CreateConfigurationSetEventDestination",
        "CreateConfigurationSetTrackingOptions",
        "CreateCustomVerificationEmailTemplate",
        "CreateDedicatedIpPool",
        "CreateDeliverabilityTestReport",
        "CreateEmailIdentity",
        "CreateReceiptFilter",
        "CreateReceiptRule",
        "CreateReceiptRuleSet",
        "CreateTemplate",
        "DeleteConfigurationSet",
        "DeleteConfigurationSetEventDestination",
        "DeleteConfigurationSetTrackingOptions",
        "DeleteCustomVerificationEmailTemplate",
        "DeleteDedicatedIpPool",
        "DeleteEmailIdentity",
        "DeleteIdentity",
        "DeleteIdentityPolicy",
        "DeleteReceiptFilter",
        "DeleteReceiptRule",
        "DeleteReceiptRuleSet",
        "DeleteTemplate",
        "DeleteVerifiedEmailAddress",
        "DescribeActiveReceiptRuleSet",
        "DescribeConfigurationSet",
        "DescribeReceiptRule",
        "DescribeReceiptRuleSet",
        "GetAccount",
        "GetAccountSendingEnabled",
        "GetBlacklistReports",
        "GetConfigurationSet",
        "GetConfigurationSetEventDestinations",
        "GetCustomVerificationEmailTemplate",
        "GetDedicatedIp",
        "GetDedicatedIps",
        "GetDeliverabilityDashboardOptions",
        "GetDeliverabilityTestReport",
        "GetDomainStatisticsReport",
        "GetEmailIdentity",
        "GetIdentityDkimAttributes",
        "GetIdentityMailFromDomainAttributes",
        "GetIdentityNotificationAttributes",
        "GetIdentityPolicies",
        "GetIdentityVerificationAttributes",
        "GetSendQuota",
        "GetSendStatistics",
        "GetTemplate",
        "ListConfigurationSets",
        "ListCustomVerificationEmailTemplates",
        "ListDedicatedIpPools",
        "ListDeliverabilityTestReports",
        "ListEmailIdentities",
        "ListIdentities",
        "ListIdentityPolicies",
        "ListReceiptFilters",
        "ListReceiptRuleSets",
        "ListTagsForResource",
        "ListTemplates",
        "ListVerifiedEmailAddresses",
        "PutAccountDedicatedIpWarmupAttributes",
        "PutAccountSendingAttributes",
        "PutConfigurationSetDeliveryOptions",
        "PutConfigurationSetReputationOptions",
        "PutConfigurationSetSendingOptions",
        "PutConfigurationSetTrackingOptions",
        "PutDedicatedIpInPool",
        "PutDedicatedIpWarmupAttributes",
        "PutDeliverabilityDashboardOption",
        "PutEmailIdentityDkimAttributes",
        "PutEmailIdentityFeedbackAttributes",
        "PutEmailIdentityMailFromAttributes",
        "PutIdentityPolicy",
        "ReorderReceiptRuleSet",
        "SendBounce",
        "SendBulkTemplatedEmail",
        "SendCustomVerificationEmail",
        "SendEmail",
        "SendRawEmail",
        "SendTemplatedEmail",
        "SetActiveReceiptRuleSet",
        "SetIdentityDkimEnabled",
        "SetIdentityFeedbackForwardingEnabled",
        "SetIdentityHeadersInNotificationsEnabled",
        "SetIdentityMailFromDomain",
        "SetIdentityNotificationTopic",
        "SetReceiptRulePosition",
        "TagResource",
        "TestRenderTemplate",
        "UntagResource",
        "UpdateAccountSendingEnabled",
        "UpdateConfigurationSetEventDestination",
        "UpdateConfigurationSetReputationMetricsEnabled",
        "UpdateConfigurationSetSendingEnabled",
        "UpdateConfigurationSetTrackingOptions",
        "UpdateCustomVerificationEmailTemplate",
        "UpdateReceiptRule",
        "UpdateTemplate",
        "VerifyDomainDkim",
        "VerifyDomainIdentity",
        "VerifyEmailAddress",
        "VerifyEmailIdentity",
    ],
    "sms-voice": [
        "CreateConfigurationSet",
        "CreateConfigurationSetEventDestination",
        "DeleteConfigurationSet",
        "DeleteConfigurationSetEventDestination",
        "GetConfigurationSetEventDestinations",
        "ListConfigurationSets",
        "SendVoiceMessage",
        "UpdateConfigurationSetEventDestination",
    ],
    "polly": [
        "DeleteLexicon",
        "DescribeVoices",
        "GetLexicon",
        "GetSpeechSynthesisTask",
        "ListLexicons",
        "ListSpeechSynthesisTasks",
        "PutLexicon",
        "StartSpeechSynthesisTask",
        "SynthesizeSpeech",
    ],
    "qldb": [
        "CreateLedger",
        "DeleteLedger",
        "DescribeJournalS3Export",
        "DescribeLedger",
        "ExecuteStatement",
        "ExportJournalToS3",
        "GetBlock",
        "GetDigest",
        "GetRevision",
        "InsertSampleData",
        "ListJournalS3Exports",
        "ListJournalS3ExportsForLedger",
        "ListLedgers",
        "ListTagsForResource",
        "SendCommand",
        "ShowCatalog",
        "TagResource",
        "UntagResource",
        "UpdateLedger",
    ],
    "quicksight": [
        "CreateAdmin",
        "CreateDashboard",
        "CreateGroup",
        "CreateGroupMembership",
        "CreateIAMPolicyAssignment",
        "CreateReader",
        "CreateTemplate",
        "CreateTemplateAlias",
        "CreateUser",
        "DeleteDashboard",
        "DeleteGroup",
        "DeleteGroupMembership",
        "DeleteIAMPolicyAssignment",
        "DeleteTemplate",
        "DeleteTemplateAlias",
        "DeleteUser",
        "DeleteUserByPrincipalId",
        "DescribeDashboard",
        "DescribeDashboardPermissions",
        "DescribeGroup",
        "DescribeIAMPolicyAssignment",
        "DescribeTemplate",
        "DescribeTemplateAlias",
        "DescribeTemplatePermissions",
        "DescribeUser",
        "GetAuthCode",
        "GetDashboardEmbedUrl",
        "GetGroupMapping",
        "ListDashboardVersions",
        "ListDashboards",
        "ListGroupMemberships",
        "ListGroups",
        "ListIAMPolicyAssignments",
        "ListIAMPolicyAssignmentsForUser",
        "ListTagsForResource",
        "ListTemplateAliases",
        "ListTemplateVersions",
        "ListTemplates",
        "ListUserGroups",
        "ListUsers",
        "RegisterUser",
        "SearchDirectoryGroups",
        "SetGroupMapping",
        "Subscribe",
        "TagResource",
        "Unsubscribe",
        "UntagResource",
        "UpdateDashboard",
        "UpdateDashboardPermissions",
        "UpdateDashboardPublishedVersion",
        "UpdateGroup",
        "UpdateIAMPolicyAssignment",
        "UpdateTemplate",
        "UpdateTemplateAlias",
        "UpdateTemplatePermissions",
        "UpdateUser",
    ],
    "rds": [
        "AddRoleToDBCluster",
        "AddRoleToDBInstance",
        "AddSourceIdentifierToSubscription",
        "AddTagsToResource",
        "ApplyPendingMaintenanceAction",
        "AuthorizeDBSecurityGroupIngress",
        "BacktrackDBCluster",
        "CancelExportTask",
        "CopyDBClusterParameterGroup",
        "CopyDBClusterSnapshot",
        "CopyDBParameterGroup",
        "CopyDBSnapshot",
        "CopyOptionGroup",
        "CreateDBCluster",
        "CreateDBClusterEndpoint",
        "CreateDBClusterParameterGroup",
        "CreateDBClusterSnapshot",
        "CreateDBInstance",
        "CreateDBInstanceReadReplica",
        "CreateDBParameterGroup",
        "CreateDBProxy",
        "CreateDBSecurityGroup",
        "CreateDBSnapshot",
        "CreateDBSubnetGroup",
        "CreateEventSubscription",
        "CreateGlobalCluster",
        "CreateOptionGroup",
        "DeleteDBCluster",
        "DeleteDBClusterEndpoint",
        "DeleteDBClusterParameterGroup",
        "DeleteDBClusterSnapshot",
        "DeleteDBInstance",
        "DeleteDBInstanceAutomatedBackup",
        "DeleteDBParameterGroup",
        "DeleteDBProxy",
        "DeleteDBSecurityGroup",
        "DeleteDBSnapshot",
        "DeleteDBSubnetGroup",
        "DeleteEventSubscription",
        "DeleteGlobalCluster",
        "DeleteOptionGroup",
        "DeregisterDBProxyTargets",
        "DescribeAccountAttributes",
        "DescribeCertificates",
        "DescribeDBClusterBacktracks",
        "DescribeDBClusterEndpoints",
        "DescribeDBClusterParameterGroups",
        "DescribeDBClusterParameters",
        "DescribeDBClusterSnapshotAttributes",
        "DescribeDBClusterSnapshots",
        "DescribeDBClusters",
        "DescribeDBEngineVersions",
        "DescribeDBInstanceAutomatedBackups",
        "DescribeDBInstances",
        "DescribeDBLogFiles",
        "DescribeDBParameterGroups",
        "DescribeDBParameters",
        "DescribeDBProxies",
        "DescribeDBProxyTargetGroups",
        "DescribeDBProxyTargets",
        "DescribeDBSecurityGroups",
        "DescribeDBSnapshotAttributes",
        "DescribeDBSnapshots",
        "DescribeDBSubnetGroups",
        "DescribeEngineDefaultClusterParameters",
        "DescribeEngineDefaultParameters",
        "DescribeEventCategories",
        "DescribeEventSubscriptions",
        "DescribeEvents",
        "DescribeExportTasks",
        "DescribeGlobalClusters",
        "DescribeOptionGroupOptions",
        "DescribeOptionGroups",
        "DescribeOrderableDBInstanceOptions",
        "DescribePendingMaintenanceActions",
        "DescribeReservedDBInstances",
        "DescribeReservedDBInstancesOfferings",
        "DescribeSourceRegions",
        "DescribeValidDBInstanceModifications",
        "DownloadCompleteDBLogFile",
        "DownloadDBLogFilePortion",
        "FailoverDBCluster",
        "ListTagsForResource",
        "ModifyCurrentDBClusterCapacity",
        "ModifyDBCluster",
        "ModifyDBClusterEndpoint",
        "ModifyDBClusterParameterGroup",
        "ModifyDBClusterSnapshotAttribute",
        "ModifyDBInstance",
        "ModifyDBParameterGroup",
        "ModifyDBProxy",
        "ModifyDBProxyTargetGroup",
        "ModifyDBSnapshot",
        "ModifyDBSnapshotAttribute",
        "ModifyDBSubnetGroup",
        "ModifyEventSubscription",
        "ModifyGlobalCluster",
        "ModifyOptionGroup",
        "PromoteReadReplica",
        "PromoteReadReplicaDBCluster",
        "PurchaseReservedDBInstancesOffering",
        "RebootDBInstance",
        "RegisterDBProxyTargets",
        "RemoveFromGlobalCluster",
        "RemoveRoleFromDBCluster",
        "RemoveRoleFromDBInstance",
        "RemoveSourceIdentifierFromSubscription",
        "RemoveTagsFromResource",
        "ResetDBClusterParameterGroup",
        "ResetDBParameterGroup",
        "RestoreDBClusterFromS3",
        "RestoreDBClusterFromSnapshot",
        "RestoreDBClusterToPointInTime",
        "RestoreDBInstanceFromDBSnapshot",
        "RestoreDBInstanceFromS3",
        "RestoreDBInstanceToPointInTime",
        "RevokeDBSecurityGroupIngress",
        "StartActivityStream",
        "StartDBCluster",
        "StartDBInstance",
        "StartExportTask",
        "StopActivityStream",
        "StopDBCluster",
        "StopDBInstance",
    ],
    "rds-data": [
        "BatchExecuteStatement",
        "BeginTransaction",
        "CommitTransaction",
        "ExecuteSql",
        "ExecuteStatement",
        "RollbackTransaction",
    ],
    "rds-db": ["connect"],
    "redshift": [
        "AcceptReservedNodeExchange",
        "AuthorizeClusterSecurityGroupIngress",
        "AuthorizeSnapshotAccess",
        "BatchDeleteClusterSnapshots",
        "BatchModifyClusterSnapshots",
        "CancelQuery",
        "CancelQuerySession",
        "CancelResize",
        "CopyClusterSnapshot",
        "CreateCluster",
        "CreateClusterParameterGroup",
        "CreateClusterSecurityGroup",
        "CreateClusterSnapshot",
        "CreateClusterSubnetGroup",
        "CreateClusterUser",
        "CreateEventSubscription",
        "CreateHsmClientCertificate",
        "CreateHsmConfiguration",
        "CreateSavedQuery",
        "CreateScheduledAction",
        "CreateSnapshotCopyGrant",
        "CreateSnapshotSchedule",
        "CreateTags",
        "DeleteCluster",
        "DeleteClusterParameterGroup",
        "DeleteClusterSecurityGroup",
        "DeleteClusterSnapshot",
        "DeleteClusterSubnetGroup",
        "DeleteEventSubscription",
        "DeleteHsmClientCertificate",
        "DeleteHsmConfiguration",
        "DeleteSavedQueries",
        "DeleteScheduledAction",
        "DeleteSnapshotCopyGrant",
        "DeleteSnapshotSchedule",
        "DeleteTags",
        "DescribeAccountAttributes",
        "DescribeClusterDbRevisions",
        "DescribeClusterParameterGroups",
        "DescribeClusterParameters",
        "DescribeClusterSecurityGroups",
        "DescribeClusterSnapshots",
        "DescribeClusterSubnetGroups",
        "DescribeClusterTracks",
        "DescribeClusterVersions",
        "DescribeClusters",
        "DescribeDefaultClusterParameters",
        "DescribeEventCategories",
        "DescribeEventSubscriptions",
        "DescribeEvents",
        "DescribeHsmClientCertificates",
        "DescribeHsmConfigurations",
        "DescribeLoggingStatus",
        "DescribeNodeConfigurationOptions",
        "DescribeOrderableClusterOptions",
        "DescribeQuery",
        "DescribeReservedNodeOfferings",
        "DescribeReservedNodes",
        "DescribeResize",
        "DescribeSavedQueries",
        "DescribeScheduledActions",
        "DescribeSnapshotCopyGrants",
        "DescribeSnapshotSchedules",
        "DescribeStorage",
        "DescribeTable",
        "DescribeTableRestoreStatus",
        "DescribeTags",
        "DisableLogging",
        "DisableSnapshotCopy",
        "EnableLogging",
        "EnableSnapshotCopy",
        "ExecuteQuery",
        "FetchResults",
        "GetClusterCredentials",
        "GetReservedNodeExchangeOfferings",
        "JoinGroup",
        "ListDatabases",
        "ListSavedQueries",
        "ListSchemas",
        "ListTables",
        "ModifyCluster",
        "ModifyClusterDbRevision",
        "ModifyClusterIamRoles",
        "ModifyClusterMaintenance",
        "ModifyClusterParameterGroup",
        "ModifyClusterSnapshot",
        "ModifyClusterSnapshotSchedule",
        "ModifyClusterSubnetGroup",
        "ModifyEventSubscription",
        "ModifySavedQuery",
        "ModifyScheduledAction",
        "ModifySnapshotCopyRetentionPeriod",
        "ModifySnapshotSchedule",
        "PauseCluster",
        "PurchaseReservedNodeOffering",
        "RebootCluster",
        "ResetClusterParameterGroup",
        "ResizeCluster",
        "RestoreFromClusterSnapshot",
        "RestoreTableFromClusterSnapshot",
        "ResumeCluster",
        "RevokeClusterSecurityGroupIngress",
        "RevokeSnapshotAccess",
        "RotateEncryptionKey",
        "ViewQueriesFromConsole",
        "ViewQueriesInConsole",
    ],
    "rekognition": [
        "CompareFaces",
        "CreateCollection",
        "CreateProject",
        "CreateProjectVersion",
        "CreateStreamProcessor",
        "DeleteCollection",
        "DeleteFaces",
        "DeleteProject",
        "DeleteProjectVersion",
        "DeleteStreamProcessor",
        "DescribeCollection",
        "DescribeProjectVersions",
        "DescribeProjects",
        "DescribeStreamProcessor",
        "DetectCustomLabels",
        "DetectFaces",
        "DetectLabels",
        "DetectModerationLabels",
        "DetectText",
        "GetCelebrityInfo",
        "GetCelebrityRecognition",
        "GetContentModeration",
        "GetFaceDetection",
        "GetFaceSearch",
        "GetLabelDetection",
        "GetPersonTracking",
        "GetTextDetection",
        "IndexFaces",
        "ListCollections",
        "ListFaces",
        "ListStreamProcessors",
        "RecognizeCelebrities",
        "SearchFaces",
        "SearchFacesByImage",
        "StartCelebrityRecognition",
        "StartContentModeration",
        "StartFaceDetection",
        "StartFaceSearch",
        "StartLabelDetection",
        "StartPersonTracking",
        "StartProjectVersion",
        "StartStreamProcessor",
        "StartTextDetection",
        "StopProjectVersion",
        "StopStreamProcessor",
    ],
    "tag": [
        "DescribeReportCreation",
        "GetComplianceSummary",
        "GetResources",
        "GetTagKeys",
        "GetTagValues",
        "StartReportCreation",
        "TagResources",
        "UntagResources",
    ],
    "route53": [
        "AssociateVPCWithHostedZone",
        "ChangeResourceRecordSets",
        "ChangeTagsForResource",
        "CreateHealthCheck",
        "CreateHostedZone",
        "CreateQueryLoggingConfig",
        "CreateReusableDelegationSet",
        "CreateTrafficPolicy",
        "CreateTrafficPolicyInstance",
        "CreateTrafficPolicyVersion",
        "CreateVPCAssociationAuthorization",
        "DeleteHealthCheck",
        "DeleteHostedZone",
        "DeleteQueryLoggingConfig",
        "DeleteReusableDelegationSet",
        "DeleteTrafficPolicy",
        "DeleteTrafficPolicyInstance",
        "DeleteVPCAssociationAuthorization",
        "DisassociateVPCFromHostedZone",
        "GetAccountLimit",
        "GetChange",
        "GetCheckerIpRanges",
        "GetGeoLocation",
        "GetHealthCheck",
        "GetHealthCheckCount",
        "GetHealthCheckLastFailureReason",
        "GetHealthCheckStatus",
        "GetHostedZone",
        "GetHostedZoneCount",
        "GetHostedZoneLimit",
        "GetQueryLoggingConfig",
        "GetReusableDelegationSet",
        "GetReusableDelegationSetLimit",
        "GetTrafficPolicy",
        "GetTrafficPolicyInstance",
        "GetTrafficPolicyInstanceCount",
        "ListGeoLocations",
        "ListHealthChecks",
        "ListHostedZones",
        "ListHostedZonesByName",
        "ListQueryLoggingConfigs",
        "ListResourceRecordSets",
        "ListReusableDelegationSets",
        "ListTagsForResource",
        "ListTagsForResources",
        "ListTrafficPolicies",
        "ListTrafficPolicyInstances",
        "ListTrafficPolicyInstancesByHostedZone",
        "ListTrafficPolicyInstancesByPolicy",
        "ListTrafficPolicyVersions",
        "ListVPCAssociationAuthorizations",
        "TestDNSAnswer",
        "UpdateHealthCheck",
        "UpdateHostedZoneComment",
        "UpdateTrafficPolicyComment",
        "UpdateTrafficPolicyInstance",
    ],
    "route53resolver": [
        "AssociateResolverEndpointIpAddress",
        "AssociateResolverRule",
        "CreateResolverEndpoint",
        "CreateResolverRule",
        "DeleteResolverEndpoint",
        "DeleteResolverRule",
        "DisassociateResolverEndpointIpAddress",
        "DisassociateResolverRule",
        "GetResolverEndpoint",
        "GetResolverRule",
        "GetResolverRuleAssociation",
        "GetResolverRulePolicy",
        "ListResolverEndpointIpAddresses",
        "ListResolverEndpoints",
        "ListResolverRuleAssociations",
        "ListResolverRules",
        "ListTagsForResource",
        "PutResolverRulePolicy",
        "TagResource",
        "UntagResource",
        "UpdateResolverEndpoint",
        "UpdateResolverRule",
    ],
    "route53domains": [
        "CheckDomainAvailability",
        "DeleteTagsForDomain",
        "DisableDomainAutoRenew",
        "DisableDomainTransferLock",
        "EnableDomainAutoRenew",
        "EnableDomainTransferLock",
        "GetContactReachabilityStatus",
        "GetDomainDetail",
        "GetDomainSuggestions",
        "GetOperationDetail",
        "ListDomains",
        "ListOperations",
        "ListTagsForDomain",
        "RegisterDomain",
        "RenewDomain",
        "ResendContactReachabilityEmail",
        "RetrieveDomainAuthCode",
        "TransferDomain",
        "UpdateDomainContact",
        "UpdateDomainContactPrivacy",
        "UpdateDomainNameservers",
        "UpdateTagsForDomain",
        "ViewBilling",
    ],
    "s3": [
        "AbortMultipartUpload",
        "BypassGovernanceRetention",
        "CreateAccessPoint",
        "CreateBucket",
        "CreateJob",
        "DeleteAccessPoint",
        "DeleteAccessPointPolicy",
        "DeleteBucket",
        "DeleteBucketPolicy",
        "DeleteBucketWebsite",
        "DeleteObject",
        "DeleteObjectTagging",
        "DeleteObjectVersion",
        "DeleteObjectVersionTagging",
        "DescribeJob",
        "GetAccelerateConfiguration",
        "GetAccessPoint",
        "GetAccessPointPolicy",
        "GetAccessPointPolicyStatus",
        "GetAccountPublicAccessBlock",
        "GetAnalyticsConfiguration",
        "GetBucketAcl",
        "GetBucketCORS",
        "GetBucketLocation",
        "GetBucketLogging",
        "GetBucketNotification",
        "GetBucketObjectLockConfiguration",
        "GetBucketPolicy",
        "GetBucketPolicyStatus",
        "GetBucketPublicAccessBlock",
        "GetBucketRequestPayment",
        "GetBucketTagging",
        "GetBucketVersioning",
        "GetBucketWebsite",
        "GetEncryptionConfiguration",
        "GetInventoryConfiguration",
        "GetLifecycleConfiguration",
        "GetMetricsConfiguration",
        "GetObject",
        "GetObjectAcl",
        "GetObjectLegalHold",
        "GetObjectRetention",
        "GetObjectTagging",
        "GetObjectTorrent",
        "GetObjectVersion",
        "GetObjectVersionAcl",
        "GetObjectVersionForReplication",
        "GetObjectVersionTagging",
        "GetObjectVersionTorrent",
        "GetReplicationConfiguration",
        "HeadBucket",
        "ListAccessPoints",
        "ListAllMyBuckets",
        "ListBucket",
        "ListBucketMultipartUploads",
        "ListBucketVersions",
        "ListJobs",
        "ListMultipartUploadParts",
        "ObjectOwnerOverrideToBucketOwner",
        "PutAccelerateConfiguration",
        "PutAccessPointPolicy",
        "PutAccountPublicAccessBlock",
        "PutAnalyticsConfiguration",
        "PutBucketAcl",
        "PutBucketCORS",
        "PutBucketLogging",
        "PutBucketNotification",
        "PutBucketObjectLockConfiguration",
        "PutBucketPolicy",
        "PutBucketPublicAccessBlock",
        "PutBucketRequestPayment",
        "PutBucketTagging",
        "PutBucketVersioning",
        "PutBucketWebsite",
        "PutEncryptionConfiguration",
        "PutInventoryConfiguration",
        "PutLifecycleConfiguration",
        "PutMetricsConfiguration",
        "PutObject",
        "PutObjectAcl",
        "PutObjectLegalHold",
        "PutObjectRetention",
        "PutObjectTagging",
        "PutObjectVersionAcl",
        "PutObjectVersionTagging",
        "PutReplicationConfiguration",
        "ReplicateDelete",
        "ReplicateObject",
        "ReplicateTags",
        "RestoreObject",
        "UpdateJobPriority",
        "UpdateJobStatus",
    ],
    "sns": [
        "AddPermission",
        "CheckIfPhoneNumberIsOptedOut",
        "ConfirmSubscription",
        "CreatePlatformApplication",
        "CreatePlatformEndpoint",
        "CreateTopic",
        "DeleteEndpoint",
        "DeletePlatformApplication",
        "DeleteTopic",
        "GetEndpointAttributes",
        "GetPlatformApplicationAttributes",
        "GetSMSAttributes",
        "GetSubscriptionAttributes",
        "GetTopicAttributes",
        "ListEndpointsByPlatformApplication",
        "ListPhoneNumbersOptedOut",
        "ListPlatformApplications",
        "ListSubscriptions",
        "ListSubscriptionsByTopic",
        "ListTagsForResource",
        "ListTopics",
        "OptInPhoneNumber",
        "Publish",
        "RemovePermission",
        "SetEndpointAttributes",
        "SetPlatformApplicationAttributes",
        "SetSMSAttributes",
        "SetSubscriptionAttributes",
        "SetTopicAttributes",
        "Subscribe",
        "TagResource",
        "Unsubscribe",
        "UntagResource",
    ],
    "sqs": [
        "AddPermission",
        "ChangeMessageVisibility",
        "ChangeMessageVisibilityBatch",
        "CreateQueue",
        "DeleteMessage",
        "DeleteMessageBatch",
        "DeleteQueue",
        "GetQueueAttributes",
        "GetQueueUrl",
        "ListDeadLetterSourceQueues",
        "ListQueueTags",
        "ListQueues",
        "PurgeQueue",
        "ReceiveMessage",
        "RemovePermission",
        "SendMessage",
        "SendMessageBatch",
        "SetQueueAttributes",
        "TagQueue",
        "UntagQueue",
    ],
    "sagemaker": [
        "AddTags",
        "AssociateTrialComponent",
        "BatchGetMetrics",
        "BatchPutMetrics",
        "CreateAlgorithm",
        "CreateApp",
        "CreateAutoMLJob",
        "CreateCodeRepository",
        "CreateCompilationJob",
        "CreateDomain",
        "CreateEndpoint",
        "CreateEndpointConfig",
        "CreateExperiment",
        "CreateFlowDefinition",
        "CreateHumanTaskUi",
        "CreateHyperParameterTuningJob",
        "CreateLabelingJob",
        "CreateModel",
        "CreateModelPackage",
        "CreateMonitoringSchedule",
        "CreateNotebookInstance",
        "CreateNotebookInstanceLifecycleConfig",
        "CreatePresignedDomainUrl",
        "CreatePresignedNotebookInstanceUrl",
        "CreateProcessingJob",
        "CreateTrainingJob",
        "CreateTransformJob",
        "CreateTrial",
        "CreateTrialComponent",
        "CreateUserProfile",
        "CreateWorkteam",
        "DeleteAlgorithm",
        "DeleteApp",
        "DeleteCodeRepository",
        "DeleteDomain",
        "DeleteEndpoint",
        "DeleteEndpointConfig",
        "DeleteExperiment",
        "DeleteFlowDefinition",
        "DeleteHumanLoop",
        "DeleteModel",
        "DeleteModelPackage",
        "DeleteMonitoringSchedule",
        "DeleteNotebookInstance",
        "DeleteNotebookInstanceLifecycleConfig",
        "DeleteTags",
        "DeleteTrial",
        "DeleteTrialComponent",
        "DeleteUserProfile",
        "DeleteWorkteam",
        "DescribeAlgorithm",
        "DescribeApp",
        "DescribeAutoMLJob",
        "DescribeCodeRepository",
        "DescribeCompilationJob",
        "DescribeDomain",
        "DescribeEndpoint",
        "DescribeEndpointConfig",
        "DescribeExperiment",
        "DescribeFlowDefinition",
        "DescribeHumanLoop",
        "DescribeHumanTaskUi",
        "DescribeHyperParameterTuningJob",
        "DescribeLabelingJob",
        "DescribeModel",
        "DescribeModelPackage",
        "DescribeMonitoringSchedule",
        "DescribeNotebookInstance",
        "DescribeNotebookInstanceLifecycleConfig",
        "DescribeProcessingJob",
        "DescribeSubscribedWorkteam",
        "DescribeTrainingJob",
        "DescribeTransformJob",
        "DescribeTrial",
        "DescribeTrialComponent",
        "DescribeUserProfile",
        "DescribeWorkforce",
        "DescribeWorkteam",
        "DisassociateTrialComponent",
        "GetSearchSuggestions",
        "InvokeEndpoint",
        "ListAlgorithms",
        "ListApps",
        "ListAutoMLJobs",
        "ListCandidatesForAutoMLJob",
        "ListCodeRepositories",
        "ListCompilationJobs",
        "ListDomains",
        "ListEndpointConfigs",
        "ListEndpoints",
        "ListExperiments",
        "ListFlowDefinitions",
        "ListHumanLoops",
        "ListHumanTaskUis",
        "ListHyperParameterTuningJobs",
        "ListLabelingJobs",
        "ListLabelingJobsForWorkteam",
        "ListModelPackages",
        "ListModels",
        "ListMonitoringExecutions",
        "ListMonitoringSchedules",
        "ListNotebookInstanceLifecycleConfigs",
        "ListNotebookInstances",
        "ListProcessingJobs",
        "ListSubscribedWorkteams",
        "ListTags",
        "ListTrainingJobs",
        "ListTrainingJobsForHyperParameterTuningJob",
        "ListTransformJobs",
        "ListTrialComponents",
        "ListTrials",
        "ListUserProfiles",
        "ListWorkteams",
        "RenderUiTemplate",
        "Search",
        "StartHumanLoop",
        "StartMonitoringSchedule",
        "StartNotebookInstance",
        "StopAutoMLJob",
        "StopCompilationJob",
        "StopHumanLoop",
        "StopHyperParameterTuningJob",
        "StopLabelingJob",
        "StopMonitoringSchedule",
        "StopNotebookInstance",
        "StopProcessingJob",
        "StopTrainingJob",
        "StopTransformJob",
        "UpdateCodeRepository",
        "UpdateDomain",
        "UpdateEndpoint",
        "UpdateEndpointWeightsAndCapacities",
        "UpdateExperiment",
        "UpdateMonitoringSchedule",
        "UpdateNotebookInstance",
        "UpdateNotebookInstanceLifecycleConfig",
        "UpdateTrial",
        "UpdateTrialComponent",
        "UpdateUserProfile",
        "UpdateWorkforce",
        "UpdateWorkteam",
    ],
    "ssmmessages": [
        "CreateControlChannel",
        "CreateDataChannel",
        "OpenControlChannel",
        "OpenDataChannel",
    ],
    "swf": [
        "CancelTimer",
        "CancelWorkflowExecution",
        "CompleteWorkflowExecution",
        "ContinueAsNewWorkflowExecution",
        "CountClosedWorkflowExecutions",
        "CountOpenWorkflowExecutions",
        "CountPendingActivityTasks",
        "CountPendingDecisionTasks",
        "DeprecateActivityType",
        "DeprecateDomain",
        "DeprecateWorkflowType",
        "DescribeActivityType",
        "DescribeDomain",
        "DescribeWorkflowExecution",
        "DescribeWorkflowType",
        "FailWorkflowExecution",
        "GetWorkflowExecutionHistory",
        "ListActivityTypes",
        "ListClosedWorkflowExecutions",
        "ListDomains",
        "ListOpenWorkflowExecutions",
        "ListTagsForResource",
        "ListWorkflowTypes",
        "PollForActivityTask",
        "PollForDecisionTask",
        "RecordActivityTaskHeartbeat",
        "RecordMarker",
        "RegisterActivityType",
        "RegisterDomain",
        "RegisterWorkflowType",
        "RequestCancelActivityTask",
        "RequestCancelExternalWorkflowExecution",
        "RequestCancelWorkflowExecution",
        "RespondActivityTaskCanceled",
        "RespondActivityTaskCompleted",
        "RespondActivityTaskFailed",
        "RespondDecisionTaskCompleted",
        "ScheduleActivityTask",
        "SignalExternalWorkflowExecution",
        "SignalWorkflowExecution",
        "StartChildWorkflowExecution",
        "StartTimer",
        "StartWorkflowExecution",
        "TagResource",
        "TerminateWorkflowExecution",
        "UntagResource",
    ],
    "sdb": [
        "BatchDeleteAttributes",
        "BatchPutAttributes",
        "CreateDomain",
        "DeleteAttributes",
        "DeleteDomain",
        "DomainMetadata",
        "GetAttributes",
        "ListDomains",
        "PutAttributes",
        "Select",
    ],
    "storagegateway": [
        "ActivateGateway",
        "AddCache",
        "AddTagsToResource",
        "AddUploadBuffer",
        "AddWorkingStorage",
        "AttachVolume",
        "CancelArchival",
        "CancelRetrieval",
        "CreateCachediSCSIVolume",
        "CreateNFSFileShare",
        "CreateSMBFileShare",
        "CreateSnapshot",
        "CreateSnapshotFromVolumeRecoveryPoint",
        "CreateStorediSCSIVolume",
        "CreateTapeWithBarcode",
        "CreateTapes",
        "DeleteBandwidthRateLimit",
        "DeleteChapCredentials",
        "DeleteFileShare",
        "DeleteGateway",
        "DeleteSnapshotSchedule",
        "DeleteTape",
        "DeleteTapeArchive",
        "DeleteVolume",
        "DescribeBandwidthRateLimit",
        "DescribeCache",
        "DescribeCachediSCSIVolumes",
        "DescribeChapCredentials",
        "DescribeGatewayInformation",
        "DescribeMaintenanceStartTime",
        "DescribeNFSFileShares",
        "DescribeSMBFileShares",
        "DescribeSMBSettings",
        "DescribeSnapshotSchedule",
        "DescribeStorediSCSIVolumes",
        "DescribeTapeArchives",
        "DescribeTapeRecoveryPoints",
        "DescribeTapes",
        "DescribeUploadBuffer",
        "DescribeVTLDevices",
        "DescribeWorkingStorage",
        "DetachVolume",
        "DisableGateway",
        "JoinDomain",
        "ListFileShares",
        "ListGateways",
        "ListLocalDisks",
        "ListTagsForResource",
        "ListTapes",
        "ListVolumeInitiators",
        "ListVolumeRecoveryPoints",
        "ListVolumes",
        "NotifyWhenUploaded",
        "RefreshCache",
        "RemoveTagsFromResource",
        "ResetCache",
        "RetrieveTapeArchive",
        "RetrieveTapeRecoveryPoint",
        "SetLocalConsolePassword",
        "SetSMBGuestPassword",
        "ShutdownGateway",
        "StartGateway",
        "UpdateBandwidthRateLimit",
        "UpdateChapCredentials",
        "UpdateGatewayInformation",
        "UpdateGatewaySoftwareNow",
        "UpdateMaintenanceStartTime",
        "UpdateNFSFileShare",
        "UpdateSMBFileShare",
        "UpdateSnapshotSchedule",
        "UpdateVTLDeviceType",
    ],
    "sumerian": ["Login", "ViewRelease"],
    "textract": [
        "AnalyzeDocument",
        "DetectDocumentText",
        "GetDocumentAnalysis",
        "GetDocumentTextDetection",
        "StartDocumentAnalysis",
        "StartDocumentTextDetection",
    ],
    "transcribe": [
        "CreateVocabulary",
        "CreateVocabularyFilter",
        "DeleteTranscriptionJob",
        "DeleteVocabulary",
        "DeleteVocabularyFilter",
        "GetTranscriptionJob",
        "GetVocabulary",
        "GetVocabularyFilter",
        "ListTranscriptionJobs",
        "ListVocabularies",
        "ListVocabularyFilters",
        "StartMedicalStreamTranscription",
        "StartStreamTranscription",
        "StartTranscriptionJob",
        "UpdateVocabulary",
        "UpdateVocabularyFilter",
    ],
    "translate": [
        "DeleteTerminology",
        "DescribeTextTranslationJob",
        "GetTerminology",
        "ImportTerminology",
        "ListTerminologies",
        "ListTextTranslationJobs",
        "StartTextTranslationJob",
        "StopTextTranslationJob",
        "TranslateText",
    ],
    "workdocs": [
        "AbortDocumentVersionUpload",
        "ActivateUser",
        "AddResourcePermissions",
        "AddUserToGroup",
        "CheckAlias",
        "CreateComment",
        "CreateCustomMetadata",
        "CreateFolder",
        "CreateInstance",
        "CreateLabels",
        "CreateNotificationSubscription",
        "CreateUser",
        "DeactivateUser",
        "DeleteComment",
        "DeleteCustomMetadata",
        "DeleteDocument",
        "DeleteFolder",
        "DeleteFolderContents",
        "DeleteInstance",
        "DeleteLabels",
        "DeleteNotificationSubscription",
        "DeleteUser",
        "DeregisterDirectory",
        "DescribeActivities",
        "DescribeAvailableDirectories",
        "DescribeComments",
        "DescribeDocumentVersions",
        "DescribeFolderContents",
        "DescribeGroups",
        "DescribeInstances",
        "DescribeNotificationSubscriptions",
        "DescribeResourcePermissions",
        "DescribeRootFolders",
        "DescribeUsers",
        "DownloadDocumentVersion",
        "GetCurrentUser",
        "GetDocument",
        "GetDocumentPath",
        "GetDocumentVersion",
        "GetFolder",
        "GetFolderPath",
        "GetResources",
        "InitiateDocumentVersionUpload",
        "RegisterDirectory",
        "RemoveAllResourcePermissions",
        "RemoveResourcePermission",
        "UpdateDocument",
        "UpdateDocumentVersion",
        "UpdateFolder",
        "UpdateInstanceAlias",
        "UpdateUser",
    ],
    "worklink": [
        "AssociateDomain",
        "AssociateWebsiteAuthorizationProvider",
        "AssociateWebsiteCertificateAuthority",
        "CreateFleet",
        "DeleteFleet",
        "DescribeAuditStreamConfiguration",
        "DescribeCompanyNetworkConfiguration",
        "DescribeDevice",
        "DescribeDevicePolicyConfiguration",
        "DescribeDomain",
        "DescribeFleetMetadata",
        "DescribeIdentityProviderConfiguration",
        "DescribeWebsiteCertificateAuthority",
        "DisassociateDomain",
        "DisassociateWebsiteAuthorizationProvider",
        "DisassociateWebsiteCertificateAuthority",
        "ListDevices",
        "ListDomains",
        "ListFleets",
        "ListWebsiteAuthorizationProviders",
        "ListWebsiteCertificateAuthorities",
        "RestoreDomainAccess",
        "RevokeDomainAccess",
        "SignOutUser",
        "UpdateAuditStreamConfiguration",
        "UpdateCompanyNetworkConfiguration",
        "UpdateDevicePolicyConfiguration",
        "UpdateDomainMetadata",
        "UpdateFleetMetadata",
        "UpdateIdentityProviderConfiguration",
    ],
    "workmail": [
        "AddMembersToGroup",
        "AssociateDelegateToResource",
        "AssociateMemberToGroup",
        "CreateAlias",
        "CreateGroup",
        "CreateInboundMailFlowRule",
        "CreateMailDomain",
        "CreateMailUser",
        "CreateOrganization",
        "CreateOutboundMailFlowRule",
        "CreateResource",
        "CreateSmtpGateway",
        "CreateUser",
        "DeleteAccessControlRule",
        "DeleteAlias",
        "DeleteGroup",
        "DeleteInboundMailFlowRule",
        "DeleteMailDomain",
        "DeleteMailboxPermissions",
        "DeleteMobileDevice",
        "DeleteOrganization",
        "DeleteOutboundMailFlowRule",
        "DeleteResource",
        "DeleteSmtpGateway",
        "DeleteUser",
        "DeregisterFromWorkMail",
        "DescribeDirectories",
        "DescribeGroup",
        "DescribeInboundMailFlowRule",
        "DescribeKmsKeys",
        "DescribeMailDomains",
        "DescribeMailGroups",
        "DescribeMailUsers",
        "DescribeOrganization",
        "DescribeOrganizations",
        "DescribeOutboundMailFlowRule",
        "DescribeResource",
        "DescribeSmtpGateway",
        "DescribeUser",
        "DisableMailGroups",
        "DisableMailUsers",
        "DisassociateDelegateFromResource",
        "DisassociateMemberFromGroup",
        "EnableMailDomain",
        "EnableMailGroups",
        "EnableMailUsers",
        "GetAccessControlEffect",
        "GetJournalingRules",
        "GetMailDomainDetails",
        "GetMailGroupDetails",
        "GetMailUserDetails",
        "GetMailboxDetails",
        "GetMobileDeviceDetails",
        "GetMobileDevicesForUser",
        "GetMobilePolicyDetails",
        "ListAccessControlRules",
        "ListAliases",
        "ListGroupMembers",
        "ListGroups",
        "ListInboundMailFlowRules",
        "ListMailboxPermissions",
        "ListMembersInMailGroup",
        "ListOrganizations",
        "ListOutboundMailFlowRules",
        "ListResourceDelegates",
        "ListResources",
        "ListSmtpGateways",
        "ListTagsForResource",
        "ListUsers",
        "PutAccessControlRule",
        "PutMailboxPermissions",
        "RegisterToWorkMail",
        "RemoveMembersFromGroup",
        "ResetPassword",
        "ResetUserPassword",
        "SearchMembers",
        "SetAdmin",
        "SetDefaultMailDomain",
        "SetJournalingRules",
        "SetMailGroupDetails",
        "SetMailUserDetails",
        "SetMobilePolicyDetails",
        "TagResource",
        "TestInboundMailFlowRules",
        "TestOutboundMailFlowRules",
        "UntagResource",
        "UpdateInboundMailFlowRule",
        "UpdateMailboxQuota",
        "UpdateOutboundMailFlowRule",
        "UpdatePrimaryEmailAddress",
        "UpdateResource",
        "UpdateSmtpGateway",
        "WipeMobileDevice",
    ],
    "workmailmessageflow": ["GetRawMessageContent"],
    "workspaces": [
        "AssociateIpGroups",
        "AuthorizeIpRules",
        "CreateIpGroup",
        "CreateTags",
        "CreateWorkspaces",
        "DeleteIpGroup",
        "DeleteTags",
        "DeleteWorkspaceImage",
        "DescribeAccount",
        "DescribeAccountModifications",
        "DescribeClientProperties",
        "DescribeIpGroups",
        "DescribeTags",
        "DescribeWorkspaceBundles",
        "DescribeWorkspaceDirectories",
        "DescribeWorkspaceImages",
        "DescribeWorkspaces",
        "DescribeWorkspacesConnectionStatus",
        "DisassociateIpGroups",
        "ImportWorkspaceImage",
        "ListAvailableManagementCidrRanges",
        "ModifyAccount",
        "ModifyClientProperties",
        "ModifyWorkspaceProperties",
        "ModifyWorkspaceState",
        "RebootWorkspaces",
        "RebuildWorkspaces",
        "RevokeIpRules",
        "StartWorkspaces",
        "StopWorkspaces",
        "TerminateWorkspaces",
        "UpdateRulesOfIpGroup",
    ],
    "wam": ["AuthenticatePackager"],
    "application-autoscaling": [
        "DeleteScalingPolicy",
        "DeleteScheduledAction",
        "DeregisterScalableTarget",
        "DescribeScalableTargets",
        "DescribeScalingActivities",
        "DescribeScalingPolicies",
        "DescribeScheduledActions",
        "PutScalingPolicy",
        "PutScheduledAction",
        "RegisterScalableTarget",
    ],
    "discovery": [
        "AssociateConfigurationItemsToApplication",
        "BatchDeleteImportData",
        "CreateApplication",
        "CreateTags",
        "DeleteApplications",
        "DeleteTags",
        "DescribeAgents",
        "DescribeConfigurations",
        "DescribeContinuousExports",
        "DescribeExportConfigurations",
        "DescribeExportTasks",
        "DescribeImportTasks",
        "DescribeTags",
        "DisassociateConfigurationItemsFromApplication",
        "ExportConfigurations",
        "GetDiscoverySummary",
        "ListConfigurations",
        "ListServerNeighbors",
        "StartContinuousExport",
        "StartDataCollectionByAgentIds",
        "StartExportTask",
        "StartImportTask",
        "StopContinuousExport",
        "StopDataCollectionByAgentIds",
        "UpdateApplication",
    ],
    "arsenal": ["RegisterOnPremisesAgent"],
    "applicationinsights": [
        "CreateApplication",
        "CreateComponent",
        "DeleteApplication",
        "DeleteComponent",
        "DescribeApplication",
        "DescribeComponent",
        "DescribeComponentConfiguration",
        "DescribeComponentConfigurationRecommendation",
        "DescribeObservation",
        "DescribeProblem",
        "DescribeProblemObservations",
        "ListApplications",
        "ListComponents",
        "ListProblems",
        "UpdateApplication",
        "UpdateComponent",
        "UpdateComponentConfiguration",
    ],
    "comprehendmedical": ["DetectEntities", "DetectPHI"],
    "compute-optimizer": [
        "GetAutoScalingGroupRecommendations",
        "GetEC2InstanceRecommendations",
        "GetEC2RecommendationProjectedMetrics",
        "GetEnrollmentStatus",
        "GetRecommendationSummaries",
        "UpdateEnrollmentStatus",
    ],
    "datapipeline": [
        "ActivatePipeline",
        "AddTags",
        "CreatePipeline",
        "DeactivatePipeline",
        "DeletePipeline",
        "DescribeObjects",
        "DescribePipelines",
        "EvaluateExpression",
        "GetAccountLimits",
        "GetPipelineDefinition",
        "ListPipelines",
        "PollForTask",
        "PutAccountLimits",
        "PutPipelineDefinition",
        "QueryObjects",
        "RemoveTags",
        "ReportTaskProgress",
        "ReportTaskRunnerHeartbeat",
        "SetStatus",
        "SetTaskStatus",
        "ValidatePipelineDefinition",
    ],
    "datasync": [
        "CancelTaskExecution",
        "CreateAgent",
        "CreateLocationEfs",
        "CreateLocationNfs",
        "CreateLocationS3",
        "CreateLocationSmb",
        "CreateTask",
        "DeleteAgent",
        "DeleteLocation",
        "DeleteTask",
        "DescribeAgent",
        "DescribeLocationEfs",
        "DescribeLocationNfs",
        "DescribeLocationS3",
        "DescribeLocationSmb",
        "DescribeTask",
        "DescribeTaskExecution",
        "ListAgents",
        "ListLocations",
        "ListTagsForResource",
        "ListTaskExecutions",
        "ListTasks",
        "StartTaskExecution",
        "TagResource",
        "UntagResource",
        "UpdateAgent",
        "UpdateTask",
    ],
    "dbqms": [
        "CreateFavoriteQuery",
        "CreateQueryHistory",
        "DeleteFavoriteQueries",
        "DeleteQueryHistory",
        "DescribeFavoriteQueries",
        "DescribeQueryHistory",
        "GetQueryString",
        "UpdateFavoriteQuery",
        "UpdateQueryHistory",
    ],
    "elasticloadbalancing": [
        "AddListenerCertificates",
        "AddTags",
        "ApplySecurityGroupsToLoadBalancer",
        "AttachLoadBalancerToSubnets",
        "ConfigureHealthCheck",
        "CreateAppCookieStickinessPolicy",
        "CreateLBCookieStickinessPolicy",
        "CreateListener",
        "CreateLoadBalancer",
        "CreateLoadBalancerListeners",
        "CreateLoadBalancerPolicy",
        "CreateRule",
        "CreateTargetGroup",
        "DeleteListener",
        "DeleteLoadBalancer",
        "DeleteLoadBalancerListeners",
        "DeleteLoadBalancerPolicy",
        "DeleteRule",
        "DeleteTargetGroup",
        "DeregisterInstancesFromLoadBalancer",
        "DeregisterTargets",
        "DescribeAccountLimits",
        "DescribeInstanceHealth",
        "DescribeListenerCertificates",
        "DescribeListeners",
        "DescribeLoadBalancerAttributes",
        "DescribeLoadBalancerPolicies",
        "DescribeLoadBalancerPolicyTypes",
        "DescribeLoadBalancers",
        "DescribeRules",
        "DescribeSSLPolicies",
        "DescribeTags",
        "DescribeTargetGroupAttributes",
        "DescribeTargetGroups",
        "DescribeTargetHealth",
        "DetachLoadBalancerFromSubnets",
        "DisableAvailabilityZonesForLoadBalancer",
        "EnableAvailabilityZonesForLoadBalancer",
        "ModifyListener",
        "ModifyLoadBalancerAttributes",
        "ModifyRule",
        "ModifyTargetGroup",
        "ModifyTargetGroupAttributes",
        "RegisterInstancesWithLoadBalancer",
        "RegisterTargets",
        "RemoveListenerCertificates",
        "RemoveTags",
        "SetIpAddressType",
        "SetLoadBalancerListenerSSLCertificate",
        "SetLoadBalancerPoliciesForBackendServer",
        "SetLoadBalancerPoliciesOfListener",
        "SetRulePriorities",
        "SetSecurityGroups",
        "SetSubnets",
        "SetWebAcl",
    ],
    "access-analyzer": [
        "CreateAnalyzer",
        "CreateArchiveRule",
        "DeleteAnalyzer",
        "DeleteArchiveRule",
        "GetAnalyzedResource",
        "GetAnalyzer",
        "GetArchiveRule",
        "GetFinding",
        "ListAnalyzedResources",
        "ListAnalyzers",
        "ListArchiveRules",
        "ListFindings",
        "ListTagsForResource",
        "StartResourceScan",
        "TagResource",
        "UntagResource",
        "UpdateArchiveRule",
        "UpdateFindings",
    ],
    "iam": [
        "AddClientIDToOpenIDConnectProvider",
        "AddRoleToInstanceProfile",
        "AddUserToGroup",
        "AttachGroupPolicy",
        "AttachRolePolicy",
        "AttachUserPolicy",
        "ChangePassword",
        "CreateAccessKey",
        "CreateAccountAlias",
        "CreateGroup",
        "CreateInstanceProfile",
        "CreateLoginProfile",
        "CreateOpenIDConnectProvider",
        "CreatePolicy",
        "CreatePolicyVersion",
        "CreateRole",
        "CreateSAMLProvider",
        "CreateServiceLinkedRole",
        "CreateServiceSpecificCredential",
        "CreateUser",
        "CreateVirtualMFADevice",
        "DeactivateMFADevice",
        "DeleteAccessKey",
        "DeleteAccountAlias",
        "DeleteAccountPasswordPolicy",
        "DeleteGroup",
        "DeleteGroupPolicy",
        "DeleteInstanceProfile",
        "DeleteLoginProfile",
        "DeleteOpenIDConnectProvider",
        "DeletePolicy",
        "DeletePolicyVersion",
        "DeleteRole",
        "DeleteRolePermissionsBoundary",
        "DeleteRolePolicy",
        "DeleteSAMLProvider",
        "DeleteSSHPublicKey",
        "DeleteServerCertificate",
        "DeleteServiceLinkedRole",
        "DeleteServiceSpecificCredential",
        "DeleteSigningCertificate",
        "DeleteUser",
        "DeleteUserPermissionsBoundary",
        "DeleteUserPolicy",
        "DeleteVirtualMFADevice",
        "DetachGroupPolicy",
        "DetachRolePolicy",
        "DetachUserPolicy",
        "EnableMFADevice",
        "GenerateCredentialReport",
        "GenerateOrganizationsAccessReport",
        "GenerateServiceLastAccessedDetails",
        "GetAccessKeyLastUsed",
        "GetAccountAuthorizationDetails",
        "GetAccountPasswordPolicy",
        "GetAccountSummary",
        "GetContextKeysForCustomPolicy",
        "GetContextKeysForPrincipalPolicy",
        "GetCredentialReport",
        "GetGroup",
        "GetGroupPolicy",
        "GetInstanceProfile",
        "GetLoginProfile",
        "GetOpenIDConnectProvider",
        "GetOrganizationsAccessReport",
        "GetPolicy",
        "GetPolicyVersion",
        "GetRole",
        "GetRolePolicy",
        "GetSAMLProvider",
        "GetSSHPublicKey",
        "GetServerCertificate",
        "GetServiceLastAccessedDetails",
        "GetServiceLastAccessedDetailsWithEntities",
        "GetServiceLinkedRoleDeletionStatus",
        "GetUser",
        "GetUserPolicy",
        "ListAccessKeys",
        "ListAccountAliases",
        "ListAttachedGroupPolicies",
        "ListAttachedRolePolicies",
        "ListAttachedUserPolicies",
        "ListEntitiesForPolicy",
        "ListGroupPolicies",
        "ListGroups",
        "ListGroupsForUser",
        "ListInstanceProfiles",
        "ListInstanceProfilesForRole",
        "ListMFADevices",
        "ListOpenIDConnectProviders",
        "ListPolicies",
        "ListPoliciesGrantingServiceAccess",
        "ListPolicyVersions",
        "ListRolePolicies",
        "ListRoleTags",
        "ListRoles",
        "ListSAMLProviders",
        "ListSSHPublicKeys",
        "ListServerCertificates",
        "ListServiceSpecificCredentials",
        "ListSigningCertificates",
        "ListUserPolicies",
        "ListUserTags",
        "ListUsers",
        "ListVirtualMFADevices",
        "PassRole",
        "PutGroupPolicy",
        "PutRolePermissionsBoundary",
        "PutRolePolicy",
        "PutUserPermissionsBoundary",
        "PutUserPolicy",
        "RemoveClientIDFromOpenIDConnectProvider",
        "RemoveRoleFromInstanceProfile",
        "RemoveUserFromGroup",
        "ResetServiceSpecificCredential",
        "ResyncMFADevice",
        "SetDefaultPolicyVersion",
        "SetSecurityTokenServicePreferences",
        "SimulateCustomPolicy",
        "SimulatePrincipalPolicy",
        "TagRole",
        "TagUser",
        "UntagRole",
        "UntagUser",
        "UpdateAccessKey",
        "UpdateAccountPasswordPolicy",
        "UpdateAssumeRolePolicy",
        "UpdateGroup",
        "UpdateLoginProfile",
        "UpdateOpenIDConnectProviderThumbprint",
        "UpdateRole",
        "UpdateRoleDescription",
        "UpdateSAMLProvider",
        "UpdateSSHPublicKey",
        "UpdateServerCertificate",
        "UpdateServiceSpecificCredential",
        "UpdateSigningCertificate",
        "UpdateUser",
        "UploadSSHPublicKey",
        "UploadServerCertificate",
        "UploadSigningCertificate",
    ],
    "launchwizard": [
        "DeleteApp",
        "DescribeProvisionedApp",
        "DescribeProvisioningEvents",
        "GetInfrastructureSuggestion",
        "GetIpAddress",
        "GetResourceCostEstimate",
        "ListProvisionedApps",
        "StartProvisioning",
    ],
    "apigateway": [
        "DELETE",
        "GET",
        "PATCH",
        "POST",
        "PUT",
        "SetWebACL",
        "UpdateRestApiPolicy",
    ],
    "networkmanager": [
        "AssociateCustomerGateway",
        "AssociateLink",
        "CreateDevice",
        "CreateGlobalNetwork",
        "CreateLink",
        "CreateSite",
        "DeleteDevice",
        "DeleteGlobalNetwork",
        "DeleteLink",
        "DeleteSite",
        "DeregisterTransitGateway",
        "DescribeGlobalNetworks",
        "DisassociateCustomerGateway",
        "DisassociateLink",
        "GetCustomerGatewayAssociations",
        "GetDevices",
        "GetLinkAssociations",
        "GetLinks",
        "GetSites",
        "GetTransitGatewayRegistrations",
        "ListTagsForResource",
        "RegisterTransitGateway",
        "TagResource",
        "UntagResource",
        "UpdateDevice",
        "UpdateGlobalNetwork",
        "UpdateLink",
        "UpdateSite",
    ],
    "servicequotas": [
        "AssociateServiceQuotaTemplate",
        "DeleteServiceQuotaIncreaseRequestFromTemplate",
        "DisassociateServiceQuotaTemplate",
        "GetAWSDefaultServiceQuota",
        "GetAssociationForServiceQuotaTemplate",
        "GetRequestedServiceQuotaChange",
        "GetServiceQuota",
        "GetServiceQuotaIncreaseRequestFromTemplate",
        "ListAWSDefaultServiceQuotas",
        "ListRequestedServiceQuotaChangeHistory",
        "ListRequestedServiceQuotaChangeHistoryByQuota",
        "ListServiceQuotaIncreaseRequestsInTemplate",
        "ListServiceQuotas",
        "ListServices",
        "PutServiceQuotaIncreaseRequestIntoTemplate",
        "RequestServiceQuotaIncrease",
    ],
}
