import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeTasksConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#database DataSnowflakeTasks#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the tasks from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#schema DataSnowflakeTasks#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeTasksTasks extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
    get warehouse(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks}
*/
export declare class DataSnowflakeTasks extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeTasksConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeTasksConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    tasks(index: string): DataSnowflakeTasksTasks;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
