import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the API integration object that should be used to authenticate the call to the proxy service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#api_integration ExternalFunction#api_integration}
    */
    readonly apiIntegration: string;
    /**
    * A description of the external function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#comment ExternalFunction#comment}
    */
    readonly comment?: string;
    /**
    * If specified, the JSON payload is compressed when sent from Snowflake to the proxy service, and when sent back from the proxy service to Snowflake.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#compression ExternalFunction#compression}
    */
    readonly compression?: string;
    /**
    * Binds Snowflake context function results to HTTP headers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#context_headers ExternalFunction#context_headers}
    */
    readonly contextHeaders?: string[];
    /**
    * The database in which to create the external function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#database ExternalFunction#database}
    */
    readonly database: string;
    /**
    * This specifies the maximum number of rows in each batch sent to the proxy service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#max_batch_rows ExternalFunction#max_batch_rows}
    */
    readonly maxBatchRows?: number;
    /**
    * Specifies the identifier for the external function. The identifier can contain the schema name and database name, as well as the function name. The function's signature (name and argument data types) must be unique within the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the external function when called with null inputs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#null_input_behavior ExternalFunction#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * Specifies the behavior of the function when returning results
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_behavior ExternalFunction#return_behavior}
    */
    readonly returnBehavior: string;
    /**
    * Indicates whether the function can return NULL values or must return only NON-NULL values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_null_allowed ExternalFunction#return_null_allowed}
    */
    readonly returnNullAllowed?: boolean | cdktf.IResolvable;
    /**
    * Specifies the data type returned by the external function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#return_type ExternalFunction#return_type}
    */
    readonly returnType: string;
    /**
    * The schema in which to create the external function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#schema ExternalFunction#schema}
    */
    readonly schema: string;
    /**
    * This is the invocation URL of the proxy service and resource through which Snowflake calls the remote service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#url_of_proxy_and_resource ExternalFunction#url_of_proxy_and_resource}
    */
    readonly urlOfProxyAndResource: string;
    /**
    * arg block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#arg ExternalFunction#arg}
    */
    readonly arg?: ExternalFunctionArg[] | cdktf.IResolvable;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#header ExternalFunction#header}
    */
    readonly header?: ExternalFunctionHeader[] | cdktf.IResolvable;
}
export interface ExternalFunctionArg {
    /**
    * Argument name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Argument type, e.g. VARCHAR
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#type ExternalFunction#type}
    */
    readonly type: string;
}
export declare function externalFunctionArgToTerraform(struct?: ExternalFunctionArg | cdktf.IResolvable): any;
export interface ExternalFunctionHeader {
    /**
    * Header name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#name ExternalFunction#name}
    */
    readonly name: string;
    /**
    * Header value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/external_function#value ExternalFunction#value}
    */
    readonly value: string;
}
export declare function externalFunctionHeaderToTerraform(struct?: ExternalFunctionHeader | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/external_function snowflake_external_function}
*/
export declare class ExternalFunction extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/external_function snowflake_external_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalFunctionConfig
    */
    constructor(scope: Construct, id: string, config: ExternalFunctionConfig);
    private _apiIntegration?;
    get apiIntegration(): string;
    set apiIntegration(value: string);
    get apiIntegrationInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _contextHeaders?;
    get contextHeaders(): string[];
    set contextHeaders(value: string[]);
    resetContextHeaders(): void;
    get contextHeadersInput(): string[] | undefined;
    get createdOn(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _maxBatchRows?;
    get maxBatchRows(): number;
    set maxBatchRows(value: number);
    resetMaxBatchRows(): void;
    get maxBatchRowsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _returnBehavior?;
    get returnBehavior(): string;
    set returnBehavior(value: string);
    get returnBehaviorInput(): string | undefined;
    private _returnNullAllowed?;
    get returnNullAllowed(): boolean | cdktf.IResolvable;
    set returnNullAllowed(value: boolean | cdktf.IResolvable);
    resetReturnNullAllowed(): void;
    get returnNullAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _urlOfProxyAndResource?;
    get urlOfProxyAndResource(): string;
    set urlOfProxyAndResource(value: string);
    get urlOfProxyAndResourceInput(): string | undefined;
    private _arg?;
    get arg(): ExternalFunctionArg[] | cdktf.IResolvable;
    set arg(value: ExternalFunctionArg[] | cdktf.IResolvable);
    resetArg(): void;
    get argInput(): cdktf.IResolvable | ExternalFunctionArg[] | undefined;
    private _header?;
    get header(): ExternalFunctionHeader[] | cdktf.IResolvable;
    set header(value: ExternalFunctionHeader[] | cdktf.IResolvable);
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ExternalFunctionHeader[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
