import setuptools
import os

if os.environ.get('CI_COMMIT_TAG'):
    version = os.environ['CI_COMMIT_TAG']
else:
    version = os.environ['CI_JOB_ID']

setuptools.setup(
    name="griffin-db",
    version=version,
    author="Adrian Campos",
    author_email="adrian@g4tv.com",
    description="A small wrapper for psycopg2 and queries with commonly used functions",
    packages=setuptools.find_packages(),
    install_requires=[
        "queries~=2.1.0",
        "python-dotenv",
    ],
    classifiers=[
        "Programming Language :: Python :: 3",
        # "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
    zip_safe=False,
)
