# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import errno
from setuptools import setup, find_packages
from setuptools.command.install import install
from subprocess import check_call


class InstallPluginCommand(install):
    def run(self):
        install.run(self)
        try:
            check_call(['pulumi', 'plugin', 'install', 'resource', 'eks', '0.33.1-alpha.1633113763+700d73e9'])
        except OSError as error:
            if error.errno == errno.ENOENT:
                print("""
                There was an error installing the eks resource provider plugin.
                It looks like `pulumi` is not installed on your system.
                Please visit https://pulumi.com/ to install the Pulumi CLI.
                You may try manually installing the plugin by running
                `pulumi plugin install resource eks 0.33.1-alpha.1633113763+700d73e9`
                """)
            else:
                raise


def readme():
    try:
        with open('README.md', encoding='utf-8') as f:
            return f.read()
    except FileNotFoundError:
            return "eks Pulumi Package - Development Version"


setup(name='pulumi_eks',
      version='0.33.1a1633113763',
      description="Pulumi Amazon Web Services (AWS) EKS Components.",
      long_description=readme(),
      long_description_content_type='text/markdown',
      cmdclass={
          'install': InstallPluginCommand,
      },
      keywords='pulumi aws eks',
      url='https://pulumi.com',
      project_urls={
          'Repository': 'https://github.com/pulumi/pulumi-eks'
      },
      license='Apache-2.0',
      packages=find_packages(),
      package_data={
          'pulumi_eks': [
              'py.typed',
          ]
      },
      install_requires=[
          'parver>=0.2.1',
          'pulumi>=3.0.0,<4.0.0',
          'pulumi-aws>=4.15.0,<5.0.0',
          'pulumi-kubernetes>=3.0.0,<4.0.0',
          'semver>=2.8.1'
      ],
      zip_safe=False)
