API
===
## main Mumble object
> `class Mumble(host, user, port=64738, password='', certfile=None, keyfile=None, reconnect=False, tokens=[], stereo=False,debug=False)`

It should be quite straightforward. `debug=True` will generate a LOT of stdout messages. Otherwise it should be silent in normal conditions.
Reconnect should allow the library to reconnect automatically if the server disconnect it.

The `tokens` parameter is a list of tokens for the channels access tokens

The `certfile` parameter takes the path to a Mumble certificate in `.pem` format. To convert the `.p12` certificate generated by the Mumble certificate wizard to `.pem`, use OpenSSL:

```$ openssl pkcs12 -in PATH_TO_CERTFILE.p12 -out CERTFILE_NAME.pem -clcerts -nokeys``` for the cert file and

```$ openssl pkcs12 -in PATH_TO_CERTFILE.p12 -out CERTFILE_NAME.pem -nocerts -nodes``` for the key file.

The `stereo` allow you to send stereo audio, only available with compatible mumble version (>1.3)

> `Mumble.start()`

Start the library thread and the connection process

> `Mumble.is_ready()`

Block until the connection process is concluded.

> `Mumble.set_bandwidth(int)`

Set (in bit per seconds) the allowed total outgoing bandwidth of the library. Can be limited by the server.

> `Mumble.set_application_string(string)`

Set the application name that will be sent to the server. Must be done before the `start()`.

> `Mumble.set_loop_rate(float)`

Set in second how long the library will wait for an incoming message, which slowdown the loop.
Must be small enough for the audio treatment you need, but if too small it will consume too much CPU
0.01 is the default and seems to be small enough to send audio in 20ms packets.
For application that just receive sound, bigger should be enough (like 0.05).

> `Mumble.get_loop_rate()`

Return the current `loop_rate`.

> `Mumble.set_receive_sound(bool)`

By default, incoming sound is not treated. If you plan to use the incoming audio, you must set this to `True`,
but then you have to get the audio out of the library regularly otherwise it will simply consume memory.

> `Mumble.my_channel()`

This function return the channel the bot is located. It's a Channel Object.
It's a shortcut for `self.channels[self.users.myself["channel_id"]`

> `Mumble.stop()`

This function ask Mumble to disconnect from the server manually.

## Callbacks object (accessible through Mumble.callbacks)
Manage the different available callbacks.
It is basically a `dict` of the available callbacks and the methods to manage them.

Callback names are in `pymumble.constants` module, starting with `PYMUMBLE_CLBK_`
- `PYMUMBLE_CLBK_CONNECTED`: connection succeeded
- `PYMUMBLE_CLBK_DISCONNECTED`: Connection as been dropped
- `PYMUMBLE_CLBK_CHANNELCREATED`: send the created channel object as parameter
- `PYMUMBLE_CLBK_CHANNELUPDATED`: send the updated channel object and a dict with all the modified fields as parameter
- `PYMUMBLE_CLBK_CHANNELREMOVED`: send the removed channel object as parameter
- `PYMUMBLE_CLBK_USERCREATED`: send the added user object as parameter
- `PYMUMBLE_CLBK_USERUPDATED`: send the updated user object and a dict with all the modified fields as parameter
- `PYMUMBLE_CLBK_USERREMOVED`: send the removed user object and the removal event as parameters. The event contains only a `session` field if a user left manually, otherwise it adds an `actor` (person who kicked/banned), `reason`, and `ban` (`True`=ban, `False`=kick).
- `PYMUMBLE_CLBK_SOUNDRECEIVED`: send the user object that received the sound and the SoundChunk object itself
- `PYMUMBLE_CLBK_TEXTMESSAGERECEIVED`: send the received message
- `PYMUMBLE_CLBK_ACLRECEIVED`: send the received acl permissions
- `PYMUMBLE_CLBK_PERMISSIONDENIED`: send the information regarding what caused the action to fail. `event.type` corresponds to [this DenyType enum](https://github.com/mumble-voip/mumble/blob/34c9b2503361163b649a35598de7de727a64148f/src/Mumble.proto#L271).

**Callbacks are executed within the library looping thread. Keep it's work short or you could have jitter issues!**

> `Mumble.callbacks.set_callback(callback, function)`

Assign a function to a callback (replace the previous ones if any).

> `Mumble.callbacks.add_callback(callback, function)`

Assign an additional function to a callback.

> `Mumble.callbacks.get_callback(callback)`

Return a list of functions assign to this callback or `None`.

> `Mumble.callbacks.remove_callback(callback, function)`

Remove the specified function from the ones assign to this callback.

> `Mumble.callbacks.reset_callback(callback)`

Remove all defined callback functions for this callback.

> `Mumble.callbacks.get_callbacks_list()`

Return the list of all the available callbacks. Better use the constants though.

## Users object (accessible through Mumble.users)
Store the users connected on the server. For the application, it is basically only interesting as a `dict` of `User` objects,
which contain the actual information.

> `Mumble.users[int]`

Where `int` is the session number on the server. It points to the specific `User` object for this session.

> `Mumble.users.count()`

Return the number of connected users on the server.

> `Mumble.users.myself_session`

Contain the session number of the `pymumble` connection itself.

> `Mumble.users.myself`

Is a shortcut to `Mumble.users[Mumble.users.myself_session]`, pointing to the User object of the current connection.

> `Mumble.denial_type(n)`

Is a shortcut to `mumble_pb2.PermissionDenied.DenyType.Name(n)`, the associated enum name for an action denial cause. (`n` comes from the callback for `PYMUMBLE_CLBK_PERMISSIONDENIED`: `event.type`.

## User object (accessible through Mumble.users[session] or Mumble.users.myself
Contain the users information and method to act on them.
User also contain an instance of the SoundQueue object, containing the audio received from this user.

> `User.sound`

SoundQueue instance for this user.

> `User.get_property()`

Return the value of the property.

> `User.mute()`
> `User.unmute()`

> `User.deafen()`
> `User.undeafen()`

> `User.suppress()`
> `User.unsuppress()`

> `User.recording()`
> `User.unrecorfing()`

> `User.comment(string)`

Set the comment for this user.

> `user.texture(texture)`

Set the image for this user (must be a format recognized by the Mumble clients. PNG seems to work, I had issues with SVG).

> `user.send_text_message(message)`

Send a message to the specific user.

> `user.register()`

Send a register demand to the murmur server (you need to have a certfile

> `user.kick()`
> `user.ban()`

You can pass a keyword argument `reason=` if you'd like, defaults to empty string.

## SoundQueue object (accessible through User.sound)
Contains the audio received from a specific user.
Take care of the decoding and keep track on the timing of the reception.

> `User.sound.set_receive_sound(bool)`

Allow stopping treating incoming audio for a specific user if `False`. `True` by default.

> `User.sound.is_sound()`

Return `True` if sound is present in this `SoundQueue`.

> `User.sound.get_sound(duration=None)`

Return a `SoundChunk` object containing the audio received in one packet coming from the server, and discard it from the list.
If `duration` (in sec) is specified and smaller than the size of the next available audio, the split is taken care of.
**Do not use a non 10ms multiple as it is the basic unit in Mumble.**

> `User.sound.first_sound()`

Return a `SoundChunk` object (the next one) but do not discard it.
Useful to check it's timing without actually treat it yet.

## SoundChunk object (received from User.sound)
It contains a sound unit, as received from the server.
It as several properties
> `SoundChunk.pcm`

The PCM buffer for this sound, in 16 bits signed mono little-endian 48000Hz format.

> `SoundChunk.timestamp`

Time when the packet was received.

> `SoundChunk.time`

Time calculated based on Mumble sequences (better to reconstruct the stream).

> `SoundChunk.sequence`

Mumble sequence for the packet.

> `SoundChunk.size`

Size of the PCM in bytes.

> `SoundChunk.duration`

Length of the PCM in secs.

> `SoundChunk.type`

Mumble type for the chunk (coded used).

> `SoundChunk.target`

Target of the packet, as sent by the server.

## Channels object (accessible through Mumble.channels)
Contains the channels known on the server. Allow listing and finding them.
It is again a `dict` by channel ids (root=0) containing all the Channel objects.

> `Mumble.channels.find_by_tree(iterable)`

Search, starting from the root for every element a subchannel with the same name.
Return the channel object or raise a `UnknownChannelError` exception.

> `Mumble.channels.get_childs(channel_id)`

Return a list of all the children objects for a channel id.

> `Mumble.channels.get_descendants(channel_id)`

Return a (nested) list of the channels above this id.

> `Mumble.channels.remove_channel(channel_id)`

Remove channel with the given id.

> `Mumble.channels.get_tree(channel_id)`

Return a nested list of the channel objects above this id.

> `Mumble.channels.find_by_name(name)`

Return the first channel object matching the name.

> `Mumble.channels.unlink(channel_id)`

Unlink every channels in server if channel_id is not given.
Unlink all channels which is linked to this id if channel_id is given.

## Channel object (accessible through Mumble.channels[channel_id] or Mumble.channels.find_by_name(Name))
Contains the properties of the specific channel.
Allow to move a user into it.

> `Channel.get_property(name)`

Return the property value for this channel.

> `Channel.move_in(session=None)`

Move (or try to) a user's session into the channel.
If no session specified, try to move the library application itself.

> `Channel.remove()`

Remove the given channel.

> `Channel.send_text_message(message)`

Send message into the specific channel.

> `Channel.get_users()`

List all users currently in channel.
After moving into a channel, it's normal to not have the list of user. Pymumble need few ms to update the list.

> `Channel.unlink()`

Unlink every channels which is linked to the channel.

> `Channel.get_acl()`

Request an ACL permissions [object](https://github.com/mumble-voip/mumble/blob/master/src/Mumble.proto#L317) (requires bot have Write ACL permissions). This will invoke PYMUMBLE_CLBK_ACLRECEIVED. Example of usage:

```
def onacl(event):
	for group in event.groups:
		if event.group.name == "admin":
			print("The admin IDs are: ", [user for user in group.add])

Mumble.callbacks.set_callback(PYMUMBLE_CLBK_ACL_RECEIVED, onacl)
Mumble.channels[0].get_acl() #Request ACL for root channel
```

## SoundOutput object (accessible through Mumble.sound_output)
Takes care of encoding, packetizing and sending the audio to the server.

> `Mumble.sound_output.set_audio_per_packet(float)`

Set the duration of one packet of audio in secs. Typically, 0.02 or 0.04. Max is 0.12 (codec limitations).

> `Mumble.sound_output.get_audio_per_packet()`

Return the current length of an audio packet in secs.

> `Mumble.sound_output.add_sound(string)`

Add PCM sound (16 bites mono 48000Hz little-endian encoded) to the outgoing queue.

> `Mumble.sound_output.get_buffer_size()`

Return in secs the size of the unsent audio buffer. Useful to transfer audio to the library at a regular pace.

> `Mumble.sound_output.set_whisper(<session_id>)`

Set Whisper to an specific User Session-ID

> `Mumble.sound_output.set_whisper([list of session_id])`

Set Whisper to multiple Users

> ``Mumble.sound_output.set_whisper(<channel_id>, channel=True)``

Set Whisper to a specific Channel

> ``Mumble.sound_output.remove_whisper()``

Remove the previously set Whisper

